/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PCRReaction_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_PCRREACTION_BASE_HPP
#define OBJECTS_SEQFEAT_PCRREACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPCRPrimerSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CPCRReaction_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPCRReaction_Base(void);
    // destructor
    virtual ~CPCRReaction_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPCRPrimerSet TForward;
    typedef CPCRPrimerSet TReverse;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_forward,
        e_reverse
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CPCRPrimerSet TForward
    ///  Check whether the Forward data member has been assigned a value.
    bool IsSetForward(void) const;
    /// Check whether it is safe or not to call GetForward method.
    bool CanGetForward(void) const;
    void ResetForward(void);
    const TForward& GetForward(void) const;
    void SetForward(TForward& value);
    TForward& SetForward(void);

    /// optional
    /// typedef CPCRPrimerSet TReverse
    ///  Check whether the Reverse data member has been assigned a value.
    bool IsSetReverse(void) const;
    /// Check whether it is safe or not to call GetReverse method.
    bool CanGetReverse(void) const;
    void ResetReverse(void);
    const TReverse& GetReverse(void) const;
    void SetReverse(TReverse& value);
    TReverse& SetReverse(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPCRReaction_Base(const CPCRReaction_Base&);
    CPCRReaction_Base& operator=(const CPCRReaction_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TForward > m_Forward;
    CRef< TReverse > m_Reverse;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPCRReaction_Base::IsSetForward(void) const
{
    return m_Forward.NotEmpty();
}

inline
bool CPCRReaction_Base::CanGetForward(void) const
{
    return IsSetForward();
}

inline
const CPCRReaction_Base::TForward& CPCRReaction_Base::GetForward(void) const
{
    if (!CanGetForward()) {
        ThrowUnassigned(0);
    }
    return (*m_Forward);
}

inline
bool CPCRReaction_Base::IsSetReverse(void) const
{
    return m_Reverse.NotEmpty();
}

inline
bool CPCRReaction_Base::CanGetReverse(void) const
{
    return IsSetReverse();
}

inline
const CPCRReaction_Base::TReverse& CPCRReaction_Base::GetReverse(void) const
{
    if (!CanGetReverse()) {
        ThrowUnassigned(1);
    }
    return (*m_Reverse);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_PCRREACTION_BASE_HPP
