/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_point_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_SEQ_POINT_BASE_HPP
#define OBJECTS_SEQLOC_SEQ_POINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/seqloc/Na_strand.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQLOC_EXPORT CSeq_point_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_point_Base(void);
    // destructor
    virtual ~CSeq_point_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSeqPos TPoint;
    typedef ENa_strand TStrand;
    typedef CSeq_id TId;
    typedef CInt_fuzz TFuzz;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_point,
        e_strand,
        e_id,
        e_fuzz
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef TSeqPos TPoint
    ///  Check whether the Point data member has been assigned a value.
    bool IsSetPoint(void) const;
    /// Check whether it is safe or not to call GetPoint method.
    bool CanGetPoint(void) const;
    void ResetPoint(void);
    TPoint GetPoint(void) const;
    void SetPoint(TPoint value);
    TPoint& SetPoint(void);

    /// optional
    /// typedef ENa_strand TStrand
    ///  Check whether the Strand data member has been assigned a value.
    bool IsSetStrand(void) const;
    /// Check whether it is safe or not to call GetStrand method.
    bool CanGetStrand(void) const;
    void ResetStrand(void);
    TStrand GetStrand(void) const;
    void SetStrand(TStrand value);
    TStrand& SetStrand(void);

    /// WARNING: this used to be optional
    /// mandatory
    /// typedef CSeq_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// optional
    /// typedef CInt_fuzz TFuzz
    ///  Check whether the Fuzz data member has been assigned a value.
    bool IsSetFuzz(void) const;
    /// Check whether it is safe or not to call GetFuzz method.
    bool CanGetFuzz(void) const;
    void ResetFuzz(void);
    const TFuzz& GetFuzz(void) const;
    void SetFuzz(TFuzz& value);
    TFuzz& SetFuzz(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_point_Base(const CSeq_point_Base&);
    CSeq_point_Base& operator=(const CSeq_point_Base&);

    // data
    Uint4 m_set_State[1];
    TSeqPos m_Point;
    ENa_strand m_Strand;
    CRef< TId > m_Id;
    CRef< TFuzz > m_Fuzz;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_point_Base::IsSetPoint(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_point_Base::CanGetPoint(void) const
{
    return IsSetPoint();
}

inline
void CSeq_point_Base::ResetPoint(void)
{
    m_Point = 0;
    m_set_State[0] &= ~0x3;
}

inline
CSeq_point_Base::TPoint CSeq_point_Base::GetPoint(void) const
{
    if (!CanGetPoint()) {
        ThrowUnassigned(0);
    }
    return m_Point;
}

inline
void CSeq_point_Base::SetPoint(CSeq_point_Base::TPoint value)
{
    m_Point = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_point_Base::TPoint& CSeq_point_Base::SetPoint(void)
{
#ifdef _DEBUG
    if (!IsSetPoint()) {
        memset(&m_Point,UnassignedByte(),sizeof(m_Point));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Point;
}

inline
bool CSeq_point_Base::IsSetStrand(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_point_Base::CanGetStrand(void) const
{
    return IsSetStrand();
}

inline
void CSeq_point_Base::ResetStrand(void)
{
    m_Strand = (ncbi::objects::ENa_strand)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSeq_point_Base::TStrand CSeq_point_Base::GetStrand(void) const
{
    if (!CanGetStrand()) {
        ThrowUnassigned(1);
    }
    return m_Strand;
}

inline
void CSeq_point_Base::SetStrand(CSeq_point_Base::TStrand value)
{
    m_Strand = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_point_Base::TStrand& CSeq_point_Base::SetStrand(void)
{
#ifdef _DEBUG
    if (!IsSetStrand()) {
        memset(&m_Strand,UnassignedByte(),sizeof(m_Strand));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Strand;
}

inline
bool CSeq_point_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeq_point_Base::CanGetId(void) const
{
    return true;
}

inline
const CSeq_point_Base::TId& CSeq_point_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CSeq_point_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CSeq_point_Base::TId& CSeq_point_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CSeq_point_Base::IsSetFuzz(void) const
{
    return m_Fuzz.NotEmpty();
}

inline
bool CSeq_point_Base::CanGetFuzz(void) const
{
    return IsSetFuzz();
}

inline
const CSeq_point_Base::TFuzz& CSeq_point_Base::GetFuzz(void) const
{
    if (!CanGetFuzz()) {
        ThrowUnassigned(3);
    }
    return (*m_Fuzz);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_POINT_BASE_HPP
