/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_column_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_SEQTABLE_COLUMN_BASE_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_COLUMN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeqTable_column_info;
class CSeqTable_multi_data;
class CSeqTable_single_data;
class CSeqTable_sparse_index;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_column_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTable_column_Base(void);
    // destructor
    virtual ~CSeqTable_column_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeqTable_column_info THeader;
    typedef CSeqTable_multi_data TData;
    typedef CSeqTable_sparse_index TSparse;
    typedef CSeqTable_single_data TDefault;
    typedef CSeqTable_single_data TSparse_other;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_header,
        e_data,
        e_sparse,
        e_default,
        e_sparse_other
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// column description or reference to previously defined info
    /// information about data
    /// mandatory
    /// typedef CSeqTable_column_info THeader
    ///  Check whether the Header data member has been assigned a value.
    bool IsSetHeader(void) const;
    /// Check whether it is safe or not to call GetHeader method.
    bool CanGetHeader(void) const;
    void ResetHeader(void);
    const THeader& GetHeader(void) const;
    void SetHeader(THeader& value);
    THeader& SetHeader(void);

    /// row data
    /// optional
    /// typedef CSeqTable_multi_data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// in case not all rows contain data this field will contain sparse info
    /// optional
    /// typedef CSeqTable_sparse_index TSparse
    ///  Check whether the Sparse data member has been assigned a value.
    bool IsSetSparse(void) const;
    /// Check whether it is safe or not to call GetSparse method.
    bool CanGetSparse(void) const;
    void ResetSparse(void);
    const TSparse& GetSparse(void) const;
    void SetSparse(TSparse& value);
    TSparse& SetSparse(void);

    /// default value for sparse table, or if row data is too short
    /// optional
    /// typedef CSeqTable_single_data TDefault
    ///  Check whether the Default data member has been assigned a value.
    bool IsSetDefault(void) const;
    /// Check whether it is safe or not to call GetDefault method.
    bool CanGetDefault(void) const;
    void ResetDefault(void);
    const TDefault& GetDefault(void) const;
    void SetDefault(TDefault& value);
    TDefault& SetDefault(void);

    /// single value for indexes not listed in sparse table
    /// optional
    /// typedef CSeqTable_single_data TSparse_other
    ///  Check whether the Sparse_other data member has been assigned a value.
    bool IsSetSparse_other(void) const;
    /// Check whether it is safe or not to call GetSparse_other method.
    bool CanGetSparse_other(void) const;
    void ResetSparse_other(void);
    const TSparse_other& GetSparse_other(void) const;
    void SetSparse_other(TSparse_other& value);
    TSparse_other& SetSparse_other(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqTable_column_Base(const CSeqTable_column_Base&);
    CSeqTable_column_Base& operator=(const CSeqTable_column_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< THeader > m_Header;
    CRef< TData > m_Data;
    CRef< TSparse > m_Sparse;
    CRef< TDefault > m_Default;
    CRef< TSparse_other > m_Sparse_other;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqTable_column_Base::IsSetHeader(void) const
{
    return m_Header.NotEmpty();
}

inline
bool CSeqTable_column_Base::CanGetHeader(void) const
{
    return true;
}

inline
const CSeqTable_column_Base::THeader& CSeqTable_column_Base::GetHeader(void) const
{
    if ( !m_Header ) {
        const_cast<CSeqTable_column_Base*>(this)->ResetHeader();
    }
    return (*m_Header);
}

inline
CSeqTable_column_Base::THeader& CSeqTable_column_Base::SetHeader(void)
{
    if ( !m_Header ) {
        ResetHeader();
    }
    return (*m_Header);
}

inline
bool CSeqTable_column_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CSeqTable_column_Base::CanGetData(void) const
{
    return IsSetData();
}

inline
const CSeqTable_column_Base::TData& CSeqTable_column_Base::GetData(void) const
{
    if (!CanGetData()) {
        ThrowUnassigned(1);
    }
    return (*m_Data);
}

inline
bool CSeqTable_column_Base::IsSetSparse(void) const
{
    return m_Sparse.NotEmpty();
}

inline
bool CSeqTable_column_Base::CanGetSparse(void) const
{
    return IsSetSparse();
}

inline
const CSeqTable_column_Base::TSparse& CSeqTable_column_Base::GetSparse(void) const
{
    if (!CanGetSparse()) {
        ThrowUnassigned(2);
    }
    return (*m_Sparse);
}

inline
bool CSeqTable_column_Base::IsSetDefault(void) const
{
    return m_Default.NotEmpty();
}

inline
bool CSeqTable_column_Base::CanGetDefault(void) const
{
    return IsSetDefault();
}

inline
const CSeqTable_column_Base::TDefault& CSeqTable_column_Base::GetDefault(void) const
{
    if (!CanGetDefault()) {
        ThrowUnassigned(3);
    }
    return (*m_Default);
}

inline
bool CSeqTable_column_Base::IsSetSparse_other(void) const
{
    return m_Sparse_other.NotEmpty();
}

inline
bool CSeqTable_column_Base::CanGetSparse_other(void) const
{
    return IsSetSparse_other();
}

inline
const CSeqTable_column_Base::TSparse_other& CSeqTable_column_Base::GetSparse_other(void) const
{
    if (!CanGetSparse_other()) {
        ThrowUnassigned(4);
    }
    return (*m_Sparse_other);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_COLUMN_BASE_HPP
