/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_table_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_SEQ_TABLE_BASE_HPP
#define OBJECTS_SEQTABLE_SEQ_TABLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeqTable_column;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeq_table_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_table_Base(void);
    // destructor
    virtual ~CSeq_table_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TFeat_type;
    typedef int TFeat_subtype;
    typedef int TNum_rows;
    typedef vector< CRef< CSeqTable_column > > TColumns;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_feat_type,
        e_feat_subtype,
        e_num_rows,
        e_columns
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// type of features in this table, equal to Seq-feat.data variant index
    /// mandatory
    /// typedef int TFeat_type
    ///  Check whether the Feat_type data member has been assigned a value.
    bool IsSetFeat_type(void) const;
    /// Check whether it is safe or not to call GetFeat_type method.
    bool CanGetFeat_type(void) const;
    void ResetFeat_type(void);
    TFeat_type GetFeat_type(void) const;
    void SetFeat_type(TFeat_type value);
    TFeat_type& SetFeat_type(void);

    /// subtype of features in this table, defined in header SeqFeatData.hpp
    /// optional
    /// typedef int TFeat_subtype
    ///  Check whether the Feat_subtype data member has been assigned a value.
    bool IsSetFeat_subtype(void) const;
    /// Check whether it is safe or not to call GetFeat_subtype method.
    bool CanGetFeat_subtype(void) const;
    void ResetFeat_subtype(void);
    TFeat_subtype GetFeat_subtype(void) const;
    void SetFeat_subtype(TFeat_subtype value);
    TFeat_subtype& SetFeat_subtype(void);

    /// number of rows
    /// mandatory
    /// typedef int TNum_rows
    ///  Check whether the Num_rows data member has been assigned a value.
    bool IsSetNum_rows(void) const;
    /// Check whether it is safe or not to call GetNum_rows method.
    bool CanGetNum_rows(void) const;
    void ResetNum_rows(void);
    TNum_rows GetNum_rows(void) const;
    void SetNum_rows(TNum_rows value);
    TNum_rows& SetNum_rows(void);

    /// data in columns
    /// mandatory
    /// typedef vector< CRef< CSeqTable_column > > TColumns
    ///  Check whether the Columns data member has been assigned a value.
    bool IsSetColumns(void) const;
    /// Check whether it is safe or not to call GetColumns method.
    bool CanGetColumns(void) const;
    void ResetColumns(void);
    const TColumns& GetColumns(void) const;
    TColumns& SetColumns(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_table_Base(const CSeq_table_Base&);
    CSeq_table_Base& operator=(const CSeq_table_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Feat_type;
    int m_Feat_subtype;
    int m_Num_rows;
    vector< CRef< CSeqTable_column > > m_Columns;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_table_Base::IsSetFeat_type(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_table_Base::CanGetFeat_type(void) const
{
    return IsSetFeat_type();
}

inline
void CSeq_table_Base::ResetFeat_type(void)
{
    m_Feat_type = 0;
    m_set_State[0] &= ~0x3;
}

inline
CSeq_table_Base::TFeat_type CSeq_table_Base::GetFeat_type(void) const
{
    if (!CanGetFeat_type()) {
        ThrowUnassigned(0);
    }
    return m_Feat_type;
}

inline
void CSeq_table_Base::SetFeat_type(CSeq_table_Base::TFeat_type value)
{
    m_Feat_type = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_table_Base::TFeat_type& CSeq_table_Base::SetFeat_type(void)
{
#ifdef _DEBUG
    if (!IsSetFeat_type()) {
        memset(&m_Feat_type,UnassignedByte(),sizeof(m_Feat_type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Feat_type;
}

inline
bool CSeq_table_Base::IsSetFeat_subtype(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_table_Base::CanGetFeat_subtype(void) const
{
    return IsSetFeat_subtype();
}

inline
void CSeq_table_Base::ResetFeat_subtype(void)
{
    m_Feat_subtype = 0;
    m_set_State[0] &= ~0xc;
}

inline
CSeq_table_Base::TFeat_subtype CSeq_table_Base::GetFeat_subtype(void) const
{
    if (!CanGetFeat_subtype()) {
        ThrowUnassigned(1);
    }
    return m_Feat_subtype;
}

inline
void CSeq_table_Base::SetFeat_subtype(CSeq_table_Base::TFeat_subtype value)
{
    m_Feat_subtype = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_table_Base::TFeat_subtype& CSeq_table_Base::SetFeat_subtype(void)
{
#ifdef _DEBUG
    if (!IsSetFeat_subtype()) {
        memset(&m_Feat_subtype,UnassignedByte(),sizeof(m_Feat_subtype));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Feat_subtype;
}

inline
bool CSeq_table_Base::IsSetNum_rows(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_table_Base::CanGetNum_rows(void) const
{
    return IsSetNum_rows();
}

inline
void CSeq_table_Base::ResetNum_rows(void)
{
    m_Num_rows = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeq_table_Base::TNum_rows CSeq_table_Base::GetNum_rows(void) const
{
    if (!CanGetNum_rows()) {
        ThrowUnassigned(2);
    }
    return m_Num_rows;
}

inline
void CSeq_table_Base::SetNum_rows(CSeq_table_Base::TNum_rows value)
{
    m_Num_rows = value;
    m_set_State[0] |= 0x30;
}

inline
CSeq_table_Base::TNum_rows& CSeq_table_Base::SetNum_rows(void)
{
#ifdef _DEBUG
    if (!IsSetNum_rows()) {
        memset(&m_Num_rows,UnassignedByte(),sizeof(m_Num_rows));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Num_rows;
}

inline
bool CSeq_table_Base::IsSetColumns(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CSeq_table_Base::CanGetColumns(void) const
{
    return true;
}

inline
const CSeq_table_Base::TColumns& CSeq_table_Base::GetColumns(void) const
{
    return m_Columns;
}

inline
CSeq_table_Base::TColumns& CSeq_table_Base::SetColumns(void)
{
    m_set_State[0] |= 0x40;
    return m_Columns;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQ_TABLE_BASE_HPP
