/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TSeq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'tinyseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TINYSEQ_TSEQ_BASE_HPP
#define OBJECTS_TINYSEQ_TSEQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TINYSEQ_EXPORT CTSeq_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTSeq_Base(void);
    // destructor
    virtual ~CTSeq_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESeqtype {
        eSeqtype_nucleotide = 1,
        eSeqtype_protein    = 2
    };
    
    /// Access to ESeqtype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESeqtype)(void);
    
    // types
    typedef ESeqtype TSeqtype;
    typedef int TGi;
    typedef string TAccver;
    typedef string TSid;
    typedef string TLocal;
    typedef int TTaxid;
    typedef string TOrgname;
    typedef string TDefline;
    typedef int TLength;
    typedef string TSequence;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seqtype,
        e_gi,
        e_accver,
        e_sid,
        e_local,
        e_taxid,
        e_orgname,
        e_defline,
        e_length,
        e_sequence
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ESeqtype TSeqtype
    ///  Check whether the Seqtype data member has been assigned a value.
    bool IsSetSeqtype(void) const;
    /// Check whether it is safe or not to call GetSeqtype method.
    bool CanGetSeqtype(void) const;
    void ResetSeqtype(void);
    TSeqtype GetSeqtype(void) const;
    void SetSeqtype(TSeqtype value);
    TSeqtype& SetSeqtype(void);

    /// optional
    /// typedef int TGi
    ///  Check whether the Gi data member has been assigned a value.
    bool IsSetGi(void) const;
    /// Check whether it is safe or not to call GetGi method.
    bool CanGetGi(void) const;
    void ResetGi(void);
    TGi GetGi(void) const;
    void SetGi(TGi value);
    TGi& SetGi(void);

    /// optional
    /// typedef string TAccver
    ///  Check whether the Accver data member has been assigned a value.
    bool IsSetAccver(void) const;
    /// Check whether it is safe or not to call GetAccver method.
    bool CanGetAccver(void) const;
    void ResetAccver(void);
    const TAccver& GetAccver(void) const;
    void SetAccver(const TAccver& value);
    void SetAccver(TAccver&& value);
    TAccver& SetAccver(void);

    /// optional
    /// typedef string TSid
    ///  Check whether the Sid data member has been assigned a value.
    bool IsSetSid(void) const;
    /// Check whether it is safe or not to call GetSid method.
    bool CanGetSid(void) const;
    void ResetSid(void);
    const TSid& GetSid(void) const;
    void SetSid(const TSid& value);
    void SetSid(TSid&& value);
    TSid& SetSid(void);

    /// optional
    /// typedef string TLocal
    ///  Check whether the Local data member has been assigned a value.
    bool IsSetLocal(void) const;
    /// Check whether it is safe or not to call GetLocal method.
    bool CanGetLocal(void) const;
    void ResetLocal(void);
    const TLocal& GetLocal(void) const;
    void SetLocal(const TLocal& value);
    void SetLocal(TLocal&& value);
    TLocal& SetLocal(void);

    /// optional
    /// typedef int TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// optional
    /// typedef string TOrgname
    ///  Check whether the Orgname data member has been assigned a value.
    bool IsSetOrgname(void) const;
    /// Check whether it is safe or not to call GetOrgname method.
    bool CanGetOrgname(void) const;
    void ResetOrgname(void);
    const TOrgname& GetOrgname(void) const;
    void SetOrgname(const TOrgname& value);
    void SetOrgname(TOrgname&& value);
    TOrgname& SetOrgname(void);

    /// mandatory
    /// typedef string TDefline
    ///  Check whether the Defline data member has been assigned a value.
    bool IsSetDefline(void) const;
    /// Check whether it is safe or not to call GetDefline method.
    bool CanGetDefline(void) const;
    void ResetDefline(void);
    const TDefline& GetDefline(void) const;
    void SetDefline(const TDefline& value);
    void SetDefline(TDefline&& value);
    TDefline& SetDefline(void);

    /// mandatory
    /// typedef int TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    TLength GetLength(void) const;
    void SetLength(TLength value);
    TLength& SetLength(void);

    /// mandatory
    /// typedef string TSequence
    ///  Check whether the Sequence data member has been assigned a value.
    bool IsSetSequence(void) const;
    /// Check whether it is safe or not to call GetSequence method.
    bool CanGetSequence(void) const;
    void ResetSequence(void);
    const TSequence& GetSequence(void) const;
    void SetSequence(const TSequence& value);
    void SetSequence(TSequence&& value);
    TSequence& SetSequence(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTSeq_Base(const CTSeq_Base&);
    CTSeq_Base& operator=(const CTSeq_Base&);

    // data
    Uint4 m_set_State[1];
    ESeqtype m_Seqtype;
    int m_Gi;
    string m_Accver;
    string m_Sid;
    string m_Local;
    int m_Taxid;
    string m_Orgname;
    string m_Defline;
    int m_Length;
    string m_Sequence;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTSeq_Base::IsSetSeqtype(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTSeq_Base::CanGetSeqtype(void) const
{
    return IsSetSeqtype();
}

inline
void CTSeq_Base::ResetSeqtype(void)
{
    m_Seqtype = (ESeqtype)(0);
    m_set_State[0] &= ~0x3;
}

inline
CTSeq_Base::TSeqtype CTSeq_Base::GetSeqtype(void) const
{
    if (!CanGetSeqtype()) {
        ThrowUnassigned(0);
    }
    return m_Seqtype;
}

inline
void CTSeq_Base::SetSeqtype(CTSeq_Base::TSeqtype value)
{
    m_Seqtype = value;
    m_set_State[0] |= 0x3;
}

inline
CTSeq_Base::TSeqtype& CTSeq_Base::SetSeqtype(void)
{
#ifdef _DEBUG
    if (!IsSetSeqtype()) {
        memset(&m_Seqtype,UnassignedByte(),sizeof(m_Seqtype));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Seqtype;
}

inline
bool CTSeq_Base::IsSetGi(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTSeq_Base::CanGetGi(void) const
{
    return IsSetGi();
}

inline
void CTSeq_Base::ResetGi(void)
{
    m_Gi = 0;
    m_set_State[0] &= ~0xc;
}

inline
CTSeq_Base::TGi CTSeq_Base::GetGi(void) const
{
    if (!CanGetGi()) {
        ThrowUnassigned(1);
    }
    return m_Gi;
}

inline
void CTSeq_Base::SetGi(CTSeq_Base::TGi value)
{
    m_Gi = value;
    m_set_State[0] |= 0xc;
}

inline
CTSeq_Base::TGi& CTSeq_Base::SetGi(void)
{
#ifdef _DEBUG
    if (!IsSetGi()) {
        memset(&m_Gi,UnassignedByte(),sizeof(m_Gi));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Gi;
}

inline
bool CTSeq_Base::IsSetAccver(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTSeq_Base::CanGetAccver(void) const
{
    return IsSetAccver();
}

inline
const CTSeq_Base::TAccver& CTSeq_Base::GetAccver(void) const
{
    if (!CanGetAccver()) {
        ThrowUnassigned(2);
    }
    return m_Accver;
}

inline
void CTSeq_Base::SetAccver(const CTSeq_Base::TAccver& value)
{
    m_Accver = value;
    m_set_State[0] |= 0x30;
}

inline
void CTSeq_Base::SetAccver(CTSeq_Base::TAccver&& value)
{
    m_Accver = std::forward<CTSeq_Base::TAccver>(value);
    m_set_State[0] |= 0x30;
}

inline
CTSeq_Base::TAccver& CTSeq_Base::SetAccver(void)
{
#ifdef _DEBUG
    if (!IsSetAccver()) {
        m_Accver = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Accver;
}

inline
bool CTSeq_Base::IsSetSid(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTSeq_Base::CanGetSid(void) const
{
    return IsSetSid();
}

inline
const CTSeq_Base::TSid& CTSeq_Base::GetSid(void) const
{
    if (!CanGetSid()) {
        ThrowUnassigned(3);
    }
    return m_Sid;
}

inline
void CTSeq_Base::SetSid(const CTSeq_Base::TSid& value)
{
    m_Sid = value;
    m_set_State[0] |= 0xc0;
}

inline
void CTSeq_Base::SetSid(CTSeq_Base::TSid&& value)
{
    m_Sid = std::forward<CTSeq_Base::TSid>(value);
    m_set_State[0] |= 0xc0;
}

inline
CTSeq_Base::TSid& CTSeq_Base::SetSid(void)
{
#ifdef _DEBUG
    if (!IsSetSid()) {
        m_Sid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Sid;
}

inline
bool CTSeq_Base::IsSetLocal(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTSeq_Base::CanGetLocal(void) const
{
    return IsSetLocal();
}

inline
const CTSeq_Base::TLocal& CTSeq_Base::GetLocal(void) const
{
    if (!CanGetLocal()) {
        ThrowUnassigned(4);
    }
    return m_Local;
}

inline
void CTSeq_Base::SetLocal(const CTSeq_Base::TLocal& value)
{
    m_Local = value;
    m_set_State[0] |= 0x300;
}

inline
void CTSeq_Base::SetLocal(CTSeq_Base::TLocal&& value)
{
    m_Local = std::forward<CTSeq_Base::TLocal>(value);
    m_set_State[0] |= 0x300;
}

inline
CTSeq_Base::TLocal& CTSeq_Base::SetLocal(void)
{
#ifdef _DEBUG
    if (!IsSetLocal()) {
        m_Local = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Local;
}

inline
bool CTSeq_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTSeq_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CTSeq_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CTSeq_Base::TTaxid CTSeq_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(5);
    }
    return m_Taxid;
}

inline
void CTSeq_Base::SetTaxid(CTSeq_Base::TTaxid value)
{
    m_Taxid = value;
    m_set_State[0] |= 0xc00;
}

inline
CTSeq_Base::TTaxid& CTSeq_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Taxid;
}

inline
bool CTSeq_Base::IsSetOrgname(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CTSeq_Base::CanGetOrgname(void) const
{
    return IsSetOrgname();
}

inline
const CTSeq_Base::TOrgname& CTSeq_Base::GetOrgname(void) const
{
    if (!CanGetOrgname()) {
        ThrowUnassigned(6);
    }
    return m_Orgname;
}

inline
void CTSeq_Base::SetOrgname(const CTSeq_Base::TOrgname& value)
{
    m_Orgname = value;
    m_set_State[0] |= 0x3000;
}

inline
void CTSeq_Base::SetOrgname(CTSeq_Base::TOrgname&& value)
{
    m_Orgname = std::forward<CTSeq_Base::TOrgname>(value);
    m_set_State[0] |= 0x3000;
}

inline
CTSeq_Base::TOrgname& CTSeq_Base::SetOrgname(void)
{
#ifdef _DEBUG
    if (!IsSetOrgname()) {
        m_Orgname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Orgname;
}

inline
bool CTSeq_Base::IsSetDefline(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CTSeq_Base::CanGetDefline(void) const
{
    return IsSetDefline();
}

inline
const CTSeq_Base::TDefline& CTSeq_Base::GetDefline(void) const
{
    if (!CanGetDefline()) {
        ThrowUnassigned(7);
    }
    return m_Defline;
}

inline
void CTSeq_Base::SetDefline(const CTSeq_Base::TDefline& value)
{
    m_Defline = value;
    m_set_State[0] |= 0xc000;
}

inline
void CTSeq_Base::SetDefline(CTSeq_Base::TDefline&& value)
{
    m_Defline = std::forward<CTSeq_Base::TDefline>(value);
    m_set_State[0] |= 0xc000;
}

inline
CTSeq_Base::TDefline& CTSeq_Base::SetDefline(void)
{
#ifdef _DEBUG
    if (!IsSetDefline()) {
        m_Defline = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Defline;
}

inline
bool CTSeq_Base::IsSetLength(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CTSeq_Base::CanGetLength(void) const
{
    return IsSetLength();
}

inline
void CTSeq_Base::ResetLength(void)
{
    m_Length = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CTSeq_Base::TLength CTSeq_Base::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(8);
    }
    return m_Length;
}

inline
void CTSeq_Base::SetLength(CTSeq_Base::TLength value)
{
    m_Length = value;
    m_set_State[0] |= 0x30000;
}

inline
CTSeq_Base::TLength& CTSeq_Base::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        memset(&m_Length,UnassignedByte(),sizeof(m_Length));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Length;
}

inline
bool CTSeq_Base::IsSetSequence(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CTSeq_Base::CanGetSequence(void) const
{
    return IsSetSequence();
}

inline
const CTSeq_Base::TSequence& CTSeq_Base::GetSequence(void) const
{
    if (!CanGetSequence()) {
        ThrowUnassigned(9);
    }
    return m_Sequence;
}

inline
void CTSeq_Base::SetSequence(const CTSeq_Base::TSequence& value)
{
    m_Sequence = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CTSeq_Base::SetSequence(CTSeq_Base::TSequence&& value)
{
    m_Sequence = std::forward<CTSeq_Base::TSequence>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CTSeq_Base::TSequence& CTSeq_Base::SetSequence(void)
{
#ifdef _DEBUG
    if (!IsSetSequence()) {
        m_Sequence = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Sequence;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TINYSEQ_TSEQ_BASE_HPP
