/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_DisplayTrack_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_DISPLAYTRACK_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_DISPLAYTRACK_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_Attribute;
class CTMgr_DTrackId;
class CTMgr_DatasetItem;
class CTMgr_DatasetItemSeq;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///-
///- Meta data for TMS, TMSUser, TMSRemote (tracks and hubs)
///-
class NCBI_TRACKMGR_EXPORT CTMgr_DisplayTrack_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_DisplayTrack_Base(void);
    // destructor
    virtual ~CTMgr_DisplayTrack_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_DTrackId TDtrack_id;
    typedef CStringUTF8 TName;
    typedef list< CRef< CTMgr_Attribute > > TAttrs;
    typedef list< CRef< CTMgr_DatasetItemSeq > > TSeqs;
    typedef list< CRef< CTMgr_DatasetItem > > TItems;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_dtrack_id,
        e_name,
        e_attrs,
        e_seqs,
        e_items
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// hub-ids, tms-ids, user-ids, remote-ids and must be distinguishable
    /// mandatory
    /// typedef CTMgr_DTrackId TDtrack_id
    ///  Check whether the Dtrack_id data member has been assigned a value.
    bool IsSetDtrack_id(void) const;
    /// Check whether it is safe or not to call GetDtrack_id method.
    bool CanGetDtrack_id(void) const;
    void ResetDtrack_id(void);
    const TDtrack_id& GetDtrack_id(void) const;
    void SetDtrack_id(TDtrack_id& value);
    TDtrack_id& SetDtrack_id(void);

    /// mandatory
    /// typedef CStringUTF8 TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef list< CRef< CTMgr_Attribute > > TAttrs
    ///  Check whether the Attrs data member has been assigned a value.
    bool IsSetAttrs(void) const;
    /// Check whether it is safe or not to call GetAttrs method.
    bool CanGetAttrs(void) const;
    void ResetAttrs(void);
    const TAttrs& GetAttrs(void) const;
    TAttrs& SetAttrs(void);

    /// optional
    /// typedef list< CRef< CTMgr_DatasetItemSeq > > TSeqs
    ///  Check whether the Seqs data member has been assigned a value.
    bool IsSetSeqs(void) const;
    /// Check whether it is safe or not to call GetSeqs method.
    bool CanGetSeqs(void) const;
    void ResetSeqs(void);
    const TSeqs& GetSeqs(void) const;
    TSeqs& SetSeqs(void);

    /// optional
    /// typedef list< CRef< CTMgr_DatasetItem > > TItems
    ///  Check whether the Items data member has been assigned a value.
    bool IsSetItems(void) const;
    /// Check whether it is safe or not to call GetItems method.
    bool CanGetItems(void) const;
    void ResetItems(void);
    const TItems& GetItems(void) const;
    TItems& SetItems(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_DisplayTrack_Base(const CTMgr_DisplayTrack_Base&);
    CTMgr_DisplayTrack_Base& operator=(const CTMgr_DisplayTrack_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TDtrack_id > m_Dtrack_id;
    CStringUTF8 m_Name;
    list< CRef< CTMgr_Attribute > > m_Attrs;
    list< CRef< CTMgr_DatasetItemSeq > > m_Seqs;
    list< CRef< CTMgr_DatasetItem > > m_Items;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_DisplayTrack_Base::IsSetDtrack_id(void) const
{
    return m_Dtrack_id.NotEmpty();
}

inline
bool CTMgr_DisplayTrack_Base::CanGetDtrack_id(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrack_Base::TDtrack_id& CTMgr_DisplayTrack_Base::GetDtrack_id(void) const
{
    if ( !m_Dtrack_id ) {
        const_cast<CTMgr_DisplayTrack_Base*>(this)->ResetDtrack_id();
    }
    return (*m_Dtrack_id);
}

inline
CTMgr_DisplayTrack_Base::TDtrack_id& CTMgr_DisplayTrack_Base::SetDtrack_id(void)
{
    if ( !m_Dtrack_id ) {
        ResetDtrack_id();
    }
    return (*m_Dtrack_id);
}

inline
bool CTMgr_DisplayTrack_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_DisplayTrack_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CTMgr_DisplayTrack_Base::TName& CTMgr_DisplayTrack_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CTMgr_DisplayTrack_Base::SetName(const CTMgr_DisplayTrack_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_DisplayTrack_Base::SetName(CTMgr_DisplayTrack_Base::TName&& value)
{
    m_Name = std::forward<CTMgr_DisplayTrack_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_DisplayTrack_Base::TName& CTMgr_DisplayTrack_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CTMgr_DisplayTrack_Base::IsSetAttrs(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_DisplayTrack_Base::CanGetAttrs(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrack_Base::TAttrs& CTMgr_DisplayTrack_Base::GetAttrs(void) const
{
    return m_Attrs;
}

inline
CTMgr_DisplayTrack_Base::TAttrs& CTMgr_DisplayTrack_Base::SetAttrs(void)
{
    m_set_State[0] |= 0x10;
    return m_Attrs;
}

inline
bool CTMgr_DisplayTrack_Base::IsSetSeqs(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_DisplayTrack_Base::CanGetSeqs(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrack_Base::TSeqs& CTMgr_DisplayTrack_Base::GetSeqs(void) const
{
    return m_Seqs;
}

inline
CTMgr_DisplayTrack_Base::TSeqs& CTMgr_DisplayTrack_Base::SetSeqs(void)
{
    m_set_State[0] |= 0x40;
    return m_Seqs;
}

inline
bool CTMgr_DisplayTrack_Base::IsSetItems(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_DisplayTrack_Base::CanGetItems(void) const
{
    return true;
}

inline
const CTMgr_DisplayTrack_Base::TItems& CTMgr_DisplayTrack_Base::GetItems(void) const
{
    return m_Items;
}

inline
CTMgr_DisplayTrack_Base::TItems& CTMgr_DisplayTrack_Base::SetItems(void)
{
    m_set_State[0] |= 0x100;
    return m_Items;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_DISPLAYTRACK_BASE_HPP
