/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_GenomeContext_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_GENOMECONTEXT_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_GENOMECONTEXT_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;
class CTMgr_AssemblySpec;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_GenomeContext_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_GenomeContext_Base(void);
    // destructor
    virtual ~CTMgr_GenomeContext_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_TRACKMGR_EXPORT C_Assembly_and_sequence : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Assembly_and_sequence(void);
        // destructor
        ~C_Assembly_and_sequence(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CTMgr_AssemblySpec TAssembly;
        typedef CSeq_id TSequence;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_assembly,
            e_sequence
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef CTMgr_AssemblySpec TAssembly
        ///  Check whether the Assembly data member has been assigned a value.
        bool IsSetAssembly(void) const;
        /// Check whether it is safe or not to call GetAssembly method.
        bool CanGetAssembly(void) const;
        void ResetAssembly(void);
        const TAssembly& GetAssembly(void) const;
        void SetAssembly(TAssembly& value);
        TAssembly& SetAssembly(void);
    
        /// mandatory
        /// typedef CSeq_id TSequence
        ///  Check whether the Sequence data member has been assigned a value.
        bool IsSetSequence(void) const;
        /// Check whether it is safe or not to call GetSequence method.
        bool CanGetSequence(void) const;
        void ResetSequence(void);
        const TSequence& GetSequence(void) const;
        void SetSequence(TSequence& value);
        TSequence& SetSequence(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Assembly_and_sequence(const C_Assembly_and_sequence&);
        C_Assembly_and_sequence& operator=(const C_Assembly_and_sequence&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAssembly > m_Assembly;
        CRef< TSequence > m_Sequence;
    };

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,            ///< No variant selected
        e_Assembly,
        e_Sequence,
        e_Refseqgene,
        e_All,
        e_Assembly_and_sequence
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Assembly_and_sequence+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CTMgr_AssemblySpec TAssembly;
    typedef CSeq_id TSequence;
    typedef C_Assembly_and_sequence TAssembly_and_sequence;

    // getters
    // setters

    // typedef CTMgr_AssemblySpec TAssembly
    bool IsAssembly(void) const;
    const TAssembly& GetAssembly(void) const;
    TAssembly& SetAssembly(void);
    void SetAssembly(TAssembly& value);

    // typedef CSeq_id TSequence
    bool IsSequence(void) const;
    const TSequence& GetSequence(void) const;
    TSequence& SetSequence(void);
    void SetSequence(TSequence& value);


    bool IsRefseqgene(void) const;
    void SetRefseqgene(void);


    bool IsAll(void) const;
    void SetAll(void);

    // typedef C_Assembly_and_sequence TAssembly_and_sequence
    bool IsAssembly_and_sequence(void) const;
    const TAssembly_and_sequence& GetAssembly_and_sequence(void) const;
    TAssembly_and_sequence& SetAssembly_and_sequence(void);
    void SetAssembly_and_sequence(TAssembly_and_sequence& value);


private:
    // copy constructor and assignment operator
    CTMgr_GenomeContext_Base(const CTMgr_GenomeContext_Base& );
    CTMgr_GenomeContext_Base& operator=(const CTMgr_GenomeContext_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_GenomeContext_Base::C_Assembly_and_sequence::IsSetAssembly(void) const
{
    return m_Assembly.NotEmpty();
}

inline
bool CTMgr_GenomeContext_Base::C_Assembly_and_sequence::CanGetAssembly(void) const
{
    return true;
}

inline
const CTMgr_GenomeContext_Base::C_Assembly_and_sequence::TAssembly& CTMgr_GenomeContext_Base::C_Assembly_and_sequence::GetAssembly(void) const
{
    if ( !m_Assembly ) {
        const_cast<C_Assembly_and_sequence*>(this)->ResetAssembly();
    }
    return (*m_Assembly);
}

inline
CTMgr_GenomeContext_Base::C_Assembly_and_sequence::TAssembly& CTMgr_GenomeContext_Base::C_Assembly_and_sequence::SetAssembly(void)
{
    if ( !m_Assembly ) {
        ResetAssembly();
    }
    return (*m_Assembly);
}

inline
bool CTMgr_GenomeContext_Base::C_Assembly_and_sequence::IsSetSequence(void) const
{
    return m_Sequence.NotEmpty();
}

inline
bool CTMgr_GenomeContext_Base::C_Assembly_and_sequence::CanGetSequence(void) const
{
    return true;
}

inline
const CTMgr_GenomeContext_Base::C_Assembly_and_sequence::TSequence& CTMgr_GenomeContext_Base::C_Assembly_and_sequence::GetSequence(void) const
{
    if ( !m_Sequence ) {
        const_cast<C_Assembly_and_sequence*>(this)->ResetSequence();
    }
    return (*m_Sequence);
}

inline
CTMgr_GenomeContext_Base::C_Assembly_and_sequence::TSequence& CTMgr_GenomeContext_Base::C_Assembly_and_sequence::SetSequence(void)
{
    if ( !m_Sequence ) {
        ResetSequence();
    }
    return (*m_Sequence);
}

inline
CTMgr_GenomeContext_Base::E_Choice CTMgr_GenomeContext_Base::Which(void) const
{
    return m_choice;
}

inline
void CTMgr_GenomeContext_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTMgr_GenomeContext_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTMgr_GenomeContext_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTMgr_GenomeContext_Base::IsAssembly(void) const
{
    return m_choice == e_Assembly;
}

inline
bool CTMgr_GenomeContext_Base::IsSequence(void) const
{
    return m_choice == e_Sequence;
}

inline
bool CTMgr_GenomeContext_Base::IsRefseqgene(void) const
{
    return m_choice == e_Refseqgene;
}

inline
void CTMgr_GenomeContext_Base::SetRefseqgene(void)
{
    Select(e_Refseqgene, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTMgr_GenomeContext_Base::IsAll(void) const
{
    return m_choice == e_All;
}

inline
void CTMgr_GenomeContext_Base::SetAll(void)
{
    Select(e_All, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CTMgr_GenomeContext_Base::IsAssembly_and_sequence(void) const
{
    return m_choice == e_Assembly_and_sequence;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_GENOMECONTEXT_BASE_HPP
