/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DbsnpTooltipSectionValue_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'dbsnp_tooltip_service.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSECTIONVALUE_BASE_HPP
#define OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSECTIONVALUE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CDbsnpTooltipSectionValue_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDbsnpTooltipSectionValue_Base(void);
    // destructor
    virtual ~CDbsnpTooltipSectionValue_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TKey;
    typedef string TValue;
    typedef string TUrl;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_key,
        e_value,
        e_url
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// Short description of the value.
    /// mandatory
    /// typedef string TKey
    ///  Check whether the Key data member has been assigned a value.
    bool IsSetKey(void) const;
    /// Check whether it is safe or not to call GetKey method.
    bool CanGetKey(void) const;
    void ResetKey(void);
    const TKey& GetKey(void) const;
    void SetKey(const TKey& value);
    void SetKey(TKey&& value);
    TKey& SetKey(void);

    /// The value as text.
    /// mandatory
    /// typedef string TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// Optional URL that points to additional information
    /// about the value.
    /// optional
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDbsnpTooltipSectionValue_Base(const CDbsnpTooltipSectionValue_Base&);
    CDbsnpTooltipSectionValue_Base& operator=(const CDbsnpTooltipSectionValue_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Key;
    string m_Value;
    string m_Url;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDbsnpTooltipSectionValue_Base::IsSetKey(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDbsnpTooltipSectionValue_Base::CanGetKey(void) const
{
    return IsSetKey();
}

inline
const CDbsnpTooltipSectionValue_Base::TKey& CDbsnpTooltipSectionValue_Base::GetKey(void) const
{
    if (!CanGetKey()) {
        ThrowUnassigned(0);
    }
    return m_Key;
}

inline
void CDbsnpTooltipSectionValue_Base::SetKey(const CDbsnpTooltipSectionValue_Base::TKey& value)
{
    m_Key = value;
    m_set_State[0] |= 0x3;
}

inline
void CDbsnpTooltipSectionValue_Base::SetKey(CDbsnpTooltipSectionValue_Base::TKey&& value)
{
    m_Key = std::forward<CDbsnpTooltipSectionValue_Base::TKey>(value);
    m_set_State[0] |= 0x3;
}

inline
CDbsnpTooltipSectionValue_Base::TKey& CDbsnpTooltipSectionValue_Base::SetKey(void)
{
#ifdef _DEBUG
    if (!IsSetKey()) {
        m_Key = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Key;
}

inline
bool CDbsnpTooltipSectionValue_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDbsnpTooltipSectionValue_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CDbsnpTooltipSectionValue_Base::TValue& CDbsnpTooltipSectionValue_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CDbsnpTooltipSectionValue_Base::SetValue(const CDbsnpTooltipSectionValue_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CDbsnpTooltipSectionValue_Base::SetValue(CDbsnpTooltipSectionValue_Base::TValue&& value)
{
    m_Value = std::forward<CDbsnpTooltipSectionValue_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CDbsnpTooltipSectionValue_Base::TValue& CDbsnpTooltipSectionValue_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

inline
bool CDbsnpTooltipSectionValue_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CDbsnpTooltipSectionValue_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const CDbsnpTooltipSectionValue_Base::TUrl& CDbsnpTooltipSectionValue_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(2);
    }
    return m_Url;
}

inline
void CDbsnpTooltipSectionValue_Base::SetUrl(const CDbsnpTooltipSectionValue_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0x30;
}

inline
void CDbsnpTooltipSectionValue_Base::SetUrl(CDbsnpTooltipSectionValue_Base::TUrl&& value)
{
    m_Url = std::forward<CDbsnpTooltipSectionValue_Base::TUrl>(value);
    m_set_State[0] |= 0x30;
}

inline
CDbsnpTooltipSectionValue_Base::TUrl& CDbsnpTooltipSectionValue_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Url;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_LIBS_DBSNP_TOOLTIP_SERVICE_DBSNPTOOLTIPSECTIONVALUE_BASE_HPP
