/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AaSite_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_AASITE_BASE_HPP
#define OBJECTS_VARREP_AASITE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAaSite_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAaSite_Base(void);
    // destructor
    virtual ~CAaSite_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSeqPos TIndex;
    typedef string TAa;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_index,
        e_aa
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef TSeqPos TIndex
    ///  Check whether the Index data member has been assigned a value.
    bool IsSetIndex(void) const;
    /// Check whether it is safe or not to call GetIndex method.
    bool CanGetIndex(void) const;
    void ResetIndex(void);
    TIndex GetIndex(void) const;
    void SetIndex(TIndex value);
    TIndex& SetIndex(void);

    /// mandatory
    /// typedef string TAa
    ///  Check whether the Aa data member has been assigned a value.
    bool IsSetAa(void) const;
    /// Check whether it is safe or not to call GetAa method.
    bool CanGetAa(void) const;
    void ResetAa(void);
    const TAa& GetAa(void) const;
    void SetAa(const TAa& value);
    void SetAa(TAa&& value);
    TAa& SetAa(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAaSite_Base(const CAaSite_Base&);
    CAaSite_Base& operator=(const CAaSite_Base&);

    // data
    Uint4 m_set_State[1];
    TSeqPos m_Index;
    string m_Aa;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAaSite_Base::IsSetIndex(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAaSite_Base::CanGetIndex(void) const
{
    return IsSetIndex();
}

inline
void CAaSite_Base::ResetIndex(void)
{
    m_Index = 0;
    m_set_State[0] &= ~0x3;
}

inline
CAaSite_Base::TIndex CAaSite_Base::GetIndex(void) const
{
    if (!CanGetIndex()) {
        ThrowUnassigned(0);
    }
    return m_Index;
}

inline
void CAaSite_Base::SetIndex(CAaSite_Base::TIndex value)
{
    m_Index = value;
    m_set_State[0] |= 0x3;
}

inline
CAaSite_Base::TIndex& CAaSite_Base::SetIndex(void)
{
#ifdef _DEBUG
    if (!IsSetIndex()) {
        memset(&m_Index,UnassignedByte(),sizeof(m_Index));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Index;
}

inline
bool CAaSite_Base::IsSetAa(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAaSite_Base::CanGetAa(void) const
{
    return IsSetAa();
}

inline
const CAaSite_Base::TAa& CAaSite_Base::GetAa(void) const
{
    if (!CanGetAa()) {
        ThrowUnassigned(1);
    }
    return m_Aa;
}

inline
void CAaSite_Base::SetAa(const CAaSite_Base::TAa& value)
{
    m_Aa = value;
    m_set_State[0] |= 0xc;
}

inline
void CAaSite_Base::SetAa(CAaSite_Base::TAa&& value)
{
    m_Aa = std::forward<CAaSite_Base::TAa>(value);
    m_set_State[0] |= 0xc;
}

inline
CAaSite_Base::TAa& CAaSite_Base::SetAa(void)
{
#ifdef _DEBUG
    if (!IsSetAa()) {
        m_Aa = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Aa;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_AASITE_BASE_HPP
