/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file NaSub_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_NASUB_BASE_HPP
#define OBJECTS_VARREP_NASUB_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNtLocation;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CNaSub_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNaSub_Base(void);
    // destructor
    virtual ~CNaSub_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CNtLocation TLoc;
    typedef string TInitial;
    typedef string TFinal;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_loc,
        e_initial,
        e_final
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CNtLocation TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(TLoc& value);
    TLoc& SetLoc(void);

    /// mandatory
    /// typedef string TInitial
    ///  Check whether the Initial data member has been assigned a value.
    bool IsSetInitial(void) const;
    /// Check whether it is safe or not to call GetInitial method.
    bool CanGetInitial(void) const;
    void ResetInitial(void);
    const TInitial& GetInitial(void) const;
    void SetInitial(const TInitial& value);
    void SetInitial(TInitial&& value);
    TInitial& SetInitial(void);

    /// mandatory
    /// typedef string TFinal
    ///  Check whether the Final data member has been assigned a value.
    bool IsSetFinal(void) const;
    /// Check whether it is safe or not to call GetFinal method.
    bool CanGetFinal(void) const;
    void ResetFinal(void);
    const TFinal& GetFinal(void) const;
    void SetFinal(const TFinal& value);
    void SetFinal(TFinal&& value);
    TFinal& SetFinal(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CNaSub_Base(const CNaSub_Base&);
    CNaSub_Base& operator=(const CNaSub_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLoc > m_Loc;
    string m_Initial;
    string m_Final;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CNaSub_Base::IsSetLoc(void) const
{
    return m_Loc.NotEmpty();
}

inline
bool CNaSub_Base::CanGetLoc(void) const
{
    return true;
}

inline
const CNaSub_Base::TLoc& CNaSub_Base::GetLoc(void) const
{
    if ( !m_Loc ) {
        const_cast<CNaSub_Base*>(this)->ResetLoc();
    }
    return (*m_Loc);
}

inline
CNaSub_Base::TLoc& CNaSub_Base::SetLoc(void)
{
    if ( !m_Loc ) {
        ResetLoc();
    }
    return (*m_Loc);
}

inline
bool CNaSub_Base::IsSetInitial(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CNaSub_Base::CanGetInitial(void) const
{
    return IsSetInitial();
}

inline
const CNaSub_Base::TInitial& CNaSub_Base::GetInitial(void) const
{
    if (!CanGetInitial()) {
        ThrowUnassigned(1);
    }
    return m_Initial;
}

inline
void CNaSub_Base::SetInitial(const CNaSub_Base::TInitial& value)
{
    m_Initial = value;
    m_set_State[0] |= 0xc;
}

inline
void CNaSub_Base::SetInitial(CNaSub_Base::TInitial&& value)
{
    m_Initial = std::forward<CNaSub_Base::TInitial>(value);
    m_set_State[0] |= 0xc;
}

inline
CNaSub_Base::TInitial& CNaSub_Base::SetInitial(void)
{
#ifdef _DEBUG
    if (!IsSetInitial()) {
        m_Initial = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Initial;
}

inline
bool CNaSub_Base::IsSetFinal(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CNaSub_Base::CanGetFinal(void) const
{
    return IsSetFinal();
}

inline
const CNaSub_Base::TFinal& CNaSub_Base::GetFinal(void) const
{
    if (!CanGetFinal()) {
        ThrowUnassigned(2);
    }
    return m_Final;
}

inline
void CNaSub_Base::SetFinal(const CNaSub_Base::TFinal& value)
{
    m_Final = value;
    m_set_State[0] |= 0x30;
}

inline
void CNaSub_Base::SetFinal(CNaSub_Base::TFinal&& value)
{
    m_Final = std::forward<CNaSub_Base::TFinal>(value);
    m_set_State[0] |= 0x30;
}

inline
CNaSub_Base::TFinal& CNaSub_Base::SetFinal(void)
{
#ifdef _DEBUG
    if (!IsSetFinal()) {
        m_Final = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Final;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_NASUB_BASE_HPP
