/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Repeat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_REPEAT_BASE_HPP
#define OBJECTS_VARREP_REPEAT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCount;
class CSeqLocation;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CRepeat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRepeat_Base(void);
    // destructor
    virtual ~CRepeat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeqLocation TLoc;
    typedef CCount TCount;
    typedef string TRaw_seq;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_loc,
        e_count,
        e_raw_seq
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeqLocation TLoc
    ///  Check whether the Loc data member has been assigned a value.
    bool IsSetLoc(void) const;
    /// Check whether it is safe or not to call GetLoc method.
    bool CanGetLoc(void) const;
    void ResetLoc(void);
    const TLoc& GetLoc(void) const;
    void SetLoc(TLoc& value);
    TLoc& SetLoc(void);

    /// mandatory
    /// typedef CCount TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    const TCount& GetCount(void) const;
    void SetCount(TCount& value);
    TCount& SetCount(void);

    ///Used if ntloc is a site, not an interval
    /// optional
    /// typedef string TRaw_seq
    ///  Check whether the Raw_seq data member has been assigned a value.
    bool IsSetRaw_seq(void) const;
    /// Check whether it is safe or not to call GetRaw_seq method.
    bool CanGetRaw_seq(void) const;
    void ResetRaw_seq(void);
    const TRaw_seq& GetRaw_seq(void) const;
    void SetRaw_seq(const TRaw_seq& value);
    void SetRaw_seq(TRaw_seq&& value);
    TRaw_seq& SetRaw_seq(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRepeat_Base(const CRepeat_Base&);
    CRepeat_Base& operator=(const CRepeat_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLoc > m_Loc;
    CRef< TCount > m_Count;
    string m_Raw_seq;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRepeat_Base::IsSetLoc(void) const
{
    return m_Loc.NotEmpty();
}

inline
bool CRepeat_Base::CanGetLoc(void) const
{
    return true;
}

inline
const CRepeat_Base::TLoc& CRepeat_Base::GetLoc(void) const
{
    if ( !m_Loc ) {
        const_cast<CRepeat_Base*>(this)->ResetLoc();
    }
    return (*m_Loc);
}

inline
CRepeat_Base::TLoc& CRepeat_Base::SetLoc(void)
{
    if ( !m_Loc ) {
        ResetLoc();
    }
    return (*m_Loc);
}

inline
bool CRepeat_Base::IsSetCount(void) const
{
    return m_Count.NotEmpty();
}

inline
bool CRepeat_Base::CanGetCount(void) const
{
    return true;
}

inline
const CRepeat_Base::TCount& CRepeat_Base::GetCount(void) const
{
    if ( !m_Count ) {
        const_cast<CRepeat_Base*>(this)->ResetCount();
    }
    return (*m_Count);
}

inline
CRepeat_Base::TCount& CRepeat_Base::SetCount(void)
{
    if ( !m_Count ) {
        ResetCount();
    }
    return (*m_Count);
}

inline
bool CRepeat_Base::IsSetRaw_seq(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRepeat_Base::CanGetRaw_seq(void) const
{
    return IsSetRaw_seq();
}

inline
const CRepeat_Base::TRaw_seq& CRepeat_Base::GetRaw_seq(void) const
{
    if (!CanGetRaw_seq()) {
        ThrowUnassigned(2);
    }
    return m_Raw_seq;
}

inline
void CRepeat_Base::SetRaw_seq(const CRepeat_Base::TRaw_seq& value)
{
    m_Raw_seq = value;
    m_set_State[0] |= 0x30;
}

inline
void CRepeat_Base::SetRaw_seq(CRepeat_Base::TRaw_seq&& value)
{
    m_Raw_seq = std::forward<CRepeat_Base::TRaw_seq>(value);
    m_set_State[0] |= 0x30;
}

inline
CRepeat_Base::TRaw_seq& CRepeat_Base::SetRaw_seq(void)
{
#ifdef _DEBUG
    if (!IsSetRaw_seq()) {
        m_Raw_seq = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Raw_seq;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_REPEAT_BASE_HPP
