/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AuthorList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_AUTHORLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_AUTHORLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAuthor;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAuthorList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CAuthorList_Base(void);
    // destructor
    virtual ~CAuthorList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_CompleteYN {
            eAttlist_CompleteYN_Y = 1,
            eAttlist_CompleteYN_N = 2
        };
        
        /// Access to EAttlist_CompleteYN's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_CompleteYN)(void);
        
        enum EAttlist_Type {
            eAttlist_Type_authors = 1,
            eAttlist_Type_editors = 2
        };
        
        /// Access to EAttlist_Type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Type)(void);
        
        // types
        typedef EAttlist_CompleteYN TCompleteYN;
        typedef EAttlist_Type TType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_CompleteYN,
            e_Type
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// optional with default eAttlist_CompleteYN_Y
        /// typedef EAttlist_CompleteYN TCompleteYN
        ///  Check whether the CompleteYN data member has been assigned a value.
        bool IsSetCompleteYN(void) const;
        /// Check whether it is safe or not to call GetCompleteYN method.
        bool CanGetCompleteYN(void) const;
        void ResetCompleteYN(void);
        void SetDefaultCompleteYN(void);
        TCompleteYN GetCompleteYN(void) const;
        void SetCompleteYN(TCompleteYN value);
        TCompleteYN& SetCompleteYN(void);
    
        /// optional
        /// typedef EAttlist_Type TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        TType GetType(void) const;
        void SetType(TType value);
        TType& SetType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_CompleteYN m_CompleteYN;
        EAttlist_Type m_Type;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthor > > TAuthor;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Author
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthor > > TAuthor
    ///  Check whether the Author data member has been assigned a value.
    bool IsSetAuthor(void) const;
    /// Check whether it is safe or not to call GetAuthor method.
    bool CanGetAuthor(void) const;
    void ResetAuthor(void);
    const TAuthor& GetAuthor(void) const;
    TAuthor& SetAuthor(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAuthorList_Base(const CAuthorList_Base&);
    CAuthorList_Base& operator=(const CAuthorList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthor > > m_Author;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAuthorList_Base::C_Attlist::IsSetCompleteYN(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAuthorList_Base::C_Attlist::CanGetCompleteYN(void) const
{
    return true;
}

inline
void CAuthorList_Base::C_Attlist::ResetCompleteYN(void)
{
    m_CompleteYN = eAttlist_CompleteYN_Y;
    m_set_State[0] &= ~0x3;
}

inline
void CAuthorList_Base::C_Attlist::SetDefaultCompleteYN(void)
{
    ResetCompleteYN();
    m_set_State[0] |= 0x1;
}

inline
CAuthorList_Base::C_Attlist::TCompleteYN CAuthorList_Base::C_Attlist::GetCompleteYN(void) const
{
    return m_CompleteYN;
}

inline
void CAuthorList_Base::C_Attlist::SetCompleteYN(CAuthorList_Base::C_Attlist::TCompleteYN value)
{
    m_CompleteYN = value;
    m_set_State[0] |= 0x3;
}

inline
CAuthorList_Base::C_Attlist::TCompleteYN& CAuthorList_Base::C_Attlist::SetCompleteYN(void)
{
#ifdef _DEBUG
    if (!IsSetCompleteYN()) {
        memset(&m_CompleteYN,UnassignedByte(),sizeof(m_CompleteYN));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_CompleteYN;
}

inline
bool CAuthorList_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAuthorList_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CAuthorList_Base::C_Attlist::ResetType(void)
{
    m_Type = (EAttlist_Type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CAuthorList_Base::C_Attlist::TType CAuthorList_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CAuthorList_Base::C_Attlist::SetType(CAuthorList_Base::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CAuthorList_Base::C_Attlist::TType& CAuthorList_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CAuthorList_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAuthorList_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CAuthorList_Base::TAttlist& CAuthorList_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CAuthorList_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAuthorList_Base::TAttlist& CAuthorList_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAuthorList_Base::IsSetAuthor(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAuthorList_Base::CanGetAuthor(void) const
{
    return true;
}

inline
const CAuthorList_Base::TAuthor& CAuthorList_Base::GetAuthor(void) const
{
    return m_Author;
}

inline
CAuthorList_Base::TAuthor& CAuthorList_Base::SetAuthor(void)
{
    m_set_State[0] |= 0x4;
    return m_Author;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_AUTHORLIST_BASE_HPP
