/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Bind_content_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_BIND_CONTENT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_BIND_CONTENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAbs;
class CAnd;
class CApply;
class CApprox;
class CArccos;
class CArccosh;
class CArccot;
class CArccoth;
class CArccsc;
class CArccsch;
class CArcsec;
class CArcsech;
class CArcsin;
class CArcsinh;
class CArctan;
class CArctanh;
class CArg;
class CBind;
class CBvar;
class CCard;
class CCartesianproduct;
class CCbytes;
class CCeiling;
class CCerror;
class CCi;
class CCn;
class CCodomain;
class CComplexes;
class CCompose;
class CCondition;
class CConjugate;
class CCos;
class CCosh;
class CCot;
class CCoth;
class CCs;
class CCsc;
class CCsch;
class CCsymbol;
class CCurl;
class CDeclare;
class CDegree;
class CDeterminant;
class CDiff;
class CDivergence;
class CDivide;
class CDomain;
class CDomainofapplication;
class CEmptyset;
class CEq;
class CEquivalent;
class CEulergamma;
class CExists;
class CExp;
class CExponentiale;
class CFactorial;
class CFactorof;
class CFalse;
class CFloor;
class CFn;
class CForall;
class CGcd;
class CGeq;
class CGrad;
class CGt;
class CIdent;
class CImage;
class CImaginary;
class CImaginaryi;
class CImplies;
class CIn;
class CInfinity;
class CInt;
class CIntegers;
class CIntersect;
class CInterval;
class CInverse;
class CLambda;
class CLaplacian;
class CLcm;
class CLeq;
class CLimit;
class CList;
class CLn;
class CLog;
class CLogbase;
class CLowlimit;
class CLt;
class CMatrix;
class CMatrixrow;
class CMax;
class CMean;
class CMedian;
class CMin;
class CMinus;
class CMode;
class CMoment;
class CMomentabout;
class CNaturalnumbers;
class CNeq;
class CNot;
class CNotanumber;
class CNotin;
class CNotprsubset;
class CNotsubset;
class COr;
class COuterproduct;
class CPartialdiff;
class CPi;
class CPiecewise;
class CPlus;
class CPower;
class CPrimes;
class CProduct;
class CPrsubset;
class CQuotient;
class CRationals;
class CReal;
class CReals;
class CReln;
class CRem;
class CRoot;
class CScalarproduct;
class CSdev;
class CSec;
class CSech;
class CSelector;
class CSemantics;
class CSet;
class CSetdiff;
class CShare;
class CSin;
class CSinh;
class CSubset;
class CSum;
class CTan;
class CTanh;
class CTendsto;
class CTimes;
class CTranspose;
class CTrue;
class CUnion;
class CUplimit;
class CVariance;
class CVector;
class CVectorproduct;
class CXor;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CBind_content_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CBind_content_Base(void);
    // destructor
    virtual ~CBind_content_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_ContExp : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_ContExp(void);
        // destructor
        ~C_ContExp(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_E_ContExp : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_E_ContExp(void);
            // destructor
            ~C_E_ContExp(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            /////////////////////////////////////////////////////////////////////////////
            class C_DeprecatedContExp : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_DeprecatedContExp(void);
                // destructor
                ~C_DeprecatedContExp(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Reln,
                    e_Fn,
                    e_Declare
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 4 ///< == e_Declare+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CReln TReln;
                typedef CFn TFn;
                typedef CDeclare TDeclare;
            
                // getters
                // setters
            
                // typedef CReln TReln
                bool IsReln(void) const;
                const TReln& GetReln(void) const;
                TReln& SetReln(void);
                void SetReln(TReln& value);
            
                // typedef CFn TFn
                bool IsFn(void) const;
                const TFn& GetFn(void) const;
                TFn& SetFn(void);
                void SetFn(TFn& value);
            
                // typedef CDeclare TDeclare
                bool IsDeclare(void) const;
                const TDeclare& GetDeclare(void) const;
                TDeclare& SetDeclare(void);
                void SetDeclare(TDeclare& value);
            
            
            private:
                // copy constructor and assignment operator
                C_DeprecatedContExp(const C_DeprecatedContExp& );
                C_DeprecatedContExp& operator=(const C_DeprecatedContExp& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Interval_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Interval_mmlclass(void);
                // destructor
                ~C_Interval_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CInterval TInterval;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_interval
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CInterval TInterval
                ///  Check whether the Interval data member has been assigned a value.
                bool IsSetInterval(void) const;
                /// Check whether it is safe or not to call GetInterval method.
                bool CanGetInterval(void) const;
                void ResetInterval(void);
                const TInterval& GetInterval(void) const;
                void SetInterval(TInterval& value);
                TInterval& SetInterval(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Interval_mmlclass(const C_Interval_mmlclass&);
                C_Interval_mmlclass& operator=(const C_Interval_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TInterval > m_Interval;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_functional_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_functional_mmlclass(void);
                // destructor
                ~C_Unary_functional_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Inverse,
                    e_Ident,
                    e_Domain,
                    e_Codomain,
                    e_Image,
                    e_Ln,
                    e_Log,
                    e_Moment
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 9 ///< == e_Moment+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CInverse TInverse;
                typedef CIdent TIdent;
                typedef CDomain TDomain;
                typedef CCodomain TCodomain;
                typedef CImage TImage;
                typedef CLn TLn;
                typedef CLog TLog;
                typedef CMoment TMoment;
            
                // getters
                // setters
            
                // typedef CInverse TInverse
                bool IsInverse(void) const;
                const TInverse& GetInverse(void) const;
                TInverse& SetInverse(void);
            
                // typedef CIdent TIdent
                bool IsIdent(void) const;
                const TIdent& GetIdent(void) const;
                TIdent& SetIdent(void);
            
                // typedef CDomain TDomain
                bool IsDomain(void) const;
                const TDomain& GetDomain(void) const;
                TDomain& SetDomain(void);
            
                // typedef CCodomain TCodomain
                bool IsCodomain(void) const;
                const TCodomain& GetCodomain(void) const;
                TCodomain& SetCodomain(void);
            
                // typedef CImage TImage
                bool IsImage(void) const;
                const TImage& GetImage(void) const;
                TImage& SetImage(void);
            
                // typedef CLn TLn
                bool IsLn(void) const;
                const TLn& GetLn(void) const;
                TLn& SetLn(void);
            
                // typedef CLog TLog
                bool IsLog(void) const;
                const TLog& GetLog(void) const;
                TLog& SetLog(void);
            
                // typedef CMoment TMoment
                bool IsMoment(void) const;
                const TMoment& GetMoment(void) const;
                TMoment& SetMoment(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Unary_functional_mmlclass(const C_Unary_functional_mmlclass& );
                C_Unary_functional_mmlclass& operator=(const C_Unary_functional_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Lambda_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Lambda_mmlclass(void);
                // destructor
                ~C_Lambda_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CLambda TLambda;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_lambda
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CLambda TLambda
                ///  Check whether the Lambda data member has been assigned a value.
                bool IsSetLambda(void) const;
                /// Check whether it is safe or not to call GetLambda method.
                bool CanGetLambda(void) const;
                void ResetLambda(void);
                const TLambda& GetLambda(void) const;
                void SetLambda(TLambda& value);
                TLambda& SetLambda(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Lambda_mmlclass(const C_Lambda_mmlclass&);
                C_Lambda_mmlclass& operator=(const C_Lambda_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TLambda > m_Lambda;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_functional_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_functional_mmlclass(void);
                // destructor
                ~C_Nary_functional_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CCompose TCompose;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_compose
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CCompose TCompose
                ///  Check whether the Compose data member has been assigned a value.
                bool IsSetCompose(void) const;
                /// Check whether it is safe or not to call GetCompose method.
                bool CanGetCompose(void) const;
                void ResetCompose(void);
                const TCompose& GetCompose(void) const;
                void SetCompose(TCompose& value);
                TCompose& SetCompose(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Nary_functional_mmlclass(const C_Nary_functional_mmlclass&);
                C_Nary_functional_mmlclass& operator=(const C_Nary_functional_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TCompose > m_Compose;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Binary_arith_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Binary_arith_mmlclass(void);
                // destructor
                ~C_Binary_arith_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Quotient,
                    e_Divide,
                    e_Minus,
                    e_Power,
                    e_Rem,
                    e_Root
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 7 ///< == e_Root+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CQuotient TQuotient;
                typedef CDivide TDivide;
                typedef CMinus TMinus;
                typedef CPower TPower;
                typedef CRem TRem;
                typedef CRoot TRoot;
            
                // getters
                // setters
            
                // typedef CQuotient TQuotient
                bool IsQuotient(void) const;
                const TQuotient& GetQuotient(void) const;
                TQuotient& SetQuotient(void);
            
                // typedef CDivide TDivide
                bool IsDivide(void) const;
                const TDivide& GetDivide(void) const;
                TDivide& SetDivide(void);
            
                // typedef CMinus TMinus
                bool IsMinus(void) const;
                const TMinus& GetMinus(void) const;
                TMinus& SetMinus(void);
            
                // typedef CPower TPower
                bool IsPower(void) const;
                const TPower& GetPower(void) const;
                TPower& SetPower(void);
            
                // typedef CRem TRem
                bool IsRem(void) const;
                const TRem& GetRem(void) const;
                TRem& SetRem(void);
            
                // typedef CRoot TRoot
                bool IsRoot(void) const;
                const TRoot& GetRoot(void) const;
                TRoot& SetRoot(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Binary_arith_mmlclass(const C_Binary_arith_mmlclass& );
                C_Binary_arith_mmlclass& operator=(const C_Binary_arith_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_arith_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_arith_mmlclass(void);
                // destructor
                ~C_Unary_arith_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Factorial,
                    e_Abs,
                    e_Conjugate,
                    e_Arg,
                    e_Real,
                    e_Imaginary,
                    e_Floor,
                    e_Ceiling,
                    e_Exp
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 10 ///< == e_Exp+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CFactorial TFactorial;
                typedef CAbs TAbs;
                typedef CConjugate TConjugate;
                typedef CArg TArg;
                typedef CReal TReal;
                typedef CImaginary TImaginary;
                typedef CFloor TFloor;
                typedef CCeiling TCeiling;
                typedef CExp TExp;
            
                // getters
                // setters
            
                // typedef CFactorial TFactorial
                bool IsFactorial(void) const;
                const TFactorial& GetFactorial(void) const;
                TFactorial& SetFactorial(void);
            
                // typedef CAbs TAbs
                bool IsAbs(void) const;
                const TAbs& GetAbs(void) const;
                TAbs& SetAbs(void);
            
                // typedef CConjugate TConjugate
                bool IsConjugate(void) const;
                const TConjugate& GetConjugate(void) const;
                TConjugate& SetConjugate(void);
            
                // typedef CArg TArg
                bool IsArg(void) const;
                const TArg& GetArg(void) const;
                TArg& SetArg(void);
            
                // typedef CReal TReal
                bool IsReal(void) const;
                const TReal& GetReal(void) const;
                TReal& SetReal(void);
            
                // typedef CImaginary TImaginary
                bool IsImaginary(void) const;
                const TImaginary& GetImaginary(void) const;
                TImaginary& SetImaginary(void);
            
                // typedef CFloor TFloor
                bool IsFloor(void) const;
                const TFloor& GetFloor(void) const;
                TFloor& SetFloor(void);
            
                // typedef CCeiling TCeiling
                bool IsCeiling(void) const;
                const TCeiling& GetCeiling(void) const;
                TCeiling& SetCeiling(void);
            
                // typedef CExp TExp
                bool IsExp(void) const;
                const TExp& GetExp(void) const;
                TExp& SetExp(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Unary_arith_mmlclass(const C_Unary_arith_mmlclass& );
                C_Unary_arith_mmlclass& operator=(const C_Unary_arith_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_minmax_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_minmax_mmlclass(void);
                // destructor
                ~C_Nary_minmax_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Max,
                    e_Min
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_Min+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CMax TMax;
                typedef CMin TMin;
            
                // getters
                // setters
            
                // typedef CMax TMax
                bool IsMax(void) const;
                const TMax& GetMax(void) const;
                TMax& SetMax(void);
            
                // typedef CMin TMin
                bool IsMin(void) const;
                const TMin& GetMin(void) const;
                TMin& SetMin(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_minmax_mmlclass(const C_Nary_minmax_mmlclass& );
                C_Nary_minmax_mmlclass& operator=(const C_Nary_minmax_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_arith_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_arith_mmlclass(void);
                // destructor
                ~C_Nary_arith_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Plus,
                    e_Times,
                    e_Gcd,
                    e_Lcm
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 5 ///< == e_Lcm+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CPlus TPlus;
                typedef CTimes TTimes;
                typedef CGcd TGcd;
                typedef CLcm TLcm;
            
                // getters
                // setters
            
                // typedef CPlus TPlus
                bool IsPlus(void) const;
                const TPlus& GetPlus(void) const;
                TPlus& SetPlus(void);
            
                // typedef CTimes TTimes
                bool IsTimes(void) const;
                const TTimes& GetTimes(void) const;
                TTimes& SetTimes(void);
            
                // typedef CGcd TGcd
                bool IsGcd(void) const;
                const TGcd& GetGcd(void) const;
                TGcd& SetGcd(void);
            
                // typedef CLcm TLcm
                bool IsLcm(void) const;
                const TLcm& GetLcm(void) const;
                TLcm& SetLcm(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_arith_mmlclass(const C_Nary_arith_mmlclass& );
                C_Nary_arith_mmlclass& operator=(const C_Nary_arith_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_logical_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_logical_mmlclass(void);
                // destructor
                ~C_Nary_logical_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_And,
                    e_Or,
                    e_Xor
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 4 ///< == e_Xor+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CAnd TAnd;
                typedef COr TOr;
                typedef CXor TXor;
            
                // getters
                // setters
            
                // typedef CAnd TAnd
                bool IsAnd(void) const;
                const TAnd& GetAnd(void) const;
                TAnd& SetAnd(void);
            
                // typedef COr TOr
                bool IsOr(void) const;
                const TOr& GetOr(void) const;
                TOr& SetOr(void);
            
                // typedef CXor TXor
                bool IsXor(void) const;
                const TXor& GetXor(void) const;
                TXor& SetXor(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_logical_mmlclass(const C_Nary_logical_mmlclass& );
                C_Nary_logical_mmlclass& operator=(const C_Nary_logical_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_logical_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_logical_mmlclass(void);
                // destructor
                ~C_Unary_logical_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CNot TNot;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_not
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CNot TNot
                ///  Check whether the Not data member has been assigned a value.
                bool IsSetNot(void) const;
                /// Check whether it is safe or not to call GetNot method.
                bool CanGetNot(void) const;
                void ResetNot(void);
                const TNot& GetNot(void) const;
                void SetNot(TNot& value);
                TNot& SetNot(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Unary_logical_mmlclass(const C_Unary_logical_mmlclass&);
                C_Unary_logical_mmlclass& operator=(const C_Unary_logical_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TNot > m_Not;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Binary_logical_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Binary_logical_mmlclass(void);
                // destructor
                ~C_Binary_logical_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Implies,
                    e_Equivalent
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_Equivalent+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CImplies TImplies;
                typedef CEquivalent TEquivalent;
            
                // getters
                // setters
            
                // typedef CImplies TImplies
                bool IsImplies(void) const;
                const TImplies& GetImplies(void) const;
                TImplies& SetImplies(void);
            
                // typedef CEquivalent TEquivalent
                bool IsEquivalent(void) const;
                const TEquivalent& GetEquivalent(void) const;
                TEquivalent& SetEquivalent(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Binary_logical_mmlclass(const C_Binary_logical_mmlclass& );
                C_Binary_logical_mmlclass& operator=(const C_Binary_logical_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Quantifier_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Quantifier_mmlclass(void);
                // destructor
                ~C_Quantifier_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Forall,
                    e_Exists
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_Exists+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CForall TForall;
                typedef CExists TExists;
            
                // getters
                // setters
            
                // typedef CForall TForall
                bool IsForall(void) const;
                const TForall& GetForall(void) const;
                TForall& SetForall(void);
            
                // typedef CExists TExists
                bool IsExists(void) const;
                const TExists& GetExists(void) const;
                TExists& SetExists(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Quantifier_mmlclass(const C_Quantifier_mmlclass& );
                C_Quantifier_mmlclass& operator=(const C_Quantifier_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_reln_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_reln_mmlclass(void);
                // destructor
                ~C_Nary_reln_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Eq,
                    e_Gt,
                    e_Lt,
                    e_Geq,
                    e_Leq
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 6 ///< == e_Leq+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CEq TEq;
                typedef CGt TGt;
                typedef CLt TLt;
                typedef CGeq TGeq;
                typedef CLeq TLeq;
            
                // getters
                // setters
            
                // typedef CEq TEq
                bool IsEq(void) const;
                const TEq& GetEq(void) const;
                TEq& SetEq(void);
            
                // typedef CGt TGt
                bool IsGt(void) const;
                const TGt& GetGt(void) const;
                TGt& SetGt(void);
            
                // typedef CLt TLt
                bool IsLt(void) const;
                const TLt& GetLt(void) const;
                TLt& SetLt(void);
            
                // typedef CGeq TGeq
                bool IsGeq(void) const;
                const TGeq& GetGeq(void) const;
                TGeq& SetGeq(void);
            
                // typedef CLeq TLeq
                bool IsLeq(void) const;
                const TLeq& GetLeq(void) const;
                TLeq& SetLeq(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_reln_mmlclass(const C_Nary_reln_mmlclass& );
                C_Nary_reln_mmlclass& operator=(const C_Nary_reln_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Binary_reln_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Binary_reln_mmlclass(void);
                // destructor
                ~C_Binary_reln_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Neq,
                    e_Approx,
                    e_Factorof,
                    e_Tendsto
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 5 ///< == e_Tendsto+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CNeq TNeq;
                typedef CApprox TApprox;
                typedef CFactorof TFactorof;
                typedef CTendsto TTendsto;
            
                // getters
                // setters
            
                // typedef CNeq TNeq
                bool IsNeq(void) const;
                const TNeq& GetNeq(void) const;
                TNeq& SetNeq(void);
            
                // typedef CApprox TApprox
                bool IsApprox(void) const;
                const TApprox& GetApprox(void) const;
                TApprox& SetApprox(void);
            
                // typedef CFactorof TFactorof
                bool IsFactorof(void) const;
                const TFactorof& GetFactorof(void) const;
                TFactorof& SetFactorof(void);
            
                // typedef CTendsto TTendsto
                bool IsTendsto(void) const;
                const TTendsto& GetTendsto(void) const;
                TTendsto& SetTendsto(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Binary_reln_mmlclass(const C_Binary_reln_mmlclass& );
                C_Binary_reln_mmlclass& operator=(const C_Binary_reln_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Int_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Int_mmlclass(void);
                // destructor
                ~C_Int_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CInt TInt;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_int
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CInt TInt
                ///  Check whether the Int data member has been assigned a value.
                bool IsSetInt(void) const;
                /// Check whether it is safe or not to call GetInt method.
                bool CanGetInt(void) const;
                void ResetInt(void);
                const TInt& GetInt(void) const;
                void SetInt(TInt& value);
                TInt& SetInt(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Int_mmlclass(const C_Int_mmlclass&);
                C_Int_mmlclass& operator=(const C_Int_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TInt > m_Int;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Differential_Operator_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Differential_Operator_mmlclass(void);
                // destructor
                ~C_Differential_Operator_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CDiff TDiff;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_diff
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CDiff TDiff
                ///  Check whether the Diff data member has been assigned a value.
                bool IsSetDiff(void) const;
                /// Check whether it is safe or not to call GetDiff method.
                bool CanGetDiff(void) const;
                void ResetDiff(void);
                const TDiff& GetDiff(void) const;
                void SetDiff(TDiff& value);
                TDiff& SetDiff(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Differential_Operator_mmlclass(const C_Differential_Operator_mmlclass&);
                C_Differential_Operator_mmlclass& operator=(const C_Differential_Operator_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TDiff > m_Diff;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Partialdiff_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Partialdiff_mmlclass(void);
                // destructor
                ~C_Partialdiff_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CPartialdiff TPartialdiff;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_partialdiff
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CPartialdiff TPartialdiff
                ///  Check whether the Partialdiff data member has been assigned a value.
                bool IsSetPartialdiff(void) const;
                /// Check whether it is safe or not to call GetPartialdiff method.
                bool CanGetPartialdiff(void) const;
                void ResetPartialdiff(void);
                const TPartialdiff& GetPartialdiff(void) const;
                void SetPartialdiff(TPartialdiff& value);
                TPartialdiff& SetPartialdiff(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Partialdiff_mmlclass(const C_Partialdiff_mmlclass&);
                C_Partialdiff_mmlclass& operator=(const C_Partialdiff_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TPartialdiff > m_Partialdiff;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_veccalc_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_veccalc_mmlclass(void);
                // destructor
                ~C_Unary_veccalc_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Divergence,
                    e_Grad,
                    e_Curl,
                    e_Laplacian
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 5 ///< == e_Laplacian+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CDivergence TDivergence;
                typedef CGrad TGrad;
                typedef CCurl TCurl;
                typedef CLaplacian TLaplacian;
            
                // getters
                // setters
            
                // typedef CDivergence TDivergence
                bool IsDivergence(void) const;
                const TDivergence& GetDivergence(void) const;
                TDivergence& SetDivergence(void);
            
                // typedef CGrad TGrad
                bool IsGrad(void) const;
                const TGrad& GetGrad(void) const;
                TGrad& SetGrad(void);
            
                // typedef CCurl TCurl
                bool IsCurl(void) const;
                const TCurl& GetCurl(void) const;
                TCurl& SetCurl(void);
            
                // typedef CLaplacian TLaplacian
                bool IsLaplacian(void) const;
                const TLaplacian& GetLaplacian(void) const;
                TLaplacian& SetLaplacian(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Unary_veccalc_mmlclass(const C_Unary_veccalc_mmlclass& );
                C_Unary_veccalc_mmlclass& operator=(const C_Unary_veccalc_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_setlist_constructor_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_setlist_constructor_mmlclass(void);
                // destructor
                ~C_Nary_setlist_constructor_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Set,
                    e_List
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_List+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CSet TSet;
                typedef CList TList;
            
                // getters
                // setters
            
                // typedef CSet TSet
                bool IsSet(void) const;
                const TSet& GetSet(void) const;
                TSet& SetSet(void);
                void SetSet(TSet& value);
            
                // typedef CList TList
                bool IsList(void) const;
                const TList& GetList(void) const;
                TList& SetList(void);
                void SetList(TList& value);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_setlist_constructor_mmlclass(const C_Nary_setlist_constructor_mmlclass& );
                C_Nary_setlist_constructor_mmlclass& operator=(const C_Nary_setlist_constructor_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_set_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_set_mmlclass(void);
                // destructor
                ~C_Nary_set_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,       ///< No variant selected
                    e_Union,
                    e_Intersect,
                    e_Cartesianproduct
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 4 ///< == e_Cartesianproduct+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CUnion TUnion;
                typedef CIntersect TIntersect;
                typedef CCartesianproduct TCartesianproduct;
            
                // getters
                // setters
            
                // typedef CUnion TUnion
                bool IsUnion(void) const;
                const TUnion& GetUnion(void) const;
                TUnion& SetUnion(void);
            
                // typedef CIntersect TIntersect
                bool IsIntersect(void) const;
                const TIntersect& GetIntersect(void) const;
                TIntersect& SetIntersect(void);
            
                // typedef CCartesianproduct TCartesianproduct
                bool IsCartesianproduct(void) const;
                const TCartesianproduct& GetCartesianproduct(void) const;
                TCartesianproduct& SetCartesianproduct(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_set_mmlclass(const C_Nary_set_mmlclass& );
                C_Nary_set_mmlclass& operator=(const C_Nary_set_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Binary_set_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Binary_set_mmlclass(void);
                // destructor
                ~C_Binary_set_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_In,
                    e_Notin,
                    e_Notsubset,
                    e_Notprsubset,
                    e_Setdiff
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 6 ///< == e_Setdiff+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CIn TIn;
                typedef CNotin TNotin;
                typedef CNotsubset TNotsubset;
                typedef CNotprsubset TNotprsubset;
                typedef CSetdiff TSetdiff;
            
                // getters
                // setters
            
                // typedef CIn TIn
                bool IsIn(void) const;
                const TIn& GetIn(void) const;
                TIn& SetIn(void);
            
                // typedef CNotin TNotin
                bool IsNotin(void) const;
                const TNotin& GetNotin(void) const;
                TNotin& SetNotin(void);
            
                // typedef CNotsubset TNotsubset
                bool IsNotsubset(void) const;
                const TNotsubset& GetNotsubset(void) const;
                TNotsubset& SetNotsubset(void);
            
                // typedef CNotprsubset TNotprsubset
                bool IsNotprsubset(void) const;
                const TNotprsubset& GetNotprsubset(void) const;
                TNotprsubset& SetNotprsubset(void);
            
                // typedef CSetdiff TSetdiff
                bool IsSetdiff(void) const;
                const TSetdiff& GetSetdiff(void) const;
                TSetdiff& SetSetdiff(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Binary_set_mmlclass(const C_Binary_set_mmlclass& );
                C_Binary_set_mmlclass& operator=(const C_Binary_set_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_set_reln_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_set_reln_mmlclass(void);
                // destructor
                ~C_Nary_set_reln_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Subset,
                    e_Prsubset
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_Prsubset+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CSubset TSubset;
                typedef CPrsubset TPrsubset;
            
                // getters
                // setters
            
                // typedef CSubset TSubset
                bool IsSubset(void) const;
                const TSubset& GetSubset(void) const;
                TSubset& SetSubset(void);
            
                // typedef CPrsubset TPrsubset
                bool IsPrsubset(void) const;
                const TPrsubset& GetPrsubset(void) const;
                TPrsubset& SetPrsubset(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_set_reln_mmlclass(const C_Nary_set_reln_mmlclass& );
                C_Nary_set_reln_mmlclass& operator=(const C_Nary_set_reln_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_set_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_set_mmlclass(void);
                // destructor
                ~C_Unary_set_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CCard TCard;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_card
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CCard TCard
                ///  Check whether the Card data member has been assigned a value.
                bool IsSetCard(void) const;
                /// Check whether it is safe or not to call GetCard method.
                bool CanGetCard(void) const;
                void ResetCard(void);
                const TCard& GetCard(void) const;
                void SetCard(TCard& value);
                TCard& SetCard(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Unary_set_mmlclass(const C_Unary_set_mmlclass&);
                C_Unary_set_mmlclass& operator=(const C_Unary_set_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TCard > m_Card;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Sum_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Sum_mmlclass(void);
                // destructor
                ~C_Sum_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CSum TSum;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_sum
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CSum TSum
                ///  Check whether the Sum data member has been assigned a value.
                bool IsSetSum(void) const;
                /// Check whether it is safe or not to call GetSum method.
                bool CanGetSum(void) const;
                void ResetSum(void);
                const TSum& GetSum(void) const;
                void SetSum(TSum& value);
                TSum& SetSum(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Sum_mmlclass(const C_Sum_mmlclass&);
                C_Sum_mmlclass& operator=(const C_Sum_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TSum > m_Sum;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Product_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Product_mmlclass(void);
                // destructor
                ~C_Product_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CProduct TProduct;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_product
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CProduct TProduct
                ///  Check whether the Product data member has been assigned a value.
                bool IsSetProduct(void) const;
                /// Check whether it is safe or not to call GetProduct method.
                bool CanGetProduct(void) const;
                void ResetProduct(void);
                const TProduct& GetProduct(void) const;
                void SetProduct(TProduct& value);
                TProduct& SetProduct(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Product_mmlclass(const C_Product_mmlclass&);
                C_Product_mmlclass& operator=(const C_Product_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TProduct > m_Product;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Limit_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Limit_mmlclass(void);
                // destructor
                ~C_Limit_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CLimit TLimit;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_limit
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CLimit TLimit
                ///  Check whether the Limit data member has been assigned a value.
                bool IsSetLimit(void) const;
                /// Check whether it is safe or not to call GetLimit method.
                bool CanGetLimit(void) const;
                void ResetLimit(void);
                const TLimit& GetLimit(void) const;
                void SetLimit(TLimit& value);
                TLimit& SetLimit(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Limit_mmlclass(const C_Limit_mmlclass&);
                C_Limit_mmlclass& operator=(const C_Limit_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TLimit > m_Limit;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_elementary_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_elementary_mmlclass(void);
                // destructor
                ~C_Unary_elementary_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Sin,
                    e_Cos,
                    e_Tan,
                    e_Sec,
                    e_Csc,
                    e_Cot,
                    e_Sinh,
                    e_Cosh,
                    e_Tanh,
                    e_Sech,
                    e_Csch,
                    e_Coth,
                    e_Arcsin,
                    e_Arccos,
                    e_Arctan,
                    e_Arccosh,
                    e_Arccot,
                    e_Arccoth,
                    e_Arccsc,
                    e_Arccsch,
                    e_Arcsec,
                    e_Arcsech,
                    e_Arcsinh,
                    e_Arctanh
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 25 ///< == e_Arctanh+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CSin TSin;
                typedef CCos TCos;
                typedef CTan TTan;
                typedef CSec TSec;
                typedef CCsc TCsc;
                typedef CCot TCot;
                typedef CSinh TSinh;
                typedef CCosh TCosh;
                typedef CTanh TTanh;
                typedef CSech TSech;
                typedef CCsch TCsch;
                typedef CCoth TCoth;
                typedef CArcsin TArcsin;
                typedef CArccos TArccos;
                typedef CArctan TArctan;
                typedef CArccosh TArccosh;
                typedef CArccot TArccot;
                typedef CArccoth TArccoth;
                typedef CArccsc TArccsc;
                typedef CArccsch TArccsch;
                typedef CArcsec TArcsec;
                typedef CArcsech TArcsech;
                typedef CArcsinh TArcsinh;
                typedef CArctanh TArctanh;
            
                // getters
                // setters
            
                // typedef CSin TSin
                bool IsSin(void) const;
                const TSin& GetSin(void) const;
                TSin& SetSin(void);
            
                // typedef CCos TCos
                bool IsCos(void) const;
                const TCos& GetCos(void) const;
                TCos& SetCos(void);
            
                // typedef CTan TTan
                bool IsTan(void) const;
                const TTan& GetTan(void) const;
                TTan& SetTan(void);
            
                // typedef CSec TSec
                bool IsSec(void) const;
                const TSec& GetSec(void) const;
                TSec& SetSec(void);
            
                // typedef CCsc TCsc
                bool IsCsc(void) const;
                const TCsc& GetCsc(void) const;
                TCsc& SetCsc(void);
            
                // typedef CCot TCot
                bool IsCot(void) const;
                const TCot& GetCot(void) const;
                TCot& SetCot(void);
            
                // typedef CSinh TSinh
                bool IsSinh(void) const;
                const TSinh& GetSinh(void) const;
                TSinh& SetSinh(void);
            
                // typedef CCosh TCosh
                bool IsCosh(void) const;
                const TCosh& GetCosh(void) const;
                TCosh& SetCosh(void);
            
                // typedef CTanh TTanh
                bool IsTanh(void) const;
                const TTanh& GetTanh(void) const;
                TTanh& SetTanh(void);
            
                // typedef CSech TSech
                bool IsSech(void) const;
                const TSech& GetSech(void) const;
                TSech& SetSech(void);
            
                // typedef CCsch TCsch
                bool IsCsch(void) const;
                const TCsch& GetCsch(void) const;
                TCsch& SetCsch(void);
            
                // typedef CCoth TCoth
                bool IsCoth(void) const;
                const TCoth& GetCoth(void) const;
                TCoth& SetCoth(void);
            
                // typedef CArcsin TArcsin
                bool IsArcsin(void) const;
                const TArcsin& GetArcsin(void) const;
                TArcsin& SetArcsin(void);
            
                // typedef CArccos TArccos
                bool IsArccos(void) const;
                const TArccos& GetArccos(void) const;
                TArccos& SetArccos(void);
            
                // typedef CArctan TArctan
                bool IsArctan(void) const;
                const TArctan& GetArctan(void) const;
                TArctan& SetArctan(void);
            
                // typedef CArccosh TArccosh
                bool IsArccosh(void) const;
                const TArccosh& GetArccosh(void) const;
                TArccosh& SetArccosh(void);
            
                // typedef CArccot TArccot
                bool IsArccot(void) const;
                const TArccot& GetArccot(void) const;
                TArccot& SetArccot(void);
            
                // typedef CArccoth TArccoth
                bool IsArccoth(void) const;
                const TArccoth& GetArccoth(void) const;
                TArccoth& SetArccoth(void);
            
                // typedef CArccsc TArccsc
                bool IsArccsc(void) const;
                const TArccsc& GetArccsc(void) const;
                TArccsc& SetArccsc(void);
            
                // typedef CArccsch TArccsch
                bool IsArccsch(void) const;
                const TArccsch& GetArccsch(void) const;
                TArccsch& SetArccsch(void);
            
                // typedef CArcsec TArcsec
                bool IsArcsec(void) const;
                const TArcsec& GetArcsec(void) const;
                TArcsec& SetArcsec(void);
            
                // typedef CArcsech TArcsech
                bool IsArcsech(void) const;
                const TArcsech& GetArcsech(void) const;
                TArcsech& SetArcsech(void);
            
                // typedef CArcsinh TArcsinh
                bool IsArcsinh(void) const;
                const TArcsinh& GetArcsinh(void) const;
                TArcsinh& SetArcsinh(void);
            
                // typedef CArctanh TArctanh
                bool IsArctanh(void) const;
                const TArctanh& GetArctanh(void) const;
                TArctanh& SetArctanh(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Unary_elementary_mmlclass(const C_Unary_elementary_mmlclass& );
                C_Unary_elementary_mmlclass& operator=(const C_Unary_elementary_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_stats_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_stats_mmlclass(void);
                // destructor
                ~C_Nary_stats_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Mean,
                    e_Sdev,
                    e_Variance,
                    e_Median,
                    e_Mode
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 6 ///< == e_Mode+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CMean TMean;
                typedef CSdev TSdev;
                typedef CVariance TVariance;
                typedef CMedian TMedian;
                typedef CMode TMode;
            
                // getters
                // setters
            
                // typedef CMean TMean
                bool IsMean(void) const;
                const TMean& GetMean(void) const;
                TMean& SetMean(void);
            
                // typedef CSdev TSdev
                bool IsSdev(void) const;
                const TSdev& GetSdev(void) const;
                TSdev& SetSdev(void);
            
                // typedef CVariance TVariance
                bool IsVariance(void) const;
                const TVariance& GetVariance(void) const;
                TVariance& SetVariance(void);
            
                // typedef CMedian TMedian
                bool IsMedian(void) const;
                const TMedian& GetMedian(void) const;
                TMedian& SetMedian(void);
            
                // typedef CMode TMode
                bool IsMode(void) const;
                const TMode& GetMode(void) const;
                TMode& SetMode(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_stats_mmlclass(const C_Nary_stats_mmlclass& );
                C_Nary_stats_mmlclass& operator=(const C_Nary_stats_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_constructor_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_constructor_mmlclass(void);
                // destructor
                ~C_Nary_constructor_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Vector,
                    e_Matrix,
                    e_Matrixrow
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 4 ///< == e_Matrixrow+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CVector TVector;
                typedef CMatrix TMatrix;
                typedef CMatrixrow TMatrixrow;
            
                // getters
                // setters
            
                // typedef CVector TVector
                bool IsVector(void) const;
                const TVector& GetVector(void) const;
                TVector& SetVector(void);
                void SetVector(TVector& value);
            
                // typedef CMatrix TMatrix
                bool IsMatrix(void) const;
                const TMatrix& GetMatrix(void) const;
                TMatrix& SetMatrix(void);
                void SetMatrix(TMatrix& value);
            
                // typedef CMatrixrow TMatrixrow
                bool IsMatrixrow(void) const;
                const TMatrixrow& GetMatrixrow(void) const;
                TMatrixrow& SetMatrixrow(void);
                void SetMatrixrow(TMatrixrow& value);
            
            
            private:
                // copy constructor and assignment operator
                C_Nary_constructor_mmlclass(const C_Nary_constructor_mmlclass& );
                C_Nary_constructor_mmlclass& operator=(const C_Nary_constructor_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Unary_linalg_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Unary_linalg_mmlclass(void);
                // destructor
                ~C_Unary_linalg_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Determinant,
                    e_Transpose
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_Transpose+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CDeterminant TDeterminant;
                typedef CTranspose TTranspose;
            
                // getters
                // setters
            
                // typedef CDeterminant TDeterminant
                bool IsDeterminant(void) const;
                const TDeterminant& GetDeterminant(void) const;
                TDeterminant& SetDeterminant(void);
            
                // typedef CTranspose TTranspose
                bool IsTranspose(void) const;
                const TTranspose& GetTranspose(void) const;
                TTranspose& SetTranspose(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Unary_linalg_mmlclass(const C_Unary_linalg_mmlclass& );
                C_Unary_linalg_mmlclass& operator=(const C_Unary_linalg_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Nary_linalg_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Nary_linalg_mmlclass(void);
                // destructor
                ~C_Nary_linalg_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef CSelector TSelector;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_selector
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
            
                // getters
                // setters
            
                /// mandatory
                /// typedef CSelector TSelector
                ///  Check whether the Selector data member has been assigned a value.
                bool IsSetSelector(void) const;
                /// Check whether it is safe or not to call GetSelector method.
                bool CanGetSelector(void) const;
                void ResetSelector(void);
                const TSelector& GetSelector(void) const;
                void SetSelector(TSelector& value);
                TSelector& SetSelector(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Nary_linalg_mmlclass(const C_Nary_linalg_mmlclass&);
                C_Nary_linalg_mmlclass& operator=(const C_Nary_linalg_mmlclass&);
            
                // data
                Uint4 m_set_State[1];
                NCBI_NS_NCBI::CRef< TSelector > m_Selector;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Binary_linalg_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Binary_linalg_mmlclass(void);
                // destructor
                ~C_Binary_linalg_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,    ///< No variant selected
                    e_Vectorproduct,
                    e_Scalarproduct,
                    e_Outerproduct
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 4 ///< == e_Outerproduct+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CVectorproduct TVectorproduct;
                typedef CScalarproduct TScalarproduct;
                typedef COuterproduct TOuterproduct;
            
                // getters
                // setters
            
                // typedef CVectorproduct TVectorproduct
                bool IsVectorproduct(void) const;
                const TVectorproduct& GetVectorproduct(void) const;
                TVectorproduct& SetVectorproduct(void);
            
                // typedef CScalarproduct TScalarproduct
                bool IsScalarproduct(void) const;
                const TScalarproduct& GetScalarproduct(void) const;
                TScalarproduct& SetScalarproduct(void);
            
                // typedef COuterproduct TOuterproduct
                bool IsOuterproduct(void) const;
                const TOuterproduct& GetOuterproduct(void) const;
                TOuterproduct& SetOuterproduct(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Binary_linalg_mmlclass(const C_Binary_linalg_mmlclass& );
                C_Binary_linalg_mmlclass& operator=(const C_Binary_linalg_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Constant_set_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Constant_set_mmlclass(void);
                // destructor
                ~C_Constant_set_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,     ///< No variant selected
                    e_Integers,
                    e_Reals,
                    e_Rationals,
                    e_Naturalnumbers,
                    e_Complexes,
                    e_Primes,
                    e_Emptyset
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 8 ///< == e_Emptyset+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CIntegers TIntegers;
                typedef CReals TReals;
                typedef CRationals TRationals;
                typedef CNaturalnumbers TNaturalnumbers;
                typedef CComplexes TComplexes;
                typedef CPrimes TPrimes;
                typedef CEmptyset TEmptyset;
            
                // getters
                // setters
            
                // typedef CIntegers TIntegers
                bool IsIntegers(void) const;
                const TIntegers& GetIntegers(void) const;
                TIntegers& SetIntegers(void);
            
                // typedef CReals TReals
                bool IsReals(void) const;
                const TReals& GetReals(void) const;
                TReals& SetReals(void);
            
                // typedef CRationals TRationals
                bool IsRationals(void) const;
                const TRationals& GetRationals(void) const;
                TRationals& SetRationals(void);
            
                // typedef CNaturalnumbers TNaturalnumbers
                bool IsNaturalnumbers(void) const;
                const TNaturalnumbers& GetNaturalnumbers(void) const;
                TNaturalnumbers& SetNaturalnumbers(void);
            
                // typedef CComplexes TComplexes
                bool IsComplexes(void) const;
                const TComplexes& GetComplexes(void) const;
                TComplexes& SetComplexes(void);
            
                // typedef CPrimes TPrimes
                bool IsPrimes(void) const;
                const TPrimes& GetPrimes(void) const;
                TPrimes& SetPrimes(void);
            
                // typedef CEmptyset TEmptyset
                bool IsEmptyset(void) const;
                const TEmptyset& GetEmptyset(void) const;
                TEmptyset& SetEmptyset(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Constant_set_mmlclass(const C_Constant_set_mmlclass& );
                C_Constant_set_mmlclass& operator=(const C_Constant_set_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_Constant_arith_mmlclass : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_Constant_arith_mmlclass(void);
                // destructor
                ~C_Constant_arith_mmlclass(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,   ///< No variant selected
                    e_Exponentiale,
                    e_Imaginaryi,
                    e_Notanumber,
                    e_True,
                    e_False,
                    e_Pi,
                    e_Eulergamma,
                    e_Infinity
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 9 ///< == e_Infinity+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CExponentiale TExponentiale;
                typedef CImaginaryi TImaginaryi;
                typedef CNotanumber TNotanumber;
                typedef CTrue TTrue;
                typedef CFalse TFalse;
                typedef CPi TPi;
                typedef CEulergamma TEulergamma;
                typedef CInfinity TInfinity;
            
                // getters
                // setters
            
                // typedef CExponentiale TExponentiale
                bool IsExponentiale(void) const;
                const TExponentiale& GetExponentiale(void) const;
                TExponentiale& SetExponentiale(void);
            
                // typedef CImaginaryi TImaginaryi
                bool IsImaginaryi(void) const;
                const TImaginaryi& GetImaginaryi(void) const;
                TImaginaryi& SetImaginaryi(void);
            
                // typedef CNotanumber TNotanumber
                bool IsNotanumber(void) const;
                const TNotanumber& GetNotanumber(void) const;
                TNotanumber& SetNotanumber(void);
            
                // typedef CTrue TTrue
                bool IsTrue(void) const;
                const TTrue& GetTrue(void) const;
                TTrue& SetTrue(void);
            
                // typedef CFalse TFalse
                bool IsFalse(void) const;
                const TFalse& GetFalse(void) const;
                TFalse& SetFalse(void);
            
                // typedef CPi TPi
                bool IsPi(void) const;
                const TPi& GetPi(void) const;
                TPi& SetPi(void);
            
                // typedef CEulergamma TEulergamma
                bool IsEulergamma(void) const;
                const TEulergamma& GetEulergamma(void) const;
                TEulergamma& SetEulergamma(void);
            
                // typedef CInfinity TInfinity
                bool IsInfinity(void) const;
                const TInfinity& GetInfinity(void) const;
                TInfinity& SetInfinity(void);
            
            
            private:
                // copy constructor and assignment operator
                C_Constant_arith_mmlclass(const C_Constant_arith_mmlclass& );
                C_Constant_arith_mmlclass& operator=(const C_Constant_arith_mmlclass& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,                        ///< No variant selected
                e_Piecewise,
                e_DeprecatedContExp,
                e_Interval_mmlclass,
                e_Unary_functional_mmlclass,
                e_Lambda_mmlclass,
                e_Nary_functional_mmlclass,
                e_Binary_arith_mmlclass,
                e_Unary_arith_mmlclass,
                e_Nary_minmax_mmlclass,
                e_Nary_arith_mmlclass,
                e_Nary_logical_mmlclass,
                e_Unary_logical_mmlclass,
                e_Binary_logical_mmlclass,
                e_Quantifier_mmlclass,
                e_Nary_reln_mmlclass,
                e_Binary_reln_mmlclass,
                e_Int_mmlclass,
                e_Differential_Operator_mmlclass,
                e_Partialdiff_mmlclass,
                e_Unary_veccalc_mmlclass,
                e_Nary_setlist_constructor_mmlclass,
                e_Nary_set_mmlclass,
                e_Binary_set_mmlclass,
                e_Nary_set_reln_mmlclass,
                e_Unary_set_mmlclass,
                e_Sum_mmlclass,
                e_Product_mmlclass,
                e_Limit_mmlclass,
                e_Unary_elementary_mmlclass,
                e_Nary_stats_mmlclass,
                e_Nary_constructor_mmlclass,
                e_Unary_linalg_mmlclass,
                e_Nary_linalg_mmlclass,
                e_Binary_linalg_mmlclass,
                e_Constant_set_mmlclass,
                e_Constant_arith_mmlclass,
                e_Semantics,
                e_Cn,
                e_Ci,
                e_Csymbol,
                e_Apply,
                e_Bind,
                e_Share,
                e_Cerror,
                e_Cbytes,
                e_Cs
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 47 ///< == e_Cs+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef CPiecewise TPiecewise;
            typedef C_DeprecatedContExp TDeprecatedContExp;
            typedef C_Interval_mmlclass TInterval_mmlclass;
            typedef C_Unary_functional_mmlclass TUnary_functional_mmlclass;
            typedef C_Lambda_mmlclass TLambda_mmlclass;
            typedef C_Nary_functional_mmlclass TNary_functional_mmlclass;
            typedef C_Binary_arith_mmlclass TBinary_arith_mmlclass;
            typedef C_Unary_arith_mmlclass TUnary_arith_mmlclass;
            typedef C_Nary_minmax_mmlclass TNary_minmax_mmlclass;
            typedef C_Nary_arith_mmlclass TNary_arith_mmlclass;
            typedef C_Nary_logical_mmlclass TNary_logical_mmlclass;
            typedef C_Unary_logical_mmlclass TUnary_logical_mmlclass;
            typedef C_Binary_logical_mmlclass TBinary_logical_mmlclass;
            typedef C_Quantifier_mmlclass TQuantifier_mmlclass;
            typedef C_Nary_reln_mmlclass TNary_reln_mmlclass;
            typedef C_Binary_reln_mmlclass TBinary_reln_mmlclass;
            typedef C_Int_mmlclass TInt_mmlclass;
            typedef C_Differential_Operator_mmlclass TDifferential_Operator_mmlclass;
            typedef C_Partialdiff_mmlclass TPartialdiff_mmlclass;
            typedef C_Unary_veccalc_mmlclass TUnary_veccalc_mmlclass;
            typedef C_Nary_setlist_constructor_mmlclass TNary_setlist_constructor_mmlclass;
            typedef C_Nary_set_mmlclass TNary_set_mmlclass;
            typedef C_Binary_set_mmlclass TBinary_set_mmlclass;
            typedef C_Nary_set_reln_mmlclass TNary_set_reln_mmlclass;
            typedef C_Unary_set_mmlclass TUnary_set_mmlclass;
            typedef C_Sum_mmlclass TSum_mmlclass;
            typedef C_Product_mmlclass TProduct_mmlclass;
            typedef C_Limit_mmlclass TLimit_mmlclass;
            typedef C_Unary_elementary_mmlclass TUnary_elementary_mmlclass;
            typedef C_Nary_stats_mmlclass TNary_stats_mmlclass;
            typedef C_Nary_constructor_mmlclass TNary_constructor_mmlclass;
            typedef C_Unary_linalg_mmlclass TUnary_linalg_mmlclass;
            typedef C_Nary_linalg_mmlclass TNary_linalg_mmlclass;
            typedef C_Binary_linalg_mmlclass TBinary_linalg_mmlclass;
            typedef C_Constant_set_mmlclass TConstant_set_mmlclass;
            typedef C_Constant_arith_mmlclass TConstant_arith_mmlclass;
            typedef CSemantics TSemantics;
            typedef CCn TCn;
            typedef CCi TCi;
            typedef CCsymbol TCsymbol;
            typedef CApply TApply;
            typedef CBind TBind;
            typedef CShare TShare;
            typedef CCerror TCerror;
            typedef CCbytes TCbytes;
            typedef CCs TCs;
        
            // getters
            // setters
        
            // typedef CPiecewise TPiecewise
            bool IsPiecewise(void) const;
            const TPiecewise& GetPiecewise(void) const;
            TPiecewise& SetPiecewise(void);
            void SetPiecewise(TPiecewise& value);
        
            // typedef C_DeprecatedContExp TDeprecatedContExp
            bool IsDeprecatedContExp(void) const;
            const TDeprecatedContExp& GetDeprecatedContExp(void) const;
            TDeprecatedContExp& SetDeprecatedContExp(void);
            void SetDeprecatedContExp(TDeprecatedContExp& value);
        
            // typedef C_Interval_mmlclass TInterval_mmlclass
            bool IsInterval_mmlclass(void) const;
            const TInterval_mmlclass& GetInterval_mmlclass(void) const;
            TInterval_mmlclass& SetInterval_mmlclass(void);
            void SetInterval_mmlclass(TInterval_mmlclass& value);
        
            // typedef C_Unary_functional_mmlclass TUnary_functional_mmlclass
            bool IsUnary_functional_mmlclass(void) const;
            const TUnary_functional_mmlclass& GetUnary_functional_mmlclass(void) const;
            TUnary_functional_mmlclass& SetUnary_functional_mmlclass(void);
            void SetUnary_functional_mmlclass(TUnary_functional_mmlclass& value);
        
            // typedef C_Lambda_mmlclass TLambda_mmlclass
            bool IsLambda_mmlclass(void) const;
            const TLambda_mmlclass& GetLambda_mmlclass(void) const;
            TLambda_mmlclass& SetLambda_mmlclass(void);
            void SetLambda_mmlclass(TLambda_mmlclass& value);
        
            // typedef C_Nary_functional_mmlclass TNary_functional_mmlclass
            bool IsNary_functional_mmlclass(void) const;
            const TNary_functional_mmlclass& GetNary_functional_mmlclass(void) const;
            TNary_functional_mmlclass& SetNary_functional_mmlclass(void);
            void SetNary_functional_mmlclass(TNary_functional_mmlclass& value);
        
            // typedef C_Binary_arith_mmlclass TBinary_arith_mmlclass
            bool IsBinary_arith_mmlclass(void) const;
            const TBinary_arith_mmlclass& GetBinary_arith_mmlclass(void) const;
            TBinary_arith_mmlclass& SetBinary_arith_mmlclass(void);
            void SetBinary_arith_mmlclass(TBinary_arith_mmlclass& value);
        
            // typedef C_Unary_arith_mmlclass TUnary_arith_mmlclass
            bool IsUnary_arith_mmlclass(void) const;
            const TUnary_arith_mmlclass& GetUnary_arith_mmlclass(void) const;
            TUnary_arith_mmlclass& SetUnary_arith_mmlclass(void);
            void SetUnary_arith_mmlclass(TUnary_arith_mmlclass& value);
        
            // typedef C_Nary_minmax_mmlclass TNary_minmax_mmlclass
            bool IsNary_minmax_mmlclass(void) const;
            const TNary_minmax_mmlclass& GetNary_minmax_mmlclass(void) const;
            TNary_minmax_mmlclass& SetNary_minmax_mmlclass(void);
            void SetNary_minmax_mmlclass(TNary_minmax_mmlclass& value);
        
            // typedef C_Nary_arith_mmlclass TNary_arith_mmlclass
            bool IsNary_arith_mmlclass(void) const;
            const TNary_arith_mmlclass& GetNary_arith_mmlclass(void) const;
            TNary_arith_mmlclass& SetNary_arith_mmlclass(void);
            void SetNary_arith_mmlclass(TNary_arith_mmlclass& value);
        
            // typedef C_Nary_logical_mmlclass TNary_logical_mmlclass
            bool IsNary_logical_mmlclass(void) const;
            const TNary_logical_mmlclass& GetNary_logical_mmlclass(void) const;
            TNary_logical_mmlclass& SetNary_logical_mmlclass(void);
            void SetNary_logical_mmlclass(TNary_logical_mmlclass& value);
        
            // typedef C_Unary_logical_mmlclass TUnary_logical_mmlclass
            bool IsUnary_logical_mmlclass(void) const;
            const TUnary_logical_mmlclass& GetUnary_logical_mmlclass(void) const;
            TUnary_logical_mmlclass& SetUnary_logical_mmlclass(void);
            void SetUnary_logical_mmlclass(TUnary_logical_mmlclass& value);
        
            // typedef C_Binary_logical_mmlclass TBinary_logical_mmlclass
            bool IsBinary_logical_mmlclass(void) const;
            const TBinary_logical_mmlclass& GetBinary_logical_mmlclass(void) const;
            TBinary_logical_mmlclass& SetBinary_logical_mmlclass(void);
            void SetBinary_logical_mmlclass(TBinary_logical_mmlclass& value);
        
            // typedef C_Quantifier_mmlclass TQuantifier_mmlclass
            bool IsQuantifier_mmlclass(void) const;
            const TQuantifier_mmlclass& GetQuantifier_mmlclass(void) const;
            TQuantifier_mmlclass& SetQuantifier_mmlclass(void);
            void SetQuantifier_mmlclass(TQuantifier_mmlclass& value);
        
            // typedef C_Nary_reln_mmlclass TNary_reln_mmlclass
            bool IsNary_reln_mmlclass(void) const;
            const TNary_reln_mmlclass& GetNary_reln_mmlclass(void) const;
            TNary_reln_mmlclass& SetNary_reln_mmlclass(void);
            void SetNary_reln_mmlclass(TNary_reln_mmlclass& value);
        
            // typedef C_Binary_reln_mmlclass TBinary_reln_mmlclass
            bool IsBinary_reln_mmlclass(void) const;
            const TBinary_reln_mmlclass& GetBinary_reln_mmlclass(void) const;
            TBinary_reln_mmlclass& SetBinary_reln_mmlclass(void);
            void SetBinary_reln_mmlclass(TBinary_reln_mmlclass& value);
        
            // typedef C_Int_mmlclass TInt_mmlclass
            bool IsInt_mmlclass(void) const;
            const TInt_mmlclass& GetInt_mmlclass(void) const;
            TInt_mmlclass& SetInt_mmlclass(void);
            void SetInt_mmlclass(TInt_mmlclass& value);
        
            // typedef C_Differential_Operator_mmlclass TDifferential_Operator_mmlclass
            bool IsDifferential_Operator_mmlclass(void) const;
            const TDifferential_Operator_mmlclass& GetDifferential_Operator_mmlclass(void) const;
            TDifferential_Operator_mmlclass& SetDifferential_Operator_mmlclass(void);
            void SetDifferential_Operator_mmlclass(TDifferential_Operator_mmlclass& value);
        
            // typedef C_Partialdiff_mmlclass TPartialdiff_mmlclass
            bool IsPartialdiff_mmlclass(void) const;
            const TPartialdiff_mmlclass& GetPartialdiff_mmlclass(void) const;
            TPartialdiff_mmlclass& SetPartialdiff_mmlclass(void);
            void SetPartialdiff_mmlclass(TPartialdiff_mmlclass& value);
        
            // typedef C_Unary_veccalc_mmlclass TUnary_veccalc_mmlclass
            bool IsUnary_veccalc_mmlclass(void) const;
            const TUnary_veccalc_mmlclass& GetUnary_veccalc_mmlclass(void) const;
            TUnary_veccalc_mmlclass& SetUnary_veccalc_mmlclass(void);
            void SetUnary_veccalc_mmlclass(TUnary_veccalc_mmlclass& value);
        
            // typedef C_Nary_setlist_constructor_mmlclass TNary_setlist_constructor_mmlclass
            bool IsNary_setlist_constructor_mmlclass(void) const;
            const TNary_setlist_constructor_mmlclass& GetNary_setlist_constructor_mmlclass(void) const;
            TNary_setlist_constructor_mmlclass& SetNary_setlist_constructor_mmlclass(void);
            void SetNary_setlist_constructor_mmlclass(TNary_setlist_constructor_mmlclass& value);
        
            // typedef C_Nary_set_mmlclass TNary_set_mmlclass
            bool IsNary_set_mmlclass(void) const;
            const TNary_set_mmlclass& GetNary_set_mmlclass(void) const;
            TNary_set_mmlclass& SetNary_set_mmlclass(void);
            void SetNary_set_mmlclass(TNary_set_mmlclass& value);
        
            // typedef C_Binary_set_mmlclass TBinary_set_mmlclass
            bool IsBinary_set_mmlclass(void) const;
            const TBinary_set_mmlclass& GetBinary_set_mmlclass(void) const;
            TBinary_set_mmlclass& SetBinary_set_mmlclass(void);
            void SetBinary_set_mmlclass(TBinary_set_mmlclass& value);
        
            // typedef C_Nary_set_reln_mmlclass TNary_set_reln_mmlclass
            bool IsNary_set_reln_mmlclass(void) const;
            const TNary_set_reln_mmlclass& GetNary_set_reln_mmlclass(void) const;
            TNary_set_reln_mmlclass& SetNary_set_reln_mmlclass(void);
            void SetNary_set_reln_mmlclass(TNary_set_reln_mmlclass& value);
        
            // typedef C_Unary_set_mmlclass TUnary_set_mmlclass
            bool IsUnary_set_mmlclass(void) const;
            const TUnary_set_mmlclass& GetUnary_set_mmlclass(void) const;
            TUnary_set_mmlclass& SetUnary_set_mmlclass(void);
            void SetUnary_set_mmlclass(TUnary_set_mmlclass& value);
        
            // typedef C_Sum_mmlclass TSum_mmlclass
            bool IsSum_mmlclass(void) const;
            const TSum_mmlclass& GetSum_mmlclass(void) const;
            TSum_mmlclass& SetSum_mmlclass(void);
            void SetSum_mmlclass(TSum_mmlclass& value);
        
            // typedef C_Product_mmlclass TProduct_mmlclass
            bool IsProduct_mmlclass(void) const;
            const TProduct_mmlclass& GetProduct_mmlclass(void) const;
            TProduct_mmlclass& SetProduct_mmlclass(void);
            void SetProduct_mmlclass(TProduct_mmlclass& value);
        
            // typedef C_Limit_mmlclass TLimit_mmlclass
            bool IsLimit_mmlclass(void) const;
            const TLimit_mmlclass& GetLimit_mmlclass(void) const;
            TLimit_mmlclass& SetLimit_mmlclass(void);
            void SetLimit_mmlclass(TLimit_mmlclass& value);
        
            // typedef C_Unary_elementary_mmlclass TUnary_elementary_mmlclass
            bool IsUnary_elementary_mmlclass(void) const;
            const TUnary_elementary_mmlclass& GetUnary_elementary_mmlclass(void) const;
            TUnary_elementary_mmlclass& SetUnary_elementary_mmlclass(void);
            void SetUnary_elementary_mmlclass(TUnary_elementary_mmlclass& value);
        
            // typedef C_Nary_stats_mmlclass TNary_stats_mmlclass
            bool IsNary_stats_mmlclass(void) const;
            const TNary_stats_mmlclass& GetNary_stats_mmlclass(void) const;
            TNary_stats_mmlclass& SetNary_stats_mmlclass(void);
            void SetNary_stats_mmlclass(TNary_stats_mmlclass& value);
        
            // typedef C_Nary_constructor_mmlclass TNary_constructor_mmlclass
            bool IsNary_constructor_mmlclass(void) const;
            const TNary_constructor_mmlclass& GetNary_constructor_mmlclass(void) const;
            TNary_constructor_mmlclass& SetNary_constructor_mmlclass(void);
            void SetNary_constructor_mmlclass(TNary_constructor_mmlclass& value);
        
            // typedef C_Unary_linalg_mmlclass TUnary_linalg_mmlclass
            bool IsUnary_linalg_mmlclass(void) const;
            const TUnary_linalg_mmlclass& GetUnary_linalg_mmlclass(void) const;
            TUnary_linalg_mmlclass& SetUnary_linalg_mmlclass(void);
            void SetUnary_linalg_mmlclass(TUnary_linalg_mmlclass& value);
        
            // typedef C_Nary_linalg_mmlclass TNary_linalg_mmlclass
            bool IsNary_linalg_mmlclass(void) const;
            const TNary_linalg_mmlclass& GetNary_linalg_mmlclass(void) const;
            TNary_linalg_mmlclass& SetNary_linalg_mmlclass(void);
            void SetNary_linalg_mmlclass(TNary_linalg_mmlclass& value);
        
            // typedef C_Binary_linalg_mmlclass TBinary_linalg_mmlclass
            bool IsBinary_linalg_mmlclass(void) const;
            const TBinary_linalg_mmlclass& GetBinary_linalg_mmlclass(void) const;
            TBinary_linalg_mmlclass& SetBinary_linalg_mmlclass(void);
            void SetBinary_linalg_mmlclass(TBinary_linalg_mmlclass& value);
        
            // typedef C_Constant_set_mmlclass TConstant_set_mmlclass
            bool IsConstant_set_mmlclass(void) const;
            const TConstant_set_mmlclass& GetConstant_set_mmlclass(void) const;
            TConstant_set_mmlclass& SetConstant_set_mmlclass(void);
            void SetConstant_set_mmlclass(TConstant_set_mmlclass& value);
        
            // typedef C_Constant_arith_mmlclass TConstant_arith_mmlclass
            bool IsConstant_arith_mmlclass(void) const;
            const TConstant_arith_mmlclass& GetConstant_arith_mmlclass(void) const;
            TConstant_arith_mmlclass& SetConstant_arith_mmlclass(void);
            void SetConstant_arith_mmlclass(TConstant_arith_mmlclass& value);
        
            // typedef CSemantics TSemantics
            bool IsSemantics(void) const;
            const TSemantics& GetSemantics(void) const;
            TSemantics& SetSemantics(void);
            void SetSemantics(TSemantics& value);
        
            // typedef CCn TCn
            bool IsCn(void) const;
            const TCn& GetCn(void) const;
            TCn& SetCn(void);
            void SetCn(TCn& value);
        
            // typedef CCi TCi
            bool IsCi(void) const;
            const TCi& GetCi(void) const;
            TCi& SetCi(void);
            void SetCi(TCi& value);
        
            // typedef CCsymbol TCsymbol
            bool IsCsymbol(void) const;
            const TCsymbol& GetCsymbol(void) const;
            TCsymbol& SetCsymbol(void);
            void SetCsymbol(TCsymbol& value);
        
            // typedef CApply TApply
            bool IsApply(void) const;
            const TApply& GetApply(void) const;
            TApply& SetApply(void);
            void SetApply(TApply& value);
        
            // typedef CBind TBind
            bool IsBind(void) const;
            const TBind& GetBind(void) const;
            TBind& SetBind(void);
            void SetBind(TBind& value);
        
            // typedef CShare TShare
            bool IsShare(void) const;
            const TShare& GetShare(void) const;
            TShare& SetShare(void);
        
            // typedef CCerror TCerror
            bool IsCerror(void) const;
            const TCerror& GetCerror(void) const;
            TCerror& SetCerror(void);
            void SetCerror(TCerror& value);
        
            // typedef CCbytes TCbytes
            bool IsCbytes(void) const;
            const TCbytes& GetCbytes(void) const;
            TCbytes& SetCbytes(void);
            void SetCbytes(TCbytes& value);
        
            // typedef CCs TCs
            bool IsCs(void) const;
            const TCs& GetCs(void) const;
            TCs& SetCs(void);
            void SetCs(TCs& value);
        
        
        private:
            // copy constructor and assignment operator
            C_E_ContExp(const C_E_ContExp& );
            C_E_ContExp& operator=(const C_E_ContExp& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef C_E_ContExp C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_ContExp > > TContExp;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_ContExp
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_ContExp > > TContExp
        ///  Check whether the ContExp data member has been assigned a value.
        bool IsSetContExp(void) const;
        /// Check whether it is safe or not to call GetContExp method.
        bool CanGetContExp(void) const;
        void ResetContExp(void);
        const TContExp& GetContExp(void) const;
        TContExp& SetContExp(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_ContExp(const C_ContExp&);
        C_ContExp& operator=(const C_ContExp&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_ContExp > > m_ContExp;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_BvarQ : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_BvarQ(void);
        // destructor
        ~C_BvarQ(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CBvar C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBvar > > TBvar;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_bvar
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBvar > > TBvar
        ///  Check whether the Bvar data member has been assigned a value.
        bool IsSetBvar(void) const;
        /// Check whether it is safe or not to call GetBvar method.
        bool CanGetBvar(void) const;
        void ResetBvar(void);
        const TBvar& GetBvar(void) const;
        TBvar& SetBvar(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_BvarQ(const C_BvarQ&);
        C_BvarQ& operator=(const C_BvarQ&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBvar > > m_Bvar;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_Qualifier : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Qualifier(void);
        // destructor
        ~C_Qualifier(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_E_Qualifier : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_E_Qualifier(void);
            // destructor
            ~C_E_Qualifier(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            /////////////////////////////////////////////////////////////////////////////
            class C_DCL : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_DCL(void);
                // destructor
                ~C_DCL(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                /////////////////////////////////////////////////////////////////////////////
                class C_LU : public NCBI_NS_NCBI::CSerialObject
                {
                    typedef NCBI_NS_NCBI::CSerialObject Tparent;
                public:
                    // constructor
                    C_LU(void);
                    // destructor
                    ~C_LU(void);
                
                    // type info
                    DECLARE_INTERNAL_TYPE_INFO();
                
                    // types
                    typedef CLowlimit TLowlimit;
                    typedef CUplimit TUplimit;
                
                    // member index
                    enum class E_memberIndex {
                        e__allMandatory = 0,
                        e_lowlimit,
                        e_uplimit
                    };
                    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
                
                    // getters
                    // setters
                
                    /// mandatory
                    /// typedef CLowlimit TLowlimit
                    ///  Check whether the Lowlimit data member has been assigned a value.
                    bool IsSetLowlimit(void) const;
                    /// Check whether it is safe or not to call GetLowlimit method.
                    bool CanGetLowlimit(void) const;
                    void ResetLowlimit(void);
                    const TLowlimit& GetLowlimit(void) const;
                    void SetLowlimit(TLowlimit& value);
                    TLowlimit& SetLowlimit(void);
                
                    /// optional
                    /// typedef CUplimit TUplimit
                    ///  Check whether the Uplimit data member has been assigned a value.
                    bool IsSetUplimit(void) const;
                    /// Check whether it is safe or not to call GetUplimit method.
                    bool CanGetUplimit(void) const;
                    void ResetUplimit(void);
                    const TUplimit& GetUplimit(void) const;
                    void SetUplimit(TUplimit& value);
                    TUplimit& SetUplimit(void);
                
                    /// Reset the whole object
                    void Reset(void);
                
                
                private:
                    // Prohibit copy constructor and assignment operator
                    C_LU(const C_LU&);
                    C_LU& operator=(const C_LU&);
                
                    // data
                    Uint4 m_set_State[1];
                    NCBI_NS_NCBI::CRef< TLowlimit > m_Lowlimit;
                    NCBI_NS_NCBI::CRef< TUplimit > m_Uplimit;
                };
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,          ///< No variant selected
                    e_Domainofapplication,
                    e_Condition,
                    e_LU
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 4 ///< == e_LU+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CDomainofapplication TDomainofapplication;
                typedef CCondition TCondition;
                typedef C_LU TLU;
            
                // getters
                // setters
            
                // typedef CDomainofapplication TDomainofapplication
                bool IsDomainofapplication(void) const;
                const TDomainofapplication& GetDomainofapplication(void) const;
                TDomainofapplication& SetDomainofapplication(void);
                void SetDomainofapplication(TDomainofapplication& value);
            
                // typedef CCondition TCondition
                bool IsCondition(void) const;
                const TCondition& GetCondition(void) const;
                TCondition& SetCondition(void);
                void SetCondition(TCondition& value);
            
                // typedef C_LU TLU
                bool IsLU(void) const;
                const TLU& GetLU(void) const;
                TLU& SetLU(void);
                void SetLU(TLU& value);
            
            
            private:
                // copy constructor and assignment operator
                C_DCL(const C_DCL& );
                C_DCL& operator=(const C_DCL& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,  ///< No variant selected
                e_DCL,
                e_Degree,
                e_Momentabout,
                e_Logbase
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 5 ///< == e_Logbase+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef C_DCL TDCL;
            typedef CDegree TDegree;
            typedef CMomentabout TMomentabout;
            typedef CLogbase TLogbase;
        
            // getters
            // setters
        
            // typedef C_DCL TDCL
            bool IsDCL(void) const;
            const TDCL& GetDCL(void) const;
            TDCL& SetDCL(void);
            void SetDCL(TDCL& value);
        
            // typedef CDegree TDegree
            bool IsDegree(void) const;
            const TDegree& GetDegree(void) const;
            TDegree& SetDegree(void);
            void SetDegree(TDegree& value);
        
            // typedef CMomentabout TMomentabout
            bool IsMomentabout(void) const;
            const TMomentabout& GetMomentabout(void) const;
            TMomentabout& SetMomentabout(void);
            void SetMomentabout(TMomentabout& value);
        
            // typedef CLogbase TLogbase
            bool IsLogbase(void) const;
            const TLogbase& GetLogbase(void) const;
            TLogbase& SetLogbase(void);
            void SetLogbase(TLogbase& value);
        
        
        private:
            // copy constructor and assignment operator
            C_E_Qualifier(const C_E_Qualifier& );
            C_E_Qualifier& operator=(const C_E_Qualifier& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef C_E_Qualifier C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Qualifier > > TQualifier;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Qualifier
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Qualifier > > TQualifier
        ///  Check whether the Qualifier data member has been assigned a value.
        bool IsSetQualifier(void) const;
        /// Check whether it is safe or not to call GetQualifier method.
        bool CanGetQualifier(void) const;
        void ResetQualifier(void);
        const TQualifier& GetQualifier(void) const;
        TQualifier& SetQualifier(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Qualifier(const C_Qualifier&);
        C_Qualifier& operator=(const C_Qualifier&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Qualifier > > m_Qualifier;
    };
    // types
    typedef C_ContExp TContExp;
    typedef C_BvarQ TBvarQ;
    typedef C_Qualifier TQualifier;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ContExp,
        e_BvarQ,
        e_Qualifier
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef C_ContExp TContExp
    ///  Check whether the ContExp data member has been assigned a value.
    bool IsSetContExp(void) const;
    /// Check whether it is safe or not to call GetContExp method.
    bool CanGetContExp(void) const;
    void ResetContExp(void);
    const TContExp& GetContExp(void) const;
    void SetContExp(TContExp& value);
    TContExp& SetContExp(void);

    /// mandatory
    /// typedef C_BvarQ TBvarQ
    ///  Check whether the BvarQ data member has been assigned a value.
    bool IsSetBvarQ(void) const;
    /// Check whether it is safe or not to call GetBvarQ method.
    bool CanGetBvarQ(void) const;
    void ResetBvarQ(void);
    const TBvarQ& GetBvarQ(void) const;
    void SetBvarQ(TBvarQ& value);
    TBvarQ& SetBvarQ(void);

    /// optional
    /// typedef C_Qualifier TQualifier
    ///  Check whether the Qualifier data member has been assigned a value.
    bool IsSetQualifier(void) const;
    /// Check whether it is safe or not to call GetQualifier method.
    bool CanGetQualifier(void) const;
    void ResetQualifier(void);
    const TQualifier& GetQualifier(void) const;
    void SetQualifier(TQualifier& value);
    TQualifier& SetQualifier(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBind_content_Base(const CBind_content_Base&);
    CBind_content_Base& operator=(const CBind_content_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TContExp > m_ContExp;
    NCBI_NS_NCBI::CRef< TBvarQ > m_BvarQ;
    NCBI_NS_NCBI::CRef< TQualifier > m_Qualifier;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::IsReln(void) const
{
    return m_choice == e_Reln;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::IsFn(void) const
{
    return m_choice == e_Fn;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_DeprecatedContExp::IsDeclare(void) const
{
    return m_choice == e_Declare;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Interval_mmlclass::IsSetInterval(void) const
{
    return m_Interval.NotEmpty();
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Interval_mmlclass::CanGetInterval(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Interval_mmlclass::TInterval& CBind_content_Base::C_ContExp::C_E_ContExp::C_Interval_mmlclass::GetInterval(void) const
{
    if ( !m_Interval ) {
        const_cast<C_Interval_mmlclass*>(this)->ResetInterval();
    }
    return (*m_Interval);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Interval_mmlclass::TInterval& CBind_content_Base::C_ContExp::C_E_ContExp::C_Interval_mmlclass::SetInterval(void)
{
    if ( !m_Interval ) {
        ResetInterval();
    }
    return (*m_Interval);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsInverse(void) const
{
    return m_choice == e_Inverse;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsIdent(void) const
{
    return m_choice == e_Ident;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsDomain(void) const
{
    return m_choice == e_Domain;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsCodomain(void) const
{
    return m_choice == e_Codomain;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsImage(void) const
{
    return m_choice == e_Image;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsLn(void) const
{
    return m_choice == e_Ln;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsLog(void) const
{
    return m_choice == e_Log;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_functional_mmlclass::IsMoment(void) const
{
    return m_choice == e_Moment;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Lambda_mmlclass::IsSetLambda(void) const
{
    return m_Lambda.NotEmpty();
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Lambda_mmlclass::CanGetLambda(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Lambda_mmlclass::TLambda& CBind_content_Base::C_ContExp::C_E_ContExp::C_Lambda_mmlclass::GetLambda(void) const
{
    if ( !m_Lambda ) {
        const_cast<C_Lambda_mmlclass*>(this)->ResetLambda();
    }
    return (*m_Lambda);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Lambda_mmlclass::TLambda& CBind_content_Base::C_ContExp::C_E_ContExp::C_Lambda_mmlclass::SetLambda(void)
{
    if ( !m_Lambda ) {
        ResetLambda();
    }
    return (*m_Lambda);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_functional_mmlclass::CanGetCompose(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_functional_mmlclass::TCompose& CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_functional_mmlclass::GetCompose(void) const
{
    if ( !m_Compose ) {
        const_cast<C_Nary_functional_mmlclass*>(this)->ResetCompose();
    }
    return (*m_Compose);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::IsQuotient(void) const
{
    return m_choice == e_Quotient;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::IsDivide(void) const
{
    return m_choice == e_Divide;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::IsMinus(void) const
{
    return m_choice == e_Minus;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::IsPower(void) const
{
    return m_choice == e_Power;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::IsRem(void) const
{
    return m_choice == e_Rem;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_arith_mmlclass::IsRoot(void) const
{
    return m_choice == e_Root;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsFactorial(void) const
{
    return m_choice == e_Factorial;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsAbs(void) const
{
    return m_choice == e_Abs;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsConjugate(void) const
{
    return m_choice == e_Conjugate;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsArg(void) const
{
    return m_choice == e_Arg;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsReal(void) const
{
    return m_choice == e_Real;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsImaginary(void) const
{
    return m_choice == e_Imaginary;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsFloor(void) const
{
    return m_choice == e_Floor;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsCeiling(void) const
{
    return m_choice == e_Ceiling;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_arith_mmlclass::IsExp(void) const
{
    return m_choice == e_Exp;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::IsMax(void) const
{
    return m_choice == e_Max;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_minmax_mmlclass::IsMin(void) const
{
    return m_choice == e_Min;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::IsPlus(void) const
{
    return m_choice == e_Plus;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::IsTimes(void) const
{
    return m_choice == e_Times;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::IsGcd(void) const
{
    return m_choice == e_Gcd;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_arith_mmlclass::IsLcm(void) const
{
    return m_choice == e_Lcm;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::IsAnd(void) const
{
    return m_choice == e_And;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::IsOr(void) const
{
    return m_choice == e_Or;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_logical_mmlclass::IsXor(void) const
{
    return m_choice == e_Xor;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_logical_mmlclass::CanGetNot(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_logical_mmlclass::TNot& CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_logical_mmlclass::GetNot(void) const
{
    if ( !m_Not ) {
        const_cast<C_Unary_logical_mmlclass*>(this)->ResetNot();
    }
    return (*m_Not);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::IsImplies(void) const
{
    return m_choice == e_Implies;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_logical_mmlclass::IsEquivalent(void) const
{
    return m_choice == e_Equivalent;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::IsForall(void) const
{
    return m_choice == e_Forall;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Quantifier_mmlclass::IsExists(void) const
{
    return m_choice == e_Exists;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::IsEq(void) const
{
    return m_choice == e_Eq;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::IsGt(void) const
{
    return m_choice == e_Gt;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::IsLt(void) const
{
    return m_choice == e_Lt;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::IsGeq(void) const
{
    return m_choice == e_Geq;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_reln_mmlclass::IsLeq(void) const
{
    return m_choice == e_Leq;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::IsNeq(void) const
{
    return m_choice == e_Neq;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::IsApprox(void) const
{
    return m_choice == e_Approx;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::IsFactorof(void) const
{
    return m_choice == e_Factorof;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_reln_mmlclass::IsTendsto(void) const
{
    return m_choice == e_Tendsto;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Int_mmlclass::CanGetInt(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Int_mmlclass::TInt& CBind_content_Base::C_ContExp::C_E_ContExp::C_Int_mmlclass::GetInt(void) const
{
    if ( !m_Int ) {
        const_cast<C_Int_mmlclass*>(this)->ResetInt();
    }
    return (*m_Int);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Differential_Operator_mmlclass::CanGetDiff(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Differential_Operator_mmlclass::TDiff& CBind_content_Base::C_ContExp::C_E_ContExp::C_Differential_Operator_mmlclass::GetDiff(void) const
{
    if ( !m_Diff ) {
        const_cast<C_Differential_Operator_mmlclass*>(this)->ResetDiff();
    }
    return (*m_Diff);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Partialdiff_mmlclass::CanGetPartialdiff(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Partialdiff_mmlclass::TPartialdiff& CBind_content_Base::C_ContExp::C_E_ContExp::C_Partialdiff_mmlclass::GetPartialdiff(void) const
{
    if ( !m_Partialdiff ) {
        const_cast<C_Partialdiff_mmlclass*>(this)->ResetPartialdiff();
    }
    return (*m_Partialdiff);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::IsDivergence(void) const
{
    return m_choice == e_Divergence;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::IsGrad(void) const
{
    return m_choice == e_Grad;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::IsCurl(void) const
{
    return m_choice == e_Curl;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_veccalc_mmlclass::IsLaplacian(void) const
{
    return m_choice == e_Laplacian;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::IsSet(void) const
{
    return m_choice == e_Set;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_setlist_constructor_mmlclass::IsList(void) const
{
    return m_choice == e_List;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::IsUnion(void) const
{
    return m_choice == e_Union;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::IsIntersect(void) const
{
    return m_choice == e_Intersect;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_mmlclass::IsCartesianproduct(void) const
{
    return m_choice == e_Cartesianproduct;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::IsIn(void) const
{
    return m_choice == e_In;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::IsNotin(void) const
{
    return m_choice == e_Notin;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::IsNotsubset(void) const
{
    return m_choice == e_Notsubset;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::IsNotprsubset(void) const
{
    return m_choice == e_Notprsubset;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_set_mmlclass::IsSetdiff(void) const
{
    return m_choice == e_Setdiff;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::IsSubset(void) const
{
    return m_choice == e_Subset;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_set_reln_mmlclass::IsPrsubset(void) const
{
    return m_choice == e_Prsubset;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_set_mmlclass::CanGetCard(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_set_mmlclass::TCard& CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_set_mmlclass::GetCard(void) const
{
    if ( !m_Card ) {
        const_cast<C_Unary_set_mmlclass*>(this)->ResetCard();
    }
    return (*m_Card);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Sum_mmlclass::CanGetSum(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Sum_mmlclass::TSum& CBind_content_Base::C_ContExp::C_E_ContExp::C_Sum_mmlclass::GetSum(void) const
{
    if ( !m_Sum ) {
        const_cast<C_Sum_mmlclass*>(this)->ResetSum();
    }
    return (*m_Sum);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Product_mmlclass::CanGetProduct(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Product_mmlclass::TProduct& CBind_content_Base::C_ContExp::C_E_ContExp::C_Product_mmlclass::GetProduct(void) const
{
    if ( !m_Product ) {
        const_cast<C_Product_mmlclass*>(this)->ResetProduct();
    }
    return (*m_Product);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Limit_mmlclass::CanGetLimit(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Limit_mmlclass::TLimit& CBind_content_Base::C_ContExp::C_E_ContExp::C_Limit_mmlclass::GetLimit(void) const
{
    if ( !m_Limit ) {
        const_cast<C_Limit_mmlclass*>(this)->ResetLimit();
    }
    return (*m_Limit);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsSin(void) const
{
    return m_choice == e_Sin;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsCos(void) const
{
    return m_choice == e_Cos;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsTan(void) const
{
    return m_choice == e_Tan;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsSec(void) const
{
    return m_choice == e_Sec;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsCsc(void) const
{
    return m_choice == e_Csc;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsCot(void) const
{
    return m_choice == e_Cot;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsSinh(void) const
{
    return m_choice == e_Sinh;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsCosh(void) const
{
    return m_choice == e_Cosh;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsTanh(void) const
{
    return m_choice == e_Tanh;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsSech(void) const
{
    return m_choice == e_Sech;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsCsch(void) const
{
    return m_choice == e_Csch;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsCoth(void) const
{
    return m_choice == e_Coth;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArcsin(void) const
{
    return m_choice == e_Arcsin;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArccos(void) const
{
    return m_choice == e_Arccos;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArctan(void) const
{
    return m_choice == e_Arctan;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArccosh(void) const
{
    return m_choice == e_Arccosh;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArccot(void) const
{
    return m_choice == e_Arccot;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArccoth(void) const
{
    return m_choice == e_Arccoth;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArccsc(void) const
{
    return m_choice == e_Arccsc;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArccsch(void) const
{
    return m_choice == e_Arccsch;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArcsec(void) const
{
    return m_choice == e_Arcsec;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArcsech(void) const
{
    return m_choice == e_Arcsech;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArcsinh(void) const
{
    return m_choice == e_Arcsinh;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_elementary_mmlclass::IsArctanh(void) const
{
    return m_choice == e_Arctanh;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::IsMean(void) const
{
    return m_choice == e_Mean;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::IsSdev(void) const
{
    return m_choice == e_Sdev;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::IsVariance(void) const
{
    return m_choice == e_Variance;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::IsMedian(void) const
{
    return m_choice == e_Median;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_stats_mmlclass::IsMode(void) const
{
    return m_choice == e_Mode;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::IsVector(void) const
{
    return m_choice == e_Vector;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::IsMatrix(void) const
{
    return m_choice == e_Matrix;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_constructor_mmlclass::IsMatrixrow(void) const
{
    return m_choice == e_Matrixrow;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::IsDeterminant(void) const
{
    return m_choice == e_Determinant;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Unary_linalg_mmlclass::IsTranspose(void) const
{
    return m_choice == e_Transpose;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_linalg_mmlclass::CanGetSelector(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_linalg_mmlclass::TSelector& CBind_content_Base::C_ContExp::C_E_ContExp::C_Nary_linalg_mmlclass::GetSelector(void) const
{
    if ( !m_Selector ) {
        const_cast<C_Nary_linalg_mmlclass*>(this)->ResetSelector();
    }
    return (*m_Selector);
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::IsVectorproduct(void) const
{
    return m_choice == e_Vectorproduct;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::IsScalarproduct(void) const
{
    return m_choice == e_Scalarproduct;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Binary_linalg_mmlclass::IsOuterproduct(void) const
{
    return m_choice == e_Outerproduct;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsIntegers(void) const
{
    return m_choice == e_Integers;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsReals(void) const
{
    return m_choice == e_Reals;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsRationals(void) const
{
    return m_choice == e_Rationals;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsNaturalnumbers(void) const
{
    return m_choice == e_Naturalnumbers;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsComplexes(void) const
{
    return m_choice == e_Complexes;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsPrimes(void) const
{
    return m_choice == e_Primes;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_set_mmlclass::IsEmptyset(void) const
{
    return m_choice == e_Emptyset;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsExponentiale(void) const
{
    return m_choice == e_Exponentiale;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsImaginaryi(void) const
{
    return m_choice == e_Imaginaryi;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsNotanumber(void) const
{
    return m_choice == e_Notanumber;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsTrue(void) const
{
    return m_choice == e_True;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsFalse(void) const
{
    return m_choice == e_False;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsPi(void) const
{
    return m_choice == e_Pi;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsEulergamma(void) const
{
    return m_choice == e_Eulergamma;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::C_Constant_arith_mmlclass::IsInfinity(void) const
{
    return m_choice == e_Infinity;
}

inline
CBind_content_Base::C_ContExp::C_E_ContExp::E_Choice CBind_content_Base::C_ContExp::C_E_ContExp::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_ContExp::C_E_ContExp::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsPiecewise(void) const
{
    return m_choice == e_Piecewise;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsDeprecatedContExp(void) const
{
    return m_choice == e_DeprecatedContExp;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsInterval_mmlclass(void) const
{
    return m_choice == e_Interval_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_functional_mmlclass(void) const
{
    return m_choice == e_Unary_functional_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsLambda_mmlclass(void) const
{
    return m_choice == e_Lambda_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_functional_mmlclass(void) const
{
    return m_choice == e_Nary_functional_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsBinary_arith_mmlclass(void) const
{
    return m_choice == e_Binary_arith_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_arith_mmlclass(void) const
{
    return m_choice == e_Unary_arith_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_minmax_mmlclass(void) const
{
    return m_choice == e_Nary_minmax_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_arith_mmlclass(void) const
{
    return m_choice == e_Nary_arith_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_logical_mmlclass(void) const
{
    return m_choice == e_Nary_logical_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_logical_mmlclass(void) const
{
    return m_choice == e_Unary_logical_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsBinary_logical_mmlclass(void) const
{
    return m_choice == e_Binary_logical_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsQuantifier_mmlclass(void) const
{
    return m_choice == e_Quantifier_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_reln_mmlclass(void) const
{
    return m_choice == e_Nary_reln_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsBinary_reln_mmlclass(void) const
{
    return m_choice == e_Binary_reln_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsInt_mmlclass(void) const
{
    return m_choice == e_Int_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsDifferential_Operator_mmlclass(void) const
{
    return m_choice == e_Differential_Operator_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsPartialdiff_mmlclass(void) const
{
    return m_choice == e_Partialdiff_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_veccalc_mmlclass(void) const
{
    return m_choice == e_Unary_veccalc_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_setlist_constructor_mmlclass(void) const
{
    return m_choice == e_Nary_setlist_constructor_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_set_mmlclass(void) const
{
    return m_choice == e_Nary_set_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsBinary_set_mmlclass(void) const
{
    return m_choice == e_Binary_set_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_set_reln_mmlclass(void) const
{
    return m_choice == e_Nary_set_reln_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_set_mmlclass(void) const
{
    return m_choice == e_Unary_set_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsSum_mmlclass(void) const
{
    return m_choice == e_Sum_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsProduct_mmlclass(void) const
{
    return m_choice == e_Product_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsLimit_mmlclass(void) const
{
    return m_choice == e_Limit_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_elementary_mmlclass(void) const
{
    return m_choice == e_Unary_elementary_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_stats_mmlclass(void) const
{
    return m_choice == e_Nary_stats_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_constructor_mmlclass(void) const
{
    return m_choice == e_Nary_constructor_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsUnary_linalg_mmlclass(void) const
{
    return m_choice == e_Unary_linalg_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsNary_linalg_mmlclass(void) const
{
    return m_choice == e_Nary_linalg_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsBinary_linalg_mmlclass(void) const
{
    return m_choice == e_Binary_linalg_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsConstant_set_mmlclass(void) const
{
    return m_choice == e_Constant_set_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsConstant_arith_mmlclass(void) const
{
    return m_choice == e_Constant_arith_mmlclass;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsSemantics(void) const
{
    return m_choice == e_Semantics;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsCn(void) const
{
    return m_choice == e_Cn;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsCi(void) const
{
    return m_choice == e_Ci;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsCsymbol(void) const
{
    return m_choice == e_Csymbol;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsApply(void) const
{
    return m_choice == e_Apply;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsBind(void) const
{
    return m_choice == e_Bind;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsShare(void) const
{
    return m_choice == e_Share;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsCerror(void) const
{
    return m_choice == e_Cerror;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsCbytes(void) const
{
    return m_choice == e_Cbytes;
}

inline
bool CBind_content_Base::C_ContExp::C_E_ContExp::IsCs(void) const
{
    return m_choice == e_Cs;
}

inline
bool CBind_content_Base::C_ContExp::IsSetContExp(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBind_content_Base::C_ContExp::CanGetContExp(void) const
{
    return true;
}

inline
const CBind_content_Base::C_ContExp::TContExp& CBind_content_Base::C_ContExp::GetContExp(void) const
{
    return m_ContExp;
}

inline
CBind_content_Base::C_ContExp::TContExp& CBind_content_Base::C_ContExp::SetContExp(void)
{
    m_set_State[0] |= 0x1;
    return m_ContExp;
}

inline
bool CBind_content_Base::C_BvarQ::IsSetBvar(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBind_content_Base::C_BvarQ::CanGetBvar(void) const
{
    return true;
}

inline
const CBind_content_Base::C_BvarQ::TBvar& CBind_content_Base::C_BvarQ::GetBvar(void) const
{
    return m_Bvar;
}

inline
CBind_content_Base::C_BvarQ::TBvar& CBind_content_Base::C_BvarQ::SetBvar(void)
{
    m_set_State[0] |= 0x1;
    return m_Bvar;
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::IsSetLowlimit(void) const
{
    return m_Lowlimit.NotEmpty();
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::CanGetLowlimit(void) const
{
    return true;
}

inline
const CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::TLowlimit& CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::GetLowlimit(void) const
{
    if ( !m_Lowlimit ) {
        const_cast<C_LU*>(this)->ResetLowlimit();
    }
    return (*m_Lowlimit);
}

inline
CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::TLowlimit& CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::SetLowlimit(void)
{
    if ( !m_Lowlimit ) {
        ResetLowlimit();
    }
    return (*m_Lowlimit);
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::IsSetUplimit(void) const
{
    return m_Uplimit.NotEmpty();
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::CanGetUplimit(void) const
{
    return IsSetUplimit();
}

inline
const CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::TUplimit& CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::C_LU::GetUplimit(void) const
{
    if (!CanGetUplimit()) {
        ThrowUnassigned(1);
    }
    return (*m_Uplimit);
}

inline
CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::E_Choice CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::IsDomainofapplication(void) const
{
    return m_choice == e_Domainofapplication;
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::IsCondition(void) const
{
    return m_choice == e_Condition;
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::C_DCL::IsLU(void) const
{
    return m_choice == e_LU;
}

inline
CBind_content_Base::C_Qualifier::C_E_Qualifier::E_Choice CBind_content_Base::C_Qualifier::C_E_Qualifier::Which(void) const
{
    return m_choice;
}

inline
void CBind_content_Base::C_Qualifier::C_E_Qualifier::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBind_content_Base::C_Qualifier::C_E_Qualifier::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBind_content_Base::C_Qualifier::C_E_Qualifier::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::IsDCL(void) const
{
    return m_choice == e_DCL;
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::IsDegree(void) const
{
    return m_choice == e_Degree;
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::IsMomentabout(void) const
{
    return m_choice == e_Momentabout;
}

inline
bool CBind_content_Base::C_Qualifier::C_E_Qualifier::IsLogbase(void) const
{
    return m_choice == e_Logbase;
}

inline
bool CBind_content_Base::C_Qualifier::IsSetQualifier(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBind_content_Base::C_Qualifier::CanGetQualifier(void) const
{
    return true;
}

inline
const CBind_content_Base::C_Qualifier::TQualifier& CBind_content_Base::C_Qualifier::GetQualifier(void) const
{
    return m_Qualifier;
}

inline
CBind_content_Base::C_Qualifier::TQualifier& CBind_content_Base::C_Qualifier::SetQualifier(void)
{
    m_set_State[0] |= 0x1;
    return m_Qualifier;
}

inline
bool CBind_content_Base::IsSetContExp(void) const
{
    return m_ContExp.NotEmpty();
}

inline
bool CBind_content_Base::CanGetContExp(void) const
{
    return IsSetContExp();
}

inline
const CBind_content_Base::TContExp& CBind_content_Base::GetContExp(void) const
{
    if (!CanGetContExp()) {
        ThrowUnassigned(0);
    }
    return (*m_ContExp);
}

inline
bool CBind_content_Base::IsSetBvarQ(void) const
{
    return m_BvarQ.NotEmpty();
}

inline
bool CBind_content_Base::CanGetBvarQ(void) const
{
    return true;
}

inline
const CBind_content_Base::TBvarQ& CBind_content_Base::GetBvarQ(void) const
{
    if ( !m_BvarQ ) {
        const_cast<CBind_content_Base*>(this)->ResetBvarQ();
    }
    return (*m_BvarQ);
}

inline
CBind_content_Base::TBvarQ& CBind_content_Base::SetBvarQ(void)
{
    if ( !m_BvarQ ) {
        ResetBvarQ();
    }
    return (*m_BvarQ);
}

inline
bool CBind_content_Base::IsSetQualifier(void) const
{
    return m_Qualifier.NotEmpty();
}

inline
bool CBind_content_Base::CanGetQualifier(void) const
{
    return IsSetQualifier();
}

inline
const CBind_content_Base::TQualifier& CBind_content_Base::GetQualifier(void) const
{
    if (!CanGetQualifier()) {
        ThrowUnassigned(2);
    }
    return (*m_Qualifier);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_BIND_CONTENT_BASE_HPP
