/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BvarQ_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_BVARQ_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_BVARQ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CBvar;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CBvarQ_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CBvarQ_Base(void);
    // destructor
    virtual ~CBvarQ_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CBvar C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBvar > > TBvar;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_bvar
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBvar > > TBvar
    ///  Check whether the Bvar data member has been assigned a value.
    bool IsSetBvar(void) const;
    /// Check whether it is safe or not to call GetBvar method.
    bool CanGetBvar(void) const;
    void ResetBvar(void);
    const TBvar& GetBvar(void) const;
    TBvar& SetBvar(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBvarQ_Base(const CBvarQ_Base&);
    CBvarQ_Base& operator=(const CBvarQ_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CBvar > > m_Bvar;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBvarQ_Base::IsSetBvar(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBvarQ_Base::CanGetBvar(void) const
{
    return true;
}

inline
const CBvarQ_Base::TBvar& CBvarQ_Base::GetBvar(void) const
{
    return m_Bvar;
}

inline
CBvarQ_Base::TBvar& CBvarQ_Base::SetBvar(void)
{
    m_set_State[0] |= 0x1;
    return m_Bvar;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_BVARQ_BASE_HPP
