/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Bvar_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_BVAR_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_BVAR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CCi;
class CDegree;
class CSemantics;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CBvar_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CBvar_Base(void);
    // destructor
    virtual ~CBvar_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_DC : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_DC(void);
        // destructor
        ~C_DC(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_CS : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_CS(void);
            // destructor
            ~C_CS(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,  ///< No variant selected
                e_Ci,
                e_Semantics
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 3 ///< == e_Semantics+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef CCi TCi;
            typedef CSemantics TSemantics;
        
            // getters
            // setters
        
            // typedef CCi TCi
            bool IsCi(void) const;
            const TCi& GetCi(void) const;
            TCi& SetCi(void);
            void SetCi(TCi& value);
        
            // typedef CSemantics TSemantics
            bool IsSemantics(void) const;
            const TSemantics& GetSemantics(void) const;
            TSemantics& SetSemantics(void);
            void SetSemantics(TSemantics& value);
        
        
        private:
            // copy constructor and assignment operator
            C_CS(const C_CS& );
            C_CS& operator=(const C_CS& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef CDegree TDegree;
        typedef C_CS TCS;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_degree,
            e_CS
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef CDegree TDegree
        ///  Check whether the Degree data member has been assigned a value.
        bool IsSetDegree(void) const;
        /// Check whether it is safe or not to call GetDegree method.
        bool CanGetDegree(void) const;
        void ResetDegree(void);
        const TDegree& GetDegree(void) const;
        void SetDegree(TDegree& value);
        TDegree& SetDegree(void);
    
        /// mandatory
        /// typedef C_CS TCS
        ///  Check whether the CS data member has been assigned a value.
        bool IsSetCS(void) const;
        /// Check whether it is safe or not to call GetCS method.
        bool CanGetCS(void) const;
        void ResetCS(void);
        const TCS& GetCS(void) const;
        void SetCS(TCS& value);
        TCS& SetCS(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_DC(const C_DC&);
        C_DC& operator=(const C_DC&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_NCBI::CRef< TDegree > m_Degree;
        NCBI_NS_NCBI::CRef< TCS > m_CS;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_CD : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_CD(void);
        // destructor
        ~C_CD(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_CS : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_CS(void);
            // destructor
            ~C_CS(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,  ///< No variant selected
                e_Ci,
                e_Semantics
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 3 ///< == e_Semantics+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef CCi TCi;
            typedef CSemantics TSemantics;
        
            // getters
            // setters
        
            // typedef CCi TCi
            bool IsCi(void) const;
            const TCi& GetCi(void) const;
            TCi& SetCi(void);
            void SetCi(TCi& value);
        
            // typedef CSemantics TSemantics
            bool IsSemantics(void) const;
            const TSemantics& GetSemantics(void) const;
            TSemantics& SetSemantics(void);
            void SetSemantics(TSemantics& value);
        
        
        private:
            // copy constructor and assignment operator
            C_CS(const C_CS& );
            C_CS& operator=(const C_CS& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef C_CS TCS;
        typedef CDegree TDegree;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_CS,
            e_degree
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_CS TCS
        ///  Check whether the CS data member has been assigned a value.
        bool IsSetCS(void) const;
        /// Check whether it is safe or not to call GetCS method.
        bool CanGetCS(void) const;
        void ResetCS(void);
        const TCS& GetCS(void) const;
        void SetCS(TCS& value);
        TCS& SetCS(void);
    
        /// optional
        /// typedef CDegree TDegree
        ///  Check whether the Degree data member has been assigned a value.
        bool IsSetDegree(void) const;
        /// Check whether it is safe or not to call GetDegree method.
        bool CanGetDegree(void) const;
        void ResetDegree(void);
        const TDegree& GetDegree(void) const;
        void SetDegree(TDegree& value);
        TDegree& SetDegree(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_CD(const C_CD&);
        C_CD& operator=(const C_CD&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_NCBI::CRef< TCS > m_CS;
        NCBI_NS_NCBI::CRef< TDegree > m_Degree;
    };

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_DC = 2,
        e_CD
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_CD+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static NCBI_NS_STD::string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                NCBI_NS_NCBI::EResetVariant reset,
                NCBI_NS_NCBI::CObjectMemoryPool* pool);

    // types
    typedef C_Attlist TAttlist;
    typedef C_DC TDC;
    typedef C_CD TCD;

    // getters
    // setters

    // typedef C_Attlist TAttlist
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    TAttlist& SetAttlist(void);
    void SetAttlist(TAttlist& value);

    // typedef C_DC TDC
    bool IsDC(void) const;
    const TDC& GetDC(void) const;
    TDC& SetDC(void);
    void SetDC(TDC& value);

    // typedef C_CD TCD
    bool IsCD(void) const;
    const TCD& GetCD(void) const;
    TCD& SetCD(void);
    void SetCD(TCD& value);


private:
    // copy constructor and assignment operator
    CBvar_Base(const CBvar_Base& );
    CBvar_Base& operator=(const CBvar_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBvar_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBvar_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CBvar_Base::C_Attlist::TId& CBvar_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CBvar_Base::C_Attlist::SetId(const CBvar_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CBvar_Base::C_Attlist::SetId(CBvar_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CBvar_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CBvar_Base::C_Attlist::TId& CBvar_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CBvar_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBvar_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CBvar_Base::C_Attlist::TXref& CBvar_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CBvar_Base::C_Attlist::SetXref(const CBvar_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CBvar_Base::C_Attlist::SetXref(CBvar_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CBvar_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CBvar_Base::C_Attlist::TXref& CBvar_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CBvar_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBvar_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CBvar_Base::C_Attlist::TClass& CBvar_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CBvar_Base::C_Attlist::SetClass(const CBvar_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CBvar_Base::C_Attlist::SetClass(CBvar_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CBvar_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CBvar_Base::C_Attlist::TClass& CBvar_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CBvar_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBvar_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CBvar_Base::C_Attlist::TStyle& CBvar_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CBvar_Base::C_Attlist::SetStyle(const CBvar_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CBvar_Base::C_Attlist::SetStyle(CBvar_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CBvar_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CBvar_Base::C_Attlist::TStyle& CBvar_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CBvar_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CBvar_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CBvar_Base::C_Attlist::THref& CBvar_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CBvar_Base::C_Attlist::SetHref(const CBvar_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CBvar_Base::C_Attlist::SetHref(CBvar_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CBvar_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CBvar_Base::C_Attlist::THref& CBvar_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
CBvar_Base::C_DC::C_CS::E_Choice CBvar_Base::C_DC::C_CS::Which(void) const
{
    return m_choice;
}

inline
void CBvar_Base::C_DC::C_CS::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBvar_Base::C_DC::C_CS::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBvar_Base::C_DC::C_CS::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBvar_Base::C_DC::C_CS::IsCi(void) const
{
    return m_choice == e_Ci;
}

inline
bool CBvar_Base::C_DC::C_CS::IsSemantics(void) const
{
    return m_choice == e_Semantics;
}

inline
bool CBvar_Base::C_DC::IsSetDegree(void) const
{
    return m_Degree.NotEmpty();
}

inline
bool CBvar_Base::C_DC::CanGetDegree(void) const
{
    return true;
}

inline
const CBvar_Base::C_DC::TDegree& CBvar_Base::C_DC::GetDegree(void) const
{
    if ( !m_Degree ) {
        const_cast<C_DC*>(this)->ResetDegree();
    }
    return (*m_Degree);
}

inline
CBvar_Base::C_DC::TDegree& CBvar_Base::C_DC::SetDegree(void)
{
    if ( !m_Degree ) {
        ResetDegree();
    }
    return (*m_Degree);
}

inline
bool CBvar_Base::C_DC::IsSetCS(void) const
{
    return m_CS.NotEmpty();
}

inline
bool CBvar_Base::C_DC::CanGetCS(void) const
{
    return true;
}

inline
const CBvar_Base::C_DC::TCS& CBvar_Base::C_DC::GetCS(void) const
{
    if ( !m_CS ) {
        const_cast<C_DC*>(this)->ResetCS();
    }
    return (*m_CS);
}

inline
CBvar_Base::C_DC::TCS& CBvar_Base::C_DC::SetCS(void)
{
    if ( !m_CS ) {
        ResetCS();
    }
    return (*m_CS);
}

inline
CBvar_Base::C_CD::C_CS::E_Choice CBvar_Base::C_CD::C_CS::Which(void) const
{
    return m_choice;
}

inline
void CBvar_Base::C_CD::C_CS::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBvar_Base::C_CD::C_CS::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBvar_Base::C_CD::C_CS::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBvar_Base::C_CD::C_CS::IsCi(void) const
{
    return m_choice == e_Ci;
}

inline
bool CBvar_Base::C_CD::C_CS::IsSemantics(void) const
{
    return m_choice == e_Semantics;
}

inline
bool CBvar_Base::C_CD::IsSetCS(void) const
{
    return m_CS.NotEmpty();
}

inline
bool CBvar_Base::C_CD::CanGetCS(void) const
{
    return true;
}

inline
const CBvar_Base::C_CD::TCS& CBvar_Base::C_CD::GetCS(void) const
{
    if ( !m_CS ) {
        const_cast<C_CD*>(this)->ResetCS();
    }
    return (*m_CS);
}

inline
CBvar_Base::C_CD::TCS& CBvar_Base::C_CD::SetCS(void)
{
    if ( !m_CS ) {
        ResetCS();
    }
    return (*m_CS);
}

inline
bool CBvar_Base::C_CD::IsSetDegree(void) const
{
    return m_Degree.NotEmpty();
}

inline
bool CBvar_Base::C_CD::CanGetDegree(void) const
{
    return IsSetDegree();
}

inline
const CBvar_Base::C_CD::TDegree& CBvar_Base::C_CD::GetDegree(void) const
{
    if (!CanGetDegree()) {
        ThrowUnassigned(1);
    }
    return (*m_Degree);
}

inline
CBvar_Base::E_Choice CBvar_Base::Which(void) const
{
    return m_choice;
}

inline
void CBvar_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CBvar_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CBvar_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CBvar_Base::IsDC(void) const
{
    return m_choice == e_DC;
}

inline
bool CBvar_Base::IsCD(void) const
{
    return m_choice == e_CD;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_BVAR_BASE_HPP
