/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CollectionTitle_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_COLLECTIONTITLE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_COLLECTIONTITLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/Text.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMath;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCollectionTitle_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CCollectionTitle_Base(void);
    // destructor
    virtual ~CCollectionTitle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TBook;
        typedef NCBI_NS_STD::string TPart;
        typedef NCBI_NS_STD::string TSec;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_book,
            e_part,
            e_sec
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TBook
        ///  Check whether the Book data member has been assigned a value.
        bool IsSetBook(void) const;
        /// Check whether it is safe or not to call GetBook method.
        bool CanGetBook(void) const;
        void ResetBook(void);
        const TBook& GetBook(void) const;
        void SetBook(const TBook& value);
        void SetBook(TBook&& value);
        TBook& SetBook(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TPart
        ///  Check whether the Part data member has been assigned a value.
        bool IsSetPart(void) const;
        /// Check whether it is safe or not to call GetPart method.
        bool CanGetPart(void) const;
        void ResetPart(void);
        const TPart& GetPart(void) const;
        void SetPart(const TPart& value);
        void SetPart(TPart&& value);
        TPart& SetPart(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSec
        ///  Check whether the Sec data member has been assigned a value.
        bool IsSetSec(void) const;
        /// Check whether it is safe or not to call GetSec method.
        bool CanGetSec(void) const;
        void ResetSec(void);
        const TSec& GetSec(void) const;
        void SetSec(const TSec& value);
        void SetSec(TSec&& value);
        TSec& SetSec(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Book;
        NCBI_NS_STD::string m_Part;
        NCBI_NS_STD::string m_Sec;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_CollectionTitle : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_CollectionTitle(void);
        // destructor
        ~C_E_CollectionTitle(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        typedef CText C_Text;
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e__CharData,
            e_Text,
            e_Math
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Math+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef C_Text TText;
        typedef CMath TMath;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef C_Text TText
        bool IsText(void) const;
        const TText& GetText(void) const;
        TText& SetText(void);
        void SetText(TText& value);
    
        // typedef CMath TMath
        bool IsMath(void) const;
        const TMath& GetMath(void) const;
        TMath& SetMath(void);
        void SetMath(TMath& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_CollectionTitle(const C_E_CollectionTitle& );
        C_E_CollectionTitle& operator=(const C_E_CollectionTitle& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_CollectionTitle C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_CollectionTitle > > TCollectionTitle;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_CollectionTitle
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_CollectionTitle > > TCollectionTitle
    ///  Check whether the CollectionTitle data member has been assigned a value.
    bool IsSetCollectionTitle(void) const;
    /// Check whether it is safe or not to call GetCollectionTitle method.
    bool CanGetCollectionTitle(void) const;
    void ResetCollectionTitle(void);
    const TCollectionTitle& GetCollectionTitle(void) const;
    TCollectionTitle& SetCollectionTitle(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCollectionTitle_Base(const CCollectionTitle_Base&);
    CCollectionTitle_Base& operator=(const CCollectionTitle_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_CollectionTitle > > m_CollectionTitle;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCollectionTitle_Base::C_Attlist::IsSetBook(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCollectionTitle_Base::C_Attlist::CanGetBook(void) const
{
    return IsSetBook();
}

inline
const CCollectionTitle_Base::C_Attlist::TBook& CCollectionTitle_Base::C_Attlist::GetBook(void) const
{
    if (!CanGetBook()) {
        ThrowUnassigned(0);
    }
    return m_Book;
}

inline
void CCollectionTitle_Base::C_Attlist::SetBook(const CCollectionTitle_Base::C_Attlist::TBook& value)
{
    m_Book = value;
    m_set_State[0] |= 0x3;
}

inline
void CCollectionTitle_Base::C_Attlist::SetBook(CCollectionTitle_Base::C_Attlist::TBook&& value)
{
    m_Book = std::forward<CCollectionTitle_Base::C_Attlist::TBook>(value);
    m_set_State[0] |= 0x3;
}

inline
CCollectionTitle_Base::C_Attlist::TBook& CCollectionTitle_Base::C_Attlist::SetBook(void)
{
#ifdef _DEBUG
    if (!IsSetBook()) {
        m_Book = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Book;
}

inline
bool CCollectionTitle_Base::C_Attlist::IsSetPart(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCollectionTitle_Base::C_Attlist::CanGetPart(void) const
{
    return IsSetPart();
}

inline
const CCollectionTitle_Base::C_Attlist::TPart& CCollectionTitle_Base::C_Attlist::GetPart(void) const
{
    if (!CanGetPart()) {
        ThrowUnassigned(1);
    }
    return m_Part;
}

inline
void CCollectionTitle_Base::C_Attlist::SetPart(const CCollectionTitle_Base::C_Attlist::TPart& value)
{
    m_Part = value;
    m_set_State[0] |= 0xc;
}

inline
void CCollectionTitle_Base::C_Attlist::SetPart(CCollectionTitle_Base::C_Attlist::TPart&& value)
{
    m_Part = std::forward<CCollectionTitle_Base::C_Attlist::TPart>(value);
    m_set_State[0] |= 0xc;
}

inline
CCollectionTitle_Base::C_Attlist::TPart& CCollectionTitle_Base::C_Attlist::SetPart(void)
{
#ifdef _DEBUG
    if (!IsSetPart()) {
        m_Part = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Part;
}

inline
bool CCollectionTitle_Base::C_Attlist::IsSetSec(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCollectionTitle_Base::C_Attlist::CanGetSec(void) const
{
    return IsSetSec();
}

inline
const CCollectionTitle_Base::C_Attlist::TSec& CCollectionTitle_Base::C_Attlist::GetSec(void) const
{
    if (!CanGetSec()) {
        ThrowUnassigned(2);
    }
    return m_Sec;
}

inline
void CCollectionTitle_Base::C_Attlist::SetSec(const CCollectionTitle_Base::C_Attlist::TSec& value)
{
    m_Sec = value;
    m_set_State[0] |= 0x30;
}

inline
void CCollectionTitle_Base::C_Attlist::SetSec(CCollectionTitle_Base::C_Attlist::TSec&& value)
{
    m_Sec = std::forward<CCollectionTitle_Base::C_Attlist::TSec>(value);
    m_set_State[0] |= 0x30;
}

inline
CCollectionTitle_Base::C_Attlist::TSec& CCollectionTitle_Base::C_Attlist::SetSec(void)
{
#ifdef _DEBUG
    if (!IsSetSec()) {
        m_Sec = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Sec;
}

inline
CCollectionTitle_Base::C_E_CollectionTitle::E_Choice CCollectionTitle_Base::C_E_CollectionTitle::Which(void) const
{
    return m_choice;
}

inline
void CCollectionTitle_Base::C_E_CollectionTitle::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCollectionTitle_Base::C_E_CollectionTitle::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCollectionTitle_Base::C_E_CollectionTitle::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCollectionTitle_Base::C_E_CollectionTitle::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CCollectionTitle_Base::C_E_CollectionTitle::T_CharData& CCollectionTitle_Base::C_E_CollectionTitle::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CCollectionTitle_Base::C_E_CollectionTitle::T_CharData& CCollectionTitle_Base::C_E_CollectionTitle::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CCollectionTitle_Base::C_E_CollectionTitle::IsText(void) const
{
    return m_choice == e_Text;
}

inline
bool CCollectionTitle_Base::C_E_CollectionTitle::IsMath(void) const
{
    return m_choice == e_Math;
}

inline
bool CCollectionTitle_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CCollectionTitle_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CCollectionTitle_Base::TAttlist& CCollectionTitle_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CCollectionTitle_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CCollectionTitle_Base::TAttlist& CCollectionTitle_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CCollectionTitle_Base::IsSetCollectionTitle(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCollectionTitle_Base::CanGetCollectionTitle(void) const
{
    return true;
}

inline
const CCollectionTitle_Base::TCollectionTitle& CCollectionTitle_Base::GetCollectionTitle(void) const
{
    return m_CollectionTitle;
}

inline
CCollectionTitle_Base::TCollectionTitle& CCollectionTitle_Base::SetCollectionTitle(void)
{
    m_set_State[0] |= 0x4;
    return m_CollectionTitle;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_COLLECTIONTITLE_BASE_HPP
