/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Maction_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MACTION_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMathExpression;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMaction_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMaction_Base(void);
    // destructor
    virtual ~CMaction_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TActiontype;
        typedef NCBI_NS_STD::string TSelection;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_actiontype,
            e_selection
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TActiontype
        ///  Check whether the Actiontype data member has been assigned a value.
        bool IsSetActiontype(void) const;
        /// Check whether it is safe or not to call GetActiontype method.
        bool CanGetActiontype(void) const;
        void ResetActiontype(void);
        const TActiontype& GetActiontype(void) const;
        void SetActiontype(const TActiontype& value);
        void SetActiontype(TActiontype&& value);
        TActiontype& SetActiontype(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSelection
        ///  Check whether the Selection data member has been assigned a value.
        bool IsSetSelection(void) const;
        /// Check whether it is safe or not to call GetSelection method.
        bool CanGetSelection(void) const;
        void ResetSelection(void);
        const TSelection& GetSelection(void) const;
        void SetSelection(const TSelection& value);
        void SetSelection(TSelection&& value);
        TSelection& SetSelection(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Actiontype;
        NCBI_NS_STD::string m_Selection;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_MathExpression : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_MathExpression(void);
        // destructor
        ~C_MathExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CMathExpression C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CMathExpression > > TMathExpression;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_MathExpression
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CMathExpression > > TMathExpression
        ///  Check whether the MathExpression data member has been assigned a value.
        bool IsSetMathExpression(void) const;
        /// Check whether it is safe or not to call GetMathExpression method.
        bool CanGetMathExpression(void) const;
        void ResetMathExpression(void);
        const TMathExpression& GetMathExpression(void) const;
        TMathExpression& SetMathExpression(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_MathExpression(const C_MathExpression&);
        C_MathExpression& operator=(const C_MathExpression&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CMathExpression > > m_MathExpression;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_MathExpression TMathExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MathExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_MathExpression TMathExpression
    ///  Check whether the MathExpression data member has been assigned a value.
    bool IsSetMathExpression(void) const;
    /// Check whether it is safe or not to call GetMathExpression method.
    bool CanGetMathExpression(void) const;
    void ResetMathExpression(void);
    const TMathExpression& GetMathExpression(void) const;
    void SetMathExpression(TMathExpression& value);
    TMathExpression& SetMathExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMaction_Base(const CMaction_Base&);
    CMaction_Base& operator=(const CMaction_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TMathExpression > m_MathExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMaction_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMaction_Base::C_Attlist::TId& CMaction_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMaction_Base::C_Attlist::SetId(const CMaction_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMaction_Base::C_Attlist::SetId(CMaction_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMaction_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMaction_Base::C_Attlist::TId& CMaction_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMaction_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMaction_Base::C_Attlist::TXref& CMaction_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMaction_Base::C_Attlist::SetXref(const CMaction_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMaction_Base::C_Attlist::SetXref(CMaction_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMaction_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMaction_Base::C_Attlist::TXref& CMaction_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMaction_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMaction_Base::C_Attlist::TClass& CMaction_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMaction_Base::C_Attlist::SetClass(const CMaction_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMaction_Base::C_Attlist::SetClass(CMaction_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMaction_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMaction_Base::C_Attlist::TClass& CMaction_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMaction_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMaction_Base::C_Attlist::TStyle& CMaction_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMaction_Base::C_Attlist::SetStyle(const CMaction_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMaction_Base::C_Attlist::SetStyle(CMaction_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMaction_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMaction_Base::C_Attlist::TStyle& CMaction_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMaction_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMaction_Base::C_Attlist::THref& CMaction_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMaction_Base::C_Attlist::SetHref(const CMaction_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMaction_Base::C_Attlist::SetHref(CMaction_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMaction_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMaction_Base::C_Attlist::THref& CMaction_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMaction_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMaction_Base::C_Attlist::TMathcolor& CMaction_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMaction_Base::C_Attlist::SetMathcolor(const CMaction_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMaction_Base::C_Attlist::SetMathcolor(CMaction_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMaction_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMaction_Base::C_Attlist::TMathcolor& CMaction_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMaction_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMaction_Base::C_Attlist::TMathbackground& CMaction_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMaction_Base::C_Attlist::SetMathbackground(const CMaction_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMaction_Base::C_Attlist::SetMathbackground(CMaction_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMaction_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMaction_Base::C_Attlist::TMathbackground& CMaction_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMaction_Base::C_Attlist::IsSetActiontype(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetActiontype(void) const
{
    return IsSetActiontype();
}

inline
const CMaction_Base::C_Attlist::TActiontype& CMaction_Base::C_Attlist::GetActiontype(void) const
{
    if (!CanGetActiontype()) {
        ThrowUnassigned(7);
    }
    return m_Actiontype;
}

inline
void CMaction_Base::C_Attlist::SetActiontype(const CMaction_Base::C_Attlist::TActiontype& value)
{
    m_Actiontype = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMaction_Base::C_Attlist::SetActiontype(CMaction_Base::C_Attlist::TActiontype&& value)
{
    m_Actiontype = std::forward<CMaction_Base::C_Attlist::TActiontype>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMaction_Base::C_Attlist::TActiontype& CMaction_Base::C_Attlist::SetActiontype(void)
{
#ifdef _DEBUG
    if (!IsSetActiontype()) {
        m_Actiontype = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Actiontype;
}

inline
bool CMaction_Base::C_Attlist::IsSetSelection(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMaction_Base::C_Attlist::CanGetSelection(void) const
{
    return IsSetSelection();
}

inline
const CMaction_Base::C_Attlist::TSelection& CMaction_Base::C_Attlist::GetSelection(void) const
{
    if (!CanGetSelection()) {
        ThrowUnassigned(8);
    }
    return m_Selection;
}

inline
void CMaction_Base::C_Attlist::SetSelection(const CMaction_Base::C_Attlist::TSelection& value)
{
    m_Selection = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMaction_Base::C_Attlist::SetSelection(CMaction_Base::C_Attlist::TSelection&& value)
{
    m_Selection = std::forward<CMaction_Base::C_Attlist::TSelection>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMaction_Base::C_Attlist::TSelection& CMaction_Base::C_Attlist::SetSelection(void)
{
#ifdef _DEBUG
    if (!IsSetSelection()) {
        m_Selection = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Selection;
}

inline
bool CMaction_Base::C_MathExpression::IsSetMathExpression(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMaction_Base::C_MathExpression::CanGetMathExpression(void) const
{
    return true;
}

inline
const CMaction_Base::C_MathExpression::TMathExpression& CMaction_Base::C_MathExpression::GetMathExpression(void) const
{
    return m_MathExpression;
}

inline
CMaction_Base::C_MathExpression::TMathExpression& CMaction_Base::C_MathExpression::SetMathExpression(void)
{
    m_set_State[0] |= 0x1;
    return m_MathExpression;
}

inline
bool CMaction_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMaction_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMaction_Base::TAttlist& CMaction_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMaction_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMaction_Base::TAttlist& CMaction_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMaction_Base::IsSetMathExpression(void) const
{
    return m_MathExpression.NotEmpty();
}

inline
bool CMaction_Base::CanGetMathExpression(void) const
{
    return true;
}

inline
const CMaction_Base::TMathExpression& CMaction_Base::GetMathExpression(void) const
{
    if ( !m_MathExpression ) {
        const_cast<CMaction_Base*>(this)->ResetMathExpression();
    }
    return (*m_MathExpression);
}

inline
CMaction_Base::TMathExpression& CMaction_Base::SetMathExpression(void)
{
    if ( !m_MathExpression ) {
        ResetMathExpression();
    }
    return (*m_MathExpression);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MACTION_BASE_HPP
