/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Math_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MATH_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MATH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MathExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// end of mathml3-presentation.rng 
/// start of mathml3-common.rng 
class CMath_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMath_Base(void);
    // destructor
    virtual ~CMath_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_display {
            eAttlist_display_block  = 1,
            eAttlist_display_inline = 2
        };
        
        /// Access to EAttlist_display's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_display)(void);
        
        enum EAttlist_overflow {
            eAttlist_overflow_linebreak = 1,
            eAttlist_overflow_scroll    = 2,
            eAttlist_overflow_elide     = 3,
            eAttlist_overflow_truncate  = 4,
            eAttlist_overflow_scale     = 5
        };
        
        /// Access to EAttlist_overflow's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_overflow)(void);
        
        enum EAttlist_displaystyle {
            eAttlist_displaystyle_true  = 1,
            eAttlist_displaystyle_false = 2
        };
        
        /// Access to EAttlist_displaystyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_displaystyle)(void);
        
        enum EAttlist_infixlinebreakstyle {
            eAttlist_infixlinebreakstyle_before    = 1,
            eAttlist_infixlinebreakstyle_after     = 2,
            eAttlist_infixlinebreakstyle_duplicate = 3
        };
        
        /// Access to EAttlist_infixlinebreakstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_infixlinebreakstyle)(void);
        
        enum EAttlist_accent {
            eAttlist_accent_true  = 1,
            eAttlist_accent_false = 2
        };
        
        /// Access to EAttlist_accent's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_accent)(void);
        
        enum EAttlist_accentunder {
            eAttlist_accentunder_true  = 1,
            eAttlist_accentunder_false = 2
        };
        
        /// Access to EAttlist_accentunder's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_accentunder)(void);
        
        enum EAttlist_align {
            eAttlist_align_left   = 1,
            eAttlist_align_right  = 2,
            eAttlist_align_center = 3
        };
        
        /// Access to EAttlist_align's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_align)(void);
        
        enum EAttlist_bevelled {
            eAttlist_bevelled_true  = 1,
            eAttlist_bevelled_false = 2
        };
        
        /// Access to EAttlist_bevelled's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_bevelled)(void);
        
        enum EAttlist_charalign {
            eAttlist_charalign_left   = 1,
            eAttlist_charalign_center = 2,
            eAttlist_charalign_right  = 3
        };
        
        /// Access to EAttlist_charalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_charalign)(void);
        
        enum EAttlist_denomalign {
            eAttlist_denomalign_left   = 1,
            eAttlist_denomalign_center = 2,
            eAttlist_denomalign_right  = 3
        };
        
        /// Access to EAttlist_denomalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_denomalign)(void);
        
        enum EAttlist_dir {
            eAttlist_dir_ltr = 1,
            eAttlist_dir_rtl = 2
        };
        
        /// Access to EAttlist_dir's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_dir)(void);
        
        enum EAttlist_edge {
            eAttlist_edge_left  = 1,
            eAttlist_edge_right = 2
        };
        
        /// Access to EAttlist_edge's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_edge)(void);
        
        enum EAttlist_equalcolumns {
            eAttlist_equalcolumns_true  = 1,
            eAttlist_equalcolumns_false = 2
        };
        
        /// Access to EAttlist_equalcolumns's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_equalcolumns)(void);
        
        enum EAttlist_equalrows {
            eAttlist_equalrows_true  = 1,
            eAttlist_equalrows_false = 2
        };
        
        /// Access to EAttlist_equalrows's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_equalrows)(void);
        
        enum EAttlist_fence {
            eAttlist_fence_true  = 1,
            eAttlist_fence_false = 2
        };
        
        /// Access to EAttlist_fence's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fence)(void);
        
        enum EAttlist_form {
            eAttlist_form_prefix  = 1,
            eAttlist_form_infix   = 2,
            eAttlist_form_postfix = 3
        };
        
        /// Access to EAttlist_form's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_form)(void);
        
        enum EAttlist_frame {
            eAttlist_frame_none   = 1,
            eAttlist_frame_solid  = 2,
            eAttlist_frame_dashed = 3
        };
        
        /// Access to EAttlist_frame's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_frame)(void);
        
        enum EAttlist_indentalign {
            eAttlist_indentalign_left   = 1,
            eAttlist_indentalign_center = 2,
            eAttlist_indentalign_right  = 3,
            eAttlist_indentalign_auto   = 4,
            eAttlist_indentalign_id     = 5
        };
        
        /// Access to EAttlist_indentalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalign)(void);
        
        enum EAttlist_indentalignfirst {
            eAttlist_indentalignfirst_left        = 1,
            eAttlist_indentalignfirst_center      = 2,
            eAttlist_indentalignfirst_right       = 3,
            eAttlist_indentalignfirst_auto        = 4,
            eAttlist_indentalignfirst_id          = 5,
            eAttlist_indentalignfirst_indentalign = 6
        };
        
        /// Access to EAttlist_indentalignfirst's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalignfirst)(void);
        
        enum EAttlist_indentalignlast {
            eAttlist_indentalignlast_left        = 1,
            eAttlist_indentalignlast_center      = 2,
            eAttlist_indentalignlast_right       = 3,
            eAttlist_indentalignlast_auto        = 4,
            eAttlist_indentalignlast_id          = 5,
            eAttlist_indentalignlast_indentalign = 6
        };
        
        /// Access to EAttlist_indentalignlast's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_indentalignlast)(void);
        
        enum EAttlist_largeop {
            eAttlist_largeop_true  = 1,
            eAttlist_largeop_false = 2
        };
        
        /// Access to EAttlist_largeop's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_largeop)(void);
        
        enum EAttlist_linebreak {
            eAttlist_linebreak_auto      = 1,
            eAttlist_linebreak_newline   = 2,
            eAttlist_linebreak_nobreak   = 3,
            eAttlist_linebreak_goodbreak = 4,
            eAttlist_linebreak_badbreak  = 5
        };
        
        /// Access to EAttlist_linebreak's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_linebreak)(void);
        
        enum EAttlist_linebreakstyle {
            eAttlist_linebreakstyle_before              = 1,
            eAttlist_linebreakstyle_after               = 2,
            eAttlist_linebreakstyle_duplicate           = 3,
            eAttlist_linebreakstyle_infixlinebreakstyle = 4
        };
        
        /// Access to EAttlist_linebreakstyle's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_linebreakstyle)(void);
        
        enum EAttlist_location {
            eAttlist_location_w  = 1,
            eAttlist_location_nw = 2,
            eAttlist_location_n  = 3,
            eAttlist_location_ne = 4,
            eAttlist_location_e  = 5,
            eAttlist_location_se = 6,
            eAttlist_location_s  = 7,
            eAttlist_location_sw = 8
        };
        
        /// Access to EAttlist_location's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_location)(void);
        
        enum EAttlist_mathvariant {
            eAttlist_mathvariant_normal                 =  1,
            eAttlist_mathvariant_bold                   =  2,
            eAttlist_mathvariant_italic                 =  3,
            eAttlist_mathvariant_bold_italic            =  4,
            eAttlist_mathvariant_double_struck          =  5,
            eAttlist_mathvariant_bold_fraktur           =  6,
            eAttlist_mathvariant_script                 =  7,
            eAttlist_mathvariant_bold_script            =  8,
            eAttlist_mathvariant_fraktur                =  9,
            eAttlist_mathvariant_sans_serif             = 10,
            eAttlist_mathvariant_bold_sans_serif        = 11,
            eAttlist_mathvariant_sans_serif_italic      = 12,
            eAttlist_mathvariant_sans_serif_bold_italic = 13,
            eAttlist_mathvariant_monospace              = 14,
            eAttlist_mathvariant_initial                = 15,
            eAttlist_mathvariant_tailed                 = 16,
            eAttlist_mathvariant_looped                 = 17,
            eAttlist_mathvariant_stretched              = 18
        };
        
        /// Access to EAttlist_mathvariant's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_mathvariant)(void);
        
        enum EAttlist_movablelimits {
            eAttlist_movablelimits_true  = 1,
            eAttlist_movablelimits_false = 2
        };
        
        /// Access to EAttlist_movablelimits's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_movablelimits)(void);
        
        enum EAttlist_numalign {
            eAttlist_numalign_left   = 1,
            eAttlist_numalign_center = 2,
            eAttlist_numalign_right  = 3
        };
        
        /// Access to EAttlist_numalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_numalign)(void);
        
        enum EAttlist_separator {
            eAttlist_separator_true  = 1,
            eAttlist_separator_false = 2
        };
        
        /// Access to EAttlist_separator's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_separator)(void);
        
        enum EAttlist_side {
            eAttlist_side_left         = 1,
            eAttlist_side_right        = 2,
            eAttlist_side_leftoverlap  = 3,
            eAttlist_side_rightoverlap = 4
        };
        
        /// Access to EAttlist_side's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_side)(void);
        
        enum EAttlist_stackalign {
            eAttlist_stackalign_left         = 1,
            eAttlist_stackalign_center       = 2,
            eAttlist_stackalign_right        = 3,
            eAttlist_stackalign_decimalpoint = 4
        };
        
        /// Access to EAttlist_stackalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_stackalign)(void);
        
        enum EAttlist_stretchy {
            eAttlist_stretchy_true  = 1,
            eAttlist_stretchy_false = 2
        };
        
        /// Access to EAttlist_stretchy's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_stretchy)(void);
        
        enum EAttlist_symmetric {
            eAttlist_symmetric_true  = 1,
            eAttlist_symmetric_false = 2
        };
        
        /// Access to EAttlist_symmetric's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_symmetric)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef EAttlist_display TDisplay;
        typedef NCBI_NS_STD::string TMaxwidth;
        typedef EAttlist_overflow TOverflow;
        typedef NCBI_NS_STD::string TAltimg;
        typedef NCBI_NS_STD::string TAltimg_width;
        typedef NCBI_NS_STD::string TAltimg_height;
        typedef NCBI_NS_STD::string TAltimg_valign;
        typedef NCBI_NS_STD::string TAlttext;
        typedef NCBI_NS_STD::string TCdgroup;
        typedef NCBI_NS_STD::string TMode;
        typedef NCBI_NS_STD::string TMacros;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TScriptlevel;
        typedef EAttlist_displaystyle TDisplaystyle;
        typedef NCBI_NS_STD::string TScriptsizemultiplier;
        typedef NCBI_NS_STD::string TScriptminsize;
        typedef EAttlist_infixlinebreakstyle TInfixlinebreakstyle;
        typedef NCBI_NS_STD::string TDecimalpoint;
        typedef EAttlist_accent TAccent;
        typedef EAttlist_accentunder TAccentunder;
        typedef EAttlist_align TAlign;
        typedef NCBI_NS_STD::string TAlignmentscope;
        typedef EAttlist_bevelled TBevelled;
        typedef EAttlist_charalign TCharalign;
        typedef NCBI_NS_STD::string TCharspacing;
        typedef NCBI_NS_STD::string TClose;
        typedef NCBI_NS_STD::string TColumnalign;
        typedef NCBI_NS_STD::string TColumnlines;
        typedef NCBI_NS_STD::string TColumnspacing;
        typedef NCBI_NS_STD::string TColumnspan;
        typedef NCBI_NS_STD::string TColumnwidth;
        typedef NCBI_NS_STD::string TCrossout;
        typedef EAttlist_denomalign TDenomalign;
        typedef NCBI_NS_STD::string TDepth;
        typedef EAttlist_dir TDir;
        typedef EAttlist_edge TEdge;
        typedef EAttlist_equalcolumns TEqualcolumns;
        typedef EAttlist_equalrows TEqualrows;
        typedef EAttlist_fence TFence;
        typedef EAttlist_form TForm;
        typedef EAttlist_frame TFrame;
        typedef NCBI_NS_STD::string TFramespacing;
        typedef NCBI_NS_STD::string TGroupalign;
        typedef NCBI_NS_STD::string THeight;
        typedef EAttlist_indentalign TIndentalign;
        typedef EAttlist_indentalignfirst TIndentalignfirst;
        typedef EAttlist_indentalignlast TIndentalignlast;
        typedef NCBI_NS_STD::string TIndentshift;
        typedef NCBI_NS_STD::string TIndentshiftfirst;
        typedef NCBI_NS_STD::string TIndentshiftlast;
        typedef NCBI_NS_STD::string TIndenttarget;
        typedef EAttlist_largeop TLargeop;
        typedef NCBI_NS_STD::string TLeftoverhang;
        typedef NCBI_NS_STD::string TLength;
        typedef EAttlist_linebreak TLinebreak;
        typedef NCBI_NS_STD::string TLinebreakmultchar;
        typedef EAttlist_linebreakstyle TLinebreakstyle;
        typedef NCBI_NS_STD::string TLineleading;
        typedef NCBI_NS_STD::string TLinethickness;
        typedef EAttlist_location TLocation;
        typedef NCBI_NS_STD::string TLongdivstyle;
        typedef NCBI_NS_STD::string TLquote;
        typedef NCBI_NS_STD::string TLspace;
        typedef NCBI_NS_STD::string TMathsize;
        typedef EAttlist_mathvariant TMathvariant;
        typedef NCBI_NS_STD::string TMaxsize;
        typedef NCBI_NS_STD::string TMinlabelspacing;
        typedef NCBI_NS_STD::string TMinsize;
        typedef EAttlist_movablelimits TMovablelimits;
        typedef NCBI_NS_STD::string TMslinethickness;
        typedef NCBI_NS_STD::string TNotation;
        typedef EAttlist_numalign TNumalign;
        typedef NCBI_NS_STD::string TOpen;
        typedef NCBI_NS_STD::string TPosition;
        typedef NCBI_NS_STD::string TRightoverhang;
        typedef NCBI_NS_STD::string TRowalign;
        typedef NCBI_NS_STD::string TRowlines;
        typedef NCBI_NS_STD::string TRowspacing;
        typedef NCBI_NS_STD::string TRowspan;
        typedef NCBI_NS_STD::string TRquote;
        typedef NCBI_NS_STD::string TRspace;
        typedef NCBI_NS_STD::string TSelection;
        typedef EAttlist_separator TSeparator;
        typedef NCBI_NS_STD::string TSeparators;
        typedef NCBI_NS_STD::string TShift;
        typedef EAttlist_side TSide;
        typedef EAttlist_stackalign TStackalign;
        typedef EAttlist_stretchy TStretchy;
        typedef NCBI_NS_STD::string TSubscriptshift;
        typedef NCBI_NS_STD::string TSuperscriptshift;
        typedef EAttlist_symmetric TSymmetric;
        typedef NCBI_NS_STD::string TValign;
        typedef NCBI_NS_STD::string TWidth;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_display,
            e_maxwidth,
            e_overflow,
            e_altimg,
            e_altimg_width,
            e_altimg_height,
            e_altimg_valign,
            e_alttext,
            e_cdgroup,
            e_mode,
            e_macros,
            e_mathcolor,
            e_mathbackground,
            e_scriptlevel,
            e_displaystyle,
            e_scriptsizemultiplier,
            e_scriptminsize,
            e_infixlinebreakstyle,
            e_decimalpoint,
            e_accent,
            e_accentunder,
            e_align,
            e_alignmentscope,
            e_bevelled,
            e_charalign,
            e_charspacing,
            e_close,
            e_columnalign,
            e_columnlines,
            e_columnspacing,
            e_columnspan,
            e_columnwidth,
            e_crossout,
            e_denomalign,
            e_depth,
            e_dir,
            e_edge,
            e_equalcolumns,
            e_equalrows,
            e_fence,
            e_form,
            e_frame,
            e_framespacing,
            e_groupalign,
            e_height,
            e_indentalign,
            e_indentalignfirst,
            e_indentalignlast,
            e_indentshift,
            e_indentshiftfirst,
            e_indentshiftlast,
            e_indenttarget,
            e_largeop,
            e_leftoverhang,
            e_length,
            e_linebreak,
            e_linebreakmultchar,
            e_linebreakstyle,
            e_lineleading,
            e_linethickness,
            e_location,
            e_longdivstyle,
            e_lquote,
            e_lspace,
            e_mathsize,
            e_mathvariant,
            e_maxsize,
            e_minlabelspacing,
            e_minsize,
            e_movablelimits,
            e_mslinethickness,
            e_notation,
            e_numalign,
            e_open,
            e_position,
            e_rightoverhang,
            e_rowalign,
            e_rowlines,
            e_rowspacing,
            e_rowspan,
            e_rquote,
            e_rspace,
            e_selection,
            e_separator,
            e_separators,
            e_shift,
            e_side,
            e_stackalign,
            e_stretchy,
            e_subscriptshift,
            e_superscriptshift,
            e_symmetric,
            e_valign,
            e_width
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 100> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef EAttlist_display TDisplay
        ///  Check whether the Display data member has been assigned a value.
        bool IsSetDisplay(void) const;
        /// Check whether it is safe or not to call GetDisplay method.
        bool CanGetDisplay(void) const;
        void ResetDisplay(void);
        TDisplay GetDisplay(void) const;
        void SetDisplay(TDisplay value);
        TDisplay& SetDisplay(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMaxwidth
        ///  Check whether the Maxwidth data member has been assigned a value.
        bool IsSetMaxwidth(void) const;
        /// Check whether it is safe or not to call GetMaxwidth method.
        bool CanGetMaxwidth(void) const;
        void ResetMaxwidth(void);
        const TMaxwidth& GetMaxwidth(void) const;
        void SetMaxwidth(const TMaxwidth& value);
        void SetMaxwidth(TMaxwidth&& value);
        TMaxwidth& SetMaxwidth(void);
    
        /// optional
        /// typedef EAttlist_overflow TOverflow
        ///  Check whether the Overflow data member has been assigned a value.
        bool IsSetOverflow(void) const;
        /// Check whether it is safe or not to call GetOverflow method.
        bool CanGetOverflow(void) const;
        void ResetOverflow(void);
        TOverflow GetOverflow(void) const;
        void SetOverflow(TOverflow value);
        TOverflow& SetOverflow(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAltimg
        ///  Check whether the Altimg data member has been assigned a value.
        bool IsSetAltimg(void) const;
        /// Check whether it is safe or not to call GetAltimg method.
        bool CanGetAltimg(void) const;
        void ResetAltimg(void);
        const TAltimg& GetAltimg(void) const;
        void SetAltimg(const TAltimg& value);
        void SetAltimg(TAltimg&& value);
        TAltimg& SetAltimg(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAltimg_width
        ///  Check whether the Altimg_width data member has been assigned a value.
        bool IsSetAltimg_width(void) const;
        /// Check whether it is safe or not to call GetAltimg_width method.
        bool CanGetAltimg_width(void) const;
        void ResetAltimg_width(void);
        const TAltimg_width& GetAltimg_width(void) const;
        void SetAltimg_width(const TAltimg_width& value);
        void SetAltimg_width(TAltimg_width&& value);
        TAltimg_width& SetAltimg_width(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAltimg_height
        ///  Check whether the Altimg_height data member has been assigned a value.
        bool IsSetAltimg_height(void) const;
        /// Check whether it is safe or not to call GetAltimg_height method.
        bool CanGetAltimg_height(void) const;
        void ResetAltimg_height(void);
        const TAltimg_height& GetAltimg_height(void) const;
        void SetAltimg_height(const TAltimg_height& value);
        void SetAltimg_height(TAltimg_height&& value);
        TAltimg_height& SetAltimg_height(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAltimg_valign
        ///  Check whether the Altimg_valign data member has been assigned a value.
        bool IsSetAltimg_valign(void) const;
        /// Check whether it is safe or not to call GetAltimg_valign method.
        bool CanGetAltimg_valign(void) const;
        void ResetAltimg_valign(void);
        const TAltimg_valign& GetAltimg_valign(void) const;
        void SetAltimg_valign(const TAltimg_valign& value);
        void SetAltimg_valign(TAltimg_valign&& value);
        TAltimg_valign& SetAltimg_valign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAlttext
        ///  Check whether the Alttext data member has been assigned a value.
        bool IsSetAlttext(void) const;
        /// Check whether it is safe or not to call GetAlttext method.
        bool CanGetAlttext(void) const;
        void ResetAlttext(void);
        const TAlttext& GetAlttext(void) const;
        void SetAlttext(const TAlttext& value);
        void SetAlttext(TAlttext&& value);
        TAlttext& SetAlttext(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCdgroup
        ///  Check whether the Cdgroup data member has been assigned a value.
        bool IsSetCdgroup(void) const;
        /// Check whether it is safe or not to call GetCdgroup method.
        bool CanGetCdgroup(void) const;
        void ResetCdgroup(void);
        const TCdgroup& GetCdgroup(void) const;
        void SetCdgroup(const TCdgroup& value);
        void SetCdgroup(TCdgroup&& value);
        TCdgroup& SetCdgroup(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMode
        ///  Check whether the Mode data member has been assigned a value.
        bool IsSetMode(void) const;
        /// Check whether it is safe or not to call GetMode method.
        bool CanGetMode(void) const;
        void ResetMode(void);
        const TMode& GetMode(void) const;
        void SetMode(const TMode& value);
        void SetMode(TMode&& value);
        TMode& SetMode(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMacros
        ///  Check whether the Macros data member has been assigned a value.
        bool IsSetMacros(void) const;
        /// Check whether it is safe or not to call GetMacros method.
        bool CanGetMacros(void) const;
        void ResetMacros(void);
        const TMacros& GetMacros(void) const;
        void SetMacros(const TMacros& value);
        void SetMacros(TMacros&& value);
        TMacros& SetMacros(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TScriptlevel
        ///  Check whether the Scriptlevel data member has been assigned a value.
        bool IsSetScriptlevel(void) const;
        /// Check whether it is safe or not to call GetScriptlevel method.
        bool CanGetScriptlevel(void) const;
        void ResetScriptlevel(void);
        const TScriptlevel& GetScriptlevel(void) const;
        void SetScriptlevel(const TScriptlevel& value);
        void SetScriptlevel(TScriptlevel&& value);
        TScriptlevel& SetScriptlevel(void);
    
        /// optional
        /// typedef EAttlist_displaystyle TDisplaystyle
        ///  Check whether the Displaystyle data member has been assigned a value.
        bool IsSetDisplaystyle(void) const;
        /// Check whether it is safe or not to call GetDisplaystyle method.
        bool CanGetDisplaystyle(void) const;
        void ResetDisplaystyle(void);
        TDisplaystyle GetDisplaystyle(void) const;
        void SetDisplaystyle(TDisplaystyle value);
        TDisplaystyle& SetDisplaystyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TScriptsizemultiplier
        ///  Check whether the Scriptsizemultiplier data member has been assigned a value.
        bool IsSetScriptsizemultiplier(void) const;
        /// Check whether it is safe or not to call GetScriptsizemultiplier method.
        bool CanGetScriptsizemultiplier(void) const;
        void ResetScriptsizemultiplier(void);
        const TScriptsizemultiplier& GetScriptsizemultiplier(void) const;
        void SetScriptsizemultiplier(const TScriptsizemultiplier& value);
        void SetScriptsizemultiplier(TScriptsizemultiplier&& value);
        TScriptsizemultiplier& SetScriptsizemultiplier(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TScriptminsize
        ///  Check whether the Scriptminsize data member has been assigned a value.
        bool IsSetScriptminsize(void) const;
        /// Check whether it is safe or not to call GetScriptminsize method.
        bool CanGetScriptminsize(void) const;
        void ResetScriptminsize(void);
        const TScriptminsize& GetScriptminsize(void) const;
        void SetScriptminsize(const TScriptminsize& value);
        void SetScriptminsize(TScriptminsize&& value);
        TScriptminsize& SetScriptminsize(void);
    
        /// optional
        /// typedef EAttlist_infixlinebreakstyle TInfixlinebreakstyle
        ///  Check whether the Infixlinebreakstyle data member has been assigned a value.
        bool IsSetInfixlinebreakstyle(void) const;
        /// Check whether it is safe or not to call GetInfixlinebreakstyle method.
        bool CanGetInfixlinebreakstyle(void) const;
        void ResetInfixlinebreakstyle(void);
        TInfixlinebreakstyle GetInfixlinebreakstyle(void) const;
        void SetInfixlinebreakstyle(TInfixlinebreakstyle value);
        TInfixlinebreakstyle& SetInfixlinebreakstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDecimalpoint
        ///  Check whether the Decimalpoint data member has been assigned a value.
        bool IsSetDecimalpoint(void) const;
        /// Check whether it is safe or not to call GetDecimalpoint method.
        bool CanGetDecimalpoint(void) const;
        void ResetDecimalpoint(void);
        const TDecimalpoint& GetDecimalpoint(void) const;
        void SetDecimalpoint(const TDecimalpoint& value);
        void SetDecimalpoint(TDecimalpoint&& value);
        TDecimalpoint& SetDecimalpoint(void);
    
        /// optional
        /// typedef EAttlist_accent TAccent
        ///  Check whether the Accent data member has been assigned a value.
        bool IsSetAccent(void) const;
        /// Check whether it is safe or not to call GetAccent method.
        bool CanGetAccent(void) const;
        void ResetAccent(void);
        TAccent GetAccent(void) const;
        void SetAccent(TAccent value);
        TAccent& SetAccent(void);
    
        /// optional
        /// typedef EAttlist_accentunder TAccentunder
        ///  Check whether the Accentunder data member has been assigned a value.
        bool IsSetAccentunder(void) const;
        /// Check whether it is safe or not to call GetAccentunder method.
        bool CanGetAccentunder(void) const;
        void ResetAccentunder(void);
        TAccentunder GetAccentunder(void) const;
        void SetAccentunder(TAccentunder value);
        TAccentunder& SetAccentunder(void);
    
        /// optional
        /// typedef EAttlist_align TAlign
        ///  Check whether the Align data member has been assigned a value.
        bool IsSetAlign(void) const;
        /// Check whether it is safe or not to call GetAlign method.
        bool CanGetAlign(void) const;
        void ResetAlign(void);
        TAlign GetAlign(void) const;
        void SetAlign(TAlign value);
        TAlign& SetAlign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAlignmentscope
        ///  Check whether the Alignmentscope data member has been assigned a value.
        bool IsSetAlignmentscope(void) const;
        /// Check whether it is safe or not to call GetAlignmentscope method.
        bool CanGetAlignmentscope(void) const;
        void ResetAlignmentscope(void);
        const TAlignmentscope& GetAlignmentscope(void) const;
        void SetAlignmentscope(const TAlignmentscope& value);
        void SetAlignmentscope(TAlignmentscope&& value);
        TAlignmentscope& SetAlignmentscope(void);
    
        /// optional
        /// typedef EAttlist_bevelled TBevelled
        ///  Check whether the Bevelled data member has been assigned a value.
        bool IsSetBevelled(void) const;
        /// Check whether it is safe or not to call GetBevelled method.
        bool CanGetBevelled(void) const;
        void ResetBevelled(void);
        TBevelled GetBevelled(void) const;
        void SetBevelled(TBevelled value);
        TBevelled& SetBevelled(void);
    
        /// optional
        /// typedef EAttlist_charalign TCharalign
        ///  Check whether the Charalign data member has been assigned a value.
        bool IsSetCharalign(void) const;
        /// Check whether it is safe or not to call GetCharalign method.
        bool CanGetCharalign(void) const;
        void ResetCharalign(void);
        TCharalign GetCharalign(void) const;
        void SetCharalign(TCharalign value);
        TCharalign& SetCharalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCharspacing
        ///  Check whether the Charspacing data member has been assigned a value.
        bool IsSetCharspacing(void) const;
        /// Check whether it is safe or not to call GetCharspacing method.
        bool CanGetCharspacing(void) const;
        void ResetCharspacing(void);
        const TCharspacing& GetCharspacing(void) const;
        void SetCharspacing(const TCharspacing& value);
        void SetCharspacing(TCharspacing&& value);
        TCharspacing& SetCharspacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClose
        ///  Check whether the Close data member has been assigned a value.
        bool IsSetClose(void) const;
        /// Check whether it is safe or not to call GetClose method.
        bool CanGetClose(void) const;
        void ResetClose(void);
        const TClose& GetClose(void) const;
        void SetClose(const TClose& value);
        void SetClose(TClose&& value);
        TClose& SetClose(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnalign
        ///  Check whether the Columnalign data member has been assigned a value.
        bool IsSetColumnalign(void) const;
        /// Check whether it is safe or not to call GetColumnalign method.
        bool CanGetColumnalign(void) const;
        void ResetColumnalign(void);
        const TColumnalign& GetColumnalign(void) const;
        void SetColumnalign(const TColumnalign& value);
        void SetColumnalign(TColumnalign&& value);
        TColumnalign& SetColumnalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnlines
        ///  Check whether the Columnlines data member has been assigned a value.
        bool IsSetColumnlines(void) const;
        /// Check whether it is safe or not to call GetColumnlines method.
        bool CanGetColumnlines(void) const;
        void ResetColumnlines(void);
        const TColumnlines& GetColumnlines(void) const;
        void SetColumnlines(const TColumnlines& value);
        void SetColumnlines(TColumnlines&& value);
        TColumnlines& SetColumnlines(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnspacing
        ///  Check whether the Columnspacing data member has been assigned a value.
        bool IsSetColumnspacing(void) const;
        /// Check whether it is safe or not to call GetColumnspacing method.
        bool CanGetColumnspacing(void) const;
        void ResetColumnspacing(void);
        const TColumnspacing& GetColumnspacing(void) const;
        void SetColumnspacing(const TColumnspacing& value);
        void SetColumnspacing(TColumnspacing&& value);
        TColumnspacing& SetColumnspacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnspan
        ///  Check whether the Columnspan data member has been assigned a value.
        bool IsSetColumnspan(void) const;
        /// Check whether it is safe or not to call GetColumnspan method.
        bool CanGetColumnspan(void) const;
        void ResetColumnspan(void);
        const TColumnspan& GetColumnspan(void) const;
        void SetColumnspan(const TColumnspan& value);
        void SetColumnspan(TColumnspan&& value);
        TColumnspan& SetColumnspan(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TColumnwidth
        ///  Check whether the Columnwidth data member has been assigned a value.
        bool IsSetColumnwidth(void) const;
        /// Check whether it is safe or not to call GetColumnwidth method.
        bool CanGetColumnwidth(void) const;
        void ResetColumnwidth(void);
        const TColumnwidth& GetColumnwidth(void) const;
        void SetColumnwidth(const TColumnwidth& value);
        void SetColumnwidth(TColumnwidth&& value);
        TColumnwidth& SetColumnwidth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCrossout
        ///  Check whether the Crossout data member has been assigned a value.
        bool IsSetCrossout(void) const;
        /// Check whether it is safe or not to call GetCrossout method.
        bool CanGetCrossout(void) const;
        void ResetCrossout(void);
        const TCrossout& GetCrossout(void) const;
        void SetCrossout(const TCrossout& value);
        void SetCrossout(TCrossout&& value);
        TCrossout& SetCrossout(void);
    
        /// optional
        /// typedef EAttlist_denomalign TDenomalign
        ///  Check whether the Denomalign data member has been assigned a value.
        bool IsSetDenomalign(void) const;
        /// Check whether it is safe or not to call GetDenomalign method.
        bool CanGetDenomalign(void) const;
        void ResetDenomalign(void);
        TDenomalign GetDenomalign(void) const;
        void SetDenomalign(TDenomalign value);
        TDenomalign& SetDenomalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDepth
        ///  Check whether the Depth data member has been assigned a value.
        bool IsSetDepth(void) const;
        /// Check whether it is safe or not to call GetDepth method.
        bool CanGetDepth(void) const;
        void ResetDepth(void);
        const TDepth& GetDepth(void) const;
        void SetDepth(const TDepth& value);
        void SetDepth(TDepth&& value);
        TDepth& SetDepth(void);
    
        /// optional
        /// typedef EAttlist_dir TDir
        ///  Check whether the Dir data member has been assigned a value.
        bool IsSetDir(void) const;
        /// Check whether it is safe or not to call GetDir method.
        bool CanGetDir(void) const;
        void ResetDir(void);
        TDir GetDir(void) const;
        void SetDir(TDir value);
        TDir& SetDir(void);
    
        /// optional
        /// typedef EAttlist_edge TEdge
        ///  Check whether the Edge data member has been assigned a value.
        bool IsSetEdge(void) const;
        /// Check whether it is safe or not to call GetEdge method.
        bool CanGetEdge(void) const;
        void ResetEdge(void);
        TEdge GetEdge(void) const;
        void SetEdge(TEdge value);
        TEdge& SetEdge(void);
    
        /// optional
        /// typedef EAttlist_equalcolumns TEqualcolumns
        ///  Check whether the Equalcolumns data member has been assigned a value.
        bool IsSetEqualcolumns(void) const;
        /// Check whether it is safe or not to call GetEqualcolumns method.
        bool CanGetEqualcolumns(void) const;
        void ResetEqualcolumns(void);
        TEqualcolumns GetEqualcolumns(void) const;
        void SetEqualcolumns(TEqualcolumns value);
        TEqualcolumns& SetEqualcolumns(void);
    
        /// optional
        /// typedef EAttlist_equalrows TEqualrows
        ///  Check whether the Equalrows data member has been assigned a value.
        bool IsSetEqualrows(void) const;
        /// Check whether it is safe or not to call GetEqualrows method.
        bool CanGetEqualrows(void) const;
        void ResetEqualrows(void);
        TEqualrows GetEqualrows(void) const;
        void SetEqualrows(TEqualrows value);
        TEqualrows& SetEqualrows(void);
    
        /// optional
        /// typedef EAttlist_fence TFence
        ///  Check whether the Fence data member has been assigned a value.
        bool IsSetFence(void) const;
        /// Check whether it is safe or not to call GetFence method.
        bool CanGetFence(void) const;
        void ResetFence(void);
        TFence GetFence(void) const;
        void SetFence(TFence value);
        TFence& SetFence(void);
    
        /// optional
        /// typedef EAttlist_form TForm
        ///  Check whether the Form data member has been assigned a value.
        bool IsSetForm(void) const;
        /// Check whether it is safe or not to call GetForm method.
        bool CanGetForm(void) const;
        void ResetForm(void);
        TForm GetForm(void) const;
        void SetForm(TForm value);
        TForm& SetForm(void);
    
        /// optional
        /// typedef EAttlist_frame TFrame
        ///  Check whether the Frame data member has been assigned a value.
        bool IsSetFrame(void) const;
        /// Check whether it is safe or not to call GetFrame method.
        bool CanGetFrame(void) const;
        void ResetFrame(void);
        TFrame GetFrame(void) const;
        void SetFrame(TFrame value);
        TFrame& SetFrame(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TFramespacing
        ///  Check whether the Framespacing data member has been assigned a value.
        bool IsSetFramespacing(void) const;
        /// Check whether it is safe or not to call GetFramespacing method.
        bool CanGetFramespacing(void) const;
        void ResetFramespacing(void);
        const TFramespacing& GetFramespacing(void) const;
        void SetFramespacing(const TFramespacing& value);
        void SetFramespacing(TFramespacing&& value);
        TFramespacing& SetFramespacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TGroupalign
        ///  Check whether the Groupalign data member has been assigned a value.
        bool IsSetGroupalign(void) const;
        /// Check whether it is safe or not to call GetGroupalign method.
        bool CanGetGroupalign(void) const;
        void ResetGroupalign(void);
        const TGroupalign& GetGroupalign(void) const;
        void SetGroupalign(const TGroupalign& value);
        void SetGroupalign(TGroupalign&& value);
        TGroupalign& SetGroupalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THeight
        ///  Check whether the Height data member has been assigned a value.
        bool IsSetHeight(void) const;
        /// Check whether it is safe or not to call GetHeight method.
        bool CanGetHeight(void) const;
        void ResetHeight(void);
        const THeight& GetHeight(void) const;
        void SetHeight(const THeight& value);
        void SetHeight(THeight&& value);
        THeight& SetHeight(void);
    
        /// optional
        /// typedef EAttlist_indentalign TIndentalign
        ///  Check whether the Indentalign data member has been assigned a value.
        bool IsSetIndentalign(void) const;
        /// Check whether it is safe or not to call GetIndentalign method.
        bool CanGetIndentalign(void) const;
        void ResetIndentalign(void);
        TIndentalign GetIndentalign(void) const;
        void SetIndentalign(TIndentalign value);
        TIndentalign& SetIndentalign(void);
    
        /// optional
        /// typedef EAttlist_indentalignfirst TIndentalignfirst
        ///  Check whether the Indentalignfirst data member has been assigned a value.
        bool IsSetIndentalignfirst(void) const;
        /// Check whether it is safe or not to call GetIndentalignfirst method.
        bool CanGetIndentalignfirst(void) const;
        void ResetIndentalignfirst(void);
        TIndentalignfirst GetIndentalignfirst(void) const;
        void SetIndentalignfirst(TIndentalignfirst value);
        TIndentalignfirst& SetIndentalignfirst(void);
    
        /// optional
        /// typedef EAttlist_indentalignlast TIndentalignlast
        ///  Check whether the Indentalignlast data member has been assigned a value.
        bool IsSetIndentalignlast(void) const;
        /// Check whether it is safe or not to call GetIndentalignlast method.
        bool CanGetIndentalignlast(void) const;
        void ResetIndentalignlast(void);
        TIndentalignlast GetIndentalignlast(void) const;
        void SetIndentalignlast(TIndentalignlast value);
        TIndentalignlast& SetIndentalignlast(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshift
        ///  Check whether the Indentshift data member has been assigned a value.
        bool IsSetIndentshift(void) const;
        /// Check whether it is safe or not to call GetIndentshift method.
        bool CanGetIndentshift(void) const;
        void ResetIndentshift(void);
        const TIndentshift& GetIndentshift(void) const;
        void SetIndentshift(const TIndentshift& value);
        void SetIndentshift(TIndentshift&& value);
        TIndentshift& SetIndentshift(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshiftfirst
        ///  Check whether the Indentshiftfirst data member has been assigned a value.
        bool IsSetIndentshiftfirst(void) const;
        /// Check whether it is safe or not to call GetIndentshiftfirst method.
        bool CanGetIndentshiftfirst(void) const;
        void ResetIndentshiftfirst(void);
        const TIndentshiftfirst& GetIndentshiftfirst(void) const;
        void SetIndentshiftfirst(const TIndentshiftfirst& value);
        void SetIndentshiftfirst(TIndentshiftfirst&& value);
        TIndentshiftfirst& SetIndentshiftfirst(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndentshiftlast
        ///  Check whether the Indentshiftlast data member has been assigned a value.
        bool IsSetIndentshiftlast(void) const;
        /// Check whether it is safe or not to call GetIndentshiftlast method.
        bool CanGetIndentshiftlast(void) const;
        void ResetIndentshiftlast(void);
        const TIndentshiftlast& GetIndentshiftlast(void) const;
        void SetIndentshiftlast(const TIndentshiftlast& value);
        void SetIndentshiftlast(TIndentshiftlast&& value);
        TIndentshiftlast& SetIndentshiftlast(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TIndenttarget
        ///  Check whether the Indenttarget data member has been assigned a value.
        bool IsSetIndenttarget(void) const;
        /// Check whether it is safe or not to call GetIndenttarget method.
        bool CanGetIndenttarget(void) const;
        void ResetIndenttarget(void);
        const TIndenttarget& GetIndenttarget(void) const;
        void SetIndenttarget(const TIndenttarget& value);
        void SetIndenttarget(TIndenttarget&& value);
        TIndenttarget& SetIndenttarget(void);
    
        /// optional
        /// typedef EAttlist_largeop TLargeop
        ///  Check whether the Largeop data member has been assigned a value.
        bool IsSetLargeop(void) const;
        /// Check whether it is safe or not to call GetLargeop method.
        bool CanGetLargeop(void) const;
        void ResetLargeop(void);
        TLargeop GetLargeop(void) const;
        void SetLargeop(TLargeop value);
        TLargeop& SetLargeop(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLeftoverhang
        ///  Check whether the Leftoverhang data member has been assigned a value.
        bool IsSetLeftoverhang(void) const;
        /// Check whether it is safe or not to call GetLeftoverhang method.
        bool CanGetLeftoverhang(void) const;
        void ResetLeftoverhang(void);
        const TLeftoverhang& GetLeftoverhang(void) const;
        void SetLeftoverhang(const TLeftoverhang& value);
        void SetLeftoverhang(TLeftoverhang&& value);
        TLeftoverhang& SetLeftoverhang(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLength
        ///  Check whether the Length data member has been assigned a value.
        bool IsSetLength(void) const;
        /// Check whether it is safe or not to call GetLength method.
        bool CanGetLength(void) const;
        void ResetLength(void);
        const TLength& GetLength(void) const;
        void SetLength(const TLength& value);
        void SetLength(TLength&& value);
        TLength& SetLength(void);
    
        /// optional
        /// typedef EAttlist_linebreak TLinebreak
        ///  Check whether the Linebreak data member has been assigned a value.
        bool IsSetLinebreak(void) const;
        /// Check whether it is safe or not to call GetLinebreak method.
        bool CanGetLinebreak(void) const;
        void ResetLinebreak(void);
        TLinebreak GetLinebreak(void) const;
        void SetLinebreak(TLinebreak value);
        TLinebreak& SetLinebreak(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLinebreakmultchar
        ///  Check whether the Linebreakmultchar data member has been assigned a value.
        bool IsSetLinebreakmultchar(void) const;
        /// Check whether it is safe or not to call GetLinebreakmultchar method.
        bool CanGetLinebreakmultchar(void) const;
        void ResetLinebreakmultchar(void);
        const TLinebreakmultchar& GetLinebreakmultchar(void) const;
        void SetLinebreakmultchar(const TLinebreakmultchar& value);
        void SetLinebreakmultchar(TLinebreakmultchar&& value);
        TLinebreakmultchar& SetLinebreakmultchar(void);
    
        /// optional
        /// typedef EAttlist_linebreakstyle TLinebreakstyle
        ///  Check whether the Linebreakstyle data member has been assigned a value.
        bool IsSetLinebreakstyle(void) const;
        /// Check whether it is safe or not to call GetLinebreakstyle method.
        bool CanGetLinebreakstyle(void) const;
        void ResetLinebreakstyle(void);
        TLinebreakstyle GetLinebreakstyle(void) const;
        void SetLinebreakstyle(TLinebreakstyle value);
        TLinebreakstyle& SetLinebreakstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLineleading
        ///  Check whether the Lineleading data member has been assigned a value.
        bool IsSetLineleading(void) const;
        /// Check whether it is safe or not to call GetLineleading method.
        bool CanGetLineleading(void) const;
        void ResetLineleading(void);
        const TLineleading& GetLineleading(void) const;
        void SetLineleading(const TLineleading& value);
        void SetLineleading(TLineleading&& value);
        TLineleading& SetLineleading(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLinethickness
        ///  Check whether the Linethickness data member has been assigned a value.
        bool IsSetLinethickness(void) const;
        /// Check whether it is safe or not to call GetLinethickness method.
        bool CanGetLinethickness(void) const;
        void ResetLinethickness(void);
        const TLinethickness& GetLinethickness(void) const;
        void SetLinethickness(const TLinethickness& value);
        void SetLinethickness(TLinethickness&& value);
        TLinethickness& SetLinethickness(void);
    
        /// optional
        /// typedef EAttlist_location TLocation
        ///  Check whether the Location data member has been assigned a value.
        bool IsSetLocation(void) const;
        /// Check whether it is safe or not to call GetLocation method.
        bool CanGetLocation(void) const;
        void ResetLocation(void);
        TLocation GetLocation(void) const;
        void SetLocation(TLocation value);
        TLocation& SetLocation(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLongdivstyle
        ///  Check whether the Longdivstyle data member has been assigned a value.
        bool IsSetLongdivstyle(void) const;
        /// Check whether it is safe or not to call GetLongdivstyle method.
        bool CanGetLongdivstyle(void) const;
        void ResetLongdivstyle(void);
        const TLongdivstyle& GetLongdivstyle(void) const;
        void SetLongdivstyle(const TLongdivstyle& value);
        void SetLongdivstyle(TLongdivstyle&& value);
        TLongdivstyle& SetLongdivstyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLquote
        ///  Check whether the Lquote data member has been assigned a value.
        bool IsSetLquote(void) const;
        /// Check whether it is safe or not to call GetLquote method.
        bool CanGetLquote(void) const;
        void ResetLquote(void);
        const TLquote& GetLquote(void) const;
        void SetLquote(const TLquote& value);
        void SetLquote(TLquote&& value);
        TLquote& SetLquote(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLspace
        ///  Check whether the Lspace data member has been assigned a value.
        bool IsSetLspace(void) const;
        /// Check whether it is safe or not to call GetLspace method.
        bool CanGetLspace(void) const;
        void ResetLspace(void);
        const TLspace& GetLspace(void) const;
        void SetLspace(const TLspace& value);
        void SetLspace(TLspace&& value);
        TLspace& SetLspace(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathsize
        ///  Check whether the Mathsize data member has been assigned a value.
        bool IsSetMathsize(void) const;
        /// Check whether it is safe or not to call GetMathsize method.
        bool CanGetMathsize(void) const;
        void ResetMathsize(void);
        const TMathsize& GetMathsize(void) const;
        void SetMathsize(const TMathsize& value);
        void SetMathsize(TMathsize&& value);
        TMathsize& SetMathsize(void);
    
        /// optional
        /// typedef EAttlist_mathvariant TMathvariant
        ///  Check whether the Mathvariant data member has been assigned a value.
        bool IsSetMathvariant(void) const;
        /// Check whether it is safe or not to call GetMathvariant method.
        bool CanGetMathvariant(void) const;
        void ResetMathvariant(void);
        TMathvariant GetMathvariant(void) const;
        void SetMathvariant(TMathvariant value);
        TMathvariant& SetMathvariant(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMaxsize
        ///  Check whether the Maxsize data member has been assigned a value.
        bool IsSetMaxsize(void) const;
        /// Check whether it is safe or not to call GetMaxsize method.
        bool CanGetMaxsize(void) const;
        void ResetMaxsize(void);
        const TMaxsize& GetMaxsize(void) const;
        void SetMaxsize(const TMaxsize& value);
        void SetMaxsize(TMaxsize&& value);
        TMaxsize& SetMaxsize(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMinlabelspacing
        ///  Check whether the Minlabelspacing data member has been assigned a value.
        bool IsSetMinlabelspacing(void) const;
        /// Check whether it is safe or not to call GetMinlabelspacing method.
        bool CanGetMinlabelspacing(void) const;
        void ResetMinlabelspacing(void);
        const TMinlabelspacing& GetMinlabelspacing(void) const;
        void SetMinlabelspacing(const TMinlabelspacing& value);
        void SetMinlabelspacing(TMinlabelspacing&& value);
        TMinlabelspacing& SetMinlabelspacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMinsize
        ///  Check whether the Minsize data member has been assigned a value.
        bool IsSetMinsize(void) const;
        /// Check whether it is safe or not to call GetMinsize method.
        bool CanGetMinsize(void) const;
        void ResetMinsize(void);
        const TMinsize& GetMinsize(void) const;
        void SetMinsize(const TMinsize& value);
        void SetMinsize(TMinsize&& value);
        TMinsize& SetMinsize(void);
    
        /// optional
        /// typedef EAttlist_movablelimits TMovablelimits
        ///  Check whether the Movablelimits data member has been assigned a value.
        bool IsSetMovablelimits(void) const;
        /// Check whether it is safe or not to call GetMovablelimits method.
        bool CanGetMovablelimits(void) const;
        void ResetMovablelimits(void);
        TMovablelimits GetMovablelimits(void) const;
        void SetMovablelimits(TMovablelimits value);
        TMovablelimits& SetMovablelimits(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMslinethickness
        ///  Check whether the Mslinethickness data member has been assigned a value.
        bool IsSetMslinethickness(void) const;
        /// Check whether it is safe or not to call GetMslinethickness method.
        bool CanGetMslinethickness(void) const;
        void ResetMslinethickness(void);
        const TMslinethickness& GetMslinethickness(void) const;
        void SetMslinethickness(const TMslinethickness& value);
        void SetMslinethickness(TMslinethickness&& value);
        TMslinethickness& SetMslinethickness(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TNotation
        ///  Check whether the Notation data member has been assigned a value.
        bool IsSetNotation(void) const;
        /// Check whether it is safe or not to call GetNotation method.
        bool CanGetNotation(void) const;
        void ResetNotation(void);
        const TNotation& GetNotation(void) const;
        void SetNotation(const TNotation& value);
        void SetNotation(TNotation&& value);
        TNotation& SetNotation(void);
    
        /// optional
        /// typedef EAttlist_numalign TNumalign
        ///  Check whether the Numalign data member has been assigned a value.
        bool IsSetNumalign(void) const;
        /// Check whether it is safe or not to call GetNumalign method.
        bool CanGetNumalign(void) const;
        void ResetNumalign(void);
        TNumalign GetNumalign(void) const;
        void SetNumalign(TNumalign value);
        TNumalign& SetNumalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TOpen
        ///  Check whether the Open data member has been assigned a value.
        bool IsSetOpen(void) const;
        /// Check whether it is safe or not to call GetOpen method.
        bool CanGetOpen(void) const;
        void ResetOpen(void);
        const TOpen& GetOpen(void) const;
        void SetOpen(const TOpen& value);
        void SetOpen(TOpen&& value);
        TOpen& SetOpen(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TPosition
        ///  Check whether the Position data member has been assigned a value.
        bool IsSetPosition(void) const;
        /// Check whether it is safe or not to call GetPosition method.
        bool CanGetPosition(void) const;
        void ResetPosition(void);
        const TPosition& GetPosition(void) const;
        void SetPosition(const TPosition& value);
        void SetPosition(TPosition&& value);
        TPosition& SetPosition(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRightoverhang
        ///  Check whether the Rightoverhang data member has been assigned a value.
        bool IsSetRightoverhang(void) const;
        /// Check whether it is safe or not to call GetRightoverhang method.
        bool CanGetRightoverhang(void) const;
        void ResetRightoverhang(void);
        const TRightoverhang& GetRightoverhang(void) const;
        void SetRightoverhang(const TRightoverhang& value);
        void SetRightoverhang(TRightoverhang&& value);
        TRightoverhang& SetRightoverhang(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowalign
        ///  Check whether the Rowalign data member has been assigned a value.
        bool IsSetRowalign(void) const;
        /// Check whether it is safe or not to call GetRowalign method.
        bool CanGetRowalign(void) const;
        void ResetRowalign(void);
        const TRowalign& GetRowalign(void) const;
        void SetRowalign(const TRowalign& value);
        void SetRowalign(TRowalign&& value);
        TRowalign& SetRowalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowlines
        ///  Check whether the Rowlines data member has been assigned a value.
        bool IsSetRowlines(void) const;
        /// Check whether it is safe or not to call GetRowlines method.
        bool CanGetRowlines(void) const;
        void ResetRowlines(void);
        const TRowlines& GetRowlines(void) const;
        void SetRowlines(const TRowlines& value);
        void SetRowlines(TRowlines&& value);
        TRowlines& SetRowlines(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowspacing
        ///  Check whether the Rowspacing data member has been assigned a value.
        bool IsSetRowspacing(void) const;
        /// Check whether it is safe or not to call GetRowspacing method.
        bool CanGetRowspacing(void) const;
        void ResetRowspacing(void);
        const TRowspacing& GetRowspacing(void) const;
        void SetRowspacing(const TRowspacing& value);
        void SetRowspacing(TRowspacing&& value);
        TRowspacing& SetRowspacing(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRowspan
        ///  Check whether the Rowspan data member has been assigned a value.
        bool IsSetRowspan(void) const;
        /// Check whether it is safe or not to call GetRowspan method.
        bool CanGetRowspan(void) const;
        void ResetRowspan(void);
        const TRowspan& GetRowspan(void) const;
        void SetRowspan(const TRowspan& value);
        void SetRowspan(TRowspan&& value);
        TRowspan& SetRowspan(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRquote
        ///  Check whether the Rquote data member has been assigned a value.
        bool IsSetRquote(void) const;
        /// Check whether it is safe or not to call GetRquote method.
        bool CanGetRquote(void) const;
        void ResetRquote(void);
        const TRquote& GetRquote(void) const;
        void SetRquote(const TRquote& value);
        void SetRquote(TRquote&& value);
        TRquote& SetRquote(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TRspace
        ///  Check whether the Rspace data member has been assigned a value.
        bool IsSetRspace(void) const;
        /// Check whether it is safe or not to call GetRspace method.
        bool CanGetRspace(void) const;
        void ResetRspace(void);
        const TRspace& GetRspace(void) const;
        void SetRspace(const TRspace& value);
        void SetRspace(TRspace&& value);
        TRspace& SetRspace(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSelection
        ///  Check whether the Selection data member has been assigned a value.
        bool IsSetSelection(void) const;
        /// Check whether it is safe or not to call GetSelection method.
        bool CanGetSelection(void) const;
        void ResetSelection(void);
        const TSelection& GetSelection(void) const;
        void SetSelection(const TSelection& value);
        void SetSelection(TSelection&& value);
        TSelection& SetSelection(void);
    
        /// optional
        /// typedef EAttlist_separator TSeparator
        ///  Check whether the Separator data member has been assigned a value.
        bool IsSetSeparator(void) const;
        /// Check whether it is safe or not to call GetSeparator method.
        bool CanGetSeparator(void) const;
        void ResetSeparator(void);
        TSeparator GetSeparator(void) const;
        void SetSeparator(TSeparator value);
        TSeparator& SetSeparator(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSeparators
        ///  Check whether the Separators data member has been assigned a value.
        bool IsSetSeparators(void) const;
        /// Check whether it is safe or not to call GetSeparators method.
        bool CanGetSeparators(void) const;
        void ResetSeparators(void);
        const TSeparators& GetSeparators(void) const;
        void SetSeparators(const TSeparators& value);
        void SetSeparators(TSeparators&& value);
        TSeparators& SetSeparators(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TShift
        ///  Check whether the Shift data member has been assigned a value.
        bool IsSetShift(void) const;
        /// Check whether it is safe or not to call GetShift method.
        bool CanGetShift(void) const;
        void ResetShift(void);
        const TShift& GetShift(void) const;
        void SetShift(const TShift& value);
        void SetShift(TShift&& value);
        TShift& SetShift(void);
    
        /// optional
        /// typedef EAttlist_side TSide
        ///  Check whether the Side data member has been assigned a value.
        bool IsSetSide(void) const;
        /// Check whether it is safe or not to call GetSide method.
        bool CanGetSide(void) const;
        void ResetSide(void);
        TSide GetSide(void) const;
        void SetSide(TSide value);
        TSide& SetSide(void);
    
        /// optional
        /// typedef EAttlist_stackalign TStackalign
        ///  Check whether the Stackalign data member has been assigned a value.
        bool IsSetStackalign(void) const;
        /// Check whether it is safe or not to call GetStackalign method.
        bool CanGetStackalign(void) const;
        void ResetStackalign(void);
        TStackalign GetStackalign(void) const;
        void SetStackalign(TStackalign value);
        TStackalign& SetStackalign(void);
    
        /// optional
        /// typedef EAttlist_stretchy TStretchy
        ///  Check whether the Stretchy data member has been assigned a value.
        bool IsSetStretchy(void) const;
        /// Check whether it is safe or not to call GetStretchy method.
        bool CanGetStretchy(void) const;
        void ResetStretchy(void);
        TStretchy GetStretchy(void) const;
        void SetStretchy(TStretchy value);
        TStretchy& SetStretchy(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSubscriptshift
        ///  Check whether the Subscriptshift data member has been assigned a value.
        bool IsSetSubscriptshift(void) const;
        /// Check whether it is safe or not to call GetSubscriptshift method.
        bool CanGetSubscriptshift(void) const;
        void ResetSubscriptshift(void);
        const TSubscriptshift& GetSubscriptshift(void) const;
        void SetSubscriptshift(const TSubscriptshift& value);
        void SetSubscriptshift(TSubscriptshift&& value);
        TSubscriptshift& SetSubscriptshift(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TSuperscriptshift
        ///  Check whether the Superscriptshift data member has been assigned a value.
        bool IsSetSuperscriptshift(void) const;
        /// Check whether it is safe or not to call GetSuperscriptshift method.
        bool CanGetSuperscriptshift(void) const;
        void ResetSuperscriptshift(void);
        const TSuperscriptshift& GetSuperscriptshift(void) const;
        void SetSuperscriptshift(const TSuperscriptshift& value);
        void SetSuperscriptshift(TSuperscriptshift&& value);
        TSuperscriptshift& SetSuperscriptshift(void);
    
        /// optional
        /// typedef EAttlist_symmetric TSymmetric
        ///  Check whether the Symmetric data member has been assigned a value.
        bool IsSetSymmetric(void) const;
        /// Check whether it is safe or not to call GetSymmetric method.
        bool CanGetSymmetric(void) const;
        void ResetSymmetric(void);
        TSymmetric GetSymmetric(void) const;
        void SetSymmetric(TSymmetric value);
        TSymmetric& SetSymmetric(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TValign
        ///  Check whether the Valign data member has been assigned a value.
        bool IsSetValign(void) const;
        /// Check whether it is safe or not to call GetValign method.
        bool CanGetValign(void) const;
        void ResetValign(void);
        const TValign& GetValign(void) const;
        void SetValign(const TValign& value);
        void SetValign(TValign&& value);
        TValign& SetValign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TWidth
        ///  Check whether the Width data member has been assigned a value.
        bool IsSetWidth(void) const;
        /// Check whether it is safe or not to call GetWidth method.
        bool CanGetWidth(void) const;
        void ResetWidth(void);
        const TWidth& GetWidth(void) const;
        void SetWidth(const TWidth& value);
        void SetWidth(TWidth&& value);
        TWidth& SetWidth(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[7];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        EAttlist_display m_Display;
        NCBI_NS_STD::string m_Maxwidth;
        EAttlist_overflow m_Overflow;
        NCBI_NS_STD::string m_Altimg;
        NCBI_NS_STD::string m_Altimg_width;
        NCBI_NS_STD::string m_Altimg_height;
        NCBI_NS_STD::string m_Altimg_valign;
        NCBI_NS_STD::string m_Alttext;
        NCBI_NS_STD::string m_Cdgroup;
        NCBI_NS_STD::string m_Mode;
        NCBI_NS_STD::string m_Macros;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Scriptlevel;
        EAttlist_displaystyle m_Displaystyle;
        NCBI_NS_STD::string m_Scriptsizemultiplier;
        NCBI_NS_STD::string m_Scriptminsize;
        EAttlist_infixlinebreakstyle m_Infixlinebreakstyle;
        NCBI_NS_STD::string m_Decimalpoint;
        EAttlist_accent m_Accent;
        EAttlist_accentunder m_Accentunder;
        EAttlist_align m_Align;
        NCBI_NS_STD::string m_Alignmentscope;
        EAttlist_bevelled m_Bevelled;
        EAttlist_charalign m_Charalign;
        NCBI_NS_STD::string m_Charspacing;
        NCBI_NS_STD::string m_Close;
        NCBI_NS_STD::string m_Columnalign;
        NCBI_NS_STD::string m_Columnlines;
        NCBI_NS_STD::string m_Columnspacing;
        NCBI_NS_STD::string m_Columnspan;
        NCBI_NS_STD::string m_Columnwidth;
        NCBI_NS_STD::string m_Crossout;
        EAttlist_denomalign m_Denomalign;
        NCBI_NS_STD::string m_Depth;
        EAttlist_dir m_Dir;
        EAttlist_edge m_Edge;
        EAttlist_equalcolumns m_Equalcolumns;
        EAttlist_equalrows m_Equalrows;
        EAttlist_fence m_Fence;
        EAttlist_form m_Form;
        EAttlist_frame m_Frame;
        NCBI_NS_STD::string m_Framespacing;
        NCBI_NS_STD::string m_Groupalign;
        NCBI_NS_STD::string m_Height;
        EAttlist_indentalign m_Indentalign;
        EAttlist_indentalignfirst m_Indentalignfirst;
        EAttlist_indentalignlast m_Indentalignlast;
        NCBI_NS_STD::string m_Indentshift;
        NCBI_NS_STD::string m_Indentshiftfirst;
        NCBI_NS_STD::string m_Indentshiftlast;
        NCBI_NS_STD::string m_Indenttarget;
        EAttlist_largeop m_Largeop;
        NCBI_NS_STD::string m_Leftoverhang;
        NCBI_NS_STD::string m_Length;
        EAttlist_linebreak m_Linebreak;
        NCBI_NS_STD::string m_Linebreakmultchar;
        EAttlist_linebreakstyle m_Linebreakstyle;
        NCBI_NS_STD::string m_Lineleading;
        NCBI_NS_STD::string m_Linethickness;
        EAttlist_location m_Location;
        NCBI_NS_STD::string m_Longdivstyle;
        NCBI_NS_STD::string m_Lquote;
        NCBI_NS_STD::string m_Lspace;
        NCBI_NS_STD::string m_Mathsize;
        EAttlist_mathvariant m_Mathvariant;
        NCBI_NS_STD::string m_Maxsize;
        NCBI_NS_STD::string m_Minlabelspacing;
        NCBI_NS_STD::string m_Minsize;
        EAttlist_movablelimits m_Movablelimits;
        NCBI_NS_STD::string m_Mslinethickness;
        NCBI_NS_STD::string m_Notation;
        EAttlist_numalign m_Numalign;
        NCBI_NS_STD::string m_Open;
        NCBI_NS_STD::string m_Position;
        NCBI_NS_STD::string m_Rightoverhang;
        NCBI_NS_STD::string m_Rowalign;
        NCBI_NS_STD::string m_Rowlines;
        NCBI_NS_STD::string m_Rowspacing;
        NCBI_NS_STD::string m_Rowspan;
        NCBI_NS_STD::string m_Rquote;
        NCBI_NS_STD::string m_Rspace;
        NCBI_NS_STD::string m_Selection;
        EAttlist_separator m_Separator;
        NCBI_NS_STD::string m_Separators;
        NCBI_NS_STD::string m_Shift;
        EAttlist_side m_Side;
        EAttlist_stackalign m_Stackalign;
        EAttlist_stretchy m_Stretchy;
        NCBI_NS_STD::string m_Subscriptshift;
        NCBI_NS_STD::string m_Superscriptshift;
        EAttlist_symmetric m_Symmetric;
        NCBI_NS_STD::string m_Valign;
        NCBI_NS_STD::string m_Width;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_MathExpression : public CMathExpression
    {
        typedef CMathExpression Tparent;
    public:
        C_E_MathExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > TMathExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MathExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > TMathExpression
    ///  Check whether the MathExpression data member has been assigned a value.
    bool IsSetMathExpression(void) const;
    /// Check whether it is safe or not to call GetMathExpression method.
    bool CanGetMathExpression(void) const;
    void ResetMathExpression(void);
    const TMathExpression& GetMathExpression(void) const;
    TMathExpression& SetMathExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMath_Base(const CMath_Base&);
    CMath_Base& operator=(const CMath_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MathExpression > > m_MathExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMath_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMath_Base::C_Attlist::TId& CMath_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMath_Base::C_Attlist::SetId(const CMath_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMath_Base::C_Attlist::SetId(CMath_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMath_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMath_Base::C_Attlist::TId& CMath_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMath_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMath_Base::C_Attlist::TXref& CMath_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMath_Base::C_Attlist::SetXref(const CMath_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMath_Base::C_Attlist::SetXref(CMath_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMath_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMath_Base::C_Attlist::TXref& CMath_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMath_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMath_Base::C_Attlist::TClass& CMath_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMath_Base::C_Attlist::SetClass(const CMath_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMath_Base::C_Attlist::SetClass(CMath_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMath_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMath_Base::C_Attlist::TClass& CMath_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMath_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMath_Base::C_Attlist::TStyle& CMath_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMath_Base::C_Attlist::SetStyle(const CMath_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMath_Base::C_Attlist::SetStyle(CMath_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMath_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMath_Base::C_Attlist::TStyle& CMath_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMath_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMath_Base::C_Attlist::THref& CMath_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMath_Base::C_Attlist::SetHref(const CMath_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMath_Base::C_Attlist::SetHref(CMath_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMath_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMath_Base::C_Attlist::THref& CMath_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMath_Base::C_Attlist::IsSetDisplay(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetDisplay(void) const
{
    return IsSetDisplay();
}

inline
void CMath_Base::C_Attlist::ResetDisplay(void)
{
    m_Display = (EAttlist_display)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CMath_Base::C_Attlist::TDisplay CMath_Base::C_Attlist::GetDisplay(void) const
{
    if (!CanGetDisplay()) {
        ThrowUnassigned(5);
    }
    return m_Display;
}

inline
void CMath_Base::C_Attlist::SetDisplay(CMath_Base::C_Attlist::TDisplay value)
{
    m_Display = value;
    m_set_State[0] |= 0xc00;
}

inline
CMath_Base::C_Attlist::TDisplay& CMath_Base::C_Attlist::SetDisplay(void)
{
#ifdef _DEBUG
    if (!IsSetDisplay()) {
        memset(&m_Display,UnassignedByte(),sizeof(m_Display));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Display;
}

inline
bool CMath_Base::C_Attlist::IsSetMaxwidth(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMaxwidth(void) const
{
    return IsSetMaxwidth();
}

inline
const CMath_Base::C_Attlist::TMaxwidth& CMath_Base::C_Attlist::GetMaxwidth(void) const
{
    if (!CanGetMaxwidth()) {
        ThrowUnassigned(6);
    }
    return m_Maxwidth;
}

inline
void CMath_Base::C_Attlist::SetMaxwidth(const CMath_Base::C_Attlist::TMaxwidth& value)
{
    m_Maxwidth = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMath_Base::C_Attlist::SetMaxwidth(CMath_Base::C_Attlist::TMaxwidth&& value)
{
    m_Maxwidth = std::forward<CMath_Base::C_Attlist::TMaxwidth>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMath_Base::C_Attlist::TMaxwidth& CMath_Base::C_Attlist::SetMaxwidth(void)
{
#ifdef _DEBUG
    if (!IsSetMaxwidth()) {
        m_Maxwidth = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Maxwidth;
}

inline
bool CMath_Base::C_Attlist::IsSetOverflow(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetOverflow(void) const
{
    return IsSetOverflow();
}

inline
void CMath_Base::C_Attlist::ResetOverflow(void)
{
    m_Overflow = (EAttlist_overflow)(0);
    m_set_State[0] &= ~0xc000;
}

inline
CMath_Base::C_Attlist::TOverflow CMath_Base::C_Attlist::GetOverflow(void) const
{
    if (!CanGetOverflow()) {
        ThrowUnassigned(7);
    }
    return m_Overflow;
}

inline
void CMath_Base::C_Attlist::SetOverflow(CMath_Base::C_Attlist::TOverflow value)
{
    m_Overflow = value;
    m_set_State[0] |= 0xc000;
}

inline
CMath_Base::C_Attlist::TOverflow& CMath_Base::C_Attlist::SetOverflow(void)
{
#ifdef _DEBUG
    if (!IsSetOverflow()) {
        memset(&m_Overflow,UnassignedByte(),sizeof(m_Overflow));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Overflow;
}

inline
bool CMath_Base::C_Attlist::IsSetAltimg(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAltimg(void) const
{
    return IsSetAltimg();
}

inline
const CMath_Base::C_Attlist::TAltimg& CMath_Base::C_Attlist::GetAltimg(void) const
{
    if (!CanGetAltimg()) {
        ThrowUnassigned(8);
    }
    return m_Altimg;
}

inline
void CMath_Base::C_Attlist::SetAltimg(const CMath_Base::C_Attlist::TAltimg& value)
{
    m_Altimg = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMath_Base::C_Attlist::SetAltimg(CMath_Base::C_Attlist::TAltimg&& value)
{
    m_Altimg = std::forward<CMath_Base::C_Attlist::TAltimg>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMath_Base::C_Attlist::TAltimg& CMath_Base::C_Attlist::SetAltimg(void)
{
#ifdef _DEBUG
    if (!IsSetAltimg()) {
        m_Altimg = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Altimg;
}

inline
bool CMath_Base::C_Attlist::IsSetAltimg_width(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAltimg_width(void) const
{
    return IsSetAltimg_width();
}

inline
const CMath_Base::C_Attlist::TAltimg_width& CMath_Base::C_Attlist::GetAltimg_width(void) const
{
    if (!CanGetAltimg_width()) {
        ThrowUnassigned(9);
    }
    return m_Altimg_width;
}

inline
void CMath_Base::C_Attlist::SetAltimg_width(const CMath_Base::C_Attlist::TAltimg_width& value)
{
    m_Altimg_width = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMath_Base::C_Attlist::SetAltimg_width(CMath_Base::C_Attlist::TAltimg_width&& value)
{
    m_Altimg_width = std::forward<CMath_Base::C_Attlist::TAltimg_width>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMath_Base::C_Attlist::TAltimg_width& CMath_Base::C_Attlist::SetAltimg_width(void)
{
#ifdef _DEBUG
    if (!IsSetAltimg_width()) {
        m_Altimg_width = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Altimg_width;
}

inline
bool CMath_Base::C_Attlist::IsSetAltimg_height(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAltimg_height(void) const
{
    return IsSetAltimg_height();
}

inline
const CMath_Base::C_Attlist::TAltimg_height& CMath_Base::C_Attlist::GetAltimg_height(void) const
{
    if (!CanGetAltimg_height()) {
        ThrowUnassigned(10);
    }
    return m_Altimg_height;
}

inline
void CMath_Base::C_Attlist::SetAltimg_height(const CMath_Base::C_Attlist::TAltimg_height& value)
{
    m_Altimg_height = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMath_Base::C_Attlist::SetAltimg_height(CMath_Base::C_Attlist::TAltimg_height&& value)
{
    m_Altimg_height = std::forward<CMath_Base::C_Attlist::TAltimg_height>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMath_Base::C_Attlist::TAltimg_height& CMath_Base::C_Attlist::SetAltimg_height(void)
{
#ifdef _DEBUG
    if (!IsSetAltimg_height()) {
        m_Altimg_height = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Altimg_height;
}

inline
bool CMath_Base::C_Attlist::IsSetAltimg_valign(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAltimg_valign(void) const
{
    return IsSetAltimg_valign();
}

inline
const CMath_Base::C_Attlist::TAltimg_valign& CMath_Base::C_Attlist::GetAltimg_valign(void) const
{
    if (!CanGetAltimg_valign()) {
        ThrowUnassigned(11);
    }
    return m_Altimg_valign;
}

inline
void CMath_Base::C_Attlist::SetAltimg_valign(const CMath_Base::C_Attlist::TAltimg_valign& value)
{
    m_Altimg_valign = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMath_Base::C_Attlist::SetAltimg_valign(CMath_Base::C_Attlist::TAltimg_valign&& value)
{
    m_Altimg_valign = std::forward<CMath_Base::C_Attlist::TAltimg_valign>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMath_Base::C_Attlist::TAltimg_valign& CMath_Base::C_Attlist::SetAltimg_valign(void)
{
#ifdef _DEBUG
    if (!IsSetAltimg_valign()) {
        m_Altimg_valign = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Altimg_valign;
}

inline
bool CMath_Base::C_Attlist::IsSetAlttext(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAlttext(void) const
{
    return IsSetAlttext();
}

inline
const CMath_Base::C_Attlist::TAlttext& CMath_Base::C_Attlist::GetAlttext(void) const
{
    if (!CanGetAlttext()) {
        ThrowUnassigned(12);
    }
    return m_Alttext;
}

inline
void CMath_Base::C_Attlist::SetAlttext(const CMath_Base::C_Attlist::TAlttext& value)
{
    m_Alttext = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CMath_Base::C_Attlist::SetAlttext(CMath_Base::C_Attlist::TAlttext&& value)
{
    m_Alttext = std::forward<CMath_Base::C_Attlist::TAlttext>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CMath_Base::C_Attlist::TAlttext& CMath_Base::C_Attlist::SetAlttext(void)
{
#ifdef _DEBUG
    if (!IsSetAlttext()) {
        m_Alttext = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Alttext;
}

inline
bool CMath_Base::C_Attlist::IsSetCdgroup(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetCdgroup(void) const
{
    return IsSetCdgroup();
}

inline
const CMath_Base::C_Attlist::TCdgroup& CMath_Base::C_Attlist::GetCdgroup(void) const
{
    if (!CanGetCdgroup()) {
        ThrowUnassigned(13);
    }
    return m_Cdgroup;
}

inline
void CMath_Base::C_Attlist::SetCdgroup(const CMath_Base::C_Attlist::TCdgroup& value)
{
    m_Cdgroup = value;
    m_set_State[0] |= 0xc000000;
}

inline
void CMath_Base::C_Attlist::SetCdgroup(CMath_Base::C_Attlist::TCdgroup&& value)
{
    m_Cdgroup = std::forward<CMath_Base::C_Attlist::TCdgroup>(value);
    m_set_State[0] |= 0xc000000;
}

inline
CMath_Base::C_Attlist::TCdgroup& CMath_Base::C_Attlist::SetCdgroup(void)
{
#ifdef _DEBUG
    if (!IsSetCdgroup()) {
        m_Cdgroup = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Cdgroup;
}

inline
bool CMath_Base::C_Attlist::IsSetMode(void) const
{
    return ((m_set_State[0] & 0x30000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMode(void) const
{
    return IsSetMode();
}

inline
const CMath_Base::C_Attlist::TMode& CMath_Base::C_Attlist::GetMode(void) const
{
    if (!CanGetMode()) {
        ThrowUnassigned(14);
    }
    return m_Mode;
}

inline
void CMath_Base::C_Attlist::SetMode(const CMath_Base::C_Attlist::TMode& value)
{
    m_Mode = value;
    m_set_State[0] |= 0x30000000;
}

inline
void CMath_Base::C_Attlist::SetMode(CMath_Base::C_Attlist::TMode&& value)
{
    m_Mode = std::forward<CMath_Base::C_Attlist::TMode>(value);
    m_set_State[0] |= 0x30000000;
}

inline
CMath_Base::C_Attlist::TMode& CMath_Base::C_Attlist::SetMode(void)
{
#ifdef _DEBUG
    if (!IsSetMode()) {
        m_Mode = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000000;
    return m_Mode;
}

inline
bool CMath_Base::C_Attlist::IsSetMacros(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMacros(void) const
{
    return IsSetMacros();
}

inline
const CMath_Base::C_Attlist::TMacros& CMath_Base::C_Attlist::GetMacros(void) const
{
    if (!CanGetMacros()) {
        ThrowUnassigned(15);
    }
    return m_Macros;
}

inline
void CMath_Base::C_Attlist::SetMacros(const CMath_Base::C_Attlist::TMacros& value)
{
    m_Macros = value;
    m_set_State[0] |= 0xc0000000;
}

inline
void CMath_Base::C_Attlist::SetMacros(CMath_Base::C_Attlist::TMacros&& value)
{
    m_Macros = std::forward<CMath_Base::C_Attlist::TMacros>(value);
    m_set_State[0] |= 0xc0000000;
}

inline
CMath_Base::C_Attlist::TMacros& CMath_Base::C_Attlist::SetMacros(void)
{
#ifdef _DEBUG
    if (!IsSetMacros()) {
        m_Macros = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000000;
    return m_Macros;
}

inline
bool CMath_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMath_Base::C_Attlist::TMathcolor& CMath_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(16);
    }
    return m_Mathcolor;
}

inline
void CMath_Base::C_Attlist::SetMathcolor(const CMath_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[1] |= 0x3;
}

inline
void CMath_Base::C_Attlist::SetMathcolor(CMath_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMath_Base::C_Attlist::TMathcolor>(value);
    m_set_State[1] |= 0x3;
}

inline
CMath_Base::C_Attlist::TMathcolor& CMath_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x1;
    return m_Mathcolor;
}

inline
bool CMath_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMath_Base::C_Attlist::TMathbackground& CMath_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(17);
    }
    return m_Mathbackground;
}

inline
void CMath_Base::C_Attlist::SetMathbackground(const CMath_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[1] |= 0xc;
}

inline
void CMath_Base::C_Attlist::SetMathbackground(CMath_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMath_Base::C_Attlist::TMathbackground>(value);
    m_set_State[1] |= 0xc;
}

inline
CMath_Base::C_Attlist::TMathbackground& CMath_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4;
    return m_Mathbackground;
}

inline
bool CMath_Base::C_Attlist::IsSetScriptlevel(void) const
{
    return ((m_set_State[1] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetScriptlevel(void) const
{
    return IsSetScriptlevel();
}

inline
const CMath_Base::C_Attlist::TScriptlevel& CMath_Base::C_Attlist::GetScriptlevel(void) const
{
    if (!CanGetScriptlevel()) {
        ThrowUnassigned(18);
    }
    return m_Scriptlevel;
}

inline
void CMath_Base::C_Attlist::SetScriptlevel(const CMath_Base::C_Attlist::TScriptlevel& value)
{
    m_Scriptlevel = value;
    m_set_State[1] |= 0x30;
}

inline
void CMath_Base::C_Attlist::SetScriptlevel(CMath_Base::C_Attlist::TScriptlevel&& value)
{
    m_Scriptlevel = std::forward<CMath_Base::C_Attlist::TScriptlevel>(value);
    m_set_State[1] |= 0x30;
}

inline
CMath_Base::C_Attlist::TScriptlevel& CMath_Base::C_Attlist::SetScriptlevel(void)
{
#ifdef _DEBUG
    if (!IsSetScriptlevel()) {
        m_Scriptlevel = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10;
    return m_Scriptlevel;
}

inline
bool CMath_Base::C_Attlist::IsSetDisplaystyle(void) const
{
    return ((m_set_State[1] & 0xc0) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetDisplaystyle(void) const
{
    return IsSetDisplaystyle();
}

inline
void CMath_Base::C_Attlist::ResetDisplaystyle(void)
{
    m_Displaystyle = (EAttlist_displaystyle)(0);
    m_set_State[1] &= ~0xc0;
}

inline
CMath_Base::C_Attlist::TDisplaystyle CMath_Base::C_Attlist::GetDisplaystyle(void) const
{
    if (!CanGetDisplaystyle()) {
        ThrowUnassigned(19);
    }
    return m_Displaystyle;
}

inline
void CMath_Base::C_Attlist::SetDisplaystyle(CMath_Base::C_Attlist::TDisplaystyle value)
{
    m_Displaystyle = value;
    m_set_State[1] |= 0xc0;
}

inline
CMath_Base::C_Attlist::TDisplaystyle& CMath_Base::C_Attlist::SetDisplaystyle(void)
{
#ifdef _DEBUG
    if (!IsSetDisplaystyle()) {
        memset(&m_Displaystyle,UnassignedByte(),sizeof(m_Displaystyle));
    }
#endif
    m_set_State[1] |= 0x40;
    return m_Displaystyle;
}

inline
bool CMath_Base::C_Attlist::IsSetScriptsizemultiplier(void) const
{
    return ((m_set_State[1] & 0x300) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetScriptsizemultiplier(void) const
{
    return IsSetScriptsizemultiplier();
}

inline
const CMath_Base::C_Attlist::TScriptsizemultiplier& CMath_Base::C_Attlist::GetScriptsizemultiplier(void) const
{
    if (!CanGetScriptsizemultiplier()) {
        ThrowUnassigned(20);
    }
    return m_Scriptsizemultiplier;
}

inline
void CMath_Base::C_Attlist::SetScriptsizemultiplier(const CMath_Base::C_Attlist::TScriptsizemultiplier& value)
{
    m_Scriptsizemultiplier = value;
    m_set_State[1] |= 0x300;
}

inline
void CMath_Base::C_Attlist::SetScriptsizemultiplier(CMath_Base::C_Attlist::TScriptsizemultiplier&& value)
{
    m_Scriptsizemultiplier = std::forward<CMath_Base::C_Attlist::TScriptsizemultiplier>(value);
    m_set_State[1] |= 0x300;
}

inline
CMath_Base::C_Attlist::TScriptsizemultiplier& CMath_Base::C_Attlist::SetScriptsizemultiplier(void)
{
#ifdef _DEBUG
    if (!IsSetScriptsizemultiplier()) {
        m_Scriptsizemultiplier = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x100;
    return m_Scriptsizemultiplier;
}

inline
bool CMath_Base::C_Attlist::IsSetScriptminsize(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetScriptminsize(void) const
{
    return IsSetScriptminsize();
}

inline
const CMath_Base::C_Attlist::TScriptminsize& CMath_Base::C_Attlist::GetScriptminsize(void) const
{
    if (!CanGetScriptminsize()) {
        ThrowUnassigned(21);
    }
    return m_Scriptminsize;
}

inline
void CMath_Base::C_Attlist::SetScriptminsize(const CMath_Base::C_Attlist::TScriptminsize& value)
{
    m_Scriptminsize = value;
    m_set_State[1] |= 0xc00;
}

inline
void CMath_Base::C_Attlist::SetScriptminsize(CMath_Base::C_Attlist::TScriptminsize&& value)
{
    m_Scriptminsize = std::forward<CMath_Base::C_Attlist::TScriptminsize>(value);
    m_set_State[1] |= 0xc00;
}

inline
CMath_Base::C_Attlist::TScriptminsize& CMath_Base::C_Attlist::SetScriptminsize(void)
{
#ifdef _DEBUG
    if (!IsSetScriptminsize()) {
        m_Scriptminsize = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x400;
    return m_Scriptminsize;
}

inline
bool CMath_Base::C_Attlist::IsSetInfixlinebreakstyle(void) const
{
    return ((m_set_State[1] & 0x3000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetInfixlinebreakstyle(void) const
{
    return IsSetInfixlinebreakstyle();
}

inline
void CMath_Base::C_Attlist::ResetInfixlinebreakstyle(void)
{
    m_Infixlinebreakstyle = (EAttlist_infixlinebreakstyle)(0);
    m_set_State[1] &= ~0x3000;
}

inline
CMath_Base::C_Attlist::TInfixlinebreakstyle CMath_Base::C_Attlist::GetInfixlinebreakstyle(void) const
{
    if (!CanGetInfixlinebreakstyle()) {
        ThrowUnassigned(22);
    }
    return m_Infixlinebreakstyle;
}

inline
void CMath_Base::C_Attlist::SetInfixlinebreakstyle(CMath_Base::C_Attlist::TInfixlinebreakstyle value)
{
    m_Infixlinebreakstyle = value;
    m_set_State[1] |= 0x3000;
}

inline
CMath_Base::C_Attlist::TInfixlinebreakstyle& CMath_Base::C_Attlist::SetInfixlinebreakstyle(void)
{
#ifdef _DEBUG
    if (!IsSetInfixlinebreakstyle()) {
        memset(&m_Infixlinebreakstyle,UnassignedByte(),sizeof(m_Infixlinebreakstyle));
    }
#endif
    m_set_State[1] |= 0x1000;
    return m_Infixlinebreakstyle;
}

inline
bool CMath_Base::C_Attlist::IsSetDecimalpoint(void) const
{
    return ((m_set_State[1] & 0xc000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetDecimalpoint(void) const
{
    return IsSetDecimalpoint();
}

inline
const CMath_Base::C_Attlist::TDecimalpoint& CMath_Base::C_Attlist::GetDecimalpoint(void) const
{
    if (!CanGetDecimalpoint()) {
        ThrowUnassigned(23);
    }
    return m_Decimalpoint;
}

inline
void CMath_Base::C_Attlist::SetDecimalpoint(const CMath_Base::C_Attlist::TDecimalpoint& value)
{
    m_Decimalpoint = value;
    m_set_State[1] |= 0xc000;
}

inline
void CMath_Base::C_Attlist::SetDecimalpoint(CMath_Base::C_Attlist::TDecimalpoint&& value)
{
    m_Decimalpoint = std::forward<CMath_Base::C_Attlist::TDecimalpoint>(value);
    m_set_State[1] |= 0xc000;
}

inline
CMath_Base::C_Attlist::TDecimalpoint& CMath_Base::C_Attlist::SetDecimalpoint(void)
{
#ifdef _DEBUG
    if (!IsSetDecimalpoint()) {
        m_Decimalpoint = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x4000;
    return m_Decimalpoint;
}

inline
bool CMath_Base::C_Attlist::IsSetAccent(void) const
{
    return ((m_set_State[1] & 0x30000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAccent(void) const
{
    return IsSetAccent();
}

inline
void CMath_Base::C_Attlist::ResetAccent(void)
{
    m_Accent = (EAttlist_accent)(0);
    m_set_State[1] &= ~0x30000;
}

inline
CMath_Base::C_Attlist::TAccent CMath_Base::C_Attlist::GetAccent(void) const
{
    if (!CanGetAccent()) {
        ThrowUnassigned(24);
    }
    return m_Accent;
}

inline
void CMath_Base::C_Attlist::SetAccent(CMath_Base::C_Attlist::TAccent value)
{
    m_Accent = value;
    m_set_State[1] |= 0x30000;
}

inline
CMath_Base::C_Attlist::TAccent& CMath_Base::C_Attlist::SetAccent(void)
{
#ifdef _DEBUG
    if (!IsSetAccent()) {
        memset(&m_Accent,UnassignedByte(),sizeof(m_Accent));
    }
#endif
    m_set_State[1] |= 0x10000;
    return m_Accent;
}

inline
bool CMath_Base::C_Attlist::IsSetAccentunder(void) const
{
    return ((m_set_State[1] & 0xc0000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAccentunder(void) const
{
    return IsSetAccentunder();
}

inline
void CMath_Base::C_Attlist::ResetAccentunder(void)
{
    m_Accentunder = (EAttlist_accentunder)(0);
    m_set_State[1] &= ~0xc0000;
}

inline
CMath_Base::C_Attlist::TAccentunder CMath_Base::C_Attlist::GetAccentunder(void) const
{
    if (!CanGetAccentunder()) {
        ThrowUnassigned(25);
    }
    return m_Accentunder;
}

inline
void CMath_Base::C_Attlist::SetAccentunder(CMath_Base::C_Attlist::TAccentunder value)
{
    m_Accentunder = value;
    m_set_State[1] |= 0xc0000;
}

inline
CMath_Base::C_Attlist::TAccentunder& CMath_Base::C_Attlist::SetAccentunder(void)
{
#ifdef _DEBUG
    if (!IsSetAccentunder()) {
        memset(&m_Accentunder,UnassignedByte(),sizeof(m_Accentunder));
    }
#endif
    m_set_State[1] |= 0x40000;
    return m_Accentunder;
}

inline
bool CMath_Base::C_Attlist::IsSetAlign(void) const
{
    return ((m_set_State[1] & 0x300000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAlign(void) const
{
    return IsSetAlign();
}

inline
void CMath_Base::C_Attlist::ResetAlign(void)
{
    m_Align = (EAttlist_align)(0);
    m_set_State[1] &= ~0x300000;
}

inline
CMath_Base::C_Attlist::TAlign CMath_Base::C_Attlist::GetAlign(void) const
{
    if (!CanGetAlign()) {
        ThrowUnassigned(26);
    }
    return m_Align;
}

inline
void CMath_Base::C_Attlist::SetAlign(CMath_Base::C_Attlist::TAlign value)
{
    m_Align = value;
    m_set_State[1] |= 0x300000;
}

inline
CMath_Base::C_Attlist::TAlign& CMath_Base::C_Attlist::SetAlign(void)
{
#ifdef _DEBUG
    if (!IsSetAlign()) {
        memset(&m_Align,UnassignedByte(),sizeof(m_Align));
    }
#endif
    m_set_State[1] |= 0x100000;
    return m_Align;
}

inline
bool CMath_Base::C_Attlist::IsSetAlignmentscope(void) const
{
    return ((m_set_State[1] & 0xc00000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetAlignmentscope(void) const
{
    return IsSetAlignmentscope();
}

inline
const CMath_Base::C_Attlist::TAlignmentscope& CMath_Base::C_Attlist::GetAlignmentscope(void) const
{
    if (!CanGetAlignmentscope()) {
        ThrowUnassigned(27);
    }
    return m_Alignmentscope;
}

inline
void CMath_Base::C_Attlist::SetAlignmentscope(const CMath_Base::C_Attlist::TAlignmentscope& value)
{
    m_Alignmentscope = value;
    m_set_State[1] |= 0xc00000;
}

inline
void CMath_Base::C_Attlist::SetAlignmentscope(CMath_Base::C_Attlist::TAlignmentscope&& value)
{
    m_Alignmentscope = std::forward<CMath_Base::C_Attlist::TAlignmentscope>(value);
    m_set_State[1] |= 0xc00000;
}

inline
CMath_Base::C_Attlist::TAlignmentscope& CMath_Base::C_Attlist::SetAlignmentscope(void)
{
#ifdef _DEBUG
    if (!IsSetAlignmentscope()) {
        m_Alignmentscope = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x400000;
    return m_Alignmentscope;
}

inline
bool CMath_Base::C_Attlist::IsSetBevelled(void) const
{
    return ((m_set_State[1] & 0x3000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetBevelled(void) const
{
    return IsSetBevelled();
}

inline
void CMath_Base::C_Attlist::ResetBevelled(void)
{
    m_Bevelled = (EAttlist_bevelled)(0);
    m_set_State[1] &= ~0x3000000;
}

inline
CMath_Base::C_Attlist::TBevelled CMath_Base::C_Attlist::GetBevelled(void) const
{
    if (!CanGetBevelled()) {
        ThrowUnassigned(28);
    }
    return m_Bevelled;
}

inline
void CMath_Base::C_Attlist::SetBevelled(CMath_Base::C_Attlist::TBevelled value)
{
    m_Bevelled = value;
    m_set_State[1] |= 0x3000000;
}

inline
CMath_Base::C_Attlist::TBevelled& CMath_Base::C_Attlist::SetBevelled(void)
{
#ifdef _DEBUG
    if (!IsSetBevelled()) {
        memset(&m_Bevelled,UnassignedByte(),sizeof(m_Bevelled));
    }
#endif
    m_set_State[1] |= 0x1000000;
    return m_Bevelled;
}

inline
bool CMath_Base::C_Attlist::IsSetCharalign(void) const
{
    return ((m_set_State[1] & 0xc000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetCharalign(void) const
{
    return IsSetCharalign();
}

inline
void CMath_Base::C_Attlist::ResetCharalign(void)
{
    m_Charalign = (EAttlist_charalign)(0);
    m_set_State[1] &= ~0xc000000;
}

inline
CMath_Base::C_Attlist::TCharalign CMath_Base::C_Attlist::GetCharalign(void) const
{
    if (!CanGetCharalign()) {
        ThrowUnassigned(29);
    }
    return m_Charalign;
}

inline
void CMath_Base::C_Attlist::SetCharalign(CMath_Base::C_Attlist::TCharalign value)
{
    m_Charalign = value;
    m_set_State[1] |= 0xc000000;
}

inline
CMath_Base::C_Attlist::TCharalign& CMath_Base::C_Attlist::SetCharalign(void)
{
#ifdef _DEBUG
    if (!IsSetCharalign()) {
        memset(&m_Charalign,UnassignedByte(),sizeof(m_Charalign));
    }
#endif
    m_set_State[1] |= 0x4000000;
    return m_Charalign;
}

inline
bool CMath_Base::C_Attlist::IsSetCharspacing(void) const
{
    return ((m_set_State[1] & 0x30000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetCharspacing(void) const
{
    return IsSetCharspacing();
}

inline
const CMath_Base::C_Attlist::TCharspacing& CMath_Base::C_Attlist::GetCharspacing(void) const
{
    if (!CanGetCharspacing()) {
        ThrowUnassigned(30);
    }
    return m_Charspacing;
}

inline
void CMath_Base::C_Attlist::SetCharspacing(const CMath_Base::C_Attlist::TCharspacing& value)
{
    m_Charspacing = value;
    m_set_State[1] |= 0x30000000;
}

inline
void CMath_Base::C_Attlist::SetCharspacing(CMath_Base::C_Attlist::TCharspacing&& value)
{
    m_Charspacing = std::forward<CMath_Base::C_Attlist::TCharspacing>(value);
    m_set_State[1] |= 0x30000000;
}

inline
CMath_Base::C_Attlist::TCharspacing& CMath_Base::C_Attlist::SetCharspacing(void)
{
#ifdef _DEBUG
    if (!IsSetCharspacing()) {
        m_Charspacing = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x10000000;
    return m_Charspacing;
}

inline
bool CMath_Base::C_Attlist::IsSetClose(void) const
{
    return ((m_set_State[1] & 0xc0000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetClose(void) const
{
    return IsSetClose();
}

inline
const CMath_Base::C_Attlist::TClose& CMath_Base::C_Attlist::GetClose(void) const
{
    if (!CanGetClose()) {
        ThrowUnassigned(31);
    }
    return m_Close;
}

inline
void CMath_Base::C_Attlist::SetClose(const CMath_Base::C_Attlist::TClose& value)
{
    m_Close = value;
    m_set_State[1] |= 0xc0000000;
}

inline
void CMath_Base::C_Attlist::SetClose(CMath_Base::C_Attlist::TClose&& value)
{
    m_Close = std::forward<CMath_Base::C_Attlist::TClose>(value);
    m_set_State[1] |= 0xc0000000;
}

inline
CMath_Base::C_Attlist::TClose& CMath_Base::C_Attlist::SetClose(void)
{
#ifdef _DEBUG
    if (!IsSetClose()) {
        m_Close = UnassignedString();
    }
#endif
    m_set_State[1] |= 0x40000000;
    return m_Close;
}

inline
bool CMath_Base::C_Attlist::IsSetColumnalign(void) const
{
    return ((m_set_State[2] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetColumnalign(void) const
{
    return IsSetColumnalign();
}

inline
const CMath_Base::C_Attlist::TColumnalign& CMath_Base::C_Attlist::GetColumnalign(void) const
{
    if (!CanGetColumnalign()) {
        ThrowUnassigned(32);
    }
    return m_Columnalign;
}

inline
void CMath_Base::C_Attlist::SetColumnalign(const CMath_Base::C_Attlist::TColumnalign& value)
{
    m_Columnalign = value;
    m_set_State[2] |= 0x3;
}

inline
void CMath_Base::C_Attlist::SetColumnalign(CMath_Base::C_Attlist::TColumnalign&& value)
{
    m_Columnalign = std::forward<CMath_Base::C_Attlist::TColumnalign>(value);
    m_set_State[2] |= 0x3;
}

inline
CMath_Base::C_Attlist::TColumnalign& CMath_Base::C_Attlist::SetColumnalign(void)
{
#ifdef _DEBUG
    if (!IsSetColumnalign()) {
        m_Columnalign = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x1;
    return m_Columnalign;
}

inline
bool CMath_Base::C_Attlist::IsSetColumnlines(void) const
{
    return ((m_set_State[2] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetColumnlines(void) const
{
    return IsSetColumnlines();
}

inline
const CMath_Base::C_Attlist::TColumnlines& CMath_Base::C_Attlist::GetColumnlines(void) const
{
    if (!CanGetColumnlines()) {
        ThrowUnassigned(33);
    }
    return m_Columnlines;
}

inline
void CMath_Base::C_Attlist::SetColumnlines(const CMath_Base::C_Attlist::TColumnlines& value)
{
    m_Columnlines = value;
    m_set_State[2] |= 0xc;
}

inline
void CMath_Base::C_Attlist::SetColumnlines(CMath_Base::C_Attlist::TColumnlines&& value)
{
    m_Columnlines = std::forward<CMath_Base::C_Attlist::TColumnlines>(value);
    m_set_State[2] |= 0xc;
}

inline
CMath_Base::C_Attlist::TColumnlines& CMath_Base::C_Attlist::SetColumnlines(void)
{
#ifdef _DEBUG
    if (!IsSetColumnlines()) {
        m_Columnlines = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x4;
    return m_Columnlines;
}

inline
bool CMath_Base::C_Attlist::IsSetColumnspacing(void) const
{
    return ((m_set_State[2] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetColumnspacing(void) const
{
    return IsSetColumnspacing();
}

inline
const CMath_Base::C_Attlist::TColumnspacing& CMath_Base::C_Attlist::GetColumnspacing(void) const
{
    if (!CanGetColumnspacing()) {
        ThrowUnassigned(34);
    }
    return m_Columnspacing;
}

inline
void CMath_Base::C_Attlist::SetColumnspacing(const CMath_Base::C_Attlist::TColumnspacing& value)
{
    m_Columnspacing = value;
    m_set_State[2] |= 0x30;
}

inline
void CMath_Base::C_Attlist::SetColumnspacing(CMath_Base::C_Attlist::TColumnspacing&& value)
{
    m_Columnspacing = std::forward<CMath_Base::C_Attlist::TColumnspacing>(value);
    m_set_State[2] |= 0x30;
}

inline
CMath_Base::C_Attlist::TColumnspacing& CMath_Base::C_Attlist::SetColumnspacing(void)
{
#ifdef _DEBUG
    if (!IsSetColumnspacing()) {
        m_Columnspacing = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x10;
    return m_Columnspacing;
}

inline
bool CMath_Base::C_Attlist::IsSetColumnspan(void) const
{
    return ((m_set_State[2] & 0xc0) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetColumnspan(void) const
{
    return IsSetColumnspan();
}

inline
const CMath_Base::C_Attlist::TColumnspan& CMath_Base::C_Attlist::GetColumnspan(void) const
{
    if (!CanGetColumnspan()) {
        ThrowUnassigned(35);
    }
    return m_Columnspan;
}

inline
void CMath_Base::C_Attlist::SetColumnspan(const CMath_Base::C_Attlist::TColumnspan& value)
{
    m_Columnspan = value;
    m_set_State[2] |= 0xc0;
}

inline
void CMath_Base::C_Attlist::SetColumnspan(CMath_Base::C_Attlist::TColumnspan&& value)
{
    m_Columnspan = std::forward<CMath_Base::C_Attlist::TColumnspan>(value);
    m_set_State[2] |= 0xc0;
}

inline
CMath_Base::C_Attlist::TColumnspan& CMath_Base::C_Attlist::SetColumnspan(void)
{
#ifdef _DEBUG
    if (!IsSetColumnspan()) {
        m_Columnspan = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x40;
    return m_Columnspan;
}

inline
bool CMath_Base::C_Attlist::IsSetColumnwidth(void) const
{
    return ((m_set_State[2] & 0x300) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetColumnwidth(void) const
{
    return IsSetColumnwidth();
}

inline
const CMath_Base::C_Attlist::TColumnwidth& CMath_Base::C_Attlist::GetColumnwidth(void) const
{
    if (!CanGetColumnwidth()) {
        ThrowUnassigned(36);
    }
    return m_Columnwidth;
}

inline
void CMath_Base::C_Attlist::SetColumnwidth(const CMath_Base::C_Attlist::TColumnwidth& value)
{
    m_Columnwidth = value;
    m_set_State[2] |= 0x300;
}

inline
void CMath_Base::C_Attlist::SetColumnwidth(CMath_Base::C_Attlist::TColumnwidth&& value)
{
    m_Columnwidth = std::forward<CMath_Base::C_Attlist::TColumnwidth>(value);
    m_set_State[2] |= 0x300;
}

inline
CMath_Base::C_Attlist::TColumnwidth& CMath_Base::C_Attlist::SetColumnwidth(void)
{
#ifdef _DEBUG
    if (!IsSetColumnwidth()) {
        m_Columnwidth = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x100;
    return m_Columnwidth;
}

inline
bool CMath_Base::C_Attlist::IsSetCrossout(void) const
{
    return ((m_set_State[2] & 0xc00) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetCrossout(void) const
{
    return IsSetCrossout();
}

inline
const CMath_Base::C_Attlist::TCrossout& CMath_Base::C_Attlist::GetCrossout(void) const
{
    if (!CanGetCrossout()) {
        ThrowUnassigned(37);
    }
    return m_Crossout;
}

inline
void CMath_Base::C_Attlist::SetCrossout(const CMath_Base::C_Attlist::TCrossout& value)
{
    m_Crossout = value;
    m_set_State[2] |= 0xc00;
}

inline
void CMath_Base::C_Attlist::SetCrossout(CMath_Base::C_Attlist::TCrossout&& value)
{
    m_Crossout = std::forward<CMath_Base::C_Attlist::TCrossout>(value);
    m_set_State[2] |= 0xc00;
}

inline
CMath_Base::C_Attlist::TCrossout& CMath_Base::C_Attlist::SetCrossout(void)
{
#ifdef _DEBUG
    if (!IsSetCrossout()) {
        m_Crossout = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x400;
    return m_Crossout;
}

inline
bool CMath_Base::C_Attlist::IsSetDenomalign(void) const
{
    return ((m_set_State[2] & 0x3000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetDenomalign(void) const
{
    return IsSetDenomalign();
}

inline
void CMath_Base::C_Attlist::ResetDenomalign(void)
{
    m_Denomalign = (EAttlist_denomalign)(0);
    m_set_State[2] &= ~0x3000;
}

inline
CMath_Base::C_Attlist::TDenomalign CMath_Base::C_Attlist::GetDenomalign(void) const
{
    if (!CanGetDenomalign()) {
        ThrowUnassigned(38);
    }
    return m_Denomalign;
}

inline
void CMath_Base::C_Attlist::SetDenomalign(CMath_Base::C_Attlist::TDenomalign value)
{
    m_Denomalign = value;
    m_set_State[2] |= 0x3000;
}

inline
CMath_Base::C_Attlist::TDenomalign& CMath_Base::C_Attlist::SetDenomalign(void)
{
#ifdef _DEBUG
    if (!IsSetDenomalign()) {
        memset(&m_Denomalign,UnassignedByte(),sizeof(m_Denomalign));
    }
#endif
    m_set_State[2] |= 0x1000;
    return m_Denomalign;
}

inline
bool CMath_Base::C_Attlist::IsSetDepth(void) const
{
    return ((m_set_State[2] & 0xc000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetDepth(void) const
{
    return IsSetDepth();
}

inline
const CMath_Base::C_Attlist::TDepth& CMath_Base::C_Attlist::GetDepth(void) const
{
    if (!CanGetDepth()) {
        ThrowUnassigned(39);
    }
    return m_Depth;
}

inline
void CMath_Base::C_Attlist::SetDepth(const CMath_Base::C_Attlist::TDepth& value)
{
    m_Depth = value;
    m_set_State[2] |= 0xc000;
}

inline
void CMath_Base::C_Attlist::SetDepth(CMath_Base::C_Attlist::TDepth&& value)
{
    m_Depth = std::forward<CMath_Base::C_Attlist::TDepth>(value);
    m_set_State[2] |= 0xc000;
}

inline
CMath_Base::C_Attlist::TDepth& CMath_Base::C_Attlist::SetDepth(void)
{
#ifdef _DEBUG
    if (!IsSetDepth()) {
        m_Depth = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x4000;
    return m_Depth;
}

inline
bool CMath_Base::C_Attlist::IsSetDir(void) const
{
    return ((m_set_State[2] & 0x30000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetDir(void) const
{
    return IsSetDir();
}

inline
void CMath_Base::C_Attlist::ResetDir(void)
{
    m_Dir = (EAttlist_dir)(0);
    m_set_State[2] &= ~0x30000;
}

inline
CMath_Base::C_Attlist::TDir CMath_Base::C_Attlist::GetDir(void) const
{
    if (!CanGetDir()) {
        ThrowUnassigned(40);
    }
    return m_Dir;
}

inline
void CMath_Base::C_Attlist::SetDir(CMath_Base::C_Attlist::TDir value)
{
    m_Dir = value;
    m_set_State[2] |= 0x30000;
}

inline
CMath_Base::C_Attlist::TDir& CMath_Base::C_Attlist::SetDir(void)
{
#ifdef _DEBUG
    if (!IsSetDir()) {
        memset(&m_Dir,UnassignedByte(),sizeof(m_Dir));
    }
#endif
    m_set_State[2] |= 0x10000;
    return m_Dir;
}

inline
bool CMath_Base::C_Attlist::IsSetEdge(void) const
{
    return ((m_set_State[2] & 0xc0000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetEdge(void) const
{
    return IsSetEdge();
}

inline
void CMath_Base::C_Attlist::ResetEdge(void)
{
    m_Edge = (EAttlist_edge)(0);
    m_set_State[2] &= ~0xc0000;
}

inline
CMath_Base::C_Attlist::TEdge CMath_Base::C_Attlist::GetEdge(void) const
{
    if (!CanGetEdge()) {
        ThrowUnassigned(41);
    }
    return m_Edge;
}

inline
void CMath_Base::C_Attlist::SetEdge(CMath_Base::C_Attlist::TEdge value)
{
    m_Edge = value;
    m_set_State[2] |= 0xc0000;
}

inline
CMath_Base::C_Attlist::TEdge& CMath_Base::C_Attlist::SetEdge(void)
{
#ifdef _DEBUG
    if (!IsSetEdge()) {
        memset(&m_Edge,UnassignedByte(),sizeof(m_Edge));
    }
#endif
    m_set_State[2] |= 0x40000;
    return m_Edge;
}

inline
bool CMath_Base::C_Attlist::IsSetEqualcolumns(void) const
{
    return ((m_set_State[2] & 0x300000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetEqualcolumns(void) const
{
    return IsSetEqualcolumns();
}

inline
void CMath_Base::C_Attlist::ResetEqualcolumns(void)
{
    m_Equalcolumns = (EAttlist_equalcolumns)(0);
    m_set_State[2] &= ~0x300000;
}

inline
CMath_Base::C_Attlist::TEqualcolumns CMath_Base::C_Attlist::GetEqualcolumns(void) const
{
    if (!CanGetEqualcolumns()) {
        ThrowUnassigned(42);
    }
    return m_Equalcolumns;
}

inline
void CMath_Base::C_Attlist::SetEqualcolumns(CMath_Base::C_Attlist::TEqualcolumns value)
{
    m_Equalcolumns = value;
    m_set_State[2] |= 0x300000;
}

inline
CMath_Base::C_Attlist::TEqualcolumns& CMath_Base::C_Attlist::SetEqualcolumns(void)
{
#ifdef _DEBUG
    if (!IsSetEqualcolumns()) {
        memset(&m_Equalcolumns,UnassignedByte(),sizeof(m_Equalcolumns));
    }
#endif
    m_set_State[2] |= 0x100000;
    return m_Equalcolumns;
}

inline
bool CMath_Base::C_Attlist::IsSetEqualrows(void) const
{
    return ((m_set_State[2] & 0xc00000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetEqualrows(void) const
{
    return IsSetEqualrows();
}

inline
void CMath_Base::C_Attlist::ResetEqualrows(void)
{
    m_Equalrows = (EAttlist_equalrows)(0);
    m_set_State[2] &= ~0xc00000;
}

inline
CMath_Base::C_Attlist::TEqualrows CMath_Base::C_Attlist::GetEqualrows(void) const
{
    if (!CanGetEqualrows()) {
        ThrowUnassigned(43);
    }
    return m_Equalrows;
}

inline
void CMath_Base::C_Attlist::SetEqualrows(CMath_Base::C_Attlist::TEqualrows value)
{
    m_Equalrows = value;
    m_set_State[2] |= 0xc00000;
}

inline
CMath_Base::C_Attlist::TEqualrows& CMath_Base::C_Attlist::SetEqualrows(void)
{
#ifdef _DEBUG
    if (!IsSetEqualrows()) {
        memset(&m_Equalrows,UnassignedByte(),sizeof(m_Equalrows));
    }
#endif
    m_set_State[2] |= 0x400000;
    return m_Equalrows;
}

inline
bool CMath_Base::C_Attlist::IsSetFence(void) const
{
    return ((m_set_State[2] & 0x3000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetFence(void) const
{
    return IsSetFence();
}

inline
void CMath_Base::C_Attlist::ResetFence(void)
{
    m_Fence = (EAttlist_fence)(0);
    m_set_State[2] &= ~0x3000000;
}

inline
CMath_Base::C_Attlist::TFence CMath_Base::C_Attlist::GetFence(void) const
{
    if (!CanGetFence()) {
        ThrowUnassigned(44);
    }
    return m_Fence;
}

inline
void CMath_Base::C_Attlist::SetFence(CMath_Base::C_Attlist::TFence value)
{
    m_Fence = value;
    m_set_State[2] |= 0x3000000;
}

inline
CMath_Base::C_Attlist::TFence& CMath_Base::C_Attlist::SetFence(void)
{
#ifdef _DEBUG
    if (!IsSetFence()) {
        memset(&m_Fence,UnassignedByte(),sizeof(m_Fence));
    }
#endif
    m_set_State[2] |= 0x1000000;
    return m_Fence;
}

inline
bool CMath_Base::C_Attlist::IsSetForm(void) const
{
    return ((m_set_State[2] & 0xc000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetForm(void) const
{
    return IsSetForm();
}

inline
void CMath_Base::C_Attlist::ResetForm(void)
{
    m_Form = (EAttlist_form)(0);
    m_set_State[2] &= ~0xc000000;
}

inline
CMath_Base::C_Attlist::TForm CMath_Base::C_Attlist::GetForm(void) const
{
    if (!CanGetForm()) {
        ThrowUnassigned(45);
    }
    return m_Form;
}

inline
void CMath_Base::C_Attlist::SetForm(CMath_Base::C_Attlist::TForm value)
{
    m_Form = value;
    m_set_State[2] |= 0xc000000;
}

inline
CMath_Base::C_Attlist::TForm& CMath_Base::C_Attlist::SetForm(void)
{
#ifdef _DEBUG
    if (!IsSetForm()) {
        memset(&m_Form,UnassignedByte(),sizeof(m_Form));
    }
#endif
    m_set_State[2] |= 0x4000000;
    return m_Form;
}

inline
bool CMath_Base::C_Attlist::IsSetFrame(void) const
{
    return ((m_set_State[2] & 0x30000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetFrame(void) const
{
    return IsSetFrame();
}

inline
void CMath_Base::C_Attlist::ResetFrame(void)
{
    m_Frame = (EAttlist_frame)(0);
    m_set_State[2] &= ~0x30000000;
}

inline
CMath_Base::C_Attlist::TFrame CMath_Base::C_Attlist::GetFrame(void) const
{
    if (!CanGetFrame()) {
        ThrowUnassigned(46);
    }
    return m_Frame;
}

inline
void CMath_Base::C_Attlist::SetFrame(CMath_Base::C_Attlist::TFrame value)
{
    m_Frame = value;
    m_set_State[2] |= 0x30000000;
}

inline
CMath_Base::C_Attlist::TFrame& CMath_Base::C_Attlist::SetFrame(void)
{
#ifdef _DEBUG
    if (!IsSetFrame()) {
        memset(&m_Frame,UnassignedByte(),sizeof(m_Frame));
    }
#endif
    m_set_State[2] |= 0x10000000;
    return m_Frame;
}

inline
bool CMath_Base::C_Attlist::IsSetFramespacing(void) const
{
    return ((m_set_State[2] & 0xc0000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetFramespacing(void) const
{
    return IsSetFramespacing();
}

inline
const CMath_Base::C_Attlist::TFramespacing& CMath_Base::C_Attlist::GetFramespacing(void) const
{
    if (!CanGetFramespacing()) {
        ThrowUnassigned(47);
    }
    return m_Framespacing;
}

inline
void CMath_Base::C_Attlist::SetFramespacing(const CMath_Base::C_Attlist::TFramespacing& value)
{
    m_Framespacing = value;
    m_set_State[2] |= 0xc0000000;
}

inline
void CMath_Base::C_Attlist::SetFramespacing(CMath_Base::C_Attlist::TFramespacing&& value)
{
    m_Framespacing = std::forward<CMath_Base::C_Attlist::TFramespacing>(value);
    m_set_State[2] |= 0xc0000000;
}

inline
CMath_Base::C_Attlist::TFramespacing& CMath_Base::C_Attlist::SetFramespacing(void)
{
#ifdef _DEBUG
    if (!IsSetFramespacing()) {
        m_Framespacing = UnassignedString();
    }
#endif
    m_set_State[2] |= 0x40000000;
    return m_Framespacing;
}

inline
bool CMath_Base::C_Attlist::IsSetGroupalign(void) const
{
    return ((m_set_State[3] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetGroupalign(void) const
{
    return IsSetGroupalign();
}

inline
const CMath_Base::C_Attlist::TGroupalign& CMath_Base::C_Attlist::GetGroupalign(void) const
{
    if (!CanGetGroupalign()) {
        ThrowUnassigned(48);
    }
    return m_Groupalign;
}

inline
void CMath_Base::C_Attlist::SetGroupalign(const CMath_Base::C_Attlist::TGroupalign& value)
{
    m_Groupalign = value;
    m_set_State[3] |= 0x3;
}

inline
void CMath_Base::C_Attlist::SetGroupalign(CMath_Base::C_Attlist::TGroupalign&& value)
{
    m_Groupalign = std::forward<CMath_Base::C_Attlist::TGroupalign>(value);
    m_set_State[3] |= 0x3;
}

inline
CMath_Base::C_Attlist::TGroupalign& CMath_Base::C_Attlist::SetGroupalign(void)
{
#ifdef _DEBUG
    if (!IsSetGroupalign()) {
        m_Groupalign = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x1;
    return m_Groupalign;
}

inline
bool CMath_Base::C_Attlist::IsSetHeight(void) const
{
    return ((m_set_State[3] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetHeight(void) const
{
    return IsSetHeight();
}

inline
const CMath_Base::C_Attlist::THeight& CMath_Base::C_Attlist::GetHeight(void) const
{
    if (!CanGetHeight()) {
        ThrowUnassigned(49);
    }
    return m_Height;
}

inline
void CMath_Base::C_Attlist::SetHeight(const CMath_Base::C_Attlist::THeight& value)
{
    m_Height = value;
    m_set_State[3] |= 0xc;
}

inline
void CMath_Base::C_Attlist::SetHeight(CMath_Base::C_Attlist::THeight&& value)
{
    m_Height = std::forward<CMath_Base::C_Attlist::THeight>(value);
    m_set_State[3] |= 0xc;
}

inline
CMath_Base::C_Attlist::THeight& CMath_Base::C_Attlist::SetHeight(void)
{
#ifdef _DEBUG
    if (!IsSetHeight()) {
        m_Height = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x4;
    return m_Height;
}

inline
bool CMath_Base::C_Attlist::IsSetIndentalign(void) const
{
    return ((m_set_State[3] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndentalign(void) const
{
    return IsSetIndentalign();
}

inline
void CMath_Base::C_Attlist::ResetIndentalign(void)
{
    m_Indentalign = (EAttlist_indentalign)(0);
    m_set_State[3] &= ~0x30;
}

inline
CMath_Base::C_Attlist::TIndentalign CMath_Base::C_Attlist::GetIndentalign(void) const
{
    if (!CanGetIndentalign()) {
        ThrowUnassigned(50);
    }
    return m_Indentalign;
}

inline
void CMath_Base::C_Attlist::SetIndentalign(CMath_Base::C_Attlist::TIndentalign value)
{
    m_Indentalign = value;
    m_set_State[3] |= 0x30;
}

inline
CMath_Base::C_Attlist::TIndentalign& CMath_Base::C_Attlist::SetIndentalign(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalign()) {
        memset(&m_Indentalign,UnassignedByte(),sizeof(m_Indentalign));
    }
#endif
    m_set_State[3] |= 0x10;
    return m_Indentalign;
}

inline
bool CMath_Base::C_Attlist::IsSetIndentalignfirst(void) const
{
    return ((m_set_State[3] & 0xc0) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndentalignfirst(void) const
{
    return IsSetIndentalignfirst();
}

inline
void CMath_Base::C_Attlist::ResetIndentalignfirst(void)
{
    m_Indentalignfirst = (EAttlist_indentalignfirst)(0);
    m_set_State[3] &= ~0xc0;
}

inline
CMath_Base::C_Attlist::TIndentalignfirst CMath_Base::C_Attlist::GetIndentalignfirst(void) const
{
    if (!CanGetIndentalignfirst()) {
        ThrowUnassigned(51);
    }
    return m_Indentalignfirst;
}

inline
void CMath_Base::C_Attlist::SetIndentalignfirst(CMath_Base::C_Attlist::TIndentalignfirst value)
{
    m_Indentalignfirst = value;
    m_set_State[3] |= 0xc0;
}

inline
CMath_Base::C_Attlist::TIndentalignfirst& CMath_Base::C_Attlist::SetIndentalignfirst(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalignfirst()) {
        memset(&m_Indentalignfirst,UnassignedByte(),sizeof(m_Indentalignfirst));
    }
#endif
    m_set_State[3] |= 0x40;
    return m_Indentalignfirst;
}

inline
bool CMath_Base::C_Attlist::IsSetIndentalignlast(void) const
{
    return ((m_set_State[3] & 0x300) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndentalignlast(void) const
{
    return IsSetIndentalignlast();
}

inline
void CMath_Base::C_Attlist::ResetIndentalignlast(void)
{
    m_Indentalignlast = (EAttlist_indentalignlast)(0);
    m_set_State[3] &= ~0x300;
}

inline
CMath_Base::C_Attlist::TIndentalignlast CMath_Base::C_Attlist::GetIndentalignlast(void) const
{
    if (!CanGetIndentalignlast()) {
        ThrowUnassigned(52);
    }
    return m_Indentalignlast;
}

inline
void CMath_Base::C_Attlist::SetIndentalignlast(CMath_Base::C_Attlist::TIndentalignlast value)
{
    m_Indentalignlast = value;
    m_set_State[3] |= 0x300;
}

inline
CMath_Base::C_Attlist::TIndentalignlast& CMath_Base::C_Attlist::SetIndentalignlast(void)
{
#ifdef _DEBUG
    if (!IsSetIndentalignlast()) {
        memset(&m_Indentalignlast,UnassignedByte(),sizeof(m_Indentalignlast));
    }
#endif
    m_set_State[3] |= 0x100;
    return m_Indentalignlast;
}

inline
bool CMath_Base::C_Attlist::IsSetIndentshift(void) const
{
    return ((m_set_State[3] & 0xc00) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndentshift(void) const
{
    return IsSetIndentshift();
}

inline
const CMath_Base::C_Attlist::TIndentshift& CMath_Base::C_Attlist::GetIndentshift(void) const
{
    if (!CanGetIndentshift()) {
        ThrowUnassigned(53);
    }
    return m_Indentshift;
}

inline
void CMath_Base::C_Attlist::SetIndentshift(const CMath_Base::C_Attlist::TIndentshift& value)
{
    m_Indentshift = value;
    m_set_State[3] |= 0xc00;
}

inline
void CMath_Base::C_Attlist::SetIndentshift(CMath_Base::C_Attlist::TIndentshift&& value)
{
    m_Indentshift = std::forward<CMath_Base::C_Attlist::TIndentshift>(value);
    m_set_State[3] |= 0xc00;
}

inline
CMath_Base::C_Attlist::TIndentshift& CMath_Base::C_Attlist::SetIndentshift(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshift()) {
        m_Indentshift = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x400;
    return m_Indentshift;
}

inline
bool CMath_Base::C_Attlist::IsSetIndentshiftfirst(void) const
{
    return ((m_set_State[3] & 0x3000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndentshiftfirst(void) const
{
    return IsSetIndentshiftfirst();
}

inline
const CMath_Base::C_Attlist::TIndentshiftfirst& CMath_Base::C_Attlist::GetIndentshiftfirst(void) const
{
    if (!CanGetIndentshiftfirst()) {
        ThrowUnassigned(54);
    }
    return m_Indentshiftfirst;
}

inline
void CMath_Base::C_Attlist::SetIndentshiftfirst(const CMath_Base::C_Attlist::TIndentshiftfirst& value)
{
    m_Indentshiftfirst = value;
    m_set_State[3] |= 0x3000;
}

inline
void CMath_Base::C_Attlist::SetIndentshiftfirst(CMath_Base::C_Attlist::TIndentshiftfirst&& value)
{
    m_Indentshiftfirst = std::forward<CMath_Base::C_Attlist::TIndentshiftfirst>(value);
    m_set_State[3] |= 0x3000;
}

inline
CMath_Base::C_Attlist::TIndentshiftfirst& CMath_Base::C_Attlist::SetIndentshiftfirst(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshiftfirst()) {
        m_Indentshiftfirst = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x1000;
    return m_Indentshiftfirst;
}

inline
bool CMath_Base::C_Attlist::IsSetIndentshiftlast(void) const
{
    return ((m_set_State[3] & 0xc000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndentshiftlast(void) const
{
    return IsSetIndentshiftlast();
}

inline
const CMath_Base::C_Attlist::TIndentshiftlast& CMath_Base::C_Attlist::GetIndentshiftlast(void) const
{
    if (!CanGetIndentshiftlast()) {
        ThrowUnassigned(55);
    }
    return m_Indentshiftlast;
}

inline
void CMath_Base::C_Attlist::SetIndentshiftlast(const CMath_Base::C_Attlist::TIndentshiftlast& value)
{
    m_Indentshiftlast = value;
    m_set_State[3] |= 0xc000;
}

inline
void CMath_Base::C_Attlist::SetIndentshiftlast(CMath_Base::C_Attlist::TIndentshiftlast&& value)
{
    m_Indentshiftlast = std::forward<CMath_Base::C_Attlist::TIndentshiftlast>(value);
    m_set_State[3] |= 0xc000;
}

inline
CMath_Base::C_Attlist::TIndentshiftlast& CMath_Base::C_Attlist::SetIndentshiftlast(void)
{
#ifdef _DEBUG
    if (!IsSetIndentshiftlast()) {
        m_Indentshiftlast = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x4000;
    return m_Indentshiftlast;
}

inline
bool CMath_Base::C_Attlist::IsSetIndenttarget(void) const
{
    return ((m_set_State[3] & 0x30000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetIndenttarget(void) const
{
    return IsSetIndenttarget();
}

inline
const CMath_Base::C_Attlist::TIndenttarget& CMath_Base::C_Attlist::GetIndenttarget(void) const
{
    if (!CanGetIndenttarget()) {
        ThrowUnassigned(56);
    }
    return m_Indenttarget;
}

inline
void CMath_Base::C_Attlist::SetIndenttarget(const CMath_Base::C_Attlist::TIndenttarget& value)
{
    m_Indenttarget = value;
    m_set_State[3] |= 0x30000;
}

inline
void CMath_Base::C_Attlist::SetIndenttarget(CMath_Base::C_Attlist::TIndenttarget&& value)
{
    m_Indenttarget = std::forward<CMath_Base::C_Attlist::TIndenttarget>(value);
    m_set_State[3] |= 0x30000;
}

inline
CMath_Base::C_Attlist::TIndenttarget& CMath_Base::C_Attlist::SetIndenttarget(void)
{
#ifdef _DEBUG
    if (!IsSetIndenttarget()) {
        m_Indenttarget = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x10000;
    return m_Indenttarget;
}

inline
bool CMath_Base::C_Attlist::IsSetLargeop(void) const
{
    return ((m_set_State[3] & 0xc0000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLargeop(void) const
{
    return IsSetLargeop();
}

inline
void CMath_Base::C_Attlist::ResetLargeop(void)
{
    m_Largeop = (EAttlist_largeop)(0);
    m_set_State[3] &= ~0xc0000;
}

inline
CMath_Base::C_Attlist::TLargeop CMath_Base::C_Attlist::GetLargeop(void) const
{
    if (!CanGetLargeop()) {
        ThrowUnassigned(57);
    }
    return m_Largeop;
}

inline
void CMath_Base::C_Attlist::SetLargeop(CMath_Base::C_Attlist::TLargeop value)
{
    m_Largeop = value;
    m_set_State[3] |= 0xc0000;
}

inline
CMath_Base::C_Attlist::TLargeop& CMath_Base::C_Attlist::SetLargeop(void)
{
#ifdef _DEBUG
    if (!IsSetLargeop()) {
        memset(&m_Largeop,UnassignedByte(),sizeof(m_Largeop));
    }
#endif
    m_set_State[3] |= 0x40000;
    return m_Largeop;
}

inline
bool CMath_Base::C_Attlist::IsSetLeftoverhang(void) const
{
    return ((m_set_State[3] & 0x300000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLeftoverhang(void) const
{
    return IsSetLeftoverhang();
}

inline
const CMath_Base::C_Attlist::TLeftoverhang& CMath_Base::C_Attlist::GetLeftoverhang(void) const
{
    if (!CanGetLeftoverhang()) {
        ThrowUnassigned(58);
    }
    return m_Leftoverhang;
}

inline
void CMath_Base::C_Attlist::SetLeftoverhang(const CMath_Base::C_Attlist::TLeftoverhang& value)
{
    m_Leftoverhang = value;
    m_set_State[3] |= 0x300000;
}

inline
void CMath_Base::C_Attlist::SetLeftoverhang(CMath_Base::C_Attlist::TLeftoverhang&& value)
{
    m_Leftoverhang = std::forward<CMath_Base::C_Attlist::TLeftoverhang>(value);
    m_set_State[3] |= 0x300000;
}

inline
CMath_Base::C_Attlist::TLeftoverhang& CMath_Base::C_Attlist::SetLeftoverhang(void)
{
#ifdef _DEBUG
    if (!IsSetLeftoverhang()) {
        m_Leftoverhang = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x100000;
    return m_Leftoverhang;
}

inline
bool CMath_Base::C_Attlist::IsSetLength(void) const
{
    return ((m_set_State[3] & 0xc00000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLength(void) const
{
    return IsSetLength();
}

inline
const CMath_Base::C_Attlist::TLength& CMath_Base::C_Attlist::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(59);
    }
    return m_Length;
}

inline
void CMath_Base::C_Attlist::SetLength(const CMath_Base::C_Attlist::TLength& value)
{
    m_Length = value;
    m_set_State[3] |= 0xc00000;
}

inline
void CMath_Base::C_Attlist::SetLength(CMath_Base::C_Attlist::TLength&& value)
{
    m_Length = std::forward<CMath_Base::C_Attlist::TLength>(value);
    m_set_State[3] |= 0xc00000;
}

inline
CMath_Base::C_Attlist::TLength& CMath_Base::C_Attlist::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        m_Length = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x400000;
    return m_Length;
}

inline
bool CMath_Base::C_Attlist::IsSetLinebreak(void) const
{
    return ((m_set_State[3] & 0x3000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLinebreak(void) const
{
    return IsSetLinebreak();
}

inline
void CMath_Base::C_Attlist::ResetLinebreak(void)
{
    m_Linebreak = (EAttlist_linebreak)(0);
    m_set_State[3] &= ~0x3000000;
}

inline
CMath_Base::C_Attlist::TLinebreak CMath_Base::C_Attlist::GetLinebreak(void) const
{
    if (!CanGetLinebreak()) {
        ThrowUnassigned(60);
    }
    return m_Linebreak;
}

inline
void CMath_Base::C_Attlist::SetLinebreak(CMath_Base::C_Attlist::TLinebreak value)
{
    m_Linebreak = value;
    m_set_State[3] |= 0x3000000;
}

inline
CMath_Base::C_Attlist::TLinebreak& CMath_Base::C_Attlist::SetLinebreak(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreak()) {
        memset(&m_Linebreak,UnassignedByte(),sizeof(m_Linebreak));
    }
#endif
    m_set_State[3] |= 0x1000000;
    return m_Linebreak;
}

inline
bool CMath_Base::C_Attlist::IsSetLinebreakmultchar(void) const
{
    return ((m_set_State[3] & 0xc000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLinebreakmultchar(void) const
{
    return IsSetLinebreakmultchar();
}

inline
const CMath_Base::C_Attlist::TLinebreakmultchar& CMath_Base::C_Attlist::GetLinebreakmultchar(void) const
{
    if (!CanGetLinebreakmultchar()) {
        ThrowUnassigned(61);
    }
    return m_Linebreakmultchar;
}

inline
void CMath_Base::C_Attlist::SetLinebreakmultchar(const CMath_Base::C_Attlist::TLinebreakmultchar& value)
{
    m_Linebreakmultchar = value;
    m_set_State[3] |= 0xc000000;
}

inline
void CMath_Base::C_Attlist::SetLinebreakmultchar(CMath_Base::C_Attlist::TLinebreakmultchar&& value)
{
    m_Linebreakmultchar = std::forward<CMath_Base::C_Attlist::TLinebreakmultchar>(value);
    m_set_State[3] |= 0xc000000;
}

inline
CMath_Base::C_Attlist::TLinebreakmultchar& CMath_Base::C_Attlist::SetLinebreakmultchar(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreakmultchar()) {
        m_Linebreakmultchar = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x4000000;
    return m_Linebreakmultchar;
}

inline
bool CMath_Base::C_Attlist::IsSetLinebreakstyle(void) const
{
    return ((m_set_State[3] & 0x30000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLinebreakstyle(void) const
{
    return IsSetLinebreakstyle();
}

inline
void CMath_Base::C_Attlist::ResetLinebreakstyle(void)
{
    m_Linebreakstyle = (EAttlist_linebreakstyle)(0);
    m_set_State[3] &= ~0x30000000;
}

inline
CMath_Base::C_Attlist::TLinebreakstyle CMath_Base::C_Attlist::GetLinebreakstyle(void) const
{
    if (!CanGetLinebreakstyle()) {
        ThrowUnassigned(62);
    }
    return m_Linebreakstyle;
}

inline
void CMath_Base::C_Attlist::SetLinebreakstyle(CMath_Base::C_Attlist::TLinebreakstyle value)
{
    m_Linebreakstyle = value;
    m_set_State[3] |= 0x30000000;
}

inline
CMath_Base::C_Attlist::TLinebreakstyle& CMath_Base::C_Attlist::SetLinebreakstyle(void)
{
#ifdef _DEBUG
    if (!IsSetLinebreakstyle()) {
        memset(&m_Linebreakstyle,UnassignedByte(),sizeof(m_Linebreakstyle));
    }
#endif
    m_set_State[3] |= 0x10000000;
    return m_Linebreakstyle;
}

inline
bool CMath_Base::C_Attlist::IsSetLineleading(void) const
{
    return ((m_set_State[3] & 0xc0000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLineleading(void) const
{
    return IsSetLineleading();
}

inline
const CMath_Base::C_Attlist::TLineleading& CMath_Base::C_Attlist::GetLineleading(void) const
{
    if (!CanGetLineleading()) {
        ThrowUnassigned(63);
    }
    return m_Lineleading;
}

inline
void CMath_Base::C_Attlist::SetLineleading(const CMath_Base::C_Attlist::TLineleading& value)
{
    m_Lineleading = value;
    m_set_State[3] |= 0xc0000000;
}

inline
void CMath_Base::C_Attlist::SetLineleading(CMath_Base::C_Attlist::TLineleading&& value)
{
    m_Lineleading = std::forward<CMath_Base::C_Attlist::TLineleading>(value);
    m_set_State[3] |= 0xc0000000;
}

inline
CMath_Base::C_Attlist::TLineleading& CMath_Base::C_Attlist::SetLineleading(void)
{
#ifdef _DEBUG
    if (!IsSetLineleading()) {
        m_Lineleading = UnassignedString();
    }
#endif
    m_set_State[3] |= 0x40000000;
    return m_Lineleading;
}

inline
bool CMath_Base::C_Attlist::IsSetLinethickness(void) const
{
    return ((m_set_State[4] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLinethickness(void) const
{
    return IsSetLinethickness();
}

inline
const CMath_Base::C_Attlist::TLinethickness& CMath_Base::C_Attlist::GetLinethickness(void) const
{
    if (!CanGetLinethickness()) {
        ThrowUnassigned(64);
    }
    return m_Linethickness;
}

inline
void CMath_Base::C_Attlist::SetLinethickness(const CMath_Base::C_Attlist::TLinethickness& value)
{
    m_Linethickness = value;
    m_set_State[4] |= 0x3;
}

inline
void CMath_Base::C_Attlist::SetLinethickness(CMath_Base::C_Attlist::TLinethickness&& value)
{
    m_Linethickness = std::forward<CMath_Base::C_Attlist::TLinethickness>(value);
    m_set_State[4] |= 0x3;
}

inline
CMath_Base::C_Attlist::TLinethickness& CMath_Base::C_Attlist::SetLinethickness(void)
{
#ifdef _DEBUG
    if (!IsSetLinethickness()) {
        m_Linethickness = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x1;
    return m_Linethickness;
}

inline
bool CMath_Base::C_Attlist::IsSetLocation(void) const
{
    return ((m_set_State[4] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
void CMath_Base::C_Attlist::ResetLocation(void)
{
    m_Location = (EAttlist_location)(0);
    m_set_State[4] &= ~0xc;
}

inline
CMath_Base::C_Attlist::TLocation CMath_Base::C_Attlist::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(65);
    }
    return m_Location;
}

inline
void CMath_Base::C_Attlist::SetLocation(CMath_Base::C_Attlist::TLocation value)
{
    m_Location = value;
    m_set_State[4] |= 0xc;
}

inline
CMath_Base::C_Attlist::TLocation& CMath_Base::C_Attlist::SetLocation(void)
{
#ifdef _DEBUG
    if (!IsSetLocation()) {
        memset(&m_Location,UnassignedByte(),sizeof(m_Location));
    }
#endif
    m_set_State[4] |= 0x4;
    return m_Location;
}

inline
bool CMath_Base::C_Attlist::IsSetLongdivstyle(void) const
{
    return ((m_set_State[4] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLongdivstyle(void) const
{
    return IsSetLongdivstyle();
}

inline
const CMath_Base::C_Attlist::TLongdivstyle& CMath_Base::C_Attlist::GetLongdivstyle(void) const
{
    if (!CanGetLongdivstyle()) {
        ThrowUnassigned(66);
    }
    return m_Longdivstyle;
}

inline
void CMath_Base::C_Attlist::SetLongdivstyle(const CMath_Base::C_Attlist::TLongdivstyle& value)
{
    m_Longdivstyle = value;
    m_set_State[4] |= 0x30;
}

inline
void CMath_Base::C_Attlist::SetLongdivstyle(CMath_Base::C_Attlist::TLongdivstyle&& value)
{
    m_Longdivstyle = std::forward<CMath_Base::C_Attlist::TLongdivstyle>(value);
    m_set_State[4] |= 0x30;
}

inline
CMath_Base::C_Attlist::TLongdivstyle& CMath_Base::C_Attlist::SetLongdivstyle(void)
{
#ifdef _DEBUG
    if (!IsSetLongdivstyle()) {
        m_Longdivstyle = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x10;
    return m_Longdivstyle;
}

inline
bool CMath_Base::C_Attlist::IsSetLquote(void) const
{
    return ((m_set_State[4] & 0xc0) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLquote(void) const
{
    return IsSetLquote();
}

inline
const CMath_Base::C_Attlist::TLquote& CMath_Base::C_Attlist::GetLquote(void) const
{
    if (!CanGetLquote()) {
        ThrowUnassigned(67);
    }
    return m_Lquote;
}

inline
void CMath_Base::C_Attlist::SetLquote(const CMath_Base::C_Attlist::TLquote& value)
{
    m_Lquote = value;
    m_set_State[4] |= 0xc0;
}

inline
void CMath_Base::C_Attlist::SetLquote(CMath_Base::C_Attlist::TLquote&& value)
{
    m_Lquote = std::forward<CMath_Base::C_Attlist::TLquote>(value);
    m_set_State[4] |= 0xc0;
}

inline
CMath_Base::C_Attlist::TLquote& CMath_Base::C_Attlist::SetLquote(void)
{
#ifdef _DEBUG
    if (!IsSetLquote()) {
        m_Lquote = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x40;
    return m_Lquote;
}

inline
bool CMath_Base::C_Attlist::IsSetLspace(void) const
{
    return ((m_set_State[4] & 0x300) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetLspace(void) const
{
    return IsSetLspace();
}

inline
const CMath_Base::C_Attlist::TLspace& CMath_Base::C_Attlist::GetLspace(void) const
{
    if (!CanGetLspace()) {
        ThrowUnassigned(68);
    }
    return m_Lspace;
}

inline
void CMath_Base::C_Attlist::SetLspace(const CMath_Base::C_Attlist::TLspace& value)
{
    m_Lspace = value;
    m_set_State[4] |= 0x300;
}

inline
void CMath_Base::C_Attlist::SetLspace(CMath_Base::C_Attlist::TLspace&& value)
{
    m_Lspace = std::forward<CMath_Base::C_Attlist::TLspace>(value);
    m_set_State[4] |= 0x300;
}

inline
CMath_Base::C_Attlist::TLspace& CMath_Base::C_Attlist::SetLspace(void)
{
#ifdef _DEBUG
    if (!IsSetLspace()) {
        m_Lspace = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x100;
    return m_Lspace;
}

inline
bool CMath_Base::C_Attlist::IsSetMathsize(void) const
{
    return ((m_set_State[4] & 0xc00) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMathsize(void) const
{
    return IsSetMathsize();
}

inline
const CMath_Base::C_Attlist::TMathsize& CMath_Base::C_Attlist::GetMathsize(void) const
{
    if (!CanGetMathsize()) {
        ThrowUnassigned(69);
    }
    return m_Mathsize;
}

inline
void CMath_Base::C_Attlist::SetMathsize(const CMath_Base::C_Attlist::TMathsize& value)
{
    m_Mathsize = value;
    m_set_State[4] |= 0xc00;
}

inline
void CMath_Base::C_Attlist::SetMathsize(CMath_Base::C_Attlist::TMathsize&& value)
{
    m_Mathsize = std::forward<CMath_Base::C_Attlist::TMathsize>(value);
    m_set_State[4] |= 0xc00;
}

inline
CMath_Base::C_Attlist::TMathsize& CMath_Base::C_Attlist::SetMathsize(void)
{
#ifdef _DEBUG
    if (!IsSetMathsize()) {
        m_Mathsize = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x400;
    return m_Mathsize;
}

inline
bool CMath_Base::C_Attlist::IsSetMathvariant(void) const
{
    return ((m_set_State[4] & 0x3000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMathvariant(void) const
{
    return IsSetMathvariant();
}

inline
void CMath_Base::C_Attlist::ResetMathvariant(void)
{
    m_Mathvariant = (EAttlist_mathvariant)(0);
    m_set_State[4] &= ~0x3000;
}

inline
CMath_Base::C_Attlist::TMathvariant CMath_Base::C_Attlist::GetMathvariant(void) const
{
    if (!CanGetMathvariant()) {
        ThrowUnassigned(70);
    }
    return m_Mathvariant;
}

inline
void CMath_Base::C_Attlist::SetMathvariant(CMath_Base::C_Attlist::TMathvariant value)
{
    m_Mathvariant = value;
    m_set_State[4] |= 0x3000;
}

inline
CMath_Base::C_Attlist::TMathvariant& CMath_Base::C_Attlist::SetMathvariant(void)
{
#ifdef _DEBUG
    if (!IsSetMathvariant()) {
        memset(&m_Mathvariant,UnassignedByte(),sizeof(m_Mathvariant));
    }
#endif
    m_set_State[4] |= 0x1000;
    return m_Mathvariant;
}

inline
bool CMath_Base::C_Attlist::IsSetMaxsize(void) const
{
    return ((m_set_State[4] & 0xc000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMaxsize(void) const
{
    return IsSetMaxsize();
}

inline
const CMath_Base::C_Attlist::TMaxsize& CMath_Base::C_Attlist::GetMaxsize(void) const
{
    if (!CanGetMaxsize()) {
        ThrowUnassigned(71);
    }
    return m_Maxsize;
}

inline
void CMath_Base::C_Attlist::SetMaxsize(const CMath_Base::C_Attlist::TMaxsize& value)
{
    m_Maxsize = value;
    m_set_State[4] |= 0xc000;
}

inline
void CMath_Base::C_Attlist::SetMaxsize(CMath_Base::C_Attlist::TMaxsize&& value)
{
    m_Maxsize = std::forward<CMath_Base::C_Attlist::TMaxsize>(value);
    m_set_State[4] |= 0xc000;
}

inline
CMath_Base::C_Attlist::TMaxsize& CMath_Base::C_Attlist::SetMaxsize(void)
{
#ifdef _DEBUG
    if (!IsSetMaxsize()) {
        m_Maxsize = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x4000;
    return m_Maxsize;
}

inline
bool CMath_Base::C_Attlist::IsSetMinlabelspacing(void) const
{
    return ((m_set_State[4] & 0x30000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMinlabelspacing(void) const
{
    return IsSetMinlabelspacing();
}

inline
const CMath_Base::C_Attlist::TMinlabelspacing& CMath_Base::C_Attlist::GetMinlabelspacing(void) const
{
    if (!CanGetMinlabelspacing()) {
        ThrowUnassigned(72);
    }
    return m_Minlabelspacing;
}

inline
void CMath_Base::C_Attlist::SetMinlabelspacing(const CMath_Base::C_Attlist::TMinlabelspacing& value)
{
    m_Minlabelspacing = value;
    m_set_State[4] |= 0x30000;
}

inline
void CMath_Base::C_Attlist::SetMinlabelspacing(CMath_Base::C_Attlist::TMinlabelspacing&& value)
{
    m_Minlabelspacing = std::forward<CMath_Base::C_Attlist::TMinlabelspacing>(value);
    m_set_State[4] |= 0x30000;
}

inline
CMath_Base::C_Attlist::TMinlabelspacing& CMath_Base::C_Attlist::SetMinlabelspacing(void)
{
#ifdef _DEBUG
    if (!IsSetMinlabelspacing()) {
        m_Minlabelspacing = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x10000;
    return m_Minlabelspacing;
}

inline
bool CMath_Base::C_Attlist::IsSetMinsize(void) const
{
    return ((m_set_State[4] & 0xc0000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMinsize(void) const
{
    return IsSetMinsize();
}

inline
const CMath_Base::C_Attlist::TMinsize& CMath_Base::C_Attlist::GetMinsize(void) const
{
    if (!CanGetMinsize()) {
        ThrowUnassigned(73);
    }
    return m_Minsize;
}

inline
void CMath_Base::C_Attlist::SetMinsize(const CMath_Base::C_Attlist::TMinsize& value)
{
    m_Minsize = value;
    m_set_State[4] |= 0xc0000;
}

inline
void CMath_Base::C_Attlist::SetMinsize(CMath_Base::C_Attlist::TMinsize&& value)
{
    m_Minsize = std::forward<CMath_Base::C_Attlist::TMinsize>(value);
    m_set_State[4] |= 0xc0000;
}

inline
CMath_Base::C_Attlist::TMinsize& CMath_Base::C_Attlist::SetMinsize(void)
{
#ifdef _DEBUG
    if (!IsSetMinsize()) {
        m_Minsize = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x40000;
    return m_Minsize;
}

inline
bool CMath_Base::C_Attlist::IsSetMovablelimits(void) const
{
    return ((m_set_State[4] & 0x300000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMovablelimits(void) const
{
    return IsSetMovablelimits();
}

inline
void CMath_Base::C_Attlist::ResetMovablelimits(void)
{
    m_Movablelimits = (EAttlist_movablelimits)(0);
    m_set_State[4] &= ~0x300000;
}

inline
CMath_Base::C_Attlist::TMovablelimits CMath_Base::C_Attlist::GetMovablelimits(void) const
{
    if (!CanGetMovablelimits()) {
        ThrowUnassigned(74);
    }
    return m_Movablelimits;
}

inline
void CMath_Base::C_Attlist::SetMovablelimits(CMath_Base::C_Attlist::TMovablelimits value)
{
    m_Movablelimits = value;
    m_set_State[4] |= 0x300000;
}

inline
CMath_Base::C_Attlist::TMovablelimits& CMath_Base::C_Attlist::SetMovablelimits(void)
{
#ifdef _DEBUG
    if (!IsSetMovablelimits()) {
        memset(&m_Movablelimits,UnassignedByte(),sizeof(m_Movablelimits));
    }
#endif
    m_set_State[4] |= 0x100000;
    return m_Movablelimits;
}

inline
bool CMath_Base::C_Attlist::IsSetMslinethickness(void) const
{
    return ((m_set_State[4] & 0xc00000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetMslinethickness(void) const
{
    return IsSetMslinethickness();
}

inline
const CMath_Base::C_Attlist::TMslinethickness& CMath_Base::C_Attlist::GetMslinethickness(void) const
{
    if (!CanGetMslinethickness()) {
        ThrowUnassigned(75);
    }
    return m_Mslinethickness;
}

inline
void CMath_Base::C_Attlist::SetMslinethickness(const CMath_Base::C_Attlist::TMslinethickness& value)
{
    m_Mslinethickness = value;
    m_set_State[4] |= 0xc00000;
}

inline
void CMath_Base::C_Attlist::SetMslinethickness(CMath_Base::C_Attlist::TMslinethickness&& value)
{
    m_Mslinethickness = std::forward<CMath_Base::C_Attlist::TMslinethickness>(value);
    m_set_State[4] |= 0xc00000;
}

inline
CMath_Base::C_Attlist::TMslinethickness& CMath_Base::C_Attlist::SetMslinethickness(void)
{
#ifdef _DEBUG
    if (!IsSetMslinethickness()) {
        m_Mslinethickness = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x400000;
    return m_Mslinethickness;
}

inline
bool CMath_Base::C_Attlist::IsSetNotation(void) const
{
    return ((m_set_State[4] & 0x3000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetNotation(void) const
{
    return IsSetNotation();
}

inline
const CMath_Base::C_Attlist::TNotation& CMath_Base::C_Attlist::GetNotation(void) const
{
    if (!CanGetNotation()) {
        ThrowUnassigned(76);
    }
    return m_Notation;
}

inline
void CMath_Base::C_Attlist::SetNotation(const CMath_Base::C_Attlist::TNotation& value)
{
    m_Notation = value;
    m_set_State[4] |= 0x3000000;
}

inline
void CMath_Base::C_Attlist::SetNotation(CMath_Base::C_Attlist::TNotation&& value)
{
    m_Notation = std::forward<CMath_Base::C_Attlist::TNotation>(value);
    m_set_State[4] |= 0x3000000;
}

inline
CMath_Base::C_Attlist::TNotation& CMath_Base::C_Attlist::SetNotation(void)
{
#ifdef _DEBUG
    if (!IsSetNotation()) {
        m_Notation = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x1000000;
    return m_Notation;
}

inline
bool CMath_Base::C_Attlist::IsSetNumalign(void) const
{
    return ((m_set_State[4] & 0xc000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetNumalign(void) const
{
    return IsSetNumalign();
}

inline
void CMath_Base::C_Attlist::ResetNumalign(void)
{
    m_Numalign = (EAttlist_numalign)(0);
    m_set_State[4] &= ~0xc000000;
}

inline
CMath_Base::C_Attlist::TNumalign CMath_Base::C_Attlist::GetNumalign(void) const
{
    if (!CanGetNumalign()) {
        ThrowUnassigned(77);
    }
    return m_Numalign;
}

inline
void CMath_Base::C_Attlist::SetNumalign(CMath_Base::C_Attlist::TNumalign value)
{
    m_Numalign = value;
    m_set_State[4] |= 0xc000000;
}

inline
CMath_Base::C_Attlist::TNumalign& CMath_Base::C_Attlist::SetNumalign(void)
{
#ifdef _DEBUG
    if (!IsSetNumalign()) {
        memset(&m_Numalign,UnassignedByte(),sizeof(m_Numalign));
    }
#endif
    m_set_State[4] |= 0x4000000;
    return m_Numalign;
}

inline
bool CMath_Base::C_Attlist::IsSetOpen(void) const
{
    return ((m_set_State[4] & 0x30000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetOpen(void) const
{
    return IsSetOpen();
}

inline
const CMath_Base::C_Attlist::TOpen& CMath_Base::C_Attlist::GetOpen(void) const
{
    if (!CanGetOpen()) {
        ThrowUnassigned(78);
    }
    return m_Open;
}

inline
void CMath_Base::C_Attlist::SetOpen(const CMath_Base::C_Attlist::TOpen& value)
{
    m_Open = value;
    m_set_State[4] |= 0x30000000;
}

inline
void CMath_Base::C_Attlist::SetOpen(CMath_Base::C_Attlist::TOpen&& value)
{
    m_Open = std::forward<CMath_Base::C_Attlist::TOpen>(value);
    m_set_State[4] |= 0x30000000;
}

inline
CMath_Base::C_Attlist::TOpen& CMath_Base::C_Attlist::SetOpen(void)
{
#ifdef _DEBUG
    if (!IsSetOpen()) {
        m_Open = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x10000000;
    return m_Open;
}

inline
bool CMath_Base::C_Attlist::IsSetPosition(void) const
{
    return ((m_set_State[4] & 0xc0000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetPosition(void) const
{
    return IsSetPosition();
}

inline
const CMath_Base::C_Attlist::TPosition& CMath_Base::C_Attlist::GetPosition(void) const
{
    if (!CanGetPosition()) {
        ThrowUnassigned(79);
    }
    return m_Position;
}

inline
void CMath_Base::C_Attlist::SetPosition(const CMath_Base::C_Attlist::TPosition& value)
{
    m_Position = value;
    m_set_State[4] |= 0xc0000000;
}

inline
void CMath_Base::C_Attlist::SetPosition(CMath_Base::C_Attlist::TPosition&& value)
{
    m_Position = std::forward<CMath_Base::C_Attlist::TPosition>(value);
    m_set_State[4] |= 0xc0000000;
}

inline
CMath_Base::C_Attlist::TPosition& CMath_Base::C_Attlist::SetPosition(void)
{
#ifdef _DEBUG
    if (!IsSetPosition()) {
        m_Position = UnassignedString();
    }
#endif
    m_set_State[4] |= 0x40000000;
    return m_Position;
}

inline
bool CMath_Base::C_Attlist::IsSetRightoverhang(void) const
{
    return ((m_set_State[5] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRightoverhang(void) const
{
    return IsSetRightoverhang();
}

inline
const CMath_Base::C_Attlist::TRightoverhang& CMath_Base::C_Attlist::GetRightoverhang(void) const
{
    if (!CanGetRightoverhang()) {
        ThrowUnassigned(80);
    }
    return m_Rightoverhang;
}

inline
void CMath_Base::C_Attlist::SetRightoverhang(const CMath_Base::C_Attlist::TRightoverhang& value)
{
    m_Rightoverhang = value;
    m_set_State[5] |= 0x3;
}

inline
void CMath_Base::C_Attlist::SetRightoverhang(CMath_Base::C_Attlist::TRightoverhang&& value)
{
    m_Rightoverhang = std::forward<CMath_Base::C_Attlist::TRightoverhang>(value);
    m_set_State[5] |= 0x3;
}

inline
CMath_Base::C_Attlist::TRightoverhang& CMath_Base::C_Attlist::SetRightoverhang(void)
{
#ifdef _DEBUG
    if (!IsSetRightoverhang()) {
        m_Rightoverhang = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x1;
    return m_Rightoverhang;
}

inline
bool CMath_Base::C_Attlist::IsSetRowalign(void) const
{
    return ((m_set_State[5] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRowalign(void) const
{
    return IsSetRowalign();
}

inline
const CMath_Base::C_Attlist::TRowalign& CMath_Base::C_Attlist::GetRowalign(void) const
{
    if (!CanGetRowalign()) {
        ThrowUnassigned(81);
    }
    return m_Rowalign;
}

inline
void CMath_Base::C_Attlist::SetRowalign(const CMath_Base::C_Attlist::TRowalign& value)
{
    m_Rowalign = value;
    m_set_State[5] |= 0xc;
}

inline
void CMath_Base::C_Attlist::SetRowalign(CMath_Base::C_Attlist::TRowalign&& value)
{
    m_Rowalign = std::forward<CMath_Base::C_Attlist::TRowalign>(value);
    m_set_State[5] |= 0xc;
}

inline
CMath_Base::C_Attlist::TRowalign& CMath_Base::C_Attlist::SetRowalign(void)
{
#ifdef _DEBUG
    if (!IsSetRowalign()) {
        m_Rowalign = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x4;
    return m_Rowalign;
}

inline
bool CMath_Base::C_Attlist::IsSetRowlines(void) const
{
    return ((m_set_State[5] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRowlines(void) const
{
    return IsSetRowlines();
}

inline
const CMath_Base::C_Attlist::TRowlines& CMath_Base::C_Attlist::GetRowlines(void) const
{
    if (!CanGetRowlines()) {
        ThrowUnassigned(82);
    }
    return m_Rowlines;
}

inline
void CMath_Base::C_Attlist::SetRowlines(const CMath_Base::C_Attlist::TRowlines& value)
{
    m_Rowlines = value;
    m_set_State[5] |= 0x30;
}

inline
void CMath_Base::C_Attlist::SetRowlines(CMath_Base::C_Attlist::TRowlines&& value)
{
    m_Rowlines = std::forward<CMath_Base::C_Attlist::TRowlines>(value);
    m_set_State[5] |= 0x30;
}

inline
CMath_Base::C_Attlist::TRowlines& CMath_Base::C_Attlist::SetRowlines(void)
{
#ifdef _DEBUG
    if (!IsSetRowlines()) {
        m_Rowlines = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x10;
    return m_Rowlines;
}

inline
bool CMath_Base::C_Attlist::IsSetRowspacing(void) const
{
    return ((m_set_State[5] & 0xc0) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRowspacing(void) const
{
    return IsSetRowspacing();
}

inline
const CMath_Base::C_Attlist::TRowspacing& CMath_Base::C_Attlist::GetRowspacing(void) const
{
    if (!CanGetRowspacing()) {
        ThrowUnassigned(83);
    }
    return m_Rowspacing;
}

inline
void CMath_Base::C_Attlist::SetRowspacing(const CMath_Base::C_Attlist::TRowspacing& value)
{
    m_Rowspacing = value;
    m_set_State[5] |= 0xc0;
}

inline
void CMath_Base::C_Attlist::SetRowspacing(CMath_Base::C_Attlist::TRowspacing&& value)
{
    m_Rowspacing = std::forward<CMath_Base::C_Attlist::TRowspacing>(value);
    m_set_State[5] |= 0xc0;
}

inline
CMath_Base::C_Attlist::TRowspacing& CMath_Base::C_Attlist::SetRowspacing(void)
{
#ifdef _DEBUG
    if (!IsSetRowspacing()) {
        m_Rowspacing = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x40;
    return m_Rowspacing;
}

inline
bool CMath_Base::C_Attlist::IsSetRowspan(void) const
{
    return ((m_set_State[5] & 0x300) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRowspan(void) const
{
    return IsSetRowspan();
}

inline
const CMath_Base::C_Attlist::TRowspan& CMath_Base::C_Attlist::GetRowspan(void) const
{
    if (!CanGetRowspan()) {
        ThrowUnassigned(84);
    }
    return m_Rowspan;
}

inline
void CMath_Base::C_Attlist::SetRowspan(const CMath_Base::C_Attlist::TRowspan& value)
{
    m_Rowspan = value;
    m_set_State[5] |= 0x300;
}

inline
void CMath_Base::C_Attlist::SetRowspan(CMath_Base::C_Attlist::TRowspan&& value)
{
    m_Rowspan = std::forward<CMath_Base::C_Attlist::TRowspan>(value);
    m_set_State[5] |= 0x300;
}

inline
CMath_Base::C_Attlist::TRowspan& CMath_Base::C_Attlist::SetRowspan(void)
{
#ifdef _DEBUG
    if (!IsSetRowspan()) {
        m_Rowspan = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x100;
    return m_Rowspan;
}

inline
bool CMath_Base::C_Attlist::IsSetRquote(void) const
{
    return ((m_set_State[5] & 0xc00) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRquote(void) const
{
    return IsSetRquote();
}

inline
const CMath_Base::C_Attlist::TRquote& CMath_Base::C_Attlist::GetRquote(void) const
{
    if (!CanGetRquote()) {
        ThrowUnassigned(85);
    }
    return m_Rquote;
}

inline
void CMath_Base::C_Attlist::SetRquote(const CMath_Base::C_Attlist::TRquote& value)
{
    m_Rquote = value;
    m_set_State[5] |= 0xc00;
}

inline
void CMath_Base::C_Attlist::SetRquote(CMath_Base::C_Attlist::TRquote&& value)
{
    m_Rquote = std::forward<CMath_Base::C_Attlist::TRquote>(value);
    m_set_State[5] |= 0xc00;
}

inline
CMath_Base::C_Attlist::TRquote& CMath_Base::C_Attlist::SetRquote(void)
{
#ifdef _DEBUG
    if (!IsSetRquote()) {
        m_Rquote = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x400;
    return m_Rquote;
}

inline
bool CMath_Base::C_Attlist::IsSetRspace(void) const
{
    return ((m_set_State[5] & 0x3000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetRspace(void) const
{
    return IsSetRspace();
}

inline
const CMath_Base::C_Attlist::TRspace& CMath_Base::C_Attlist::GetRspace(void) const
{
    if (!CanGetRspace()) {
        ThrowUnassigned(86);
    }
    return m_Rspace;
}

inline
void CMath_Base::C_Attlist::SetRspace(const CMath_Base::C_Attlist::TRspace& value)
{
    m_Rspace = value;
    m_set_State[5] |= 0x3000;
}

inline
void CMath_Base::C_Attlist::SetRspace(CMath_Base::C_Attlist::TRspace&& value)
{
    m_Rspace = std::forward<CMath_Base::C_Attlist::TRspace>(value);
    m_set_State[5] |= 0x3000;
}

inline
CMath_Base::C_Attlist::TRspace& CMath_Base::C_Attlist::SetRspace(void)
{
#ifdef _DEBUG
    if (!IsSetRspace()) {
        m_Rspace = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x1000;
    return m_Rspace;
}

inline
bool CMath_Base::C_Attlist::IsSetSelection(void) const
{
    return ((m_set_State[5] & 0xc000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSelection(void) const
{
    return IsSetSelection();
}

inline
const CMath_Base::C_Attlist::TSelection& CMath_Base::C_Attlist::GetSelection(void) const
{
    if (!CanGetSelection()) {
        ThrowUnassigned(87);
    }
    return m_Selection;
}

inline
void CMath_Base::C_Attlist::SetSelection(const CMath_Base::C_Attlist::TSelection& value)
{
    m_Selection = value;
    m_set_State[5] |= 0xc000;
}

inline
void CMath_Base::C_Attlist::SetSelection(CMath_Base::C_Attlist::TSelection&& value)
{
    m_Selection = std::forward<CMath_Base::C_Attlist::TSelection>(value);
    m_set_State[5] |= 0xc000;
}

inline
CMath_Base::C_Attlist::TSelection& CMath_Base::C_Attlist::SetSelection(void)
{
#ifdef _DEBUG
    if (!IsSetSelection()) {
        m_Selection = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x4000;
    return m_Selection;
}

inline
bool CMath_Base::C_Attlist::IsSetSeparator(void) const
{
    return ((m_set_State[5] & 0x30000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSeparator(void) const
{
    return IsSetSeparator();
}

inline
void CMath_Base::C_Attlist::ResetSeparator(void)
{
    m_Separator = (EAttlist_separator)(0);
    m_set_State[5] &= ~0x30000;
}

inline
CMath_Base::C_Attlist::TSeparator CMath_Base::C_Attlist::GetSeparator(void) const
{
    if (!CanGetSeparator()) {
        ThrowUnassigned(88);
    }
    return m_Separator;
}

inline
void CMath_Base::C_Attlist::SetSeparator(CMath_Base::C_Attlist::TSeparator value)
{
    m_Separator = value;
    m_set_State[5] |= 0x30000;
}

inline
CMath_Base::C_Attlist::TSeparator& CMath_Base::C_Attlist::SetSeparator(void)
{
#ifdef _DEBUG
    if (!IsSetSeparator()) {
        memset(&m_Separator,UnassignedByte(),sizeof(m_Separator));
    }
#endif
    m_set_State[5] |= 0x10000;
    return m_Separator;
}

inline
bool CMath_Base::C_Attlist::IsSetSeparators(void) const
{
    return ((m_set_State[5] & 0xc0000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSeparators(void) const
{
    return IsSetSeparators();
}

inline
const CMath_Base::C_Attlist::TSeparators& CMath_Base::C_Attlist::GetSeparators(void) const
{
    if (!CanGetSeparators()) {
        ThrowUnassigned(89);
    }
    return m_Separators;
}

inline
void CMath_Base::C_Attlist::SetSeparators(const CMath_Base::C_Attlist::TSeparators& value)
{
    m_Separators = value;
    m_set_State[5] |= 0xc0000;
}

inline
void CMath_Base::C_Attlist::SetSeparators(CMath_Base::C_Attlist::TSeparators&& value)
{
    m_Separators = std::forward<CMath_Base::C_Attlist::TSeparators>(value);
    m_set_State[5] |= 0xc0000;
}

inline
CMath_Base::C_Attlist::TSeparators& CMath_Base::C_Attlist::SetSeparators(void)
{
#ifdef _DEBUG
    if (!IsSetSeparators()) {
        m_Separators = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x40000;
    return m_Separators;
}

inline
bool CMath_Base::C_Attlist::IsSetShift(void) const
{
    return ((m_set_State[5] & 0x300000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetShift(void) const
{
    return IsSetShift();
}

inline
const CMath_Base::C_Attlist::TShift& CMath_Base::C_Attlist::GetShift(void) const
{
    if (!CanGetShift()) {
        ThrowUnassigned(90);
    }
    return m_Shift;
}

inline
void CMath_Base::C_Attlist::SetShift(const CMath_Base::C_Attlist::TShift& value)
{
    m_Shift = value;
    m_set_State[5] |= 0x300000;
}

inline
void CMath_Base::C_Attlist::SetShift(CMath_Base::C_Attlist::TShift&& value)
{
    m_Shift = std::forward<CMath_Base::C_Attlist::TShift>(value);
    m_set_State[5] |= 0x300000;
}

inline
CMath_Base::C_Attlist::TShift& CMath_Base::C_Attlist::SetShift(void)
{
#ifdef _DEBUG
    if (!IsSetShift()) {
        m_Shift = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x100000;
    return m_Shift;
}

inline
bool CMath_Base::C_Attlist::IsSetSide(void) const
{
    return ((m_set_State[5] & 0xc00000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSide(void) const
{
    return IsSetSide();
}

inline
void CMath_Base::C_Attlist::ResetSide(void)
{
    m_Side = (EAttlist_side)(0);
    m_set_State[5] &= ~0xc00000;
}

inline
CMath_Base::C_Attlist::TSide CMath_Base::C_Attlist::GetSide(void) const
{
    if (!CanGetSide()) {
        ThrowUnassigned(91);
    }
    return m_Side;
}

inline
void CMath_Base::C_Attlist::SetSide(CMath_Base::C_Attlist::TSide value)
{
    m_Side = value;
    m_set_State[5] |= 0xc00000;
}

inline
CMath_Base::C_Attlist::TSide& CMath_Base::C_Attlist::SetSide(void)
{
#ifdef _DEBUG
    if (!IsSetSide()) {
        memset(&m_Side,UnassignedByte(),sizeof(m_Side));
    }
#endif
    m_set_State[5] |= 0x400000;
    return m_Side;
}

inline
bool CMath_Base::C_Attlist::IsSetStackalign(void) const
{
    return ((m_set_State[5] & 0x3000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetStackalign(void) const
{
    return IsSetStackalign();
}

inline
void CMath_Base::C_Attlist::ResetStackalign(void)
{
    m_Stackalign = (EAttlist_stackalign)(0);
    m_set_State[5] &= ~0x3000000;
}

inline
CMath_Base::C_Attlist::TStackalign CMath_Base::C_Attlist::GetStackalign(void) const
{
    if (!CanGetStackalign()) {
        ThrowUnassigned(92);
    }
    return m_Stackalign;
}

inline
void CMath_Base::C_Attlist::SetStackalign(CMath_Base::C_Attlist::TStackalign value)
{
    m_Stackalign = value;
    m_set_State[5] |= 0x3000000;
}

inline
CMath_Base::C_Attlist::TStackalign& CMath_Base::C_Attlist::SetStackalign(void)
{
#ifdef _DEBUG
    if (!IsSetStackalign()) {
        memset(&m_Stackalign,UnassignedByte(),sizeof(m_Stackalign));
    }
#endif
    m_set_State[5] |= 0x1000000;
    return m_Stackalign;
}

inline
bool CMath_Base::C_Attlist::IsSetStretchy(void) const
{
    return ((m_set_State[5] & 0xc000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetStretchy(void) const
{
    return IsSetStretchy();
}

inline
void CMath_Base::C_Attlist::ResetStretchy(void)
{
    m_Stretchy = (EAttlist_stretchy)(0);
    m_set_State[5] &= ~0xc000000;
}

inline
CMath_Base::C_Attlist::TStretchy CMath_Base::C_Attlist::GetStretchy(void) const
{
    if (!CanGetStretchy()) {
        ThrowUnassigned(93);
    }
    return m_Stretchy;
}

inline
void CMath_Base::C_Attlist::SetStretchy(CMath_Base::C_Attlist::TStretchy value)
{
    m_Stretchy = value;
    m_set_State[5] |= 0xc000000;
}

inline
CMath_Base::C_Attlist::TStretchy& CMath_Base::C_Attlist::SetStretchy(void)
{
#ifdef _DEBUG
    if (!IsSetStretchy()) {
        memset(&m_Stretchy,UnassignedByte(),sizeof(m_Stretchy));
    }
#endif
    m_set_State[5] |= 0x4000000;
    return m_Stretchy;
}

inline
bool CMath_Base::C_Attlist::IsSetSubscriptshift(void) const
{
    return ((m_set_State[5] & 0x30000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSubscriptshift(void) const
{
    return IsSetSubscriptshift();
}

inline
const CMath_Base::C_Attlist::TSubscriptshift& CMath_Base::C_Attlist::GetSubscriptshift(void) const
{
    if (!CanGetSubscriptshift()) {
        ThrowUnassigned(94);
    }
    return m_Subscriptshift;
}

inline
void CMath_Base::C_Attlist::SetSubscriptshift(const CMath_Base::C_Attlist::TSubscriptshift& value)
{
    m_Subscriptshift = value;
    m_set_State[5] |= 0x30000000;
}

inline
void CMath_Base::C_Attlist::SetSubscriptshift(CMath_Base::C_Attlist::TSubscriptshift&& value)
{
    m_Subscriptshift = std::forward<CMath_Base::C_Attlist::TSubscriptshift>(value);
    m_set_State[5] |= 0x30000000;
}

inline
CMath_Base::C_Attlist::TSubscriptshift& CMath_Base::C_Attlist::SetSubscriptshift(void)
{
#ifdef _DEBUG
    if (!IsSetSubscriptshift()) {
        m_Subscriptshift = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x10000000;
    return m_Subscriptshift;
}

inline
bool CMath_Base::C_Attlist::IsSetSuperscriptshift(void) const
{
    return ((m_set_State[5] & 0xc0000000) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSuperscriptshift(void) const
{
    return IsSetSuperscriptshift();
}

inline
const CMath_Base::C_Attlist::TSuperscriptshift& CMath_Base::C_Attlist::GetSuperscriptshift(void) const
{
    if (!CanGetSuperscriptshift()) {
        ThrowUnassigned(95);
    }
    return m_Superscriptshift;
}

inline
void CMath_Base::C_Attlist::SetSuperscriptshift(const CMath_Base::C_Attlist::TSuperscriptshift& value)
{
    m_Superscriptshift = value;
    m_set_State[5] |= 0xc0000000;
}

inline
void CMath_Base::C_Attlist::SetSuperscriptshift(CMath_Base::C_Attlist::TSuperscriptshift&& value)
{
    m_Superscriptshift = std::forward<CMath_Base::C_Attlist::TSuperscriptshift>(value);
    m_set_State[5] |= 0xc0000000;
}

inline
CMath_Base::C_Attlist::TSuperscriptshift& CMath_Base::C_Attlist::SetSuperscriptshift(void)
{
#ifdef _DEBUG
    if (!IsSetSuperscriptshift()) {
        m_Superscriptshift = UnassignedString();
    }
#endif
    m_set_State[5] |= 0x40000000;
    return m_Superscriptshift;
}

inline
bool CMath_Base::C_Attlist::IsSetSymmetric(void) const
{
    return ((m_set_State[6] & 0x3) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetSymmetric(void) const
{
    return IsSetSymmetric();
}

inline
void CMath_Base::C_Attlist::ResetSymmetric(void)
{
    m_Symmetric = (EAttlist_symmetric)(0);
    m_set_State[6] &= ~0x3;
}

inline
CMath_Base::C_Attlist::TSymmetric CMath_Base::C_Attlist::GetSymmetric(void) const
{
    if (!CanGetSymmetric()) {
        ThrowUnassigned(96);
    }
    return m_Symmetric;
}

inline
void CMath_Base::C_Attlist::SetSymmetric(CMath_Base::C_Attlist::TSymmetric value)
{
    m_Symmetric = value;
    m_set_State[6] |= 0x3;
}

inline
CMath_Base::C_Attlist::TSymmetric& CMath_Base::C_Attlist::SetSymmetric(void)
{
#ifdef _DEBUG
    if (!IsSetSymmetric()) {
        memset(&m_Symmetric,UnassignedByte(),sizeof(m_Symmetric));
    }
#endif
    m_set_State[6] |= 0x1;
    return m_Symmetric;
}

inline
bool CMath_Base::C_Attlist::IsSetValign(void) const
{
    return ((m_set_State[6] & 0xc) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetValign(void) const
{
    return IsSetValign();
}

inline
const CMath_Base::C_Attlist::TValign& CMath_Base::C_Attlist::GetValign(void) const
{
    if (!CanGetValign()) {
        ThrowUnassigned(97);
    }
    return m_Valign;
}

inline
void CMath_Base::C_Attlist::SetValign(const CMath_Base::C_Attlist::TValign& value)
{
    m_Valign = value;
    m_set_State[6] |= 0xc;
}

inline
void CMath_Base::C_Attlist::SetValign(CMath_Base::C_Attlist::TValign&& value)
{
    m_Valign = std::forward<CMath_Base::C_Attlist::TValign>(value);
    m_set_State[6] |= 0xc;
}

inline
CMath_Base::C_Attlist::TValign& CMath_Base::C_Attlist::SetValign(void)
{
#ifdef _DEBUG
    if (!IsSetValign()) {
        m_Valign = UnassignedString();
    }
#endif
    m_set_State[6] |= 0x4;
    return m_Valign;
}

inline
bool CMath_Base::C_Attlist::IsSetWidth(void) const
{
    return ((m_set_State[6] & 0x30) != 0);
}

inline
bool CMath_Base::C_Attlist::CanGetWidth(void) const
{
    return IsSetWidth();
}

inline
const CMath_Base::C_Attlist::TWidth& CMath_Base::C_Attlist::GetWidth(void) const
{
    if (!CanGetWidth()) {
        ThrowUnassigned(98);
    }
    return m_Width;
}

inline
void CMath_Base::C_Attlist::SetWidth(const CMath_Base::C_Attlist::TWidth& value)
{
    m_Width = value;
    m_set_State[6] |= 0x30;
}

inline
void CMath_Base::C_Attlist::SetWidth(CMath_Base::C_Attlist::TWidth&& value)
{
    m_Width = std::forward<CMath_Base::C_Attlist::TWidth>(value);
    m_set_State[6] |= 0x30;
}

inline
CMath_Base::C_Attlist::TWidth& CMath_Base::C_Attlist::SetWidth(void)
{
#ifdef _DEBUG
    if (!IsSetWidth()) {
        m_Width = UnassignedString();
    }
#endif
    m_set_State[6] |= 0x10;
    return m_Width;
}

inline
CMath_Base::C_E_MathExpression::C_E_MathExpression(void)
{
}

inline
bool CMath_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMath_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMath_Base::TAttlist& CMath_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMath_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMath_Base::TAttlist& CMath_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMath_Base::IsSetMathExpression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMath_Base::CanGetMathExpression(void) const
{
    return true;
}

inline
const CMath_Base::TMathExpression& CMath_Base::GetMathExpression(void) const
{
    return m_MathExpression;
}

inline
CMath_Base::TMathExpression& CMath_Base::SetMathExpression(void)
{
    m_set_State[0] |= 0x4;
    return m_MathExpression;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MATH_BASE_HPP
