/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file OtherID_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_OTHERID_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_OTHERID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class COtherID_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    COtherID_Base(void);
    // destructor
    virtual ~COtherID_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Source {
            eAttlist_Source_NASA  =  1,
            eAttlist_Source_KIE   =  2,
            eAttlist_Source_PIP   =  3,
            eAttlist_Source_POP   =  4,
            eAttlist_Source_ARPL  =  5,
            eAttlist_Source_CPC   =  6,
            eAttlist_Source_IND   =  7,
            eAttlist_Source_CPFH  =  8,
            eAttlist_Source_CLML  =  9,
            eAttlist_Source_NRCBL = 10,
            eAttlist_Source_NLM   = 11,
            eAttlist_Source_QCIM  = 12
        };
        
        /// Access to EAttlist_Source's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Source)(void);
        
        // types
        typedef EAttlist_Source TSource;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Source
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef EAttlist_Source TSource
        ///  Check whether the Source data member has been assigned a value.
        bool IsSetSource(void) const;
        /// Check whether it is safe or not to call GetSource method.
        bool CanGetSource(void) const;
        void ResetSource(void);
        TSource GetSource(void) const;
        void SetSource(TSource value);
        TSource& SetSource(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        EAttlist_Source m_Source;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TOtherID;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_OtherID
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TOtherID
    ///  Check whether the OtherID data member has been assigned a value.
    bool IsSetOtherID(void) const;
    /// Check whether it is safe or not to call GetOtherID method.
    bool CanGetOtherID(void) const;
    void ResetOtherID(void);
    const TOtherID& GetOtherID(void) const;
    void SetOtherID(const TOtherID& value);
    void SetOtherID(TOtherID&& value);
    TOtherID& SetOtherID(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    COtherID_Base(const COtherID_Base&);
    COtherID_Base& operator=(const COtherID_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_OtherID;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool COtherID_Base::C_Attlist::IsSetSource(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool COtherID_Base::C_Attlist::CanGetSource(void) const
{
    return IsSetSource();
}

inline
void COtherID_Base::C_Attlist::ResetSource(void)
{
    m_Source = (EAttlist_Source)(0);
    m_set_State[0] &= ~0x3;
}

inline
COtherID_Base::C_Attlist::TSource COtherID_Base::C_Attlist::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(0);
    }
    return m_Source;
}

inline
void COtherID_Base::C_Attlist::SetSource(COtherID_Base::C_Attlist::TSource value)
{
    m_Source = value;
    m_set_State[0] |= 0x3;
}

inline
COtherID_Base::C_Attlist::TSource& COtherID_Base::C_Attlist::SetSource(void)
{
#ifdef _DEBUG
    if (!IsSetSource()) {
        memset(&m_Source,UnassignedByte(),sizeof(m_Source));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Source;
}

inline
bool COtherID_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool COtherID_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const COtherID_Base::TAttlist& COtherID_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<COtherID_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
COtherID_Base::TAttlist& COtherID_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool COtherID_Base::IsSetOtherID(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool COtherID_Base::CanGetOtherID(void) const
{
    return IsSetOtherID();
}

inline
const COtherID_Base::TOtherID& COtherID_Base::GetOtherID(void) const
{
    if (!CanGetOtherID()) {
        ThrowUnassigned(1);
    }
    return m_OtherID;
}

inline
void COtherID_Base::SetOtherID(const COtherID_Base::TOtherID& value)
{
    m_OtherID = value;
    m_set_State[0] |= 0xc;
}

inline
void COtherID_Base::SetOtherID(COtherID_Base::TOtherID&& value)
{
    m_OtherID = std::forward<COtherID_Base::TOtherID>(value);
    m_set_State[0] |= 0xc;
}

inline
COtherID_Base::TOtherID& COtherID_Base::SetOtherID(void)
{
#ifdef _DEBUG
    if (!IsSetOtherID()) {
        m_OtherID = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_OtherID;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_OTHERID_BASE_HPP
