/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pagination_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PAGINATION_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PAGINATION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CEndPage;
class CMedlinePgn;
class CStartPage;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPagination_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPagination_Base(void);
    // destructor
    virtual ~CPagination_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_SEM : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_SEM(void);
        // destructor
        ~C_SEM(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CStartPage TStartPage;
        typedef CEndPage TEndPage;
        typedef CMedlinePgn TMedlinePgn;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_StartPage,
            e_EndPage,
            e_MedlinePgn
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef CStartPage TStartPage
        ///  Check whether the StartPage data member has been assigned a value.
        bool IsSetStartPage(void) const;
        /// Check whether it is safe or not to call GetStartPage method.
        bool CanGetStartPage(void) const;
        void ResetStartPage(void);
        const TStartPage& GetStartPage(void) const;
        void SetStartPage(TStartPage& value);
        TStartPage& SetStartPage(void);
    
        /// optional
        /// typedef CEndPage TEndPage
        ///  Check whether the EndPage data member has been assigned a value.
        bool IsSetEndPage(void) const;
        /// Check whether it is safe or not to call GetEndPage method.
        bool CanGetEndPage(void) const;
        void ResetEndPage(void);
        const TEndPage& GetEndPage(void) const;
        void SetEndPage(TEndPage& value);
        TEndPage& SetEndPage(void);
    
        /// optional
        /// typedef CMedlinePgn TMedlinePgn
        ///  Check whether the MedlinePgn data member has been assigned a value.
        bool IsSetMedlinePgn(void) const;
        /// Check whether it is safe or not to call GetMedlinePgn method.
        bool CanGetMedlinePgn(void) const;
        void ResetMedlinePgn(void);
        const TMedlinePgn& GetMedlinePgn(void) const;
        void SetMedlinePgn(TMedlinePgn& value);
        TMedlinePgn& SetMedlinePgn(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_SEM(const C_SEM&);
        C_SEM& operator=(const C_SEM&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_NCBI::CRef< TStartPage > m_StartPage;
        NCBI_NS_NCBI::CRef< TEndPage > m_EndPage;
        NCBI_NS_NCBI::CRef< TMedlinePgn > m_MedlinePgn;
    };

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_SEM,
        e_MedlinePgn
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_MedlinePgn+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static NCBI_NS_STD::string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                NCBI_NS_NCBI::EResetVariant reset,
                NCBI_NS_NCBI::CObjectMemoryPool* pool);

    // types
    typedef C_SEM TSEM;
    typedef CMedlinePgn TMedlinePgn;

    // getters
    // setters

    // typedef C_SEM TSEM
    bool IsSEM(void) const;
    const TSEM& GetSEM(void) const;
    TSEM& SetSEM(void);
    void SetSEM(TSEM& value);

    // typedef CMedlinePgn TMedlinePgn
    bool IsMedlinePgn(void) const;
    const TMedlinePgn& GetMedlinePgn(void) const;
    TMedlinePgn& SetMedlinePgn(void);
    void SetMedlinePgn(TMedlinePgn& value);


private:
    // copy constructor and assignment operator
    CPagination_Base(const CPagination_Base& );
    CPagination_Base& operator=(const CPagination_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPagination_Base::C_SEM::IsSetStartPage(void) const
{
    return m_StartPage.NotEmpty();
}

inline
bool CPagination_Base::C_SEM::CanGetStartPage(void) const
{
    return true;
}

inline
const CPagination_Base::C_SEM::TStartPage& CPagination_Base::C_SEM::GetStartPage(void) const
{
    if ( !m_StartPage ) {
        const_cast<C_SEM*>(this)->ResetStartPage();
    }
    return (*m_StartPage);
}

inline
CPagination_Base::C_SEM::TStartPage& CPagination_Base::C_SEM::SetStartPage(void)
{
    if ( !m_StartPage ) {
        ResetStartPage();
    }
    return (*m_StartPage);
}

inline
bool CPagination_Base::C_SEM::IsSetEndPage(void) const
{
    return m_EndPage.NotEmpty();
}

inline
bool CPagination_Base::C_SEM::CanGetEndPage(void) const
{
    return IsSetEndPage();
}

inline
const CPagination_Base::C_SEM::TEndPage& CPagination_Base::C_SEM::GetEndPage(void) const
{
    if (!CanGetEndPage()) {
        ThrowUnassigned(1);
    }
    return (*m_EndPage);
}

inline
bool CPagination_Base::C_SEM::IsSetMedlinePgn(void) const
{
    return m_MedlinePgn.NotEmpty();
}

inline
bool CPagination_Base::C_SEM::CanGetMedlinePgn(void) const
{
    return IsSetMedlinePgn();
}

inline
const CPagination_Base::C_SEM::TMedlinePgn& CPagination_Base::C_SEM::GetMedlinePgn(void) const
{
    if (!CanGetMedlinePgn()) {
        ThrowUnassigned(2);
    }
    return (*m_MedlinePgn);
}

inline
CPagination_Base::E_Choice CPagination_Base::Which(void) const
{
    return m_choice;
}

inline
void CPagination_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPagination_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPagination_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPagination_Base::IsSEM(void) const
{
    return m_choice == e_SEM;
}

inline
bool CPagination_Base::IsMedlinePgn(void) const
{
    return m_choice == e_MedlinePgn;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PAGINATION_BASE_HPP
