/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PubmedArticle_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDARTICLE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDARTICLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMedlineCitation;
class CPubmedData;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///   ============= Document-level elements ============================ 
class CPubmedArticle_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPubmedArticle_Base(void);
    // destructor
    virtual ~CPubmedArticle_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMedlineCitation TMedlineCitation;
    typedef CPubmedData TPubmedData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_MedlineCitation,
        e_PubmedData
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMedlineCitation TMedlineCitation
    ///  Check whether the MedlineCitation data member has been assigned a value.
    bool IsSetMedlineCitation(void) const;
    /// Check whether it is safe or not to call GetMedlineCitation method.
    bool CanGetMedlineCitation(void) const;
    void ResetMedlineCitation(void);
    const TMedlineCitation& GetMedlineCitation(void) const;
    void SetMedlineCitation(TMedlineCitation& value);
    TMedlineCitation& SetMedlineCitation(void);

    /// optional
    /// typedef CPubmedData TPubmedData
    ///  Check whether the PubmedData data member has been assigned a value.
    bool IsSetPubmedData(void) const;
    /// Check whether it is safe or not to call GetPubmedData method.
    bool CanGetPubmedData(void) const;
    void ResetPubmedData(void);
    const TPubmedData& GetPubmedData(void) const;
    void SetPubmedData(TPubmedData& value);
    TPubmedData& SetPubmedData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmedArticle_Base(const CPubmedArticle_Base&);
    CPubmedArticle_Base& operator=(const CPubmedArticle_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TMedlineCitation > m_MedlineCitation;
    NCBI_NS_NCBI::CRef< TPubmedData > m_PubmedData;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubmedArticle_Base::IsSetMedlineCitation(void) const
{
    return m_MedlineCitation.NotEmpty();
}

inline
bool CPubmedArticle_Base::CanGetMedlineCitation(void) const
{
    return true;
}

inline
const CPubmedArticle_Base::TMedlineCitation& CPubmedArticle_Base::GetMedlineCitation(void) const
{
    if ( !m_MedlineCitation ) {
        const_cast<CPubmedArticle_Base*>(this)->ResetMedlineCitation();
    }
    return (*m_MedlineCitation);
}

inline
CPubmedArticle_Base::TMedlineCitation& CPubmedArticle_Base::SetMedlineCitation(void)
{
    if ( !m_MedlineCitation ) {
        ResetMedlineCitation();
    }
    return (*m_MedlineCitation);
}

inline
bool CPubmedArticle_Base::IsSetPubmedData(void) const
{
    return m_PubmedData.NotEmpty();
}

inline
bool CPubmedArticle_Base::CanGetPubmedData(void) const
{
    return IsSetPubmedData();
}

inline
const CPubmedArticle_Base::TPubmedData& CPubmedArticle_Base::GetPubmedData(void) const
{
    if (!CanGetPubmedData()) {
        ThrowUnassigned(1);
    }
    return (*m_PubmedData);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDARTICLE_BASE_HPP
