/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TableCellExpression_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_TABLECELLEXPRESSION_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_TABLECELLEXPRESSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMtd;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CTableCellExpression_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CTableCellExpression_Base(void);
    // destructor
    virtual ~CTableCellExpression_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMtd TMtd;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_mtd
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMtd TMtd
    ///  Check whether the Mtd data member has been assigned a value.
    bool IsSetMtd(void) const;
    /// Check whether it is safe or not to call GetMtd method.
    bool CanGetMtd(void) const;
    void ResetMtd(void);
    const TMtd& GetMtd(void) const;
    void SetMtd(TMtd& value);
    TMtd& SetMtd(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTableCellExpression_Base(const CTableCellExpression_Base&);
    CTableCellExpression_Base& operator=(const CTableCellExpression_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TMtd > m_Mtd;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTableCellExpression_Base::IsSetMtd(void) const
{
    return m_Mtd.NotEmpty();
}

inline
bool CTableCellExpression_Base::CanGetMtd(void) const
{
    return true;
}

inline
const CTableCellExpression_Base::TMtd& CTableCellExpression_Base::GetMtd(void) const
{
    if ( !m_Mtd ) {
        const_cast<CTableCellExpression_Base*>(this)->ResetMtd();
    }
    return (*m_Mtd);
}

inline
CTableCellExpression_Base::TMtd& CTableCellExpression_Base::SetMtd(void)
{
    if ( !m_Mtd ) {
        ResetMtd();
    }
    return (*m_Mtd);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_TABLECELLEXPRESSION_BASE_HPP
