/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Token_content_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_TOKEN_CONTENT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_TOKEN_CONTENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMalignmark;
class CMglyph;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CToken_content_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CToken_content_Base(void);
    // destructor
    virtual ~CToken_content_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_EMM : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_EMM(void);
        // destructor
        ~C_EMM(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Mglyph,
            e_Malignmark
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Malignmark+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef CMglyph TMglyph;
        typedef CMalignmark TMalignmark;
    
        // getters
        // setters
    
        // typedef CMglyph TMglyph
        bool IsMglyph(void) const;
        const TMglyph& GetMglyph(void) const;
        TMglyph& SetMglyph(void);
    
        // typedef CMalignmark TMalignmark
        bool IsMalignmark(void) const;
        const TMalignmark& GetMalignmark(void) const;
        TMalignmark& SetMalignmark(void);
    
    
    private:
        // copy constructor and assignment operator
        C_EMM(const C_EMM& );
        C_EMM& operator=(const C_EMM& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef C_EMM TEMM;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_EMM
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef C_EMM TEMM
    ///  Check whether the EMM data member has been assigned a value.
    bool IsSetEMM(void) const;
    /// Check whether it is safe or not to call GetEMM method.
    bool CanGetEMM(void) const;
    void ResetEMM(void);
    const TEMM& GetEMM(void) const;
    void SetEMM(TEMM& value);
    TEMM& SetEMM(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CToken_content_Base(const CToken_content_Base&);
    CToken_content_Base& operator=(const CToken_content_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TEMM > m_EMM;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CToken_content_Base::C_EMM::E_Choice CToken_content_Base::C_EMM::Which(void) const
{
    return m_choice;
}

inline
void CToken_content_Base::C_EMM::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CToken_content_Base::C_EMM::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CToken_content_Base::C_EMM::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CToken_content_Base::C_EMM::IsMglyph(void) const
{
    return m_choice == e_Mglyph;
}

inline
bool CToken_content_Base::C_EMM::IsMalignmark(void) const
{
    return m_choice == e_Malignmark;
}

inline
bool CToken_content_Base::IsSetEMM(void) const
{
    return m_EMM.NotEmpty();
}

inline
bool CToken_content_Base::CanGetEMM(void) const
{
    return IsSetEMM();
}

inline
const CToken_content_Base::TEMM& CToken_content_Base::GetEMM(void) const
{
    if (!CanGetEMM()) {
        ThrowUnassigned(0);
    }
    return (*m_EMM);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_TOKEN_CONTENT_BASE_HPP
