/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ResultItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'egquery.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef egquery__OBJTOOLS_EUTILS_EGQUERY_RESULTITEM_BASE_HPP
#define egquery__OBJTOOLS_EUTILS_EGQUERY_RESULTITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_egquery_SCOPE
#  define BEGIN_egquery_SCOPE BEGIN_SCOPE(egquery)
#  define END_egquery_SCOPE END_SCOPE(egquery)
#endif
BEGIN_egquery_SCOPE // namespace egquery::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CResultItem_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CResultItem_Base(void);
    // destructor
    virtual ~CResultItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TDbName;
    typedef NCBI_NS_STD::string TMenuName;
    typedef NCBI_NS_STD::string TCount;
    typedef NCBI_NS_STD::string TStatus;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_DbName,
        e_MenuName,
        e_Count,
        e_Status
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDbName
    ///  Check whether the DbName data member has been assigned a value.
    bool IsSetDbName(void) const;
    /// Check whether it is safe or not to call GetDbName method.
    bool CanGetDbName(void) const;
    void ResetDbName(void);
    const TDbName& GetDbName(void) const;
    void SetDbName(const TDbName& value);
    void SetDbName(TDbName&& value);
    TDbName& SetDbName(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TMenuName
    ///  Check whether the MenuName data member has been assigned a value.
    bool IsSetMenuName(void) const;
    /// Check whether it is safe or not to call GetMenuName method.
    bool CanGetMenuName(void) const;
    void ResetMenuName(void);
    const TMenuName& GetMenuName(void) const;
    void SetMenuName(const TMenuName& value);
    void SetMenuName(TMenuName&& value);
    TMenuName& SetMenuName(void);

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    const TCount& GetCount(void) const;
    void SetCount(const TCount& value);
    void SetCount(TCount&& value);
    TCount& SetCount(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TStatus
    ///  Check whether the Status data member has been assigned a value.
    bool IsSetStatus(void) const;
    /// Check whether it is safe or not to call GetStatus method.
    bool CanGetStatus(void) const;
    void ResetStatus(void);
    const TStatus& GetStatus(void) const;
    void SetStatus(const TStatus& value);
    void SetStatus(TStatus&& value);
    TStatus& SetStatus(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CResultItem_Base(const CResultItem_Base&);
    CResultItem_Base& operator=(const CResultItem_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_DbName;
    NCBI_NS_STD::string m_MenuName;
    NCBI_NS_STD::string m_Count;
    NCBI_NS_STD::string m_Status;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CResultItem_Base::IsSetDbName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CResultItem_Base::CanGetDbName(void) const
{
    return IsSetDbName();
}

inline
const CResultItem_Base::TDbName& CResultItem_Base::GetDbName(void) const
{
    if (!CanGetDbName()) {
        ThrowUnassigned(0);
    }
    return m_DbName;
}

inline
void CResultItem_Base::SetDbName(const CResultItem_Base::TDbName& value)
{
    m_DbName = value;
    m_set_State[0] |= 0x3;
}

inline
void CResultItem_Base::SetDbName(CResultItem_Base::TDbName&& value)
{
    m_DbName = std::forward<CResultItem_Base::TDbName>(value);
    m_set_State[0] |= 0x3;
}

inline
CResultItem_Base::TDbName& CResultItem_Base::SetDbName(void)
{
#ifdef _DEBUG
    if (!IsSetDbName()) {
        m_DbName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DbName;
}

inline
bool CResultItem_Base::IsSetMenuName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CResultItem_Base::CanGetMenuName(void) const
{
    return IsSetMenuName();
}

inline
const CResultItem_Base::TMenuName& CResultItem_Base::GetMenuName(void) const
{
    if (!CanGetMenuName()) {
        ThrowUnassigned(1);
    }
    return m_MenuName;
}

inline
void CResultItem_Base::SetMenuName(const CResultItem_Base::TMenuName& value)
{
    m_MenuName = value;
    m_set_State[0] |= 0xc;
}

inline
void CResultItem_Base::SetMenuName(CResultItem_Base::TMenuName&& value)
{
    m_MenuName = std::forward<CResultItem_Base::TMenuName>(value);
    m_set_State[0] |= 0xc;
}

inline
CResultItem_Base::TMenuName& CResultItem_Base::SetMenuName(void)
{
#ifdef _DEBUG
    if (!IsSetMenuName()) {
        m_MenuName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_MenuName;
}

inline
bool CResultItem_Base::IsSetCount(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CResultItem_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
const CResultItem_Base::TCount& CResultItem_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(2);
    }
    return m_Count;
}

inline
void CResultItem_Base::SetCount(const CResultItem_Base::TCount& value)
{
    m_Count = value;
    m_set_State[0] |= 0x30;
}

inline
void CResultItem_Base::SetCount(CResultItem_Base::TCount&& value)
{
    m_Count = std::forward<CResultItem_Base::TCount>(value);
    m_set_State[0] |= 0x30;
}

inline
CResultItem_Base::TCount& CResultItem_Base::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        m_Count = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Count;
}

inline
bool CResultItem_Base::IsSetStatus(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CResultItem_Base::CanGetStatus(void) const
{
    return IsSetStatus();
}

inline
const CResultItem_Base::TStatus& CResultItem_Base::GetStatus(void) const
{
    if (!CanGetStatus()) {
        ThrowUnassigned(3);
    }
    return m_Status;
}

inline
void CResultItem_Base::SetStatus(const CResultItem_Base::TStatus& value)
{
    m_Status = value;
    m_set_State[0] |= 0xc0;
}

inline
void CResultItem_Base::SetStatus(CResultItem_Base::TStatus&& value)
{
    m_Status = std::forward<CResultItem_Base::TStatus>(value);
    m_set_State[0] |= 0xc0;
}

inline
CResultItem_Base::TStatus& CResultItem_Base::SetStatus(void)
{
#ifdef _DEBUG
    if (!IsSetStatus()) {
        m_Status = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Status;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_egquery_SCOPE // namespace egquery::


#endif // egquery__OBJTOOLS_EUTILS_EGQUERY_RESULTITEM_BASE_HPP
