/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DbInfo_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'einfo.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef einfo__OBJTOOLS_EUTILS_EINFO_DBINFO_BASE_HPP
#define einfo__OBJTOOLS_EUTILS_EINFO_DBINFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_einfo_SCOPE
#  define BEGIN_einfo_SCOPE BEGIN_SCOPE(einfo)
#  define END_einfo_SCOPE END_SCOPE(einfo)
#endif
BEGIN_einfo_SCOPE // namespace einfo::


// forward declarations
class CFieldList;
class CLinkList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CDbInfo_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CDbInfo_Base(void);
    // destructor
    virtual ~CDbInfo_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TDbName;
    typedef NCBI_NS_STD::string TMenuName;
    typedef NCBI_NS_STD::string TDescription;
    typedef NCBI_NS_STD::string TDbBuild;
    typedef NCBI_NS_STD::string TWarning;
    typedef NCBI_NS_STD::string TCount;
    typedef NCBI_NS_STD::string TLastUpdate;
    typedef CFieldList TFieldList;
    typedef CLinkList TLinkList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_DbName,
        e_MenuName,
        e_Description,
        e_DbBuild,
        e_Warning,
        e_Count,
        e_LastUpdate,
        e_FieldList,
        e_LinkList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// \S+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDbName
    ///  Check whether the DbName data member has been assigned a value.
    bool IsSetDbName(void) const;
    /// Check whether it is safe or not to call GetDbName method.
    bool CanGetDbName(void) const;
    void ResetDbName(void);
    const TDbName& GetDbName(void) const;
    void SetDbName(const TDbName& value);
    void SetDbName(TDbName&& value);
    TDbName& SetDbName(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TMenuName
    ///  Check whether the MenuName data member has been assigned a value.
    bool IsSetMenuName(void) const;
    /// Check whether it is safe or not to call GetMenuName method.
    bool CanGetMenuName(void) const;
    void ResetMenuName(void);
    const TMenuName& GetMenuName(void) const;
    void SetMenuName(const TMenuName& value);
    void SetMenuName(TMenuName&& value);
    TMenuName& SetMenuName(void);

    /// .+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TDbBuild
    ///  Check whether the DbBuild data member has been assigned a value.
    bool IsSetDbBuild(void) const;
    /// Check whether it is safe or not to call GetDbBuild method.
    bool CanGetDbBuild(void) const;
    void ResetDbBuild(void);
    const TDbBuild& GetDbBuild(void) const;
    void SetDbBuild(const TDbBuild& value);
    void SetDbBuild(TDbBuild&& value);
    TDbBuild& SetDbBuild(void);

    /// .+ 
    /// optional
    /// typedef NCBI_NS_STD::string TWarning
    ///  Check whether the Warning data member has been assigned a value.
    bool IsSetWarning(void) const;
    /// Check whether it is safe or not to call GetWarning method.
    bool CanGetWarning(void) const;
    void ResetWarning(void);
    const TWarning& GetWarning(void) const;
    void SetWarning(const TWarning& value);
    void SetWarning(TWarning&& value);
    TWarning& SetWarning(void);

    /// \d+ 
    /// optional
    /// typedef NCBI_NS_STD::string TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    const TCount& GetCount(void) const;
    void SetCount(const TCount& value);
    void SetCount(TCount&& value);
    TCount& SetCount(void);

    /// \d+ 
    /// optional
    /// typedef NCBI_NS_STD::string TLastUpdate
    ///  Check whether the LastUpdate data member has been assigned a value.
    bool IsSetLastUpdate(void) const;
    /// Check whether it is safe or not to call GetLastUpdate method.
    bool CanGetLastUpdate(void) const;
    void ResetLastUpdate(void);
    const TLastUpdate& GetLastUpdate(void) const;
    void SetLastUpdate(const TLastUpdate& value);
    void SetLastUpdate(TLastUpdate&& value);
    TLastUpdate& SetLastUpdate(void);

    /// optional
    /// typedef CFieldList TFieldList
    ///  Check whether the FieldList data member has been assigned a value.
    bool IsSetFieldList(void) const;
    /// Check whether it is safe or not to call GetFieldList method.
    bool CanGetFieldList(void) const;
    void ResetFieldList(void);
    const TFieldList& GetFieldList(void) const;
    void SetFieldList(TFieldList& value);
    TFieldList& SetFieldList(void);

    /// optional
    /// typedef CLinkList TLinkList
    ///  Check whether the LinkList data member has been assigned a value.
    bool IsSetLinkList(void) const;
    /// Check whether it is safe or not to call GetLinkList method.
    bool CanGetLinkList(void) const;
    void ResetLinkList(void);
    const TLinkList& GetLinkList(void) const;
    void SetLinkList(TLinkList& value);
    TLinkList& SetLinkList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDbInfo_Base(const CDbInfo_Base&);
    CDbInfo_Base& operator=(const CDbInfo_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_DbName;
    NCBI_NS_STD::string m_MenuName;
    NCBI_NS_STD::string m_Description;
    NCBI_NS_STD::string m_DbBuild;
    NCBI_NS_STD::string m_Warning;
    NCBI_NS_STD::string m_Count;
    NCBI_NS_STD::string m_LastUpdate;
    NCBI_NS_NCBI::CRef< TFieldList > m_FieldList;
    NCBI_NS_NCBI::CRef< TLinkList > m_LinkList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDbInfo_Base::IsSetDbName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDbInfo_Base::CanGetDbName(void) const
{
    return IsSetDbName();
}

inline
const CDbInfo_Base::TDbName& CDbInfo_Base::GetDbName(void) const
{
    if (!CanGetDbName()) {
        ThrowUnassigned(0);
    }
    return m_DbName;
}

inline
void CDbInfo_Base::SetDbName(const CDbInfo_Base::TDbName& value)
{
    m_DbName = value;
    m_set_State[0] |= 0x3;
}

inline
void CDbInfo_Base::SetDbName(CDbInfo_Base::TDbName&& value)
{
    m_DbName = std::forward<CDbInfo_Base::TDbName>(value);
    m_set_State[0] |= 0x3;
}

inline
CDbInfo_Base::TDbName& CDbInfo_Base::SetDbName(void)
{
#ifdef _DEBUG
    if (!IsSetDbName()) {
        m_DbName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DbName;
}

inline
bool CDbInfo_Base::IsSetMenuName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDbInfo_Base::CanGetMenuName(void) const
{
    return IsSetMenuName();
}

inline
const CDbInfo_Base::TMenuName& CDbInfo_Base::GetMenuName(void) const
{
    if (!CanGetMenuName()) {
        ThrowUnassigned(1);
    }
    return m_MenuName;
}

inline
void CDbInfo_Base::SetMenuName(const CDbInfo_Base::TMenuName& value)
{
    m_MenuName = value;
    m_set_State[0] |= 0xc;
}

inline
void CDbInfo_Base::SetMenuName(CDbInfo_Base::TMenuName&& value)
{
    m_MenuName = std::forward<CDbInfo_Base::TMenuName>(value);
    m_set_State[0] |= 0xc;
}

inline
CDbInfo_Base::TMenuName& CDbInfo_Base::SetMenuName(void)
{
#ifdef _DEBUG
    if (!IsSetMenuName()) {
        m_MenuName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_MenuName;
}

inline
bool CDbInfo_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CDbInfo_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CDbInfo_Base::TDescription& CDbInfo_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(2);
    }
    return m_Description;
}

inline
void CDbInfo_Base::SetDescription(const CDbInfo_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0x30;
}

inline
void CDbInfo_Base::SetDescription(CDbInfo_Base::TDescription&& value)
{
    m_Description = std::forward<CDbInfo_Base::TDescription>(value);
    m_set_State[0] |= 0x30;
}

inline
CDbInfo_Base::TDescription& CDbInfo_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Description;
}

inline
bool CDbInfo_Base::IsSetDbBuild(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CDbInfo_Base::CanGetDbBuild(void) const
{
    return IsSetDbBuild();
}

inline
const CDbInfo_Base::TDbBuild& CDbInfo_Base::GetDbBuild(void) const
{
    if (!CanGetDbBuild()) {
        ThrowUnassigned(3);
    }
    return m_DbBuild;
}

inline
void CDbInfo_Base::SetDbBuild(const CDbInfo_Base::TDbBuild& value)
{
    m_DbBuild = value;
    m_set_State[0] |= 0xc0;
}

inline
void CDbInfo_Base::SetDbBuild(CDbInfo_Base::TDbBuild&& value)
{
    m_DbBuild = std::forward<CDbInfo_Base::TDbBuild>(value);
    m_set_State[0] |= 0xc0;
}

inline
CDbInfo_Base::TDbBuild& CDbInfo_Base::SetDbBuild(void)
{
#ifdef _DEBUG
    if (!IsSetDbBuild()) {
        m_DbBuild = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_DbBuild;
}

inline
bool CDbInfo_Base::IsSetWarning(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CDbInfo_Base::CanGetWarning(void) const
{
    return IsSetWarning();
}

inline
const CDbInfo_Base::TWarning& CDbInfo_Base::GetWarning(void) const
{
    if (!CanGetWarning()) {
        ThrowUnassigned(4);
    }
    return m_Warning;
}

inline
void CDbInfo_Base::SetWarning(const CDbInfo_Base::TWarning& value)
{
    m_Warning = value;
    m_set_State[0] |= 0x300;
}

inline
void CDbInfo_Base::SetWarning(CDbInfo_Base::TWarning&& value)
{
    m_Warning = std::forward<CDbInfo_Base::TWarning>(value);
    m_set_State[0] |= 0x300;
}

inline
CDbInfo_Base::TWarning& CDbInfo_Base::SetWarning(void)
{
#ifdef _DEBUG
    if (!IsSetWarning()) {
        m_Warning = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Warning;
}

inline
bool CDbInfo_Base::IsSetCount(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CDbInfo_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
const CDbInfo_Base::TCount& CDbInfo_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(5);
    }
    return m_Count;
}

inline
void CDbInfo_Base::SetCount(const CDbInfo_Base::TCount& value)
{
    m_Count = value;
    m_set_State[0] |= 0xc00;
}

inline
void CDbInfo_Base::SetCount(CDbInfo_Base::TCount&& value)
{
    m_Count = std::forward<CDbInfo_Base::TCount>(value);
    m_set_State[0] |= 0xc00;
}

inline
CDbInfo_Base::TCount& CDbInfo_Base::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        m_Count = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Count;
}

inline
bool CDbInfo_Base::IsSetLastUpdate(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CDbInfo_Base::CanGetLastUpdate(void) const
{
    return IsSetLastUpdate();
}

inline
const CDbInfo_Base::TLastUpdate& CDbInfo_Base::GetLastUpdate(void) const
{
    if (!CanGetLastUpdate()) {
        ThrowUnassigned(6);
    }
    return m_LastUpdate;
}

inline
void CDbInfo_Base::SetLastUpdate(const CDbInfo_Base::TLastUpdate& value)
{
    m_LastUpdate = value;
    m_set_State[0] |= 0x3000;
}

inline
void CDbInfo_Base::SetLastUpdate(CDbInfo_Base::TLastUpdate&& value)
{
    m_LastUpdate = std::forward<CDbInfo_Base::TLastUpdate>(value);
    m_set_State[0] |= 0x3000;
}

inline
CDbInfo_Base::TLastUpdate& CDbInfo_Base::SetLastUpdate(void)
{
#ifdef _DEBUG
    if (!IsSetLastUpdate()) {
        m_LastUpdate = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_LastUpdate;
}

inline
bool CDbInfo_Base::IsSetFieldList(void) const
{
    return m_FieldList.NotEmpty();
}

inline
bool CDbInfo_Base::CanGetFieldList(void) const
{
    return IsSetFieldList();
}

inline
const CDbInfo_Base::TFieldList& CDbInfo_Base::GetFieldList(void) const
{
    if (!CanGetFieldList()) {
        ThrowUnassigned(7);
    }
    return (*m_FieldList);
}

inline
bool CDbInfo_Base::IsSetLinkList(void) const
{
    return m_LinkList.NotEmpty();
}

inline
bool CDbInfo_Base::CanGetLinkList(void) const
{
    return IsSetLinkList();
}

inline
const CDbInfo_Base::TLinkList& CDbInfo_Base::GetLinkList(void) const
{
    if (!CanGetLinkList()) {
        ThrowUnassigned(8);
    }
    return (*m_LinkList);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_einfo_SCOPE // namespace einfo::


#endif // einfo__OBJTOOLS_EUTILS_EINFO_DBINFO_BASE_HPP
