/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file IdUrlList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'elink.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef elink__OBJTOOLS_EUTILS_ELINK_IDURLLIST_BASE_HPP
#define elink__OBJTOOLS_EUTILS_ELINK_IDURLLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_elink_SCOPE
#  define BEGIN_elink_SCOPE BEGIN_SCOPE(elink)
#  define END_elink_SCOPE END_SCOPE(elink)
#endif
BEGIN_elink_SCOPE // namespace elink::


// forward declarations
class CFirstChars;
class CIdUrlSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CIdUrlList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CIdUrlList_Base(void);
    // destructor
    virtual ~CIdUrlList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_IdUrlSet,
        e_FirstChars
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 3 ///< == e_FirstChars+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static NCBI_NS_STD::string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                NCBI_NS_NCBI::EResetVariant reset,
                NCBI_NS_NCBI::CObjectMemoryPool* pool);

    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdUrlSet > > TIdUrlSet;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CFirstChars > > TFirstChars;

    // getters
    // setters

    // typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIdUrlSet > > TIdUrlSet
    bool IsIdUrlSet(void) const;
    const TIdUrlSet& GetIdUrlSet(void) const;
    TIdUrlSet& SetIdUrlSet(void);

    // typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CFirstChars > > TFirstChars
    bool IsFirstChars(void) const;
    const TFirstChars& GetFirstChars(void) const;
    TFirstChars& SetFirstChars(void);


private:
    // copy constructor and assignment operator
    CIdUrlList_Base(const CIdUrlList_Base& );
    CIdUrlList_Base& operator=(const CIdUrlList_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<TIdUrlSet> m_IdUrlSet;
        NCBI_NS_NCBI::CUnionBuffer<TFirstChars> m_FirstChars;
        void* m_dummy_pointer_for_alignment;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CIdUrlList_Base::E_Choice CIdUrlList_Base::Which(void) const
{
    return m_choice;
}

inline
void CIdUrlList_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CIdUrlList_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CIdUrlList_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CIdUrlList_Base::IsIdUrlSet(void) const
{
    return m_choice == e_IdUrlSet;
}

inline
const CIdUrlList_Base::TIdUrlSet& CIdUrlList_Base::GetIdUrlSet(void) const
{
    CheckSelected(e_IdUrlSet);
    return *m_IdUrlSet;
}

inline
CIdUrlList_Base::TIdUrlSet& CIdUrlList_Base::SetIdUrlSet(void)
{
    Select(e_IdUrlSet, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_IdUrlSet;
}

inline
bool CIdUrlList_Base::IsFirstChars(void) const
{
    return m_choice == e_FirstChars;
}

inline
const CIdUrlList_Base::TFirstChars& CIdUrlList_Base::GetFirstChars(void) const
{
    CheckSelected(e_FirstChars);
    return *m_FirstChars;
}

inline
CIdUrlList_Base::TFirstChars& CIdUrlList_Base::SetFirstChars(void)
{
    Select(e_FirstChars, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_FirstChars;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_elink_SCOPE // namespace elink::


#endif // elink__OBJTOOLS_EUTILS_ELINK_IDURLLIST_BASE_HPP
