/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TranslationStack_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esearch.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esearch__OBJTOOLS_EUTILS_ESEARCH_TRANSLATIONSTACK_BASE_HPP
#define esearch__OBJTOOLS_EUTILS_ESEARCH_TRANSLATIONSTACK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_esearch_SCOPE
#  define BEGIN_esearch_SCOPE BEGIN_SCOPE(esearch)
#  define END_esearch_SCOPE END_SCOPE(esearch)
#endif
BEGIN_esearch_SCOPE // namespace esearch::


// forward declarations
class CTermSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CTranslationStack_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CTranslationStack_Base(void);
    // destructor
    virtual ~CTranslationStack_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Data : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_TermSet,
            e_OP            ///< (AND|OR|NOT|RANGE|GROUP) 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_OP+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef CTermSet TTermSet;
        typedef NCBI_NS_STD::string TOP;
    
        // getters
        // setters
    
        // typedef CTermSet TTermSet
        bool IsTermSet(void) const;
        const TTermSet& GetTermSet(void) const;
        TTermSet& SetTermSet(void);
        void SetTermSet(TTermSet& value);
    
        // typedef NCBI_NS_STD::string TOP
        bool IsOP(void) const;
        const TOP& GetOP(void) const;
        TOP& SetOP(void);
        void SetOP(const TOP& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CTranslationStack_Base(const CTranslationStack_Base&);
    CTranslationStack_Base& operator=(const CTranslationStack_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTranslationStack_Base::C_Data::E_Choice CTranslationStack_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CTranslationStack_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTranslationStack_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTranslationStack_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTranslationStack_Base::C_Data::IsTermSet(void) const
{
    return m_choice == e_TermSet;
}

inline
bool CTranslationStack_Base::C_Data::IsOP(void) const
{
    return m_choice == e_OP;
}

inline
const CTranslationStack_Base::C_Data::TOP& CTranslationStack_Base::C_Data::GetOP(void) const
{
    CheckSelected(e_OP);
    return *m_string;
}

inline
CTranslationStack_Base::C_Data::TOP& CTranslationStack_Base::C_Data::SetOP(void)
{
    Select(e_OP, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CTranslationStack_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTranslationStack_Base::CanGet(void) const
{
    return true;
}

inline
const CTranslationStack_Base::Tdata& CTranslationStack_Base::Get(void) const
{
    return m_data;
}

inline
CTranslationStack_Base::Tdata& CTranslationStack_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CTranslationStack_Base::operator const CTranslationStack_Base::Tdata& (void) const
{
    return m_data;
}

inline
CTranslationStack_Base::operator CTranslationStack_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esearch_SCOPE // namespace esearch::


#endif // esearch__OBJTOOLS_EUTILS_ESEARCH_TRANSLATIONSTACK_BASE_HPP
