/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ESpellResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'espell.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef espell__OBJTOOLS_EUTILS_ESPELL_ESPELLRESULT_BASE_HPP
#define espell__OBJTOOLS_EUTILS_ESPELL_ESPELLRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_espell_SCOPE
#  define BEGIN_espell_SCOPE BEGIN_SCOPE(espell)
#  define END_espell_SCOPE END_SCOPE(espell)
#endif
BEGIN_espell_SCOPE // namespace espell::


// forward declarations
class CSpelledQuery;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CESpellResult_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CESpellResult_Base(void);
    // destructor
    virtual ~CESpellResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string TDatabase;
    typedef NCBI_NS_STD::string TQuery;
    typedef NCBI_NS_STD::string TCorrectedQuery;
    typedef CSpelledQuery TSpelledQuery;
    typedef NCBI_NS_STD::string TERROR;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Database,
        e_Query,
        e_CorrectedQuery,
        e_SpelledQuery,
        e_ERROR
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TDatabase
    ///  Check whether the Database data member has been assigned a value.
    bool IsSetDatabase(void) const;
    /// Check whether it is safe or not to call GetDatabase method.
    bool CanGetDatabase(void) const;
    void ResetDatabase(void);
    const TDatabase& GetDatabase(void) const;
    void SetDatabase(const TDatabase& value);
    void SetDatabase(TDatabase&& value);
    TDatabase& SetDatabase(void);

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TQuery
    ///  Check whether the Query data member has been assigned a value.
    bool IsSetQuery(void) const;
    /// Check whether it is safe or not to call GetQuery method.
    bool CanGetQuery(void) const;
    void ResetQuery(void);
    const TQuery& GetQuery(void) const;
    void SetQuery(const TQuery& value);
    void SetQuery(TQuery&& value);
    TQuery& SetQuery(void);

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TCorrectedQuery
    ///  Check whether the CorrectedQuery data member has been assigned a value.
    bool IsSetCorrectedQuery(void) const;
    /// Check whether it is safe or not to call GetCorrectedQuery method.
    bool CanGetCorrectedQuery(void) const;
    void ResetCorrectedQuery(void);
    const TCorrectedQuery& GetCorrectedQuery(void) const;
    void SetCorrectedQuery(const TCorrectedQuery& value);
    void SetCorrectedQuery(TCorrectedQuery&& value);
    TCorrectedQuery& SetCorrectedQuery(void);

    /// \d+ 
    /// mandatory
    /// typedef CSpelledQuery TSpelledQuery
    ///  Check whether the SpelledQuery data member has been assigned a value.
    bool IsSetSpelledQuery(void) const;
    /// Check whether it is safe or not to call GetSpelledQuery method.
    bool CanGetSpelledQuery(void) const;
    void ResetSpelledQuery(void);
    const TSpelledQuery& GetSpelledQuery(void) const;
    void SetSpelledQuery(TSpelledQuery& value);
    TSpelledQuery& SetSpelledQuery(void);

    /// \d+ 
    /// mandatory
    /// typedef NCBI_NS_STD::string TERROR
    ///  Check whether the ERROR data member has been assigned a value.
    bool IsSetERROR(void) const;
    /// Check whether it is safe or not to call GetERROR method.
    bool CanGetERROR(void) const;
    void ResetERROR(void);
    const TERROR& GetERROR(void) const;
    void SetERROR(const TERROR& value);
    void SetERROR(TERROR&& value);
    TERROR& SetERROR(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CESpellResult_Base(const CESpellResult_Base&);
    CESpellResult_Base& operator=(const CESpellResult_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_Database;
    NCBI_NS_STD::string m_Query;
    NCBI_NS_STD::string m_CorrectedQuery;
    NCBI_NS_NCBI::CRef< TSpelledQuery > m_SpelledQuery;
    NCBI_NS_STD::string m_ERROR;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CESpellResult_Base::IsSetDatabase(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CESpellResult_Base::CanGetDatabase(void) const
{
    return IsSetDatabase();
}

inline
const CESpellResult_Base::TDatabase& CESpellResult_Base::GetDatabase(void) const
{
    if (!CanGetDatabase()) {
        ThrowUnassigned(0);
    }
    return m_Database;
}

inline
void CESpellResult_Base::SetDatabase(const CESpellResult_Base::TDatabase& value)
{
    m_Database = value;
    m_set_State[0] |= 0x3;
}

inline
void CESpellResult_Base::SetDatabase(CESpellResult_Base::TDatabase&& value)
{
    m_Database = std::forward<CESpellResult_Base::TDatabase>(value);
    m_set_State[0] |= 0x3;
}

inline
CESpellResult_Base::TDatabase& CESpellResult_Base::SetDatabase(void)
{
#ifdef _DEBUG
    if (!IsSetDatabase()) {
        m_Database = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Database;
}

inline
bool CESpellResult_Base::IsSetQuery(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CESpellResult_Base::CanGetQuery(void) const
{
    return IsSetQuery();
}

inline
const CESpellResult_Base::TQuery& CESpellResult_Base::GetQuery(void) const
{
    if (!CanGetQuery()) {
        ThrowUnassigned(1);
    }
    return m_Query;
}

inline
void CESpellResult_Base::SetQuery(const CESpellResult_Base::TQuery& value)
{
    m_Query = value;
    m_set_State[0] |= 0xc;
}

inline
void CESpellResult_Base::SetQuery(CESpellResult_Base::TQuery&& value)
{
    m_Query = std::forward<CESpellResult_Base::TQuery>(value);
    m_set_State[0] |= 0xc;
}

inline
CESpellResult_Base::TQuery& CESpellResult_Base::SetQuery(void)
{
#ifdef _DEBUG
    if (!IsSetQuery()) {
        m_Query = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Query;
}

inline
bool CESpellResult_Base::IsSetCorrectedQuery(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CESpellResult_Base::CanGetCorrectedQuery(void) const
{
    return IsSetCorrectedQuery();
}

inline
const CESpellResult_Base::TCorrectedQuery& CESpellResult_Base::GetCorrectedQuery(void) const
{
    if (!CanGetCorrectedQuery()) {
        ThrowUnassigned(2);
    }
    return m_CorrectedQuery;
}

inline
void CESpellResult_Base::SetCorrectedQuery(const CESpellResult_Base::TCorrectedQuery& value)
{
    m_CorrectedQuery = value;
    m_set_State[0] |= 0x30;
}

inline
void CESpellResult_Base::SetCorrectedQuery(CESpellResult_Base::TCorrectedQuery&& value)
{
    m_CorrectedQuery = std::forward<CESpellResult_Base::TCorrectedQuery>(value);
    m_set_State[0] |= 0x30;
}

inline
CESpellResult_Base::TCorrectedQuery& CESpellResult_Base::SetCorrectedQuery(void)
{
#ifdef _DEBUG
    if (!IsSetCorrectedQuery()) {
        m_CorrectedQuery = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_CorrectedQuery;
}

inline
bool CESpellResult_Base::IsSetSpelledQuery(void) const
{
    return m_SpelledQuery.NotEmpty();
}

inline
bool CESpellResult_Base::CanGetSpelledQuery(void) const
{
    return true;
}

inline
const CESpellResult_Base::TSpelledQuery& CESpellResult_Base::GetSpelledQuery(void) const
{
    if ( !m_SpelledQuery ) {
        const_cast<CESpellResult_Base*>(this)->ResetSpelledQuery();
    }
    return (*m_SpelledQuery);
}

inline
CESpellResult_Base::TSpelledQuery& CESpellResult_Base::SetSpelledQuery(void)
{
    if ( !m_SpelledQuery ) {
        ResetSpelledQuery();
    }
    return (*m_SpelledQuery);
}

inline
bool CESpellResult_Base::IsSetERROR(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CESpellResult_Base::CanGetERROR(void) const
{
    return IsSetERROR();
}

inline
const CESpellResult_Base::TERROR& CESpellResult_Base::GetERROR(void) const
{
    if (!CanGetERROR()) {
        ThrowUnassigned(4);
    }
    return m_ERROR;
}

inline
void CESpellResult_Base::SetERROR(const CESpellResult_Base::TERROR& value)
{
    m_ERROR = value;
    m_set_State[0] |= 0x300;
}

inline
void CESpellResult_Base::SetERROR(CESpellResult_Base::TERROR&& value)
{
    m_ERROR = std::forward<CESpellResult_Base::TERROR>(value);
    m_set_State[0] |= 0x300;
}

inline
CESpellResult_Base::TERROR& CESpellResult_Base::SetERROR(void)
{
#ifdef _DEBUG
    if (!IsSetERROR()) {
        m_ERROR = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_ERROR;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_espell_SCOPE // namespace espell::


#endif // espell__OBJTOOLS_EUTILS_ESPELL_ESPELLRESULT_BASE_HPP
