/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SpelledQuery_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'espell.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef espell__OBJTOOLS_EUTILS_ESPELL_SPELLEDQUERY_BASE_HPP
#define espell__OBJTOOLS_EUTILS_ESPELL_SPELLEDQUERY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_espell_SCOPE
#  define BEGIN_espell_SCOPE BEGIN_SCOPE(espell)
#  define END_espell_SCOPE END_SCOPE(espell)
#endif
BEGIN_espell_SCOPE // namespace espell::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_EUTILS_EXPORT CSpelledQuery_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CSpelledQuery_Base(void);
    // destructor
    virtual ~CSpelledQuery_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// \d+ 
    class NCBI_EUTILS_EXPORT C_Data : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Replaced,     ///< \d+ 
            e_Original      ///< \d+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Original+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string TReplaced;
        typedef NCBI_NS_STD::string TOriginal;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string TReplaced
        bool IsReplaced(void) const;
        const TReplaced& GetReplaced(void) const;
        TReplaced& SetReplaced(void);
        void SetReplaced(const TReplaced& value);
    
        // typedef NCBI_NS_STD::string TOriginal
        bool IsOriginal(void) const;
        const TOriginal& GetOriginal(void) const;
        TOriginal& SetOriginal(void);
        void SetOriginal(const TOriginal& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CSpelledQuery_Base(const CSpelledQuery_Base&);
    CSpelledQuery_Base& operator=(const CSpelledQuery_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_Data > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSpelledQuery_Base::C_Data::E_Choice CSpelledQuery_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CSpelledQuery_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSpelledQuery_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSpelledQuery_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSpelledQuery_Base::C_Data::IsReplaced(void) const
{
    return m_choice == e_Replaced;
}

inline
const CSpelledQuery_Base::C_Data::TReplaced& CSpelledQuery_Base::C_Data::GetReplaced(void) const
{
    CheckSelected(e_Replaced);
    return *m_string;
}

inline
CSpelledQuery_Base::C_Data::TReplaced& CSpelledQuery_Base::C_Data::SetReplaced(void)
{
    Select(e_Replaced, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSpelledQuery_Base::C_Data::IsOriginal(void) const
{
    return m_choice == e_Original;
}

inline
const CSpelledQuery_Base::C_Data::TOriginal& CSpelledQuery_Base::C_Data::GetOriginal(void) const
{
    CheckSelected(e_Original);
    return *m_string;
}

inline
CSpelledQuery_Base::C_Data::TOriginal& CSpelledQuery_Base::C_Data::SetOriginal(void)
{
    Select(e_Original, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CSpelledQuery_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSpelledQuery_Base::CanGet(void) const
{
    return true;
}

inline
const CSpelledQuery_Base::Tdata& CSpelledQuery_Base::Get(void) const
{
    return m_data;
}

inline
CSpelledQuery_Base::Tdata& CSpelledQuery_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CSpelledQuery_Base::operator const CSpelledQuery_Base::Tdata& (void) const
{
    return m_data;
}

inline
CSpelledQuery_Base::operator CSpelledQuery_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_espell_SCOPE // namespace espell::


#endif // espell__OBJTOOLS_EUTILS_ESPELL_SPELLEDQUERY_BASE_HPP
