/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Item_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'esummary.dtd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef esummary__OBJTOOLS_EUTILS_ESUMMARY_ITEM_BASE_HPP
#define esummary__OBJTOOLS_EUTILS_ESUMMARY_ITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_esummary_SCOPE
#  define BEGIN_esummary_SCOPE BEGIN_SCOPE(esummary)
#  define END_esummary_SCOPE END_SCOPE(esummary)
#endif
BEGIN_esummary_SCOPE // namespace esummary::


// forward declarations
class CItem;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// .+ 
class NCBI_EUTILS_EXPORT CItem_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CItem_Base(void);
    // destructor
    virtual ~CItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_EUTILS_EXPORT C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_Type {
            eAttlist_Type_Integer    = 1,
            eAttlist_Type_Date       = 2,
            eAttlist_Type_String     = 3,
            eAttlist_Type_Structure  = 4,
            eAttlist_Type_List       = 5,
            eAttlist_Type_Flags      = 6,
            eAttlist_Type_Qualifier  = 7,
            eAttlist_Type_Enumerator = 8,
            eAttlist_Type_Unknown    = 9
        };
        
        /// Access to EAttlist_Type's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_Type)(void);
        
        // types
        typedef NCBI_NS_STD::string TName;
        typedef EAttlist_Type TType;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Name,
            e_Type
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TName
        ///  Check whether the Name data member has been assigned a value.
        bool IsSetName(void) const;
        /// Check whether it is safe or not to call GetName method.
        bool CanGetName(void) const;
        void ResetName(void);
        const TName& GetName(void) const;
        void SetName(const TName& value);
        void SetName(TName&& value);
        TName& SetName(void);
    
        /// mandatory
        /// typedef EAttlist_Type TType
        ///  Check whether the Type data member has been assigned a value.
        bool IsSetType(void) const;
        /// Check whether it is safe or not to call GetType method.
        bool CanGetType(void) const;
        void ResetType(void);
        TType GetType(void) const;
        void SetType(TType value);
        TType& SetType(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Name;
        EAttlist_Type m_Type;
    };
    /////////////////////////////////////////////////////////////////////////////
    /// .+ 
    class NCBI_EUTILS_EXPORT C_E_Item : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E_Item(void);
        // destructor
        ~C_E_Item(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e__CharData,
            e_Item          ///< .+ 
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Item+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef CItem TItem;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef CItem TItem
        bool IsItem(void) const;
        const TItem& GetItem(void) const;
        TItem& SetItem(void);
        void SetItem(TItem& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E_Item(const C_E_Item& );
        C_E_Item& operator=(const C_E_Item& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_E_Item C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Item > > TItem;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Item
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Item > > TItem
    ///  Check whether the Item data member has been assigned a value.
    bool IsSetItem(void) const;
    /// Check whether it is safe or not to call GetItem method.
    bool CanGetItem(void) const;
    void ResetItem(void);
    const TItem& GetItem(void) const;
    TItem& SetItem(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CItem_Base(const CItem_Base&);
    CItem_Base& operator=(const CItem_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_Item > > m_Item;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CItem_Base::C_Attlist::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CItem_Base::C_Attlist::CanGetName(void) const
{
    return IsSetName();
}

inline
const CItem_Base::C_Attlist::TName& CItem_Base::C_Attlist::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CItem_Base::C_Attlist::SetName(const CItem_Base::C_Attlist::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CItem_Base::C_Attlist::SetName(CItem_Base::C_Attlist::TName&& value)
{
    m_Name = std::forward<CItem_Base::C_Attlist::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CItem_Base::C_Attlist::TName& CItem_Base::C_Attlist::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CItem_Base::C_Attlist::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CItem_Base::C_Attlist::CanGetType(void) const
{
    return IsSetType();
}

inline
void CItem_Base::C_Attlist::ResetType(void)
{
    m_Type = (EAttlist_Type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CItem_Base::C_Attlist::TType CItem_Base::C_Attlist::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CItem_Base::C_Attlist::SetType(CItem_Base::C_Attlist::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CItem_Base::C_Attlist::TType& CItem_Base::C_Attlist::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
CItem_Base::C_E_Item::E_Choice CItem_Base::C_E_Item::Which(void) const
{
    return m_choice;
}

inline
void CItem_Base::C_E_Item::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CItem_Base::C_E_Item::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CItem_Base::C_E_Item::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CItem_Base::C_E_Item::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CItem_Base::C_E_Item::T_CharData& CItem_Base::C_E_Item::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CItem_Base::C_E_Item::T_CharData& CItem_Base::C_E_Item::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CItem_Base::C_E_Item::IsItem(void) const
{
    return m_choice == e_Item;
}

inline
bool CItem_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CItem_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CItem_Base::TAttlist& CItem_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CItem_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CItem_Base::TAttlist& CItem_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CItem_Base::IsSetItem(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CItem_Base::CanGetItem(void) const
{
    return true;
}

inline
const CItem_Base::TItem& CItem_Base::GetItem(void) const
{
    return m_Item;
}

inline
CItem_Base::TItem& CItem_Base::SetItem(void)
{
    m_set_State[0] |= 0x4;
    return m_Item;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_esummary_SCOPE // namespace esummary::


#endif // esummary__OBJTOOLS_EUTILS_ESUMMARY_ITEM_BASE_HPP
