/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.HttpOutputStream;
import HTTPClient.NVPair;
import HTTPClient.RoRequest;
import HTTPClient.TransferListener;

public final class Request
implements RoRequest,
Cloneable {
    private static final NVPair[] empty = new NVPair[0];
    private HTTPConnection connection;
    private String method;
    private String req_uri;
    private NVPair[] headers;
    private byte[] data;
    private HttpOutputStream stream;
    private boolean allow_ui;
    long delay_entity = 0L;
    int num_retries = 0;
    boolean dont_pipeline = false;
    boolean aborted = false;
    boolean internal_subrequest = false;
    TransferListener listener;

    public Request(HTTPConnection con, String method, String req_uri, NVPair[] headers, byte[] data, HttpOutputStream stream, boolean allow_ui) {
        this(con, method, req_uri, headers, data, stream, allow_ui, null);
    }

    public Request(HTTPConnection con, String method, String req_uri, NVPair[] headers, byte[] data, HttpOutputStream stream, boolean allow_ui, TransferListener listener) {
        this.connection = con;
        this.method = method;
        this.setRequestURI(req_uri);
        this.setHeaders(headers);
        this.data = data;
        this.stream = stream;
        this.allow_ui = allow_ui;
        this.listener = listener;
    }

    public TransferListener getTransferListener() {
        return this.listener;
    }

    public HTTPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(HTTPConnection con) {
        this.connection = con;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getRequestURI() {
        return this.req_uri;
    }

    public void setRequestURI(String req_uri) {
        if (req_uri != null && req_uri.trim().length() > 0) {
            if (!((req_uri = req_uri.trim()).charAt(0) == '/' || req_uri.equals("*") || this.method.equals("CONNECT") || Request.isAbsolute(req_uri))) {
                req_uri = "/" + req_uri;
            }
            this.req_uri = req_uri;
        } else {
            this.req_uri = "/";
        }
    }

    private static final boolean isAbsolute(String uri) {
        int ch = 0;
        int len = uri.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = uri.charAt(pos);
            ch = c;
            if (c == ':' || ch == 47 || ch == 63 || ch == 35) break;
        }
        return ch == 58;
    }

    public NVPair[] getHeaders() {
        return this.headers;
    }

    public void setHeaders(NVPair[] headers) {
        this.headers = headers != null ? headers : empty;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public HttpOutputStream getStream() {
        return this.stream;
    }

    public void setStream(HttpOutputStream stream) {
        this.stream = stream;
    }

    public boolean allowUI() {
        return this.allow_ui;
    }

    public void setAllowUI(boolean allow_ui) {
        this.allow_ui = allow_ui;
    }

    public Object clone() {
        Request cl;
        try {
            cl = (Request)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
        cl.headers = new NVPair[this.headers.length];
        System.arraycopy(this.headers, 0, cl.headers, 0, this.headers.length);
        return cl;
    }

    public void copyFrom(Request other) {
        this.connection = other.connection;
        this.method = other.method;
        this.req_uri = other.req_uri;
        this.headers = other.headers;
        this.data = other.data;
        this.stream = other.stream;
        this.allow_ui = other.allow_ui;
        this.delay_entity = other.delay_entity;
        this.num_retries = other.num_retries;
        this.dont_pipeline = other.dont_pipeline;
        this.aborted = other.aborted;
        this.internal_subrequest = other.internal_subrequest;
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.method + " " + this.req_uri;
    }
}

