<?php
/**
 * Internationalisation file for extension ParserFunctions.
 *
 * @file
 * @ingroup Extensions
 */

$magicWords = [];

/** English (English) */
$magicWords['en'] = [
	'expr' => [ 0, 'expr' ],
	'if' => [ 0, 'if' ],
	'ifeq' => [ 0, 'ifeq' ],
	'ifexpr' => [ 0, 'ifexpr' ],
	'iferror' => [ 0, 'iferror' ],
	'switch' => [ 0, 'switch' ],
	'default' => [ 0, '#default' ],
	'ifexist' => [ 0, 'ifexist' ],
	'time' => [ 0, 'time' ],
	'timel' => [ 0, 'timel' ],
	'rel2abs' => [ 0, 'rel2abs' ],
	'titleparts' => [ 0, 'titleparts' ],
	'len' => [ 0, 'len' ],
	'pos' => [ 0, 'pos' ],
	'rpos' => [ 0, 'rpos' ],
	'sub' => [ 0, 'sub' ],
	'count' => [ 0, 'count' ],
	'replace' => [ 0, 'replace' ],
	'explode' => [ 0, 'explode' ],
	'urldecode' => [ 0, 'urldecode' ],
];

/** Arabic (العربية) */
$magicWords['ar'] = [
	'expr' => [ 0, 'تعبير' ],
	'if' => [ 0, 'لو' ],
	'ifeq' => [ 0, 'لومعادلة' ],
	'ifexpr' => [ 0, 'لوتعبير' ],
	'iferror' => [ 0, 'لوخطأ' ],
	'switch' => [ 0, 'تبديل' ],
	'default' => [ 0, '#افتراضي' ],
	'ifexist' => [ 0, 'لوموجود' ],
	'time' => [ 0, 'وقت' ],
	'timel' => [ 0, 'تيمل' ],
	'rel2abs' => [ 0, 'ريلتوآبس' ],
	'titleparts' => [ 0, 'أجزاء_العنوان' ],
	'len' => [ 0, 'لين' ],
	'pos' => [ 0, 'بوس' ],
	'rpos' => [ 0, 'آربوس' ],
	'sub' => [ 0, 'متفرع' ],
	'count' => [ 0, 'عدد' ],
	'replace' => [ 0, 'استبدال' ],
	'explode' => [ 0, 'انفجار' ],
	'urldecode' => [ 0, 'فك_مسار' ],
];

/** Egyptian Arabic (مصرى) */
$magicWords['arz'] = [
	'expr' => [ 0, 'تعبير' ],
	'if' => [ 0, 'لو' ],
	'ifeq' => [ 0, 'لومعادلة' ],
	'ifexpr' => [ 0, 'لوتعبير' ],
	'iferror' => [ 0, 'لوخطأ' ],
	'switch' => [ 0, 'تبديل' ],
	'default' => [ 0, '#افتراضي' ],
	'ifexist' => [ 0, 'لوموجود' ],
	'time' => [ 0, 'وقت' ],
	'timel' => [ 0, 'تيمل' ],
	'rel2abs' => [ 0, 'ريلتوآبس' ],
	'titleparts' => [ 0, 'أجزاء_العنوان' ],
	'len' => [ 0, 'لين' ],
	'pos' => [ 0, 'بوس' ],
	'rpos' => [ 0, 'آربوس' ],
	'sub' => [ 0, 'متفرع' ],
	'count' => [ 0, 'عدد' ],
	'replace' => [ 0, 'استبدال' ],
	'explode' => [ 0, 'انفجار' ],
	'urldecode' => [ 0, 'فك_مسار' ],
];

/** South Azerbaijani (تۆرکجه) */
$magicWords['azb'] = [
	'ifeq' => [ 0, 'ایربیر' ],
	'ifexpr' => [ 0, 'ایرحساب' ],
	'iferror' => [ 0, 'ایریالنیش' ],
	'ifexist' => [ 0, 'ایراولسا' ],
];

/** Breton (brezhoneg) */
$magicWords['br'] = [
	'time' => [ 0, 'amzer' ],
	'count' => [ 0, 'kontañ' ],
	'replace' => [ 0, 'erlec\'hiañ' ],
];

/** Chechen (нохчийн) */
$magicWords['ce'] = [
	'time' => [ 0, 'хан' ],
	'replace' => [ 0, 'хийцарна', 'замена' ],
];

/** Sorani Kurdish (کوردی) */
$magicWords['ckb'] = [
	'default' => [ 0, 'بنچینەیی' ],
	'expr' => [ 0, 'دەربڕین' ],
	'if' => [ 0, 'ئەگەر' ],
	'iferror' => [ 0, 'ئەگەر_ھەڵە' ],
	'ifexist' => [ 0, 'ئەگەر_ھەبوو' ],
	'ifexpr' => [ 0, 'ئەگەر_دەربڕین' ],
	'switch' => [ 0, 'گۆڕینەوە' ],
	'time' => [ 0, 'کات' ],
];

/** Czech (čeština) */
$magicWords['cs'] = [
	'expr' => [ 0, 'výraz' ],
	'if' => [ 0, 'když' ],
	'ifexist' => [ 0, 'kdyžexist' ],
	'time' => [ 0, 'čas' ],
	'len' => [ 0, 'délka' ],
	'count' => [ 0, 'počet' ],
	'replace' => [ 0, 'nahradit' ],
];

/** Chuvash (Чӑвашла) */
$magicWords['cv'] = [
	'expr' => [ 0, 'expr' ],
	'if' => [ 0, 'if' ],
	'ifeq' => [ 0, 'ifeq' ],
	'ifexpr' => [ 0, 'ifexpr' ],
	'iferror' => [ 0, 'iferror' ],
	'switch' => [ 0, 'switch' ],
	'default' => [ 0, '#default' ],
	'ifexist' => [ 0, 'ifexist' ],
	'time' => [ 0, 'time' ],
	'timel' => [ 0, 'timel' ],
	'rel2abs' => [ 0, 'rel2abs' ],
	'titleparts' => [ 0, 'titleparts' ],
	'len' => [ 0, 'len' ],
	'pos' => [ 0, 'pos' ],
	'rpos' => [ 0, 'rpos' ],
	'sub' => [ 0, 'sub' ],
	'count' => [ 0, 'count' ],
	'replace' => [ 0, 'replace' ],
	'explode' => [ 0, 'explode' ],
	'urldecode' => [ 0, 'urldecode' ],
];

/** German (Deutsch) */
$magicWords['de'] = [
	'switch' => [ 0, 'wechsle' ],
	'default' => [ 0, '#standard' ],
	'count' => [ 0, 'zähle' ],
	'replace' => [ 0, 'ersetze' ],
	'urldecode' => [ 0, 'URLDEKODIERT:' ],
];

/** Zazaki (Zazaki) */
$magicWords['diq'] = [
	'expr' => [ 0, 'ifade' ],
	'if' => [ 0, 'se' ],
	'ifeq' => [ 0, 'sek' ],
	'ifexpr' => [ 0, 'ifadeyose' ],
	'iferror' => [ 0, 'çınyose' ],
	'switch' => [ 0, 'rayek' ],
	'default' => [ 0, '#hesıbyaye' ],
	'time' => [ 0, 'zeman' ],
	'sub' => [ 0, 'bın' ],
	'count' => [ 0, 'hesabk' ],
	'replace' => [ 0, 'vırnayen' ],
];

/** Esperanto (Esperanto) */
$magicWords['eo'] = [
	'expr' => [ 0, 'espr', 'esprimo', 'esprime' ],
	'if' => [ 0, 'se' ],
	'ifeq' => [ 0, 'seekv', 'seekvacio', 'seeglas', 'laŭsamvalorade', 'lauxsamvalorade' ],
	'ifexpr' => [ 0, 'seespr', 'seeksprimo', 'seesprimo', 'laŭevaluade', 'laŭevaluade' ],
	'iferror' => [ 0, 'seeraras', 'laŭerarade', 'lauxerarade' ],
	'switch' => [ 0, 'ŝaltu', 'ŝalti', 'sxaltu', 'sxalti', 'ŝalte', 'sxalte' ],
	'default' => [ 0, '#apriore', '#defaŭlte', '#defauxlte' ],
	'ifexist' => [ 0, 'seekzistas', 'laŭasignade', 'lauxasignade' ],
	'time' => [ 0, 'tempo', 'datformu' ],
	'timel' => [ 0, 'tempoo', 'lokaĵdatdonu', 'lokajxdatdonu' ],
	'len' => [ 0, 'lungo', 'longo', 'longdonu', 'pesu', 'pese' ],
	'replace' => [ 0, 'anstataŭigi', 'anstataŭigu', 'anstatauxigi', 'anstatauxigu' ],
	'rel2abs' => [ 0, 'absolutvojdonu', 'malrelativige' ],
	'titleparts' => [ 0, 'titolpartdonu' ],
	'pos' => [ 0, 'ejdonu', 'lokdonu' ],
	'rpos' => [ 0, 'lastejdonu', 'lastlokdonu' ],
	'sub' => [ 0, 'subĉendonu', 'subcxendonu' ],
	'count' => [ 0, 'subĉennombru', 'subcxennombru' ],
	'explode' => [ 0, 'disĉenigu' ],
	'urldecode' => [ 0, 'URL-malkodu', 'URI-malkodu' ],
];

/** Spanish (español) */
$magicWords['es'] = [
	'if' => [ 0, 'si' ],
	'ifeq' => [ 0, 'siigual' ],
	'ifexpr' => [ 0, 'siexpr' ],
	'iferror' => [ 0, 'sierror' ],
	'switch' => [ 0, 'según' ],
	'default' => [ 0, '#predeterminado' ],
	'ifexist' => [ 0, 'siexiste' ],
	'time' => [ 0, 'tiempo' ],
	'timel' => [ 0, 'tiempol' ],
	'len' => [ 0, 'long', 'longitud' ],
	'replace' => [ 0, 'reemplazar' ],
	'explode' => [ 0, 'separar' ],
];

/** Persian (فارسی) */
$magicWords['fa'] = [
	'expr' => [ 0, 'حساب' ],
	'if' => [ 0, 'اگر' ],
	'ifeq' => [ 0, 'اگرمساوی' ],
	'ifexpr' => [ 0, 'اگرحساب' ],
	'iferror' => [ 0, 'اگرخطا' ],
	'switch' => [ 0, 'گزینه' ],
	'default' => [ 0, '#پیش‌فرض' ],
	'ifexist' => [ 0, 'اگرموجود' ],
	'time' => [ 0, 'زمان' ],
	'timel' => [ 0, 'زمان‌بلند' ],
	'rel2abs' => [ 0, 'نسبی‌به‌مطلق' ],
	'titleparts' => [ 0, 'پاره‌عنوان' ],
	'len' => [ 0, 'طول' ],
	'pos' => [ 0, 'جا' ],
	'rpos' => [ 0, 'جار' ],
	'sub' => [ 0, 'تکه' ],
	'count' => [ 0, 'شمار' ],
	'replace' => [ 0, 'جایگزین' ],
	'explode' => [ 0, 'گسترش' ],
	'urldecode' => [ 0, 'نشانی‌بی‌کد' ],
];

/** French (français) */
$magicWords['fr'] = [
	'expr' => [ 0, 'expr' ],
	'if' => [ 0, 'si' ],
	'ifeq' => [ 0, 'si=' ],
	'ifexpr' => [ 0, 'siexpr' ],
	'iferror' => [ 0, 'sierreur' ],
	'switch' => [ 0, 'selon' ],
	'default' => [ 0, '#défaut' ],
	'ifexist' => [ 0, 'siexiste' ],
	'time' => [ 0, 'heure' ],
	'timel' => [ 0, 'heurel' ],
	'rel2abs' => [ 0, 'relenabs' ],
	'titleparts' => [ 0, 'partiestitre' ],
	'len' => [ 0, 'nbcar' ],
	'pos' => [ 0, 'pos' ],
	'rpos' => [ 0, 'posr' ],
	'sub' => [ 0, 'stxt' ],
	'count' => [ 0, 'nb' ],
	'replace' => [ 0, 'remplacer' ],
	'explode' => [ 0, 'exploser' ],
	'urldecode' => [ 0, 'décoderurl', 'decodeurl' ],
];

/** Western Frisian (Frysk) */
$magicWords['fy'] = [
	'expr' => [ 0, 'ekspresje' ],
	'if' => [ 0, 'as' ],
	'ifeq' => [ 0, 'asgelyk' ],
	'ifexpr' => [ 0, 'asekspresje' ],
	'iferror' => [ 0, 'asflater' ],
	'switch' => [ 0, 'skeakelje' ],
	'default' => [ 0, '#standert' ],
	'ifexist' => [ 0, 'asbestiet' ],
	'time' => [ 0, 'tiid' ],
	'timel' => [ 0, 'tiidl' ],
];

/** Hebrew (עברית) */
$magicWords['he'] = [
	'expr' => [ 0, 'חשב' ],
	'if' => [ 0, 'תנאי' ],
	'ifeq' => [ 0, 'שווה' ],
	'ifexpr' => [ 0, 'חשב תנאי' ],
	'iferror' => [ 0, 'תנאי שגיאה' ],
	'switch' => [ 0, 'בחר' ],
	'default' => [ 0, '#ברירת מחדל' ],
	'ifexist' => [ 0, 'קיים' ],
	'time' => [ 0, 'זמן' ],
	'timel' => [ 0, 'זמןמ' ],
	'rel2abs' => [ 0, 'יחסי למוחלט' ],
	'titleparts' => [ 0, 'חלק בכותרת' ],
	'count' => [ 0, 'מספר' ],
];

/** Hindi (हिन्दी) */
$magicWords['hi'] = [
	'expr' => [ 0, 'सूत्र' ],
	'if' => [ 0, 'यदि' ],
	'ifeq' => [ 0, 'यदिसम', 'यदि_समान', 'यदि_बराबर' ],
	'ifexpr' => [ 0, 'यदि_सूत्र' ],
	'iferror' => [ 0, 'यदि_त्रुटि' ],
	'switch' => [ 0, 'बदलें' ],
	'default' => [ 0, '#मूल' ],
	'ifexist' => [ 0, 'यदि_मौजूद' ],
	'time' => [ 0, 'समय' ],
	'timel' => [ 0, 'समय_स्थानीय' ],
	'rel2abs' => [ 0, 'सम्बन्धित_से_पूर्ण', 'संबंधित_से_पूर्ण' ],
	'titleparts' => [ 0, 'शीर्षक_भाग' ],
];

/** Hungarian (magyar) */
$magicWords['hu'] = [
	'expr' => [ 0, 'kif', 'expr' ],
	'if' => [ 0, 'ha', 'if' ],
	'ifeq' => [ 0, 'haegyenlő', 'ifeq' ],
	'ifexpr' => [ 0, 'hakif', 'ifexpr' ],
	'iferror' => [ 0, 'hahibás', 'iferror' ],
	'default' => [ 0, '#alapértelmezett', '#default' ],
	'ifexist' => [ 0, 'halétezik', 'ifexist' ],
	'time' => [ 0, 'idő', 'time' ],
	'len' => [ 0, 'hossz', 'len' ],
	'pos' => [ 0, 'pozíció', 'pos' ],
	'rpos' => [ 0, 'jpozíció', 'rpos' ],
];

/** Indonesian (Bahasa Indonesia) */
$magicWords['id'] = [
	'expr' => [ 0, 'hitung' ],
	'if' => [ 0, 'jika' ],
	'ifeq' => [ 0, 'jikasama' ],
	'ifexpr' => [ 0, 'jikahitung' ],
	'iferror' => [ 0, 'jikasalah' ],
	'switch' => [ 0, 'pilih' ],
	'default' => [ 0, '#baku' ],
	'ifexist' => [ 0, 'jikaada' ],
	'time' => [ 0, 'waktu' ],
	'timel' => [ 0, 'waktu1' ],
	'titleparts' => [ 0, 'bagianjudul' ],
];

/** Igbo (Igbo) */
$magicWords['ig'] = [
	'if' => [ 0, 'ȯ_bú', 'if' ],
	'time' => [ 0, 'ógè', 'time' ],
	'timel' => [ 0, 'ógèl', 'timel' ],
];

/** Italian (italiano) */
$magicWords['it'] = [
	'expr' => [ 0, 'espr' ],
	'if' => [ 0, 'se' ],
	'ifeq' => [ 0, 'seeq' ],
	'ifexpr' => [ 0, 'seespr' ],
	'iferror' => [ 0, 'seerrore' ],
	'ifexist' => [ 0, 'seesiste' ],
	'time' => [ 0, 'tempo' ],
	'titleparts' => [ 0, 'patititolo' ],
	'count' => [ 0, 'conto' ],
	'replace' => [ 0, 'sostituisci' ],
];

/** Japanese (日本語) */
$magicWords['ja'] = [
	'expr' => [ 0, '式' ],
	'if' => [ 0, 'もし' ],
	'ifeq' => [ 0, 'もし等しい' ],
	'ifexpr' => [ 0, 'もし式' ],
	'iferror' => [ 0, 'もしエラー' ],
	'switch' => [ 0, '切り替え' ],
	'default' => [ 0, '#既定' ],
	'ifexist' => [ 0, 'もし存在' ],
	'time' => [ 0, '時間' ],
	'timel' => [ 0, '時間地方' ],
	'rel2abs' => [ 0, '参照から絶対' ],
	'titleparts' => [ 0, 'タイトル部分' ],
	'len' => [ 0, '長さ' ],
	'pos' => [ 0, '位置' ],
	'rpos' => [ 0, '最後の位置' ],
	'sub' => [ 0, '切り取り' ],
	'count' => [ 0, '回数' ],
	'replace' => [ 0, '置き換え' ],
	'explode' => [ 0, '分割' ],
	'urldecode' => [ 0, 'URLデコード', 'ＵＲＬデコード' ],
];

/** Georgian (ქართული) */
$magicWords['ka'] = [
	'time' => [ 0, 'დრო' ],
];

/** Korean (한국어) */
$magicWords['ko'] = [
	'expr' => [ 0, '수식' ],
	'if' => [ 0, '만약' ],
	'ifeq' => [ 0, '만약일치' ],
	'ifexpr' => [ 0, '만약계산' ],
	'iferror' => [ 0, '만약오류' ],
	'switch' => [ 0, '스위치' ],
	'default' => [ 0, '#기본값' ],
	'ifexist' => [ 0, '만약존재' ],
	'time' => [ 0, '시간' ],
	'timel' => [ 0, '현지시간' ],
	'rel2abs' => [ 0, '상대를절대로' ],
	'titleparts' => [ 0, '제목부분' ],
	'len' => [ 0, '길이' ],
	'pos' => [ 0, '위치' ],
	'rpos' => [ 0, '오른위치' ],
	'sub' => [ 0, '자르기' ],
	'count' => [ 0, '개수' ],
	'replace' => [ 0, '바꾸기', '교체' ],
	'explode' => [ 0, '분리' ],
	'urldecode' => [ 0, '주소디코딩:' ],
];

/** Kurdish (Latin script) (Kurdî (latînî)) */
$magicWords['ku-latn'] = [
	'len' => [ 0, '#ziman' ],
];

/** Cornish (kernowek) */
$magicWords['kw'] = [
	'if' => [ 0, 'mar' ],
	'time' => [ 0, 'termyn' ],
];

/** Ladino (Ladino) */
$magicWords['lad'] = [
	'switch' => [ 0, 'asegún', 'según', 'switch' ],
];

/** Malagasy (Malagasy) */
$magicWords['mg'] = [
	'if' => [ 0, 'raha', 'if' ],
	'ifeq' => [ 0, 'rahamitovy', 'ifeq' ],
	'ifexpr' => [ 0, 'rahamarina', 'ifexpr' ],
	'iferror' => [ 0, 'rahadiso', 'iferror' ],
	'default' => [ 0, '#tsipalotra', '#default' ],
	'ifexist' => [ 0, 'rahamisy', 'ifexist' ],
	'time' => [ 0, 'lera', 'time' ],
];

/** Macedonian (македонски) */
$magicWords['mk'] = [
	'expr' => [ 0, 'израз' ],
	'if' => [ 0, 'ако' ],
	'ifeq' => [ 0, 'акоисто' ],
	'ifexpr' => [ 0, 'акоизраз' ],
	'iferror' => [ 0, 'акогрешка' ],
	'switch' => [ 0, 'префрли' ],
	'default' => [ 0, '#поосновно' ],
	'ifexist' => [ 0, 'акопостои' ],
	'time' => [ 0, 'време' ],
	'timel' => [ 0, 'времел' ],
	'rel2abs' => [ 0, 'релдоапс' ],
	'titleparts' => [ 0, 'насловделови' ],
	'len' => [ 0, 'долж' ],
	'pos' => [ 0, 'пол' ],
	'rpos' => [ 0, 'впол' ],
	'sub' => [ 0, 'зам' ],
	'count' => [ 0, 'сметај' ],
	'replace' => [ 0, 'замени' ],
	'explode' => [ 0, 'разложи' ],
	'urldecode' => [ 0, 'urlдекод' ],
];

/** Malayalam (മലയാളം) */
$magicWords['ml'] = [
	'expr' => [ 0, 'ദ്യോതകം' ],
	'if' => [ 0, 'എങ്കിൽ' ],
	'ifeq' => [ 0, 'സമമെങ്കിൽ' ],
	'ifexpr' => [ 0, 'എക്സ്പ്രെഷനെങ്കിൽ' ],
	'iferror' => [ 0, 'പിഴവെങ്കിൽ' ],
	'switch' => [ 0, 'മാറ്റുക' ],
	'default' => [ 0, '#സ്വതേ' ],
	'ifexist' => [ 0, 'ഉണ്ടെങ്കിൽ' ],
	'time' => [ 0, 'സമയം' ],
	'timel' => [ 0, 'സമയം|' ],
	'len' => [ 0, 'നീളം' ],
	'pos' => [ 0, 'സ്ഥാനം' ],
	'rpos' => [ 0, 'ആപേക്ഷികസ്ഥാനം' ],
	'sub' => [ 0, 'ഉപം' ],
	'count' => [ 0, 'എണ്ണുക' ],
	'replace' => [ 0, 'മാറ്റിച്ചേർക്കുക' ],
	'explode' => [ 0, 'വിസ്ഫോടനം' ],
	'urldecode' => [ 0, 'വിലാസഗൂഢീകരണമൊഴിവാക്കൽ' ],
];

/** Marathi (मराठी) */
$magicWords['mr'] = [
	'expr' => [ 0, 'करण' ],
	'if' => [ 0, 'जर', 'इफ' ],
	'ifeq' => [ 0, 'जरसम' ],
	'ifexpr' => [ 0, 'जरकरण' ],
	'iferror' => [ 0, 'जरत्रुटी' ],
	'switch' => [ 0, 'कळ', 'सांगकळ', 'असेलतरसांग', 'असलेतरसांग', 'स्वीच' ],
	'default' => [ 0, '#अविचल' ],
	'ifexist' => [ 0, 'जरअसेल', 'जरआहे' ],
	'time' => [ 0, 'वेळ' ],
	'timel' => [ 0, 'वेळस्था' ],
	'titleparts' => [ 0, 'शीर्षकखंड', 'टाइटलपार्ट्स' ],
	'len' => [ 0, 'लांबी' ],
	'pos' => [ 0, 'स्थशोध' ],
	'rpos' => [ 0, 'माग्चास्थशोध' ],
	'sub' => [ 0, 'उप' ],
	'count' => [ 0, 'मोज', 'मोजा' ],
	'replace' => [ 0, 'नेबदल', 'रिप्लेस' ],
	'explode' => [ 0, 'एकफोड' ],
];

/** Low Saxon (Netherlands) (Nedersaksies) */
$magicWords['nds-nl'] = [
	'if' => [ 0, 'as' ],
	'ifeq' => [ 0, 'asgelieke' ],
	'ifexpr' => [ 0, 'asexpressie' ],
	'iferror' => [ 0, 'asfout' ],
	'default' => [ 0, '#standard' ],
	'ifexist' => [ 0, 'asbesteet' ],
	'time' => [ 0, 'tied' ],
	'timel' => [ 0, 'tiedl' ],
	'rel2abs' => [ 0, 'relatiefnaorabseluut' ],
];

/** Dutch (Nederlands) */
$magicWords['nl'] = [
	'expr' => [ 0, 'expressie' ],
	'if' => [ 0, 'als' ],
	'ifeq' => [ 0, 'alsgelijk' ],
	'ifexpr' => [ 0, 'alsexpressie' ],
	'iferror' => [ 0, 'alsfout' ],
	'switch' => [ 0, 'schakelen' ],
	'default' => [ 0, '#standaard' ],
	'ifexist' => [ 0, 'alsbestaat' ],
	'time' => [ 0, 'tijd' ],
	'timel' => [ 0, 'tijdl' ],
	'rel2abs' => [ 0, 'relatiefnaarabsoluut' ],
	'titleparts' => [ 0, 'paginanaamdelen' ],
	'count' => [ 0, 'telling' ],
	'replace' => [ 0, 'vervangen' ],
	'explode' => [ 0, 'exploderen' ],
	'urldecode' => [ 0, 'urldecoderen' ],
];

/** Norwegian Nynorsk (norsk nynorsk) */
$magicWords['nn'] = [
	'expr' => [ 0, 'uttrykk', 'uttr' ],
	'if' => [ 0, 'om' ],
	'ifeq' => [ 0, 'omlik' ],
	'ifexpr' => [ 0, 'omuttrykk', 'omuttr' ],
	'iferror' => [ 0, 'omfeil' ],
	'switch' => [ 0, 'byt' ],
	'ifexist' => [ 0, 'omfinst' ],
	'time' => [ 0, 'tid' ],
	'timel' => [ 0, 'tidl' ],
	'rel2abs' => [ 0, 'reltilabs' ],
	'titleparts' => [ 0, 'titteldelar' ],
	'len' => [ 0, 'lengd' ],
	'replace' => [ 0, 'byt_ut', 'erstatt' ],
];

/** Oriya (ଓଡ଼ିଆ) */
$magicWords['or'] = [
	'time' => [ 0, 'ସମୟ' ],
];

/** Punjabi (ਪੰਜਾਬੀ) */
$magicWords['pa'] = [
	'time' => [ 0, 'ਸਮੇ' ],
];

/** Pashto (پښتو) */
$magicWords['ps'] = [
	'if' => [ 0, 'که', 'if' ],
	'time' => [ 0, 'وخت', 'time' ],
	'count' => [ 0, 'شمېرل', 'count' ],
];

/** Portuguese (português) */
$magicWords['pt'] = [
	'if' => [ 0, 'se' ],
	'ifeq' => [ 0, 'seigual' ],
	'ifexpr' => [ 0, 'seexpr' ],
	'iferror' => [ 0, 'seerro' ],
	'default' => [ 0, '#padrão', '#padrao' ],
	'ifexist' => [ 0, 'seexiste' ],
	'titleparts' => [ 0, 'partesdotítulo', 'partesdotitulo' ],
	'len' => [ 0, 'comprimento' ],
];

/** Quechua (Runa Simi) */
$magicWords['qu'] = [
	'expr' => [ 0, 'rikuchiy' ],
	'if' => [ 0, 'kaptin' ],
	'ifeq' => [ 0, 'kaqllakaptin' ],
	'ifexpr' => [ 0, 'rikuchiykaptin' ],
	'iferror' => [ 0, 'pantasqakaptin' ],
	'switch' => [ 0, 'winkuy' ],
	'default' => [ 0, '#kikinmanta' ],
	'ifexist' => [ 0, 'kachkaptin' ],
	'time' => [ 0, 'pacha' ],
	'timel' => [ 0, 'pachal' ],
	'len' => [ 0, 'suni' ],
	'pos' => [ 0, 'tiyay' ],
	'replace' => [ 0, 'rantichay', 'huknachay' ],
	'explode' => [ 0, 'phatmay' ],
];

/** Russian (русский) */
$magicWords['ru'] = [
	'if' => [ 0, 'если' ],
	'iferror' => [ 0, 'еслиошибка' ],
	'switch' => [ 0, 'переключатель' ],
	'default' => [ 0, '#умолчание' ],
	'time' => [ 0, 'время' ],
	'timel' => [ 0, 'мвремя' ],
	'replace' => [ 0, 'замена' ],
];

/** Serbian (Cyrillic script) (српски (ћирилица)) */
$magicWords['sr-ec'] = [
	'if' => [ 0, 'ако' ],
	'default' => [ 0, '#подразумевано' ],
	'time' => [ 0, 'време' ],
	'pos' => [ 0, 'поз' ],
	'count' => [ 0, 'број' ],
	'replace' => [ 0, 'замени' ],
];

/** Serbian (Latin script) (srpski (latinica)) */
$magicWords['sr-el'] = [
	'if' => [ 0, 'ako' ],
	'default' => [ 0, '#podrazumevano' ],
	'time' => [ 0, 'vreme' ],
	'pos' => [ 0, 'poz' ],
	'count' => [ 0, 'broj' ],
	'replace' => [ 0, 'zameni' ],
];

/** Swedish (svenska) */
$magicWords['sv'] = [
	'expr' => [ 0, 'utr', 'expr' ],
	'if' => [ 0, 'om', 'if' ],
	'ifeq' => [ 0, 'omlika', 'ifeq' ],
	'ifexpr' => [ 0, 'omutr', 'ifexpr' ],
	'iferror' => [ 0, 'omfel', 'iferror' ],
	'switch' => [ 0, 'växel', 'switch' ],
	'default' => [ 0, '#standard', '#default' ],
	'ifexist' => [ 0, 'omfinns', 'ifexist' ],
	'time' => [ 0, 'tid', 'time' ],
	'timel' => [ 0, 'tidl', 'timel' ],
	'replace' => [ 0, 'ersätt', 'replace' ],
	'explode' => [ 0, 'explodera', 'explode' ],
];

/** Tamil (தமிழ்) */
$magicWords['ta'] = [
	'count' => [ 0, 'எண்ணிக்கை' ],
];

/** Turkish (Türkçe) */
$magicWords['tr'] = [
	'expr' => [ 0, 'işlem', 'islem', 'ifade' ],
	'if' => [ 0, 'eğer', 'eger' ],
	'switch' => [ 0, 'değiştir', 'degistir' ],
	'default' => [ 0, '#vas' ],
];

/** Ukrainian (українська) */
$magicWords['uk'] = [
	'expr' => [ 0, 'вираз' ],
	'if' => [ 0, 'якщо', 'если' ],
	'ifeq' => [ 0, 'якщорівні', 'рівні' ],
	'ifexpr' => [ 0, 'якщовираз' ],
	'iferror' => [ 0, 'якщопомилка', 'еслиошибка' ],
	'switch' => [ 0, 'вибірка', 'переключатель' ],
	'default' => [ 0, '#інакше', '#за_замовчуванням', '#умолчание' ],
	'ifexist' => [ 0, 'якщоіснує' ],
	'replace' => [ 0, 'заміна', 'замена' ],
];

/** Urdu (اردو) */
$magicWords['ur'] = [
	'expr' => [ 0, 'اظہار' ],
	'if' => [ 0, 'اگر' ],
	'ifeq' => [ 0, 'اگربرابر' ],
	'ifexpr' => [ 0, 'اگراظہار' ],
	'iferror' => [ 0, 'اگرنقص' ],
	'switch' => [ 0, 'منتقل' ],
	'default' => [ 0, '#ابتدائی' ],
	'ifexist' => [ 0, 'اگرموجود' ],
	'time' => [ 0, 'وقت' ],
	'timel' => [ 0, 'وقت_لمبائی' ],
	'rel2abs' => [ 0, 'اضافی_تا_مطلق' ],
	'titleparts' => [ 0, 'اجزاء_عنوان' ],
	'len' => [ 0, 'لمبائی' ],
	'pos' => [ 0, 'جگہ' ],
	'rpos' => [ 0, 'جگہ_واپس' ],
	'sub' => [ 0, 'ذیلی' ],
	'count' => [ 0, 'شمار' ],
	'replace' => [ 0, 'تبدیلی' ],
	'explode' => [ 0, 'انتشار' ],
	'urldecode' => [ 0, 'بلاکوڈیوآرایل' ],
];

/** Uzbek (oʻzbekcha/ўзбекча) */
$magicWords['uz'] = [
	'expr' => [ 0, 'ifoda' ],
	'if' => [ 0, 'agar' ],
	'ifeq' => [ 0, 'agarteng' ],
	'ifexpr' => [ 0, 'agarifoda' ],
	'iferror' => [ 0, 'agarxato' ],
	'switch' => [ 0, 'tanlov' ],
	'default' => [ 0, '#boshlangʻich' ],
	'ifexist' => [ 0, 'agarbor' ],
	'time' => [ 0, 'vaqt' ],
	'len' => [ 0, 'uzunlik' ],
	'pos' => [ 0, 'oʻrin' ],
	'count' => [ 0, 'miqdor' ],
	'replace' => [ 0, 'almashtirish' ],
];

/** Vietnamese (Tiếng Việt) */
$magicWords['vi'] = [
	'expr' => [ 0, 'công_thức', 'côngthức' ],
	'if' => [ 0, 'nếu' ],
	'ifeq' => [ 0, 'nếu_bằng', 'nếubằng' ],
	'ifexpr' => [ 0, 'nếu_công_thức', 'nếucôngthức' ],
	'iferror' => [ 0, 'nếu_lỗi', 'nếulỗi' ],
	'default' => [ 0, '#mặc_định', '#mặcđịnh' ],
	'ifexist' => [ 0, 'nếu_tồn_tại', 'nếutồntại' ],
	'time' => [ 0, 'giờ' ],
	'timel' => [ 0, 'giờ_địa_phương', 'giờđịaphương' ],
	'len' => [ 0, 'số_chữ', 'sốchữ', 'số_ký_tự', 'sốkýtự', 'số_kí_tự', 'sốkítự' ],
	'pos' => [ 0, 'vị_trí', 'vịtrí' ],
	'rpos' => [ 0, 'vị_trí_phải', 'vịtríphải' ],
	'sub' => [ 0, 'chuỗi_con', 'chuỗicon' ],
	'count' => [ 0, 'số' ],
	'replace' => [ 0, 'thay_thế', 'thaythế' ],
	'urldecode' => [ 0, 'giải_mã_url', 'giảimãurl' ],
];

/** Yiddish (ייִדיש) */
$magicWords['yi'] = [
	'expr' => [ 0, 'רעכן' ],
	'if' => [ 0, 'תנאי' ],
	'ifeq' => [ 0, 'גלייך' ],
	'ifexpr' => [ 0, 'אויברעכן' ],
	'switch' => [ 0, 'קלייב' ],
	'default' => [ 0, '#גרונט' ],
	'ifexist' => [ 0, 'עקזיסט' ],
	'time' => [ 0, 'צייט' ],
	'timel' => [ 0, 'צייטל' ],
	'count' => [ 0, 'צאל' ],
];

/** Chinese (中文) */
$magicWords['zh'] = [
	'expr' => [ 0, '计算式' ],
	'if' => [ 0, '非空式' ],
	'ifeq' => [ 0, '相同式', '匹配式' ],
	'iferror' => [ 0, '错误式' ],
	'switch' => [ 0, '多选式', '多条件式', '双射式' ],
	'default' => [ 0, '#默认' ],
	'ifexist' => [ 0, '存在式' ],
	'len' => [ 0, '长度' ],
	'pos' => [ 0, '位置' ],
	'rpos' => [ 0, '最近位置' ],
	'sub' => [ 0, '截取' ],
	'count' => [ 0, '计数' ],
	'replace' => [ 0, '替换' ],
	'explode' => [ 0, '爆炸', '炸开' ],
];

/** Simplified Chinese (中文（简体）) */
$magicWords['zh-hans'] = [
	'expr' => [ 0, '表达式' ],
	'if' => [ 0, '若', '如果' ],
	'ifeq' => [ 0, '若相等', '如果相等' ],
	'ifexpr' => [ 0, '若表达式' ],
	'iferror' => [ 0, '如果错误' ],
	'switch' => [ 0, '开关', '转换' ],
	'default' => [ 0, '#默认' ],
	'ifexist' => [ 0, '若有', '如有' ],
	'time' => [ 0, '时间' ],
	'timel' => [ 0, '时间l' ],
	'titleparts' => [ 0, '标题组成部分' ],
	'len' => [ 0, '长度' ],
	'pos' => [ 0, '终端' ],
	'rpos' => [ 0, '反终端' ],
	'sub' => [ 0, 'PF子' ],
	'count' => [ 0, '计数' ],
	'replace' => [ 0, '取代' ],
	'explode' => [ 0, '粉碎' ],
	'urldecode' => [ 0, 'url解码' ],
];

/** Traditional Chinese (中文（繁體）) */
$magicWords['zh-hant'] = [
	'expr' => [ 0, '表達式' ],
	'if' => [ 0, '若' ],
	'ifexpr' => [ 0, '若表達式' ],
	'iferror' => [ 0, '如果錯誤' ],
	'switch' => [ 0, '轉換' ],
	'default' => [ 0, '#默認' ],
	'time' => [ 0, '時間' ],
	'timel' => [ 0, '時間L' ],
	'len' => [ 0, '長度' ],
	'count' => [ 0, '計算' ],
	'urldecode' => [ 0, 'URI解碼' ],
];
