# pylint:disable=line-too-long
from __future__ import annotations
import logging
from collections import OrderedDict

from angr.sim_type import SimTypeFunction, SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat, SimTypePointer, SimTypeChar, SimStruct, SimTypeArray, SimTypeBottom, SimUnion, SimTypeBool, SimTypeRef
from angr.calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from angr.procedures import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.type_collection_names = ["win32"]
lib.set_default_cc("X86", SimCCStdcall)
lib.set_default_cc("AMD64", SimCCMicrosoftAMD64)
lib.set_library_names("fwpuclnt.dll")
prototypes = \
    {
        #
        'FwpmFreeMemory0': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeBottom(label="Void"), arg_names=["p"]),
        #
        'FwpmEngineOpen0': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SEC_WINNT_AUTH_IDENTITY_W", SimStruct), offset=0), SimTypePointer(SimTypeRef("FWPM_SESSION0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["serverName", "authnService", "authIdentity", "session", "engineHandle"]),
        #
        'FwpmEngineClose0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle"]),
        #
        'FwpmEngineGetOption0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="FWPM_ENGINE_OPTION"), SimTypePointer(SimTypePointer(SimTypeRef("FWP_VALUE0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "option", "value"]),
        #
        'FwpmEngineSetOption0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="FWPM_ENGINE_OPTION"), SimTypePointer(SimTypeRef("FWP_VALUE0", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "option", "newValue"]),
        #
        'FwpmEngineGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmEngineSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmSessionCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_SESSION_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmSessionEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_SESSION0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmSessionDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmTransactionBegin0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "flags"]),
        #
        'FwpmTransactionCommit0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle"]),
        #
        'FwpmTransactionAbort0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle"]),
        #
        'FwpmProviderAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER0", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "provider", "sd"]),
        #
        'FwpmProviderDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmProviderGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "provider"]),
        #
        'FwpmProviderCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmProviderEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmProviderDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmProviderGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmProviderSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmProviderContextAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT0", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextAdd1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT1", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextAdd2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT2", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextAdd3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT3", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "providerContext", "sd", "id"]),
        #
        'FwpmProviderContextDeleteById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id"]),
        #
        'FwpmProviderContextDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmProviderContextGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetById1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT1", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetById2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT2", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetById3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT3", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "providerContext"]),
        #
        'FwpmProviderContextGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "providerContext"]),
        #
        'FwpmProviderContextGetByKey1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT1", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "providerContext"]),
        #
        'FwpmProviderContextGetByKey2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT2", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "providerContext"]),
        #
        'FwpmProviderContextGetByKey3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT3", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "providerContext"]),
        #
        'FwpmProviderContextCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmProviderContextEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmProviderContextEnum1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT1", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmProviderContextEnum2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT2", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmProviderContextEnum3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT3", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmProviderContextDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmProviderContextGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmProviderContextSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmSubLayerAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_SUBLAYER0", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "subLayer", "sd"]),
        #
        'FwpmSubLayerDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmSubLayerGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_SUBLAYER0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "subLayer"]),
        #
        'FwpmSubLayerCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_SUBLAYER_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmSubLayerEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_SUBLAYER0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmSubLayerDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmSubLayerGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmSubLayerSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmLayerGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_LAYER0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "layer"]),
        #
        'FwpmLayerGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_LAYER0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "layer"]),
        #
        'FwpmLayerCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_LAYER_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmLayerEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_LAYER0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmLayerDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmLayerGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmLayerSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmCalloutAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_CALLOUT0", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "callout", "sd", "id"]),
        #
        'FwpmCalloutDeleteById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id"]),
        #
        'FwpmCalloutDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmCalloutGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_CALLOUT0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "callout"]),
        #
        'FwpmCalloutGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_CALLOUT0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "callout"]),
        #
        'FwpmCalloutCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_CALLOUT_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmCalloutEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_CALLOUT0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmCalloutDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmCalloutGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmCalloutSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmFilterAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_FILTER0", SimStruct), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "filter", "sd", "id"]),
        #
        'FwpmFilterDeleteById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id"]),
        #
        'FwpmFilterDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key"]),
        #
        'FwpmFilterGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_FILTER0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "filter"]),
        #
        'FwpmFilterGetByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_FILTER0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "filter"]),
        #
        'FwpmFilterCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_FILTER_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmFilterEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_FILTER0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmFilterDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmFilterGetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmFilterSetSecurityInfoByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmIPsecTunnelAdd0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT0", SimStruct), offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT0", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_FILTER_CONDITION0", SimStruct), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "flags", "mainModePolicy", "tunnelPolicy", "numFilterConditions", "filterConditions", "sd"]),
        #
        'FwpmIPsecTunnelAdd1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT1", SimStruct), offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT1", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_FILTER_CONDITION0", SimStruct), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "flags", "mainModePolicy", "tunnelPolicy", "numFilterConditions", "filterConditions", "keyModKey", "sd"]),
        #
        'FwpmIPsecTunnelAdd2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT2", SimStruct), offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT2", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_FILTER_CONDITION0", SimStruct), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "flags", "mainModePolicy", "tunnelPolicy", "numFilterConditions", "filterConditions", "keyModKey", "sd"]),
        #
        'FwpmIPsecTunnelAdd3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT3", SimStruct), offset=0), SimTypePointer(SimTypeRef("FWPM_PROVIDER_CONTEXT3", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("FWPM_FILTER_CONDITION0", SimStruct), label="LPArray", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "flags", "mainModePolicy", "tunnelPolicy", "numFilterConditions", "filterConditions", "keyModKey", "sd"]),
        #
        'FwpmIPsecTunnelDeleteByKey0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "key"]),
        #
        'IPsecGetStatistics0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_STATISTICS0", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "ipsecStatistics"]),
        #
        'IPsecGetStatistics1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_STATISTICS1", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "ipsecStatistics"]),
        #
        'IPsecSaContextCreate0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_TRAFFIC0", SimStruct), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "outboundTraffic", "inboundFilterId", "id"]),
        #
        'IPsecSaContextCreate1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_TRAFFIC1", SimStruct), offset=0), SimTypePointer(SimTypeRef("IPSEC_VIRTUAL_IF_TUNNEL_INFO0", SimStruct), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0), SimTypePointer(SimTypeLongLong(signed=False, label="UInt64"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "outboundTraffic", "virtualIfTunnelInfo", "inboundFilterId", "id"]),
        #
        'IPsecSaContextDeleteById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id"]),
        #
        'IPsecSaContextGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_SA_CONTEXT0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "saContext"]),
        #
        'IPsecSaContextGetById1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_SA_CONTEXT1", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "saContext"]),
        #
        'IPsecSaContextGetSpi0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_GETSPI0", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "getSpi", "inboundSpi"]),
        #
        'IPsecSaContextGetSpi1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_GETSPI1", SimStruct), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "getSpi", "inboundSpi"]),
        #
        'IPsecSaContextSetSpi0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_GETSPI1", SimStruct), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "getSpi", "inboundSpi"]),
        #
        'IPsecSaContextAddInbound0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_SA_BUNDLE0", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "inboundBundle"]),
        #
        'IPsecSaContextAddOutbound0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_SA_BUNDLE0", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "outboundBundle"]),
        #
        'IPsecSaContextAddInbound1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_SA_BUNDLE1", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "inboundBundle"]),
        #
        'IPsecSaContextAddOutbound1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_SA_BUNDLE1", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "outboundBundle"]),
        #
        'IPsecSaContextExpire0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id"]),
        #
        'IPsecSaContextUpdate0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeRef("IPSEC_SA_CONTEXT1", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "flags", "newValues"]),
        #
        'IPsecSaContextCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_SA_CONTEXT_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'IPsecSaContextEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_SA_CONTEXT0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IPsecSaContextEnum1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_SA_CONTEXT1", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IPsecSaContextDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'IPsecSaCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_SA_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'IPsecSaEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_SA_DETAILS0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IPsecSaEnum1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_SA_DETAILS1", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IPsecSaDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'IPsecSaDbGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'IPsecSaDbSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'IPsecDospGetStatistics0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_DOSP_STATISTICS0", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "idpStatistics"]),
        #
        'IPsecDospStateCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IPSEC_DOSP_STATE_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'IPsecDospStateEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IPSEC_DOSP_STATE0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntries"]),
        #
        'IPsecDospStateDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'IPsecDospGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'IPsecDospSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'IkeextGetStatistics0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IKEEXT_STATISTICS0", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "ikeextStatistics"]),
        #
        'IkeextGetStatistics1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IKEEXT_STATISTICS1", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "ikeextStatistics"]),
        #
        'IkeextSaDeleteById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64")], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id"]),
        #
        'IkeextSaGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("IKEEXT_SA_DETAILS0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "sa"]),
        #
        'IkeextSaGetById1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("IKEEXT_SA_DETAILS1", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "saLookupContext", "sa"]),
        #
        'IkeextSaGetById2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("IKEEXT_SA_DETAILS2", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "saLookupContext", "sa"]),
        #
        'IkeextSaCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("IKEEXT_SA_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'IkeextSaEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IKEEXT_SA_DETAILS0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IkeextSaEnum1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IKEEXT_SA_DETAILS1", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IkeextSaEnum2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("IKEEXT_SA_DETAILS2", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'IkeextSaDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'IkeextSaDbGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'IkeextSaDbSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmNetEventCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_NET_EVENT_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmNetEventEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_NET_EVENT0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmNetEventEnum1': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_NET_EVENT1", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmNetEventEnum2': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_NET_EVENT2", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmNetEventEnum3': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_NET_EVENT3", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmNetEventEnum4': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_NET_EVENT4", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmNetEventEnum5': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_NET_EVENT5", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmNetEventDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmNetEventsGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmNetEventsSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmConnectionGetById0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypePointer(SimTypePointer(SimTypeRef("FWPM_CONNECTION0", SimStruct), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "id", "connection"]),
        #
        'FwpmConnectionEnum0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypePointer(SimTypeRef("FWPM_CONNECTION0", SimStruct), offset=0), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle", "numEntriesRequested", "entries", "numEntriesReturned"]),
        #
        'FwpmConnectionCreateEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeRef("FWPM_CONNECTION_ENUM_TEMPLATE0", SimStruct), offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumTemplate", "enumHandle"]),
        #
        'FwpmConnectionDestroyEnumHandle0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "enumHandle"]),
        #
        'FwpmConnectionGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmConnectionSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
        #
        'FwpmvSwitchEventsGetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl", "securityDescriptor"]),
        #
        'FwpmvSwitchEventsSetSecurityInfo0': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("SID", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0), SimTypePointer(SimTypeRef("ACL", SimStruct), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["engineHandle", "securityInfo", "sidOwner", "sidGroup", "dacl", "sacl"]),
    }

lib.set_prototypes(prototypes)
