/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.H5T;
import java.lang.reflect.Field;

abstract class HDF5MemberByteifyer {
    private final Field fieldOrNull;
    private final String memberName;
    protected final int size;
    protected final int sizeInBytes;
    protected final int offset;
    protected final CharacterEncoding encoding;
    private final HDF5DataTypeVariant typeVariant;

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int offset, HDF5DataTypeVariant typeVariantOrNull) {
        this(fieldOrNull, memberName, size, size, offset, CharacterEncoding.ASCII, typeVariantOrNull);
    }

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int sizeInBytes, int offset, CharacterEncoding encoding) {
        this(fieldOrNull, memberName, size, sizeInBytes, offset, encoding, HDF5DataTypeVariant.NONE);
    }

    HDF5MemberByteifyer(Field fieldOrNull, String memberName, int size, int sizeInBytes, int offset, CharacterEncoding encoding, HDF5DataTypeVariant typeVariantOrNull) {
        this.fieldOrNull = fieldOrNull;
        this.memberName = memberName;
        this.size = size;
        this.sizeInBytes = sizeInBytes;
        this.offset = offset;
        this.encoding = encoding;
        this.typeVariant = HDF5DataTypeVariant.maskNull(typeVariantOrNull);
    }

    abstract byte[] byteify(int var1, Object var2) throws IllegalAccessException;

    abstract void setFromByteArray(int var1, Object var2, byte[] var3, int var4) throws IllegalAccessException;

    abstract int getMemberStorageTypeId();

    abstract int getMemberNativeTypeId();

    HDF5EnumerationType tryGetEnumType() {
        return null;
    }

    void insertType(int dataTypeId) {
        H5T.H5Tinsert(dataTypeId, this.memberName, this.offset, this.getMemberStorageTypeId());
    }

    void insertNativeType(int dataTypeId, HDF5 h5, ICleanUpRegistry registry) {
        if (this.getMemberNativeTypeId() < 0) {
            H5T.H5Tinsert(dataTypeId, this.memberName, this.offset, h5.getNativeDataType(this.getMemberStorageTypeId(), registry));
        } else {
            H5T.H5Tinsert(dataTypeId, this.memberName, this.offset, this.getMemberNativeTypeId());
        }
    }

    String getMemberName() {
        return this.memberName;
    }

    Field tryGetField() {
        return this.fieldOrNull;
    }

    int getSize() {
        return this.size;
    }

    int getSizeInBytes() {
        return this.sizeInBytes;
    }

    int getOffset() {
        return this.offset;
    }

    int getTotalSize() {
        return this.offset + this.sizeInBytes;
    }

    HDF5DataTypeVariant getTypeVariant() {
        return this.typeVariant;
    }

    String describe() {
        if (this.fieldOrNull != null) {
            return "field '" + this.fieldOrNull.getName() + "' of class '" + this.fieldOrNull.getDeclaringClass().getCanonicalName() + "'";
        }
        return "member '" + this.memberName + "'";
    }

    boolean isDummy() {
        return false;
    }

    boolean mayBeCut() {
        return false;
    }

    public String toString() {
        return this.describe();
    }
}

