/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5.h5ar;

public final class ListParameters {
    private final boolean recursive;
    private final boolean readLinkTargets;
    private final boolean testArchive;
    private final boolean suppressDirectoryEntries;
    private final boolean includeTopLevelDirectoryEntry;
    private final boolean resolveSymbolicLinks;
    private final boolean followSymbolicLinks;
    public static final ListParameters DEFAULT = new ListParameters(true, true, false, false, false, false, false);
    public static final ListParameters TEST = new ListParameters(true, true, true, false, true, false, false);

    public static ListParametersBuilder build() {
        return new ListParametersBuilder();
    }

    private ListParameters(boolean recursive, boolean readLinkTargets, boolean testArchive, boolean suppressDirectoryEntries, boolean includeTopLevelDirectoryEntry, boolean resolveSymbolicLinks, boolean followSymbolicLinks) {
        this.recursive = recursive;
        this.readLinkTargets = readLinkTargets || resolveSymbolicLinks;
        this.testArchive = testArchive;
        this.suppressDirectoryEntries = suppressDirectoryEntries;
        this.includeTopLevelDirectoryEntry = includeTopLevelDirectoryEntry;
        this.resolveSymbolicLinks = resolveSymbolicLinks;
        this.followSymbolicLinks = followSymbolicLinks;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isReadLinkTargets() {
        return this.readLinkTargets;
    }

    public boolean isTestArchive() {
        return this.testArchive;
    }

    public boolean isSuppressDirectoryEntries() {
        return this.suppressDirectoryEntries;
    }

    public boolean isIncludeTopLevelDirectoryEntry() {
        return this.includeTopLevelDirectoryEntry;
    }

    public boolean isResolveSymbolicLinks() {
        return this.resolveSymbolicLinks;
    }

    public boolean isFollowSymbolicLinks() {
        return this.followSymbolicLinks;
    }

    /* synthetic */ ListParameters(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, ListParameters listParameters) {
        this(bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    public static final class ListParametersBuilder {
        private boolean recursive = true;
        private boolean readLinkTargets = true;
        private boolean testArchive = false;
        private boolean suppressDirectoryEntries = false;
        private boolean includeTopLevelDirectoryEntry = false;
        private boolean resolveSymbolicLinks = false;
        private boolean followSymbolicLinks = false;

        private ListParametersBuilder() {
        }

        public ListParametersBuilder nonRecursive() {
            this.recursive = false;
            return this;
        }

        public ListParametersBuilder recursive(boolean recursive) {
            this.recursive = recursive;
            return this;
        }

        public ListParametersBuilder noReadLinkTarget() {
            this.readLinkTargets = false;
            return this;
        }

        public ListParametersBuilder readLinkTargets(boolean readLinkTargets) {
            this.readLinkTargets = readLinkTargets;
            return this;
        }

        public ListParametersBuilder testArchive() {
            this.testArchive = true;
            return this;
        }

        public ListParametersBuilder testArchive(boolean testArchive) {
            this.testArchive = testArchive;
            return this;
        }

        public ListParametersBuilder suppressDirectoryEntries() {
            this.suppressDirectoryEntries = true;
            return this;
        }

        public ListParametersBuilder suppressDirectoryEntries(boolean suppressDirectoryEntries) {
            this.suppressDirectoryEntries = suppressDirectoryEntries;
            return this;
        }

        public ListParametersBuilder includeTopLevelDirectoryEntry() {
            this.includeTopLevelDirectoryEntry = true;
            return this;
        }

        public ListParametersBuilder includeTopLevelDirectoryEntry(boolean includeTopLevelDirectoryEntry) {
            this.includeTopLevelDirectoryEntry = includeTopLevelDirectoryEntry;
            return this;
        }

        public ListParametersBuilder resolveSymbolicLinks() {
            this.resolveSymbolicLinks = true;
            return this;
        }

        public ListParametersBuilder resolveSymbolicLinks(boolean resolveSymbolicLinks) {
            this.resolveSymbolicLinks = resolveSymbolicLinks;
            return this;
        }

        public ListParametersBuilder followSymbolicLinks() {
            this.followSymbolicLinks = true;
            return this;
        }

        public ListParametersBuilder followSymbolicLinks(boolean followSymbolicLinks) {
            this.followSymbolicLinks = followSymbolicLinks;
            return this;
        }

        public ListParameters get() {
            return new ListParameters(this.recursive, this.readLinkTargets, this.testArchive, this.suppressDirectoryEntries, this.includeTopLevelDirectoryEntry, this.resolveSymbolicLinks, this.followSymbolicLinks, null);
        }
    }
}

