/*
 * Decompiled with CFR 0.152.
 */
package com.gallery.GalleryRemote;

import com.gallery.GalleryRemote.GalleryRemote;
import com.gallery.GalleryRemote.Log;
import com.gallery.GalleryRemote.MainFrame;
import com.gallery.GalleryRemote.PictureSelection;
import com.gallery.GalleryRemote.model.Picture;
import com.gallery.GalleryRemote.util.GRI18n;
import com.gallery.GalleryRemote.util.ImageUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class DroppableList
extends JList
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    protected static final String MODULE = "Droplist";
    MainFrame mf = null;
    DragSource dragSource = new DragSource();
    DropTarget dropTarget;
    int lastY = -1;
    int scrollPace = 0;

    public DroppableList() {
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public void paint(Graphics g) {
        this.lastY = -1;
        super.paint(g);
    }

    public boolean isDragOK(DropTargetEvent dropTargetEvent) {
        if (!this.isEnabled()) {
            return false;
        }
        if (dropTargetEvent instanceof DropTargetDragEvent) {
            return ((DropTargetDragEvent)dropTargetEvent).isDataFlavorSupported(DataFlavor.javaFileListFlavor) || ((DropTargetDragEvent)dropTargetEvent).isDataFlavorSupported(PictureSelection.flavors[0]) || ((DropTargetDragEvent)dropTargetEvent).isDataFlavorSupported(DataFlavor.stringFlavor);
        }
        return ((DropTargetDropEvent)dropTargetEvent).isDataFlavorSupported(DataFlavor.javaFileListFlavor) || ((DropTargetDropEvent)dropTargetEvent).isDataFlavorSupported(PictureSelection.flavors[0]) || ((DropTargetDropEvent)dropTargetEvent).isDataFlavorSupported(DataFlavor.stringFlavor);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        Log.log(3, MODULE, "dragEnter - dtde");
        Iterator<DataFlavor> it = dropTargetDragEvent.getCurrentDataFlavorsAsList().iterator();
        while (it.hasNext()) {
            DataFlavor flavor = it.next();
            Log.log(3, MODULE, "Flavor: " + flavor.getHumanPresentableName() + " -- " + flavor.getMimeType());
        }
        Log.log(3, MODULE, "Action: " + dropTargetDragEvent.getSourceActions() + " -- " + dropTargetDragEvent.getDropAction());
        if (!this.isDragOK(dropTargetDragEvent)) {
            Log.log(3, MODULE, "Refusing drag");
            dropTargetDragEvent.rejectDrag();
            return;
        }
        Log.log(3, MODULE, "Accepting drag");
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        Log.log(3, MODULE, "dragExit - dtde");
        this.repaint();
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this.isDragOK(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this.dragOver((int)dropTargetDragEvent.getLocation().getY());
    }

    public void dragOver(int y) {
        int ySnap;
        int tmpLastY;
        int i = this.locationToIndex(new Point(1, y));
        Rectangle r = this.getVisibleRect();
        boolean scrolled = false;
        if ((double)y < r.getY() + (double)this.safeGetFixedCellHeight() && i > 0) {
            tmpLastY = this.lastY;
            this.ensureIndexIsVisible(i - 1);
            this.lastY = tmpLastY;
            scrolled = true;
        }
        if ((double)y > r.getY() + r.getHeight() - (double)this.safeGetFixedCellHeight() && i < this.getModel().getSize() - 1) {
            tmpLastY = this.lastY;
            this.ensureIndexIsVisible(i + 1);
            this.lastY = tmpLastY;
            scrolled = true;
        }
        Graphics g = this.getGraphics();
        g.setXORMode(Color.cyan);
        int xStart = 10;
        int xStop = (int)this.getVisibleRect().getWidth() - xStart;
        if (this.lastY != -1) {
            ySnap = this.snap(this.lastY);
            g.drawLine(xStart, ySnap, xStop, ySnap);
            g.drawLine(xStart, ySnap + 1, xStop, ySnap + 1);
        }
        this.lastY = y;
        ySnap = this.snap(this.lastY);
        g.drawLine(xStart, ySnap, xStop, ySnap);
        g.drawLine(xStart, ySnap + 1, xStop, ySnap + 1);
        if (scrolled) {
            ++this.scrollPace;
            try {
                Thread.sleep(this.scrollPace > 5 ? 10L : 200L);
            }
            catch (InterruptedException e) {}
        } else {
            this.scrollPace = 0;
        }
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
        Log.log(3, MODULE, "drop - dtde");
        if (!this.isDragOK(dropTargetDropEvent)) {
            Log.log(3, MODULE, "Refusing drop");
            dropTargetDropEvent.rejectDrop();
            return;
        }
        Log.log(3, MODULE, "Accepting drop");
        try {
            boolean endOfList;
            Transferable tr = dropTargetDropEvent.getTransferable();
            dropTargetDropEvent.acceptDrop(0x40000003);
            Point dropLocation = dropTargetDropEvent.getLocation();
            int listIndex = this.snapIndex((int)dropLocation.getY());
            boolean bl = endOfList = listIndex >= this.getModel().getSize();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                fileList = this.expandDirectories(fileList);
                Log.log(3, MODULE, "Adding " + fileList.size() + " new files(s) to list at index " + listIndex);
                GalleryRemote._().getCore().addPictures(fileList.toArray(new File[0]), listIndex, false);
            } else if (tr.isDataFlavorSupported(PictureSelection.flavors[0])) {
                List pictureList = (List)tr.getTransferData(PictureSelection.flavors[0]);
                Log.log(3, MODULE, "Adding " + pictureList.size() + " new pictures(s) to list at index " + listIndex);
                GalleryRemote._().getCore().addPictures(pictureList.toArray(new Picture[0]), listIndex, true);
            } else if (tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String[] fileStrings = ((String)tr.getTransferData(DataFlavor.stringFlavor)).split("\r\n");
                List fileList = new ArrayList<File>();
                for (int i = 0; i < fileStrings.length; ++i) {
                    try {
                        fileList.add(new File(new URI(fileStrings[i])));
                        continue;
                    }
                    catch (URISyntaxException ue) {
                        // empty catch block
                    }
                }
                fileList = this.expandDirectories(fileList);
                Log.log(3, MODULE, "Adding " + fileList.size() + " new files(s) to list at index " + listIndex);
                GalleryRemote._().getCore().addPictures(fileList.toArray(new File[0]), listIndex, false);
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            if (endOfList && this.getModel().getSize() > 0) {
                this.ensureIndexIsVisible(this.getModel().getSize() - 1);
            }
        }
        catch (IOException io) {
            Log.logException(1, MODULE, io);
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
        catch (UnsupportedFlavorException ufe) {
            Log.logException(1, MODULE, ufe);
            dropTargetDropEvent.getDropTargetContext().dropComplete(false);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        Log.log(3, MODULE, "dropActionChanged - dtde");
        if (!this.isDragOK(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        Log.log(3, MODULE, "dragDropEnd - dsde");
        if (dragSourceDropEvent.getDropSuccess() && dragSourceDropEvent.getDropAction() == 2) {
            PictureSelection ps = (PictureSelection)dragSourceDropEvent.getDragSourceContext().getTransferable();
            Iterator it = ps.iterator();
            while (it.hasNext()) {
                GalleryRemote._().getCore().getCurrentAlbum().removePicture((Picture)it.next());
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent event) {
        Log.log(3, MODULE, "dragGestureRecognized");
        PictureSelection ps = new PictureSelection(this);
        if (!ps.isEmpty()) {
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, ps, this);
        } else {
            Log.log(3, MODULE, "nothing was selected");
        }
    }

    int safeGetFixedCellHeight() {
        int height = this.getFixedCellHeight();
        if (height == -1) {
            height = (int)this.getCellRenderer().getListCellRendererComponent(this, null, -1, false, false).getPreferredSize().getHeight();
        }
        return height;
    }

    public int snap(int y) {
        int snap = this.snapIndex(y) * this.safeGetFixedCellHeight();
        if (snap >= this.getHeight()) {
            snap = this.getHeight() - 2;
        }
        return snap;
    }

    public int snapIndex(int y) {
        int height = this.safeGetFixedCellHeight();
        int row = (int)Math.floor((double)((float)y / (float)height) + 0.5);
        if (row > this.getModel().getSize()) {
            row = this.getModel().getSize();
        }
        return row;
    }

    public List expandDirectories(List fileList) {
        try {
            return ImageUtils.expandDirectories(fileList);
        }
        catch (IOException ioe) {
            Log.log(1, MODULE, "i/o exception listing dirs in a drop");
            Log.logStack(1, MODULE);
            JOptionPane.showMessageDialog(null, GRI18n.getString(MODULE, "imgError"), GRI18n.getString(MODULE, "dragError"), 0);
            return fileList;
        }
    }
}

