/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.Rational;
import com.drew.metadata.Directory;
import com.drew.metadata.MetadataException;
import com.drew.metadata.TagDescriptor;
import java.text.DecimalFormat;

public class ExifDescriptor
extends TagDescriptor {
    private boolean _allowDecimalRepresentationOfRationals = true;

    public ExifDescriptor(Directory directory) {
        super(directory);
    }

    public String getDescription(int n) throws MetadataException {
        switch (n) {
            case 274: {
                return this.getOrientationDescription();
            }
            case 296: {
                return this.getResolutionDescription();
            }
            case 531: {
                return this.getYCbCrPositioningDescription();
            }
            case 33434: {
                return this.getExposureTimeDescription();
            }
            case 37377: {
                return this.getShutterSpeedDescription();
            }
            case 33437: {
                return this.getFNumberDescription();
            }
            case 282: {
                return this.getXResolutionDescription();
            }
            case 283: {
                return this.getYResolutionDescription();
            }
            case 513: {
                return this.getThumbnailOffsetDescription();
            }
            case 514: {
                return this.getThumbnailLengthDescription();
            }
            case 37122: {
                return this.getCompressionLevelDescription();
            }
            case 37382: {
                return this.getSubjectDistanceDescription();
            }
            case 37383: {
                return this.getMeteringModeDescription();
            }
            case 37384: {
                return this.getWhiteBalanceDescription();
            }
            case 37385: {
                return this.getFlashDescription();
            }
            case 37386: {
                return this.getFocalLengthDescription();
            }
            case 40961: {
                return this.getColorSpaceDescription();
            }
            case 40962: {
                return this.getExifImageWidthDescription();
            }
            case 40963: {
                return this.getExifImageHeightDescription();
            }
            case 41488: {
                return this.getFocalPlaneResolutionUnitDescription();
            }
            case 41486: {
                return this.getFocalPlaneXResolutionDescription();
            }
            case 41487: {
                return this.getFocalPlaneYResolutionDescription();
            }
            case 256: {
                return this.getThumbnailImageWidthDescription();
            }
            case 257: {
                return this.getThumbnailImageHeightDescription();
            }
            case 258: {
                return this.getBitsPerSampleDescription();
            }
            case 259: {
                return this.getCompressionDescription();
            }
            case 262: {
                return this.getPhotometricInterpretationDescription();
            }
            case 278: {
                return this.getRowsPerStripDescription();
            }
            case 279: {
                return this.getStripByteCountsDescription();
            }
            case 277: {
                return this.getSamplesPerPixelDescription();
            }
            case 284: {
                return this.getPlanarConfigurationDescription();
            }
            case 530: {
                return this.getYCbCrSubsamplingDescription();
            }
            case 34850: {
                return this.getExposureProgramDescription();
            }
            case 37378: {
                return this.getApertureValueDescription();
            }
            case 37381: {
                return this.getMaxApertureValueDescription();
            }
            case 41495: {
                return this.getSensingMethodDescription();
            }
            case 37380: {
                return this.getExposureBiasDescription();
            }
            case 41728: {
                return this.getFileSourceDescription();
            }
            case 41729: {
                return this.getSceneTypeDescription();
            }
            case 37121: {
                return this.getComponentConfigurationDescription();
            }
            case 36864: {
                return this.getExifVersionDescription();
            }
            case 40960: {
                return this.getFlashPixVersionDescription();
            }
            case 532: {
                return this.getReferenceBlackWhiteDescription();
            }
            case 34855: {
                return this.getIsoEquivalentDescription();
            }
            case 61441: {
                return this.getThumbnailDescription();
            }
        }
        return this._directory.getString(n);
    }

    private String getThumbnailDescription() throws MetadataException {
        if (!this._directory.containsTag(61441)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(61441);
        return "[" + nArray.length + " bytes of thumbnail data]";
    }

    private String getIsoEquivalentDescription() throws MetadataException {
        if (!this._directory.containsTag(34855)) {
            return null;
        }
        int n = this._directory.getInt(34855);
        if (n < 50) {
            n *= 200;
        }
        return Integer.toString(n);
    }

    private String getReferenceBlackWhiteDescription() throws MetadataException {
        if (!this._directory.containsTag(532)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(532);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4];
        int n6 = nArray[5];
        String string = "[" + n + "," + n3 + "," + n5 + "] " + "[" + n2 + "," + n4 + "," + n6 + "]";
        return string;
    }

    private String getExifVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(36864)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(36864);
        return ExifDescriptor.convertBytesToVersionString(nArray);
    }

    private String getFlashPixVersionDescription() throws MetadataException {
        if (!this._directory.containsTag(40960)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(40960);
        return ExifDescriptor.convertBytesToVersionString(nArray);
    }

    private String getSceneTypeDescription() throws MetadataException {
        if (!this._directory.containsTag(41729)) {
            return null;
        }
        int n = this._directory.getInt(41729);
        if (n == 1) {
            return "Directly photographed image";
        }
        return "Unknown (" + n + ")";
    }

    private String getFileSourceDescription() throws MetadataException {
        if (!this._directory.containsTag(41728)) {
            return null;
        }
        int n = this._directory.getInt(41728);
        if (n == 3) {
            return "Digital Still Camera (DSC)";
        }
        return "Unknown (" + n + ")";
    }

    private String getExposureBiasDescription() throws MetadataException {
        if (!this._directory.containsTag(37380)) {
            return null;
        }
        Rational rational = this._directory.getRational(37380);
        return rational.toSimpleString(true);
    }

    private String getMaxApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(37381)) {
            return null;
        }
        double d = this._directory.getDouble(37381);
        double d2 = Math.sqrt(2.0);
        double d3 = Math.pow(d2, d);
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        return "F" + decimalFormat.format(d3);
    }

    private String getApertureValueDescription() throws MetadataException {
        if (!this._directory.containsTag(37378)) {
            return null;
        }
        double d = this._directory.getDouble(37378);
        double d2 = Math.sqrt(2.0);
        double d3 = Math.pow(d2, d);
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        return "F" + decimalFormat.format(d3);
    }

    private String getExposureProgramDescription() throws MetadataException {
        if (!this._directory.containsTag(34850)) {
            return null;
        }
        switch (this._directory.getInt(34850)) {
            case 1: {
                return "Manual control";
            }
            case 2: {
                return "Program normal";
            }
            case 3: {
                return "Aperture priority";
            }
            case 4: {
                return "Shutter priority";
            }
            case 5: {
                return "Program creative (slow program)";
            }
            case 6: {
                return "Program action (high-speed program)";
            }
            case 7: {
                return "Portrait mode";
            }
            case 8: {
                return "Landscape mode";
            }
        }
        return "Unknown program (" + this._directory.getInt(34850) + ")";
    }

    private String getYCbCrSubsamplingDescription() throws MetadataException {
        if (!this._directory.containsTag(530)) {
            return null;
        }
        int[] nArray = this._directory.getIntArray(530);
        if (nArray[0] == 2 && nArray[1] == 1) {
            return "YCbCr4:2:2";
        }
        if (nArray[0] == 2 && nArray[1] == 2) {
            return "YCbCr4:2:0";
        }
        return "(Unknown)";
    }

    private String getPlanarConfigurationDescription() throws MetadataException {
        if (!this._directory.containsTag(284)) {
            return null;
        }
        switch (this._directory.getInt(284)) {
            case 1: {
                return "Chunky (contiguous for each subsampling pixel)";
            }
            case 2: {
                return "Separate (Y-plane/Cb-plane/Cr-plane format)";
            }
        }
        return "Unknown configuration";
    }

    private String getSamplesPerPixelDescription() {
        if (!this._directory.containsTag(277)) {
            return null;
        }
        return this._directory.getString(277) + " samples/pixel";
    }

    private String getRowsPerStripDescription() {
        if (!this._directory.containsTag(278)) {
            return null;
        }
        return this._directory.getString(278) + " rows/strip";
    }

    private String getStripByteCountsDescription() {
        if (!this._directory.containsTag(279)) {
            return null;
        }
        return this._directory.getString(279) + " bytes";
    }

    private String getPhotometricInterpretationDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        switch (this._directory.getInt(259)) {
            case 1: {
                return "Monochrome";
            }
            case 2: {
                return "RGB";
            }
            case 6: {
                return "YCbCr";
            }
        }
        return "Unknown colour space";
    }

    private String getCompressionDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        switch (this._directory.getInt(259)) {
            case 1: {
                return "No compression";
            }
            case 6: {
                return "JPEG compression";
            }
        }
        return "Unknown compression";
    }

    private String getBitsPerSampleDescription() {
        if (!this._directory.containsTag(258)) {
            return null;
        }
        return this._directory.getString(258) + " bits/component/pixel";
    }

    private String getThumbnailImageWidthDescription() {
        if (!this._directory.containsTag(256)) {
            return null;
        }
        return this._directory.getString(256) + " pixels";
    }

    private String getThumbnailImageHeightDescription() {
        if (!this._directory.containsTag(257)) {
            return null;
        }
        return this._directory.getString(257) + " pixels";
    }

    private String getFocalPlaneXResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(41486)) {
            return null;
        }
        Rational rational = this._directory.getRational(41486);
        return rational.getReciprocal().toSimpleString(this._allowDecimalRepresentationOfRationals) + " " + this.getFocalPlaneResolutionUnitDescription().toLowerCase();
    }

    private String getFocalPlaneYResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(259)) {
            return null;
        }
        Rational rational = this._directory.getRational(41487);
        return rational.getReciprocal().toSimpleString(this._allowDecimalRepresentationOfRationals) + " " + this.getFocalPlaneResolutionUnitDescription().toLowerCase();
    }

    private String getFocalPlaneResolutionUnitDescription() throws MetadataException {
        if (!this._directory.containsTag(41488)) {
            return null;
        }
        switch (this._directory.getInt(41488)) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inches";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    private String getExifImageWidthDescription() throws MetadataException {
        if (!this._directory.containsTag(40962)) {
            return null;
        }
        return this._directory.getInt(40962) + " pixels";
    }

    private String getExifImageHeightDescription() throws MetadataException {
        if (!this._directory.containsTag(40963)) {
            return null;
        }
        return this._directory.getInt(40963) + " pixels";
    }

    private String getColorSpaceDescription() throws MetadataException {
        if (!this._directory.containsTag(40961)) {
            return null;
        }
        int n = this._directory.getInt(40961);
        if (n == 1) {
            return "sRGB";
        }
        if (n == 65535) {
            return "Undefined";
        }
        return "Unknown";
    }

    private String getFocalLengthDescription() throws MetadataException {
        if (!this._directory.containsTag(37386)) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.0##");
        Rational rational = this._directory.getRational(37386);
        return decimalFormat.format(rational.doubleValue()) + " mm";
    }

    private String getFlashDescription() throws MetadataException {
        if (!this._directory.containsTag(37385)) {
            return null;
        }
        switch (this._directory.getInt(37385)) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Flash fired";
            }
            case 5: {
                return "Flash fired but strobe return light not detected";
            }
            case 7: {
                return "flash fired and strobe return light detected";
            }
        }
        return "Unknown (" + this._directory.getInt(37385) + ")";
    }

    private String getWhiteBalanceDescription() throws MetadataException {
        if (!this._directory.containsTag(37384)) {
            return null;
        }
        switch (this._directory.getInt(37384)) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Daylight";
            }
            case 2: {
                return "Flourescent";
            }
            case 3: {
                return "Tungsten";
            }
            case 10: {
                return "Flash";
            }
            case 17: {
                return "Standard light";
            }
            case 18: {
                return "Standard light (B)";
            }
            case 19: {
                return "Standard light (C)";
            }
            case 20: {
                return "D55";
            }
            case 21: {
                return "D65";
            }
            case 22: {
                return "D75";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "Unknown (" + this._directory.getInt(37384) + ")";
    }

    private String getMeteringModeDescription() throws MetadataException {
        if (!this._directory.containsTag(37383)) {
            return null;
        }
        int n = this._directory.getInt(37383);
        switch (n) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Average";
            }
            case 2: {
                return "Center weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 4: {
                return "Multi-spot";
            }
            case 5: {
                return "Multi-segment";
            }
            case 6: {
                return "Partial";
            }
            case 255: {
                return "(Other)";
            }
        }
        return "";
    }

    private String getSubjectDistanceDescription() throws MetadataException {
        if (!this._directory.containsTag(37382)) {
            return null;
        }
        Rational rational = this._directory.getRational(37382);
        DecimalFormat decimalFormat = new DecimalFormat("0.0##");
        return decimalFormat.format(rational.doubleValue()) + " metres";
    }

    private String getCompressionLevelDescription() throws MetadataException {
        if (!this._directory.containsTag(37122)) {
            return null;
        }
        Rational rational = this._directory.getRational(37122);
        String string = rational.toSimpleString(this._allowDecimalRepresentationOfRationals);
        if (rational.isInteger() && rational.intValue() == 1) {
            return string + " bit/pixel";
        }
        return string + " bits/pixel";
    }

    private String getThumbnailLengthDescription() {
        if (!this._directory.containsTag(514)) {
            return null;
        }
        return this._directory.getString(514) + " bytes";
    }

    private String getThumbnailOffsetDescription() {
        if (!this._directory.containsTag(513)) {
            return null;
        }
        return this._directory.getString(513) + " bytes";
    }

    private String getYResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(283)) {
            return null;
        }
        Rational rational = this._directory.getRational(283);
        return rational.getReciprocal().toSimpleString(this._allowDecimalRepresentationOfRationals) + " " + this.getResolutionDescription().toLowerCase();
    }

    private String getXResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(282)) {
            return null;
        }
        Rational rational = this._directory.getRational(282);
        return rational.getReciprocal().toSimpleString(this._allowDecimalRepresentationOfRationals) + " " + this.getResolutionDescription().toLowerCase();
    }

    private String getExposureTimeDescription() {
        if (!this._directory.containsTag(33434)) {
            return null;
        }
        return this._directory.getString(33434) + " sec";
    }

    private String getShutterSpeedDescription() throws MetadataException {
        if (!this._directory.containsTag(37377)) {
            return null;
        }
        int n = this._directory.getInt(37377);
        int n2 = (int)(Math.pow(2.0, n) + 0.5);
        return "1/" + n2 + " sec";
    }

    private String getFNumberDescription() throws MetadataException {
        if (!this._directory.containsTag(33437)) {
            return null;
        }
        Rational rational = this._directory.getRational(33437);
        DecimalFormat decimalFormat = new DecimalFormat("0.#");
        return "F" + decimalFormat.format(rational.doubleValue());
    }

    private String getYCbCrPositioningDescription() throws MetadataException {
        if (!this._directory.containsTag(531)) {
            return null;
        }
        int n = this._directory.getInt(531);
        switch (n) {
            case 1: {
                return "Center of pixel array";
            }
            case 2: {
                return "Datum point";
            }
        }
        return String.valueOf(n);
    }

    private String getOrientationDescription() throws MetadataException {
        if (!this._directory.containsTag(274)) {
            return null;
        }
        int n = this._directory.getInt(274);
        switch (n) {
            case 1: {
                return "top, left side";
            }
            case 2: {
                return "top, right side";
            }
            case 3: {
                return "bottom, right side";
            }
            case 4: {
                return "bottom, left side";
            }
            case 5: {
                return "left side, top";
            }
            case 6: {
                return "right side, top";
            }
            case 7: {
                return "right side, bottom";
            }
            case 8: {
                return "left side, bottom";
            }
        }
        return String.valueOf(n);
    }

    private String getResolutionDescription() throws MetadataException {
        if (!this._directory.containsTag(296)) {
            return "";
        }
        int n = this._directory.getInt(296);
        switch (n) {
            case 1: {
                return "(No unit)";
            }
            case 2: {
                return "Inches";
            }
            case 3: {
                return "cm";
            }
        }
        return "";
    }

    private String getSensingMethodDescription() throws MetadataException {
        if (!this._directory.containsTag(41495)) {
            return null;
        }
        int n = this._directory.getInt(41495);
        switch (n) {
            case 1: {
                return "(Not defined)";
            }
            case 2: {
                return "One-chip color area sensor";
            }
            case 3: {
                return "Two-chip color area sensor";
            }
            case 4: {
                return "Three-chip color area sensor";
            }
            case 5: {
                return "Color sequential area sensor";
            }
            case 7: {
                return "Trilinear sensor";
            }
            case 8: {
                return "Color sequential linear sensor";
            }
        }
        return "";
    }

    private String getComponentConfigurationDescription() throws MetadataException {
        int[] nArray = this._directory.getIntArray(37121);
        String[] stringArray = new String[]{"", "Y", "Cb", "Cr", "R", "G", "B"};
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < Math.min(4, nArray.length)) {
            int n2 = nArray[n];
            if (n2 > 0 && n2 < stringArray.length) {
                stringBuffer.append(stringArray[n2]);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String convertBytesToVersionString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            if (n == 2) {
                stringBuffer.append('.');
            }
            String string = String.valueOf((char)nArray[n]);
            if (n != 0 || !"0".equals(string)) {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

