/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.SplitButtonModel;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class SplitButtonGroup
extends ButtonGroup {
    ButtonModel selection = null;

    @Override
    public void add(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.addElement(b);
        if (b instanceof JideSplitButton) {
            if (((JideSplitButton)b).isButtonSelected()) {
                if (this.selection == null) {
                    this.selection = b.getModel();
                } else {
                    ((JideSplitButton)b).setButtonSelected(false);
                }
            }
        } else if (b.isSelected()) {
            if (this.selection == null) {
                this.selection = b.getModel();
            } else {
                b.setSelected(false);
            }
        }
        b.getModel().setGroup(this);
    }

    @Override
    public void remove(AbstractButton b) {
        if (b == null) {
            return;
        }
        this.buttons.removeElement(b);
        if (b.getModel() == this.selection) {
            this.selection = null;
        }
        b.getModel().setGroup(null);
    }

    @Override
    public void setSelected(ButtonModel m, boolean b) {
        if (b && m != null && m != this.selection) {
            ButtonModel oldSelection = this.selection;
            this.selection = m;
            if (oldSelection != null) {
                if (oldSelection instanceof SplitButtonModel) {
                    ((SplitButtonModel)oldSelection).setButtonSelected(false);
                } else {
                    oldSelection.setSelected(false);
                }
            }
            if (m instanceof SplitButtonModel) {
                ((SplitButtonModel)m).setButtonSelected(true);
            } else {
                m.setSelected(true);
            }
        }
    }

    @Override
    public boolean isSelected(ButtonModel m) {
        return m == this.selection;
    }
}

