/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.baseinfo;

import java.util.Properties;
import org.campagnelab.dl.varanalysis.protobuf.BaseInformationRecords;
import org.campagnelab.goby.baseinfo.StatAccumulator;

public class StatAccumulatorBaseQuality
extends StatAccumulator {
    public static final String STATS_BASEQUALITY_FORWARD = "stats.baseQuality.forward";
    public static final String STATS_BASEQUALITY_REVERSE = "stats.baseQuality.reverse";
    protected float minimumValueQualForward = Float.POSITIVE_INFINITY;
    protected float maximumValueQualForward = Float.NEGATIVE_INFINITY;
    protected float minimumValueQualReverse = Float.POSITIVE_INFINITY;
    protected float maximumValueQualReverse = Float.NEGATIVE_INFINITY;
    private String propertyName;

    public StatAccumulatorBaseQuality() {
        super(null, null);
    }

    @Override
    void setProperties(Properties properties) {
        this.propertyName = STATS_BASEQUALITY_FORWARD;
        if (this.isDefined(this.minimumValueQualForward)) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValueQualForward));
        }
        if (this.isDefined(this.maximumValueQualForward)) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValueQualForward));
        }
        this.propertyName = STATS_BASEQUALITY_REVERSE;
        if (this.isDefined(this.minimumValueQualReverse)) {
            properties.setProperty(this.propertyName + ".min", Float.toString(this.minimumValueQualReverse));
        }
        if (this.isDefined(this.maximumValueQualReverse)) {
            properties.setProperty(this.propertyName + ".max", Float.toString(this.maximumValueQualReverse));
        }
    }

    @Override
    void observe(BaseInformationRecords.BaseInformation record) {
        for (BaseInformationRecords.SampleInfo sample : record.getSamplesList()) {
            for (BaseInformationRecords.CountInfo count : sample.getCountsList()) {
                for (BaseInformationRecords.NumberWithFrequency freqvalue : count.getQualityScoresForwardStrandList()) {
                    this.minimumValueQualForward = Math.min(this.minimumValueQualForward, (float)freqvalue.getNumber());
                    this.maximumValueQualForward = Math.max(this.maximumValueQualForward, (float)freqvalue.getNumber());
                }
                for (BaseInformationRecords.NumberWithFrequency freqvalue : count.getQualityScoresReverseStrandList()) {
                    this.minimumValueQualReverse = Math.min(this.minimumValueQualReverse, (float)freqvalue.getNumber());
                    this.maximumValueQualReverse = Math.max(this.maximumValueQualReverse, (float)freqvalue.getNumber());
                }
            }
        }
    }

    @Override
    void mergeWith(Properties properties) {
        if (properties.get("stats.baseQuality.forward.min") != null) {
            this.minimumValueQualForward = Math.min(this.minimumValueQualForward, Float.parseFloat(properties.get("stats.baseQuality.forward.min").toString()));
        }
        if (properties.get("stats.baseQuality.reverse.min") != null) {
            this.minimumValueQualReverse = Math.min(this.minimumValueQualReverse, Float.parseFloat(properties.get("stats.baseQuality.reverse.min").toString()));
        }
        if (properties.get("stats.baseQuality.forward.max") != null) {
            this.maximumValueQualForward = Math.max(this.maximumValueQualForward, Float.parseFloat(properties.get("stats.baseQuality.forward.max").toString()));
        }
        if (properties.get("stats.baseQuality.reverse.max") != null) {
            this.maximumValueQualReverse = Math.max(this.maximumValueQualReverse, Float.parseFloat(properties.get("stats.baseQuality.reverse.max").toString()));
        }
    }
}

