/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.SGlyph;

public class CGlyph
extends Glyph
implements Cloneable {
    public static short PRIMARY_GLYPH_ONLY = 0;
    public static short ALL_GLYPHS = 1;
    short compSensit = ALL_GLYPHS;
    Glyph pGlyph;
    SGlyph[] sGlyphs;

    public CGlyph(Glyph primary, SGlyph[] secondaries) {
        if (primary != null) {
            this.setPrimaryGlyph(primary);
        }
        if (secondaries != null && secondaries.length > 0) {
            this.sGlyphs = secondaries;
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[i].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[i].yoffset));
                this.sGlyphs[i].g.setCGlyph(this);
            }
        }
    }

    public void initCams(int nbCam) {
    }

    public void addCamera(int verifIndex) {
    }

    public void removeCamera(int index) {
    }

    public void resetMouseIn() {
    }

    public void resetMouseIn(int i) {
    }

    public void move(long x, long y) {
        this.vx += x;
        this.vy += y;
        this.pGlyph.move(x, y);
        if (this.sGlyphs != null) {
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].g.move(x, y);
            }
        }
        this.propagateMove(x, y);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public void moveTo(long x, long y) {
        this.propagateMove(x - this.vx, y - this.vy);
        this.pGlyph.moveTo(x, y);
        if (this.sGlyphs != null) {
            double teta = -this.getOrient();
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long x2 = Math.round(this.sGlyphs[i].xoffset * Math.cos(teta) + this.sGlyphs[i].yoffset * Math.sin(teta));
                    long y2 = Math.round(this.sGlyphs[i].yoffset * Math.cos(teta) - this.sGlyphs[i].xoffset * Math.sin(teta));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + x2, this.pGlyph.vy + y2);
                    continue;
                }
                this.sGlyphs[i].g.moveTo(x + Math.round(this.sGlyphs[i].xoffset), Math.round((double)y + this.sGlyphs[i].yoffset));
            }
        }
        this.vx = this.pGlyph.vx;
        this.vy = this.pGlyph.vy;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public float getOrient() {
        if (this.pGlyph != null) {
            return this.pGlyph.getOrient();
        }
        return 0.0f;
    }

    public void orientTo(float angle) {
        try {
            this.pGlyph.orientTo(angle);
            if (this.sGlyphs != null) {
                double teta = -angle;
                for (int i = 0; i < this.sGlyphs.length; ++i) {
                    if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_ANGLE_ONLY) {
                        this.sGlyphs[i].g.orientTo(angle + this.sGlyphs[i].aoffset);
                    }
                    if (this.sGlyphs[i].rotationPolicy != SGlyph.FULL_ROTATION && this.sGlyphs[i].rotationPolicy != SGlyph.ROTATION_POSITION_ONLY) continue;
                    long x2 = Math.round(this.sGlyphs[i].xoffset * Math.cos(teta) + this.sGlyphs[i].yoffset * Math.sin(teta));
                    long y2 = Math.round(this.sGlyphs[i].yoffset * Math.cos(teta) - this.sGlyphs[i].xoffset * Math.sin(teta));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + x2, this.pGlyph.vy + y2);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        if (this.pGlyph != null) {
            return this.pGlyph.getSize();
        }
        return 0.0f;
    }

    public synchronized void sizeTo(float radius) {
        if (this.sGlyphs != null) {
            float ratio = radius / this.getSize();
            double teta = this.getOrient();
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].xoffset *= (double)ratio;
                this.sGlyphs[i].yoffset *= (double)ratio;
                if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long x2 = Math.round(this.sGlyphs[i].xoffset * Math.cos(teta) - this.sGlyphs[i].yoffset * Math.sin(teta));
                    long y2 = Math.round(this.sGlyphs[i].xoffset * Math.sin(teta) + this.sGlyphs[i].yoffset * Math.cos(teta));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + x2, this.pGlyph.vy + y2);
                } else {
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[i].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[i].yoffset));
                }
                if (this.sGlyphs[i].sizePolicy != SGlyph.RESIZE) continue;
                this.sGlyphs[i].g.reSize(ratio);
            }
        }
        this.pGlyph.sizeTo(radius);
    }

    public synchronized void reSize(float factor) {
        if (this.sGlyphs != null) {
            double teta = this.getOrient();
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                this.sGlyphs[i].xoffset *= (double)factor;
                this.sGlyphs[i].yoffset *= (double)factor;
                if (this.sGlyphs[i].rotationPolicy == SGlyph.FULL_ROTATION || this.sGlyphs[i].rotationPolicy == SGlyph.ROTATION_POSITION_ONLY) {
                    long x2 = Math.round(this.sGlyphs[i].xoffset * Math.cos(teta) - this.sGlyphs[i].yoffset * Math.sin(teta));
                    long y2 = Math.round(this.sGlyphs[i].xoffset * Math.sin(teta) + this.sGlyphs[i].yoffset * Math.cos(teta));
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + x2, this.pGlyph.vy + y2);
                } else {
                    this.sGlyphs[i].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[i].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[i].yoffset));
                }
                if (this.sGlyphs[i].sizePolicy != SGlyph.RESIZE) continue;
                this.sGlyphs[i].g.reSize(factor);
            }
        }
        this.pGlyph.reSize(factor);
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return 0;
    }

    public void project(Camera c, Dimension d) {
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
    }

    void textDraw(Graphics2D g, int i) {
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
    }

    public void setSensitivity(short s) {
        if (s != this.compSensit) {
            if (s == PRIMARY_GLYPH_ONLY && this.sGlyphs != null) {
                for (int i = 0; i < this.sGlyphs.length; ++i) {
                    this.sGlyphs[i].g.setSensitivity(false);
                }
            } else if (s == ALL_GLYPHS && this.sGlyphs != null) {
                for (int i = 0; i < this.sGlyphs.length; ++i) {
                    this.sGlyphs[i].g.setSensitivity(true);
                }
            }
            this.compSensit = s;
        }
    }

    public void setPrimaryGlyph(Glyph g) {
        this.pGlyph = g;
        g.setCGlyph(this);
        this.vx = this.pGlyph.vx;
        this.vy = this.pGlyph.vy;
    }

    public void addSecondaryGlyph(Glyph g, long rx, long ry) {
        if (this.sGlyphs == null) {
            this.sGlyphs = new SGlyph[1];
            this.sGlyphs[0] = new SGlyph(g, rx, ry);
            this.sGlyphs[0].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[0].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[0].yoffset));
        } else {
            SGlyph[] tmpA = new SGlyph[this.sGlyphs.length + 1];
            System.arraycopy(this.sGlyphs, 0, tmpA, 0, this.sGlyphs.length);
            tmpA[tmpA.length - 1] = new SGlyph(g, rx, ry);
            this.sGlyphs = tmpA;
            this.sGlyphs[this.sGlyphs.length - 1].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[this.sGlyphs.length - 1].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[this.sGlyphs.length - 1].yoffset));
        }
        g.setCGlyph(this);
    }

    public void addSecondaryGlyph(SGlyph g) {
        if (this.sGlyphs == null) {
            this.sGlyphs = new SGlyph[1];
            this.sGlyphs[0] = g;
            this.sGlyphs[0].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[0].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[0].yoffset));
            this.sGlyphs[0].g.setCGlyph(this);
        } else {
            SGlyph[] tmpA = new SGlyph[this.sGlyphs.length + 1];
            System.arraycopy(this.sGlyphs, 0, tmpA, 0, this.sGlyphs.length);
            tmpA[tmpA.length - 1] = g;
            this.sGlyphs = tmpA;
            this.sGlyphs[this.sGlyphs.length - 1].g.moveTo(this.pGlyph.vx + Math.round(this.sGlyphs[this.sGlyphs.length - 1].xoffset), this.pGlyph.vy + Math.round(this.sGlyphs[this.sGlyphs.length - 1].yoffset));
            this.sGlyphs[this.sGlyphs.length - 1].g.setCGlyph(this);
        }
    }

    public void removeSecondaryGlyph(Glyph g) {
        if (this.sGlyphs != null) {
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                if (this.sGlyphs[i].g != g) continue;
                g.setCGlyph(null);
                SGlyph[] tmpA = new SGlyph[this.sGlyphs.length - 1];
                System.arraycopy(this.sGlyphs, 0, tmpA, 0, i);
                System.arraycopy(this.sGlyphs, i + 1, tmpA, i, this.sGlyphs.length - i - 1);
                this.sGlyphs = tmpA;
                break;
            }
            if (this.sGlyphs.length == 0) {
                this.sGlyphs = null;
            }
        }
    }

    public SGlyph getSGlyph(Glyph gl) {
        SGlyph res = null;
        if (this.sGlyphs != null) {
            for (int i = 0; i < this.sGlyphs.length; ++i) {
                if (this.sGlyphs[i].g != gl) continue;
                res = this.sGlyphs[i];
                break;
            }
        }
        return res;
    }

    public SGlyph[] getSecondaryGlyphs() {
        return this.sGlyphs;
    }

    public Glyph getPrimaryGlyph() {
        return this.pGlyph;
    }

    public Object clone() {
        return null;
    }

    public void highlight(boolean b, Color selectedColor) {
    }
}

