require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&OPENSSL_COMP_H)) {
    eval 'sub OPENSSL_COMP_H () {1;}' unless defined(&OPENSSL_COMP_H);
    require 'openssl/macros.ph';
    unless(defined(&OPENSSL_NO_DEPRECATED_3_0)) {
	eval 'sub HEADER_COMP_H () {1;}' unless defined(&HEADER_COMP_H);
    }
    require 'openssl/opensslconf.ph';
    require 'openssl/crypto.ph';
    require 'openssl/comperr.ph';
    if(defined(&__cplusplus)) {
    }
    unless(defined(&OPENSSL_NO_COMP)) {
	unless(defined(&OPENSSL_NO_DEPRECATED_1_1_0)) {
	    eval 'sub COMP_zlib_cleanup () {
	        eval q( &while(0)  &continue);
	    }' unless defined(&COMP_zlib_cleanup);
	}
	if(defined(&OPENSSL_BIO_H)) {
	}
    }
    eval 'sub sk_SSL_COMP_num {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_num( &ossl_check_const_SSL_COMP_sk_type($sk)));
    }' unless defined(&sk_SSL_COMP_num);
    eval 'sub sk_SSL_COMP_value {
        my($sk, $idx) = @_;
	    eval q((( &SSL_COMP *) &OPENSSL_sk_value( &ossl_check_const_SSL_COMP_sk_type($sk), ($idx))));
    }' unless defined(&sk_SSL_COMP_value);
    eval 'sub sk_SSL_COMP_new {
        my($cmp) = @_;
	    eval q((( &STACK_OF( &SSL_COMP) *) &OPENSSL_sk_new( &ossl_check_SSL_COMP_compfunc_type($cmp))));
    }' unless defined(&sk_SSL_COMP_new);
    eval 'sub sk_SSL_COMP_new_null () {
        eval q((( &STACK_OF( &SSL_COMP) *) &OPENSSL_sk_new_null()));
    }' unless defined(&sk_SSL_COMP_new_null);
    eval 'sub sk_SSL_COMP_new_reserve {
        my($cmp, $n) = @_;
	    eval q((( &STACK_OF( &SSL_COMP) *) &OPENSSL_sk_new_reserve( &ossl_check_SSL_COMP_compfunc_type($cmp), ($n))));
    }' unless defined(&sk_SSL_COMP_new_reserve);
    eval 'sub sk_SSL_COMP_reserve {
        my($sk, $n) = @_;
	    eval q( &OPENSSL_sk_reserve( &ossl_check_SSL_COMP_sk_type($sk), ($n)));
    }' unless defined(&sk_SSL_COMP_reserve);
    eval 'sub sk_SSL_COMP_free {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_free( &ossl_check_SSL_COMP_sk_type($sk)));
    }' unless defined(&sk_SSL_COMP_free);
    eval 'sub sk_SSL_COMP_zero {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_zero( &ossl_check_SSL_COMP_sk_type($sk)));
    }' unless defined(&sk_SSL_COMP_zero);
    eval 'sub sk_SSL_COMP_delete {
        my($sk, $i) = @_;
	    eval q((( &SSL_COMP *) &OPENSSL_sk_delete( &ossl_check_SSL_COMP_sk_type($sk), ($i))));
    }' unless defined(&sk_SSL_COMP_delete);
    eval 'sub sk_SSL_COMP_delete_ptr {
        my($sk, $ptr) = @_;
	    eval q((( &SSL_COMP *) &OPENSSL_sk_delete_ptr( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr))));
    }' unless defined(&sk_SSL_COMP_delete_ptr);
    eval 'sub sk_SSL_COMP_push {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_push( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr)));
    }' unless defined(&sk_SSL_COMP_push);
    eval 'sub sk_SSL_COMP_unshift {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_unshift( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr)));
    }' unless defined(&sk_SSL_COMP_unshift);
    eval 'sub sk_SSL_COMP_pop {
        my($sk) = @_;
	    eval q((( &SSL_COMP *) &OPENSSL_sk_pop( &ossl_check_SSL_COMP_sk_type($sk))));
    }' unless defined(&sk_SSL_COMP_pop);
    eval 'sub sk_SSL_COMP_shift {
        my($sk) = @_;
	    eval q((( &SSL_COMP *) &OPENSSL_sk_shift( &ossl_check_SSL_COMP_sk_type($sk))));
    }' unless defined(&sk_SSL_COMP_shift);
    eval 'sub sk_SSL_COMP_pop_free {
        my($sk, $freefunc) = @_;
	    eval q( &OPENSSL_sk_pop_free( &ossl_check_SSL_COMP_sk_type($sk), &ossl_check_SSL_COMP_freefunc_type($freefunc)));
    }' unless defined(&sk_SSL_COMP_pop_free);
    eval 'sub sk_SSL_COMP_insert {
        my($sk, $ptr, $idx) = @_;
	    eval q( &OPENSSL_sk_insert( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr), ($idx)));
    }' unless defined(&sk_SSL_COMP_insert);
    eval 'sub sk_SSL_COMP_set {
        my($sk, $idx, $ptr) = @_;
	    eval q((( &SSL_COMP *) &OPENSSL_sk_set( &ossl_check_SSL_COMP_sk_type($sk), ($idx),  &ossl_check_SSL_COMP_type($ptr))));
    }' unless defined(&sk_SSL_COMP_set);
    eval 'sub sk_SSL_COMP_find {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr)));
    }' unless defined(&sk_SSL_COMP_find);
    eval 'sub sk_SSL_COMP_find_ex {
        my($sk, $ptr) = @_;
	    eval q( &OPENSSL_sk_find_ex( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr)));
    }' unless defined(&sk_SSL_COMP_find_ex);
    eval 'sub sk_SSL_COMP_find_all {
        my($sk, $ptr, $pnum) = @_;
	    eval q( &OPENSSL_sk_find_all( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_type($ptr), $pnum));
    }' unless defined(&sk_SSL_COMP_find_all);
    eval 'sub sk_SSL_COMP_sort {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_sort( &ossl_check_SSL_COMP_sk_type($sk)));
    }' unless defined(&sk_SSL_COMP_sort);
    eval 'sub sk_SSL_COMP_is_sorted {
        my($sk) = @_;
	    eval q( &OPENSSL_sk_is_sorted( &ossl_check_const_SSL_COMP_sk_type($sk)));
    }' unless defined(&sk_SSL_COMP_is_sorted);
    eval 'sub sk_SSL_COMP_dup {
        my($sk) = @_;
	    eval q((( &STACK_OF( &SSL_COMP) *) &OPENSSL_sk_dup( &ossl_check_const_SSL_COMP_sk_type($sk))));
    }' unless defined(&sk_SSL_COMP_dup);
    eval 'sub sk_SSL_COMP_deep_copy {
        my($sk, $copyfunc, $freefunc) = @_;
	    eval q((( &STACK_OF( &SSL_COMP) *) &OPENSSL_sk_deep_copy( &ossl_check_const_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_copyfunc_type($copyfunc),  &ossl_check_SSL_COMP_freefunc_type($freefunc))));
    }' unless defined(&sk_SSL_COMP_deep_copy);
    eval 'sub sk_SSL_COMP_set_cmp_func {
        my($sk, $cmp) = @_;
	    eval q((( &sk_SSL_COMP_compfunc) &OPENSSL_sk_set_cmp_func( &ossl_check_SSL_COMP_sk_type($sk),  &ossl_check_SSL_COMP_compfunc_type($cmp))));
    }' unless defined(&sk_SSL_COMP_set_cmp_func);
    if(defined(&__cplusplus)) {
    }
}
1;
