<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\FirebaseManagement;

class StreamMapping extends \Google\Model
{
  public $app;
  public $measurementId;
  public $streamId;

  public function setApp($app)
  {
    $this->app = $app;
  }
  public function getApp()
  {
    return $this->app;
  }
  public function setMeasurementId($measurementId)
  {
    $this->measurementId = $measurementId;
  }
  public function getMeasurementId()
  {
    return $this->measurementId;
  }
  public function setStreamId($streamId)
  {
    $this->streamId = $streamId;
  }
  public function getStreamId()
  {
    return $this->streamId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(StreamMapping::class, 'Google_Service_FirebaseManagement_StreamMapping');
