/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MetalFileChooserUI
extends BasicFileChooserUI {
    DirectoryComboBoxModel directoryModel;

    public static ComponentUI createUI(JComponent c) {
        JFileChooser chooser = (JFileChooser)c;
        return new MetalFileChooserUI(chooser);
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    public MetalFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private List items = new ArrayList();
        private int selectedIndex = -1;

        public int getSize() {
            return this.items.size();
        }

        public Object getElementAt(int index) {
            return this.items.get(index);
        }

        public int getDepth(int index) {
            return Math.max(index, 0);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.items.get(this.selectedIndex);
            }
            return null;
        }

        public void setSelectedItem(Object selectedDirectory) {
            this.items.clear();
            FileSystemView fsv = MetalFileChooserUI.this.getFileChooser().getFileSystemView();
            File parent = (File)selectedDirectory;
            while (parent != null) {
                this.items.add(0, parent);
                parent = fsv.getParentDirectory(parent);
            }
            this.selectedIndex = this.items.indexOf(selectedDirectory);
            this.fireContentsChanged(this, 0, this.items.size() - 1);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters = new FileFilter[1];
        private int selectedIndex;

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("fileFilterChanged")) {
                this.selectedIndex = -1;
                FileFilter selected = (FileFilter)e.getNewValue();
                int i = 0;
                while (i < this.filters.length) {
                    if (this.filters[i].equals(selected)) {
                        this.selectedIndex = i;
                    }
                    ++i;
                }
                this.fireContentsChanged(this, -1, -1);
            } else if (e.getPropertyName().equals("ChoosableFileFilterChangedProperty")) {
                JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
                FileFilter[] choosableFilters = fc.getChoosableFileFilters();
                this.filters = choosableFilters;
                this.fireContentsChanged(this, 0, this.filters.length);
            }
        }

        public void setSelectedItem(Object filter) {
            MetalFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
        }

        public Object getSelectedItem() {
            if (this.selectedIndex >= 0) {
                return this.filters[this.selectedIndex];
            }
            return null;
        }

        public int getSize() {
            return this.filters.length;
        }

        public Object getElementAt(int index) {
            return this.filters[index];
        }

        protected FilterComboBoxModel() {
            this.filters[0] = MetalFileChooserUI.this.getAcceptAllFileFilter(MetalFileChooserUI.this.getFileChooser());
            this.selectedIndex = 0;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FileFilter filter = (FileFilter)value;
            return super.getListCellRendererComponent(list2, filter.getDescription(), index, isSelected, cellHasFocus);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class FileRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FileView v = MetalFileChooserUI.this.getFileView(MetalFileChooserUI.this.getFileChooser());
            File f = (File)value;
            this.setText(v.getName(f));
            this.setIcon(v.getIcon(f));
            if (isSelected) {
                this.setBackground(list2.getSelectionBackground());
                this.setForeground(list2.getSelectionForeground());
            } else {
                this.setBackground(list2.getBackground());
                this.setForeground(list2.getForeground());
            }
            this.setEnabled(list2.isEnabled());
            this.setFont(list2.getFont());
            if (cellHasFocus) {
                this.setBorder(UIManager.getBorder("List.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }

        protected FileRenderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class DirectoryComboBoxAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = MetalFileChooserUI.this.getFileChooser();
            fc.setCurrentDirectory((File)MetalFileChooserUI.this.directoryModel.getSelectedItem());
        }

        protected DirectoryComboBoxAction() {
        }
    }
}

