/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zvtm.glyphs;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VDiamond;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VImage;
import com.xerox.VTM.glyphs.VOctagon;
import com.xerox.VTM.glyphs.VPolygon;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VRoundRect;
import com.xerox.VTM.glyphs.VShape;
import com.xerox.VTM.glyphs.VTriangle;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;

public class GlyphUtils {
    public static Shape getJava2DShape(Glyph g) {
        if (g instanceof VEllipse) {
            VEllipse el1 = (VEllipse)g;
            return new Ellipse2D.Double(el1.vx - el1.getWidth(), el1.vy - el1.getHeight(), el1.getWidth() * 2L, el1.getHeight() * 2L);
        }
        if (g instanceof VRectangle) {
            VRectangle el1 = (VRectangle)g;
            return new Rectangle2D.Double(el1.vx - el1.getWidth(), el1.vy - el1.getHeight(), el1.getWidth() * 2L, el1.getHeight() * 2L);
        }
        if (g instanceof VRoundRect) {
            VRoundRect el1 = (VRoundRect)g;
            return new RoundRectangle2D.Double(el1.vx - el1.getWidth(), el1.vy - el1.getHeight(), el1.getWidth() * 2L, el1.getHeight() * 2L, el1.getArcWidth(), el1.getArcHeight());
        }
        if (g instanceof VCircle) {
            return new Ellipse2D.Double((float)g.vx - g.getSize(), (float)g.vy - g.getSize(), g.getSize() * 2.0f, g.getSize() * 2.0f);
        }
        if (g instanceof VShape) {
            VShape sh1 = (VShape)g;
            float vertexAngle = sh1.getOrient();
            float[] vertices = sh1.getVertices();
            int[] xcoords = new int[vertices.length];
            int[] ycoords = new int[vertices.length];
            float size = g.getSize();
            for (int j = 0; j < vertices.length - 1; ++j) {
                xcoords[j] = (int)Math.round((double)sh1.vx + (double)size * Math.cos(vertexAngle) * (double)vertices[j]);
                ycoords[j] = (int)Math.round((double)sh1.vy + (double)size * Math.sin(vertexAngle) * (double)vertices[j]);
                vertexAngle = (float)((double)vertexAngle + Math.PI * 2 / (double)vertices.length);
            }
            xcoords[vertices.length - 1] = (int)Math.round((double)sh1.vx + (double)size * Math.cos(vertexAngle) * (double)vertices[vertices.length - 1]);
            ycoords[vertices.length - 1] = (int)Math.round((double)sh1.vy + (double)size * Math.sin(vertexAngle) * (double)vertices[vertices.length - 1]);
            return new Polygon(xcoords, ycoords, vertices.length);
        }
        if (g instanceof VPolygon) {
            VPolygon pg1 = (VPolygon)g;
            LongPoint[] vertices = pg1.getVertices();
            int[] xcoords = new int[vertices.length];
            int[] ycoords = new int[vertices.length];
            for (int j = 0; j < vertices.length; ++j) {
                xcoords[j] = Math.round(pg1.vx + vertices[j].x);
                ycoords[j] = Math.round(pg1.vy + vertices[j].y);
            }
            return new Polygon(xcoords, ycoords, vertices.length);
        }
        if (g instanceof VTriangle) {
            int size = Math.round(g.getSize());
            int halfEdge = Math.round(0.866f * g.getSize());
            int thirdHeight = Math.round(0.5f * g.getSize());
            if (g instanceof VTriangleOr) {
                float orient = g.getOrient();
                int[] xcoords = new int[3];
                int[] ycoords = new int[3];
                xcoords[0] = (int)Math.round((double)g.vx - (double)size * Math.sin(orient));
                xcoords[1] = (int)Math.round((double)g.vx - (double)halfEdge * Math.cos(orient) + (double)thirdHeight * Math.sin(orient));
                xcoords[2] = (int)Math.round((double)g.vx + (double)halfEdge * Math.cos(orient) + (double)thirdHeight * Math.sin(orient));
                ycoords[0] = (int)Math.round((double)g.vy + (double)size * Math.cos(orient));
                ycoords[1] = (int)Math.round((double)g.vy - (double)thirdHeight * Math.cos(orient) + (double)halfEdge * Math.sin(orient));
                ycoords[2] = (int)Math.round((double)g.vy - (double)thirdHeight * Math.cos(orient) - (double)halfEdge * Math.sin(orient));
                return new Polygon(xcoords, ycoords, 3);
            }
            int[] xcoords = new int[]{(int)g.vx, (int)g.vx - halfEdge, (int)g.vx + halfEdge};
            int[] ycoords = new int[]{(int)g.vy + size, (int)g.vy - thirdHeight, (int)g.vy - thirdHeight};
            return new Polygon(xcoords, ycoords, 3);
        }
        if (g instanceof VDiamond) {
            int size = Math.round(g.getSize());
            int[] xcoords = new int[]{(int)g.vx + size, (int)g.vx, (int)g.vx - size, (int)g.vx};
            int[] ycoords = new int[]{(int)g.vy, (int)g.vy - size, (int)g.vy, (int)g.vy + size};
            return new Polygon(xcoords, ycoords, 4);
        }
        if (g instanceof VOctagon) {
            int size = Math.round(g.getSize());
            int halfSize = Math.round(0.5f * g.getSize());
            int[] xcoords = new int[]{(int)g.vx + size, (int)g.vx + halfSize, (int)g.vx - halfSize, (int)g.vx - size, (int)g.vx - size, (int)g.vx - halfSize, (int)g.vx + halfSize, (int)g.vx + size};
            int[] ycoords = new int[]{(int)g.vy + halfSize, (int)g.vy + size, (int)g.vy + size, (int)g.vy + halfSize, (int)g.vy - halfSize, (int)g.vy - size, (int)g.vy - size, (int)g.vy - halfSize};
            return new Polygon(xcoords, ycoords, 8);
        }
        if (g instanceof VImage) {
            VImage im1 = (VImage)g;
            return new Rectangle2D.Double(im1.vx - im1.getWidth(), im1.vy - im1.getHeight(), im1.getWidth() * 2L, im1.getHeight() * 2L);
        }
        return new Rectangle2D.Double(g.vx, g.vy, 1.0, 1.0);
    }

    public static Glyph basicClone(Glyph g) {
        if (g instanceof Cloneable) {
            return (Glyph)g.clone();
        }
        return null;
    }
}

