<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class OceanVolumeAccessRights extends \Google\Model
{
  /**
   * @var bool
   */
  public $allowAutoGeneratedText;
  /**
   * @var bool
   */
  public $canShowInfoCards;
  /**
   * @var bool
   */
  public $canShowPhotos;
  /**
   * @var int
   */
  public $numAdeDeviceAllowed;
  /**
   * @var int
   */
  public $numAdobeIdAllowed;
  /**
   * @var int
   */
  public $numDownloadsAllowed;
  /**
   * @var int
   */
  public $numSimultaneousAccess;
  /**
   * @var string
   */
  public $offlineDownload;
  /**
   * @var int
   */
  public $percentCopyable;
  /**
   * @var int
   */
  public $percentPrintable;
  /**
   * @var bool
   */
  public $restrictOnlyToText;
  /**
   * @var bool
   */
  public $sellFixedLayoutAsImageOnly;
  /**
   * @var bool
   */
  public $textToSpeech;
  /**
   * @var bool
   */
  public $treatAsPublicDomain;

  /**
   * @param bool
   */
  public function setAllowAutoGeneratedText($allowAutoGeneratedText)
  {
    $this->allowAutoGeneratedText = $allowAutoGeneratedText;
  }
  /**
   * @return bool
   */
  public function getAllowAutoGeneratedText()
  {
    return $this->allowAutoGeneratedText;
  }
  /**
   * @param bool
   */
  public function setCanShowInfoCards($canShowInfoCards)
  {
    $this->canShowInfoCards = $canShowInfoCards;
  }
  /**
   * @return bool
   */
  public function getCanShowInfoCards()
  {
    return $this->canShowInfoCards;
  }
  /**
   * @param bool
   */
  public function setCanShowPhotos($canShowPhotos)
  {
    $this->canShowPhotos = $canShowPhotos;
  }
  /**
   * @return bool
   */
  public function getCanShowPhotos()
  {
    return $this->canShowPhotos;
  }
  /**
   * @param int
   */
  public function setNumAdeDeviceAllowed($numAdeDeviceAllowed)
  {
    $this->numAdeDeviceAllowed = $numAdeDeviceAllowed;
  }
  /**
   * @return int
   */
  public function getNumAdeDeviceAllowed()
  {
    return $this->numAdeDeviceAllowed;
  }
  /**
   * @param int
   */
  public function setNumAdobeIdAllowed($numAdobeIdAllowed)
  {
    $this->numAdobeIdAllowed = $numAdobeIdAllowed;
  }
  /**
   * @return int
   */
  public function getNumAdobeIdAllowed()
  {
    return $this->numAdobeIdAllowed;
  }
  /**
   * @param int
   */
  public function setNumDownloadsAllowed($numDownloadsAllowed)
  {
    $this->numDownloadsAllowed = $numDownloadsAllowed;
  }
  /**
   * @return int
   */
  public function getNumDownloadsAllowed()
  {
    return $this->numDownloadsAllowed;
  }
  /**
   * @param int
   */
  public function setNumSimultaneousAccess($numSimultaneousAccess)
  {
    $this->numSimultaneousAccess = $numSimultaneousAccess;
  }
  /**
   * @return int
   */
  public function getNumSimultaneousAccess()
  {
    return $this->numSimultaneousAccess;
  }
  /**
   * @param string
   */
  public function setOfflineDownload($offlineDownload)
  {
    $this->offlineDownload = $offlineDownload;
  }
  /**
   * @return string
   */
  public function getOfflineDownload()
  {
    return $this->offlineDownload;
  }
  /**
   * @param int
   */
  public function setPercentCopyable($percentCopyable)
  {
    $this->percentCopyable = $percentCopyable;
  }
  /**
   * @return int
   */
  public function getPercentCopyable()
  {
    return $this->percentCopyable;
  }
  /**
   * @param int
   */
  public function setPercentPrintable($percentPrintable)
  {
    $this->percentPrintable = $percentPrintable;
  }
  /**
   * @return int
   */
  public function getPercentPrintable()
  {
    return $this->percentPrintable;
  }
  /**
   * @param bool
   */
  public function setRestrictOnlyToText($restrictOnlyToText)
  {
    $this->restrictOnlyToText = $restrictOnlyToText;
  }
  /**
   * @return bool
   */
  public function getRestrictOnlyToText()
  {
    return $this->restrictOnlyToText;
  }
  /**
   * @param bool
   */
  public function setSellFixedLayoutAsImageOnly($sellFixedLayoutAsImageOnly)
  {
    $this->sellFixedLayoutAsImageOnly = $sellFixedLayoutAsImageOnly;
  }
  /**
   * @return bool
   */
  public function getSellFixedLayoutAsImageOnly()
  {
    return $this->sellFixedLayoutAsImageOnly;
  }
  /**
   * @param bool
   */
  public function setTextToSpeech($textToSpeech)
  {
    $this->textToSpeech = $textToSpeech;
  }
  /**
   * @return bool
   */
  public function getTextToSpeech()
  {
    return $this->textToSpeech;
  }
  /**
   * @param bool
   */
  public function setTreatAsPublicDomain($treatAsPublicDomain)
  {
    $this->treatAsPublicDomain = $treatAsPublicDomain;
  }
  /**
   * @return bool
   */
  public function getTreatAsPublicDomain()
  {
    return $this->treatAsPublicDomain;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(OceanVolumeAccessRights::class, 'Google_Service_Contentwarehouse_OceanVolumeAccessRights');
