/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.transport;

import br.arca.morcego.Config;
import br.arca.morcego.transport.Transport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcAppletClient;
import org.apache.xmlrpc.XmlRpcException;

public class XmlrpcTransport
implements Transport {
    private XmlRpcAppletClient client;
    private String url;
    private int protocolVersion = 1;

    public void setup() {
        this.setServerUrl(Config.getString("morcego.serverUrl"));
        this.protocolVersion = this.fetchVersion();
    }

    public void setServerUrl(String server_url) {
        this.url = server_url;
        try {
            this.client = new XmlRpcAppletClient(server_url);
        }
        catch (MalformedURLException e) {
            System.out.println("Bad URL " + this.url);
            e.printStackTrace();
        }
    }

    private Hashtable fetch(String method, Vector params) {
        Hashtable result = new Hashtable();
        try {
            result = (Hashtable)this.client.execute(method, params);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Hashtable retrieveData(String centerId, Integer depth) {
        float protocolVersion = this.fetchVersion();
        if (protocolVersion >= 2.0f) {
            return this.fetchGraph(centerId, depth);
        }
        return this.oldFetchGraph(centerId, depth);
    }

    private int fetchVersion() {
        int version;
        try {
            version = (Integer)this.client.execute("getVersion", new Vector());
        }
        catch (XmlRpcException e) {
            version = 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            version = 1;
        }
        return version;
    }

    public Hashtable fetchGraph(String centerId, Integer depth) {
        Vector<Object> params = new Vector<Object>();
        params.add(centerId);
        params.add(depth);
        Hashtable result = this.fetch("getSubGraph", params);
        return result;
    }

    private Hashtable oldFetchGraph(String centerId, Integer depth) {
        Hashtable graph = this.fetchGraph(centerId, depth);
        Hashtable nodes = (Hashtable)graph.get("graph");
        Vector links = new Vector();
        Enumeration e = nodes.keys();
        while (e.hasMoreElements()) {
            String nodeId = (String)e.nextElement();
            Hashtable node = (Hashtable)nodes.get(nodeId);
            Vector neighbours = (Vector)node.get("neighbours");
            Enumeration eN = neighbours.elements();
            while (eN.hasMoreElements()) {
                Hashtable<String, String> link = new Hashtable<String, String>();
                link.put("to", nodeId);
                link.put("from", (String)eN.nextElement());
                links.add(link);
            }
        }
        graph.put("links", links);
        graph.put("nodes", nodes);
        return graph;
    }
}

