/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPException;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class BMPInfoHeader {
    public static final int SIZE = 40;
    public static final int BI_RGB = 0;
    public static final int BI_RLE8 = 1;
    public static final int BI_RLE4 = 2;
    public static final int BI_BITFIELDS = 3;
    private int biSize;
    private int biWidth;
    private int biHeight;
    private short biPlanes;
    private short biBitCount;
    private int biCompression;
    private int biSizeImage;
    private int biXPelsPerMeter;
    private int biYPelsPerMeter;
    private int biClrUsed;
    private int biClrImportant;

    public void setBitCount(short bitcount) throws BMPException {
        switch (bitcount) {
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                this.biBitCount = bitcount;
                break;
            }
            default: {
                throw new BMPException("Invalid number of bits per pixel: " + bitcount);
            }
        }
    }

    public short getBitCount() {
        return this.biBitCount;
    }

    public void setCompression(int compression) throws BMPException {
        switch (compression) {
            case 1: {
                if (this.getBitCount() != 8) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = compression;
                break;
            }
            case 2: {
                if (this.getBitCount() != 4) {
                    throw new BMPException("Invalid number of bits per pixel.");
                }
                this.biCompression = compression;
                break;
            }
            case 0: 
            case 3: {
                this.biCompression = compression;
                break;
            }
            default: {
                throw new BMPException("Unknown bitmap compression type.");
            }
        }
    }

    public int getNumberOfPaletteEntries() {
        if (this.biClrUsed == 0) {
            switch (this.biBitCount) {
                case 1: {
                    return 2;
                }
                case 4: {
                    return 16;
                }
                case 8: {
                    return 256;
                }
            }
            return 0;
        }
        return this.biClrUsed;
    }

    public int getCompression() {
        return this.biCompression;
    }

    public Dimension getSize() {
        return new Dimension(this.biWidth, this.biHeight);
    }

    public int getWidth() {
        return this.biWidth;
    }

    public int getHeight() {
        return this.biHeight;
    }

    public void setSize(Dimension d) {
        this.biWidth = (int)d.getWidth();
        this.biHeight = (int)d.getHeight();
    }

    public BMPInfoHeader(ImageInputStream in) throws IOException, BMPException {
        byte[] data = new byte[40];
        if (in.read(data) != 40) {
            throw new IOException("Couldn't read header.");
        }
        ByteBuffer buf = ByteBuffer.wrap(data);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int n = buf.getInt();
        if (n != 40) {
            throw new BMPException("Invalid BITMAPINFOHEADER size: " + n);
        }
        this.biWidth = buf.getInt();
        this.biHeight = buf.getInt();
        this.biPlanes = buf.getShort();
        this.setBitCount(buf.getShort());
        this.setCompression(buf.getInt());
        this.biSizeImage = buf.getInt();
        this.biXPelsPerMeter = buf.getInt();
        this.biYPelsPerMeter = buf.getInt();
        this.biClrUsed = buf.getInt();
        this.biClrImportant = buf.getInt();
    }
}

