/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.classpath.SystemProperties;
import gnu.classpath.VMStackWalker;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.PropertyPermission;

public final class System {
    public static final InputStream in = VMSystem.makeStandardInputStream();
    public static final PrintStream out = VMSystem.makeStandardOutputStream();
    public static final PrintStream err = VMSystem.makeStandardErrorStream();

    public static final void setIn(InputStream in) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setIn(in);
    }

    public static final void setOut(PrintStream out) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setOut(out);
    }

    public static final void setErr(PrintStream err) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("setIO"));
        }
        VMSystem.setErr(err);
    }

    public static final synchronized void setSecurityManager(SecurityManager sm) {
        if (SecurityManager.current != null) {
            SecurityManager.current.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        SecurityManager.current = sm;
    }

    public static final SecurityManager getSecurityManager() {
        return SecurityManager.current;
    }

    public static final long currentTimeMillis() {
        return VMSystem.currentTimeMillis();
    }

    public static final void arraycopy(Object src, int srcStart, Object dest, int destStart, int len) {
        VMSystem.arraycopy(src, srcStart, dest, destStart, len);
    }

    public static final int identityHashCode(Object o) {
        return VMSystem.identityHashCode(o);
    }

    public static final Properties getProperties() {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        return SystemProperties.getProperties();
    }

    public static final void setProperties(Properties properties) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertiesAccess();
        }
        SystemProperties.setProperties(properties);
    }

    public static final String getProperty(String key) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertyAccess(key);
        } else if (key.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return SystemProperties.getProperty(key);
    }

    public static final String getProperty(String key, String def) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPropertyAccess(key);
        }
        return SystemProperties.getProperty(key, def);
    }

    public static final String setProperty(String key, String value) {
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new PropertyPermission(key, "write"));
        }
        return SystemProperties.setProperty(key, value);
    }

    public static final String getenv(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        SecurityManager sm = SecurityManager.current;
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getenv." + name));
        }
        return VMSystem.getenv(name);
    }

    public static final void exit(int status) {
        Runtime.getRuntime().exit(status);
    }

    public static final void gc() {
        Runtime.getRuntime().gc();
    }

    public static final void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static final void runFinalizersOnExit(boolean finalizeOnExit) {
        Runtime.runFinalizersOnExit(finalizeOnExit);
    }

    public static final void load(String filename) {
        Runtime.getRuntime().load(filename, VMStackWalker.getCallingClassLoader());
    }

    public static final void loadLibrary(String libname) {
        Runtime.getRuntime().loadLibrary(libname, VMStackWalker.getCallingClassLoader());
    }

    public static final String mapLibraryName(String libname) {
        return VMRuntime.mapLibraryName(libname);
    }

    private System() {
    }
}

