/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;

public class DebugGraphics
extends Graphics {
    public static final int LOG_OPTION = 1;
    public static final int FLASH_OPTION = 2;
    public static final int BUFFERED_OPTION = 4;
    public static final int NONE_OPTION = -1;
    static Color debugFlashColor = Color.RED;
    static int debugFlashCount = 10;
    static int debugFlashTime = 1000;
    static PrintStream debugLogStream = System.out;
    static int counter = 0;
    Graphics graphics;
    Image buffer;
    int debugOptions;
    int graphicsID;
    int xOffset;
    int yOffset;

    public void setColor(Color color) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting color: " + color);
        }
        this.graphics.setColor(color);
    }

    public Graphics create() {
        DebugGraphics copy = new DebugGraphics(this.graphics.create());
        copy.debugOptions = this.debugOptions;
        return copy;
    }

    public Graphics create(int x, int y, int width, int height) {
        DebugGraphics copy = new DebugGraphics(this.graphics.create(x, y, width, height));
        copy.debugOptions = this.debugOptions;
        return copy;
    }

    public static Color flashColor() {
        return debugFlashColor;
    }

    public static void setFlashColor(Color color) {
        debugFlashColor = color;
    }

    public static int flashTime() {
        return debugFlashTime;
    }

    public static void setFlashTime(int time) {
        debugFlashTime = time;
    }

    public static int flashCount() {
        return debugFlashCount;
    }

    public static void setFlashCount(int count) {
        debugFlashCount = count;
    }

    public static PrintStream logStream() {
        return debugLogStream;
    }

    public static void setLogStream(PrintStream stream) {
        debugLogStream = stream;
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public void setFont(Font font) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting font: " + font);
        }
        this.graphics.setFont(font);
    }

    public Color getColor() {
        return this.graphics.getColor();
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public void translate(int x, int y) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Translating by: " + new Point(x, y));
        }
        this.graphics.translate(x, y);
    }

    public void setPaintMode() {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting paint mode");
        }
        this.graphics.setPaintMode();
    }

    public void setXORMode(Color color) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting XOR mode: " + color);
        }
        this.graphics.setXORMode(color);
    }

    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public void clipRect(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().print(this.prefix() + " Setting clipRect: " + new Rectangle(x, y, width, height));
        }
        this.graphics.clipRect(x, y, width, height);
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(" Netting clipRect: " + this.graphics.getClipBounds());
        }
    }

    public void setClip(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting new clipRect: " + new Rectangle(x, y, width, height));
        }
        this.graphics.setClip(x, y, width, height);
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public void setClip(Shape shape) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Setting new clipRect: " + shape);
        }
        this.graphics.setClip(shape);
    }

    private final void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing rect: " + new Rectangle(x, y, width, height));
        }
        if ((this.debugOptions & 2) != 0) {
            Color color = this.graphics.getColor();
            int index = 0;
            while (index < debugFlashCount - 1) {
                this.graphics.setColor(color);
                this.graphics.drawRect(x, y, width, height);
                this.sleep(debugFlashTime);
                this.graphics.setColor(debugFlashColor);
                this.graphics.drawRect(x, y, width, height);
                this.sleep(debugFlashTime);
                ++index;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling rect: " + new Rectangle(x, y, width, height));
        }
        if ((this.debugOptions & 2) != 0) {
            Color color = this.graphics.getColor();
            int index = 0;
            while (index < debugFlashCount - 1) {
                this.graphics.setColor(color);
                this.graphics.fillRect(x, y, width, height);
                this.sleep(debugFlashTime);
                this.graphics.setColor(debugFlashColor);
                this.graphics.fillRect(x, y, width, height);
                this.sleep(debugFlashTime);
                ++index;
            }
            this.graphics.setColor(color);
        }
        this.graphics.fillRect(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Clearing rect: " + new Rectangle(x, y, width, height));
        }
        this.graphics.clearRect(x, y, width, height);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing round rect: " + new Rectangle(x, y, width, height) + " arcWidth: " + arcWidth + " arcHeight: " + arcHeight);
        }
        this.graphics.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling round rect: " + new Rectangle(x, y, width, height) + " arcWidth: " + arcWidth + " arcHeight: " + arcHeight);
        }
        this.graphics.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing line: from (" + x1 + ", " + y1 + ") to (" + x2 + ", " + y2 + ')');
        }
        this.graphics.drawLine(x1, y1, x2, y2);
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing 3D rect: " + new Rectangle(x, y, width, height) + "Raised bezel: " + raised);
        }
        this.graphics.draw3DRect(x, y, width, height, raised);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling 3D rect: " + new Rectangle(x, y, width, height) + "Raised bezel: " + raised);
        }
        this.graphics.fill3DRect(x, y, width, height, raised);
    }

    public void drawOval(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing oval: " + new Rectangle(x, y, width, height));
        }
        this.graphics.drawOval(x, y, width, height);
    }

    public void fillOval(int x, int y, int width, int height) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling oval: " + new Rectangle(x, y, width, height));
        }
        this.graphics.fillOval(x, y, width, height);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing arc: " + new Rectangle(x, y, width, height) + " startAngle: " + startAngle + " arcAngle: " + arcAngle);
        }
        this.graphics.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Filling arc: " + new Rectangle(x, y, width, height) + " startAngle: " + startAngle + " arcAngle: " + arcAngle);
        }
        this.graphics.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawPolyline(int[] xpoints, int[] ypoints, int npoints) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing polyline: nPoints: " + npoints + " X's: " + xpoints + " Y's: " + ypoints);
        }
        this.graphics.drawPolyline(xpoints, ypoints, npoints);
    }

    public void drawPolygon(int[] xpoints, int[] ypoints, int npoints) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing polygon: nPoints: " + npoints + " X's: " + xpoints + " Y's: " + ypoints);
        }
        this.graphics.drawPolygon(xpoints, ypoints, npoints);
    }

    public void fillPolygon(int[] xpoints, int[] ypoints, int npoints) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing polygon: nPoints: " + npoints + " X's: " + xpoints + " Y's: " + ypoints);
        }
        this.graphics.fillPolygon(xpoints, ypoints, npoints);
    }

    public void drawString(String string, int x, int y) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing string: \"" + string + "\" at: " + new Point(x, y));
        }
        this.graphics.drawString(string, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing string: \"" + iterator + "\" at: " + new Point(x, y));
        }
        this.graphics.drawString(iterator, x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing bytes at: " + new Point(x, y));
        }
        this.graphics.drawBytes(data, offset, length, x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing chars at: " + new Point(x, y));
        }
        if ((this.debugOptions & 2) != 0) {
            Color color = this.graphics.getColor();
            int index = 0;
            while (index < debugFlashCount - 1) {
                this.graphics.setColor(color);
                this.graphics.drawChars(data, offset, length, x, y);
                this.sleep(debugFlashTime);
                this.graphics.setColor(debugFlashColor);
                this.graphics.drawChars(data, offset, length, x, y);
                this.sleep(debugFlashTime);
                ++index;
            }
            this.graphics.setColor(color);
        }
        this.graphics.drawChars(data, offset, length, x, y);
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Point(x, y));
        }
        return this.graphics.drawImage(image, x, y, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Rectangle(x, y, width, height));
        }
        return this.graphics.drawImage(image, x, y, width, height, observer);
    }

    public boolean drawImage(Image image, int x, int y, Color background, ImageObserver observer) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Point(x, y) + ", bgcolor: " + background);
        }
        return this.graphics.drawImage(image, x, y, background, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color background, ImageObserver observer) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " at: " + new Rectangle(x, y, width, height) + ", bgcolor: " + background);
        }
        return this.graphics.drawImage(image, x, y, width, height, background, observer);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " destination: " + new Rectangle(dx1, dy1, dx2, dy2) + " source: " + new Rectangle(sx1, sy1, sx2, sy2));
        }
        return this.graphics.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color background, ImageObserver observer) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Drawing image: " + image + " destination: " + new Rectangle(dx1, dy1, dx2, dy2) + " source: " + new Rectangle(sx1, sy1, sx2, sy2) + ", bgcolor: " + background);
        }
        return this.graphics.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, background, observer);
    }

    public void copyArea(int x, int y, int width, int height, int destx, int desty) {
        if ((this.debugOptions & 1) != 0) {
            DebugGraphics.logStream().println(this.prefix() + " Copying area from: " + new Rectangle(x, y, width, height) + " to: " + new Point(destx, desty));
        }
        this.graphics.copyArea(x, y, width, height, destx, desty);
    }

    public void dispose() {
        this.graphics.dispose();
        this.graphics = null;
    }

    public boolean isDrawingBuffer() {
        return false;
    }

    public void setDebugOptions(int options) {
        this.debugOptions = options;
        if ((this.debugOptions & 1) != 0) {
            if (options == -1) {
                DebugGraphics.logStream().println(this.prefix() + "Disabling debug");
            } else {
                DebugGraphics.logStream().println(this.prefix() + "Enabling debug");
            }
        }
    }

    public int getDebugOptions() {
        return this.debugOptions;
    }

    private final String prefix() {
        return "Graphics(" + counter + "-1)";
    }

    public DebugGraphics() {
        ++counter;
    }

    public DebugGraphics(Graphics graphics, JComponent component) {
        this(graphics);
    }

    public DebugGraphics(Graphics graphics) {
        this();
        this.graphics = graphics;
    }
}

