package TDS::List::Base;
# $Id: Base.pm,v 1.14 2000/12/10 10:22:58 tom Exp $
################################################################

use strict qw(vars);
use Exporter;
use vars qw(@ISA @EXPORT);

use TDS;
use TDS::Cache::Base;
use TDS::Style;
use TDS::DirInfo;
use TDS::Skelton;

@ISA = qw(TDS::Cache::Base TDS::Skelton);
@EXPORT = qw(attributes);

attributes qw(cache_html);

################################################################

sub initialize($)
{
    my $self = shift;

    $self->TDS::Cache::Base::initialize;
    $self->TDS::Skelton::initialize;
}
sub AsHTML($)
{
    my $self = shift;
    
    if ($self->cache_html){
	return $self->cache_html;
    }
    $self->TDS::Skelton::Read;
    my $html = $self->SUPER::AsHTML;
    $self->WriteCache($html);
    return $html;

}
sub GetListDataFilename($)
{
    my $self = shift;
    
    my $var = $self->get_static_variable('DataFilename');
    return GetDataDir() . "/$$var";
}
sub GetDataFilename($)
{
    my $self = shift;

    return $self->GetListDataFilename;
}
sub GetCacheFilename($)
{
    my $self = shift;

    my $var = $self->get_static_variable('CacheFilename');
    require TDS::Cache::DirInfo;
    return TDS::Cache::DirInfo::CacheDir() . "/$$var";
}
sub get_static_variable($$)
{
    my ($self, $var_name) = @_;

    my $class = (ref $self) ? ref $self : $self;

    return "${class}::$var_name";
}
    
1;
